--### color neutral filter ###

-- !!! Colors are 1:1 neutral if they are litten by the sun with a sunangle of 45° !!!
-- Otherwise they are brighter or darker, but due to the used linear tonemapping,
-- this should be a linear shift.

function init_sol_custom_config()

	--[[
	nerd__sky_adjust.Level = 1.00
	nerd__sun_adjust.ls_Level = 1.00
	nerd__sun_adjust.ls_Saturation = 1.00
	nerd__ambient_adjust.Level = 1.00
	nerd__ambient_adjust.Saturation = 1.00
	]]
	SOL__set_config("nerd__sky_adjust", "Level", 1.00)
	SOL__set_config("nerd__sun_adjust", "ls_Level", 1.00)
	SOL__set_config("nerd__sun_adjust", "ls_Saturation", 1.00)
	SOL__set_config("nerd__ambient_adjust", "Level", 1.00)
	SOL__set_config("nerd__ambient_adjust", "Saturation", 1.00)

	--ppfilter__brightness_sun_link = 0
	SOL__set_config("pp", "brightness_sun_link", 0)

	SOL__set_config("ambient", "sun_color_balance", 0.5)

	-- reset customs to default
	ac.resetGodraysCustomColor()
	ac.resetGodraysCustomDirection()
	ac.resetWeatherStaticAmbient()
	ac.resetShadowsResolution()
	ac.resetShadowsSplits()
	ac.resetSpecularColor()
	ac.resetHorizonFogMultiplier()
	ac.resetGlowBrightness()
	ac.resetWeatherLightsMultiplier()
	ac.resetEmissiveMultiplier()

	ac.setAutoExposureLimits(0.3, 0.55)
	ac.setCarExposureActive(false)
	
	ac.setPpColorTemperatureK(6250)
	-- whitebalance is modulated by Sol if "ppfilter__modify_spectrum" is activated
	ac.setPpWhiteBalanceK(6250)

	ac.setPpSepia(0)
	ac.setPpTonemapGamma(1.45)
	ac.setPpTonemapFilmicContrast(0.0)
	ac.setPpSaturation(0.98)
	ac.setPpContrast(1.00)
	ac.setPpBrightness(1.00)

end

function update_sol_custom_config(dt)

	
	ac.setPpTonemapFilmicContrast(0.5)
	ac.setPpTonemapGamma(1.00)
	ac.setPpBrightness(1.0)
	ac.setPpContrast(1.000)
	ac.setPpSaturation(1.00)
	ac.setPpSepia(0)

	SOL_filter__set_exposure_base(0.236)
	ac.setPpTonemapExposure(0.236)


	ac.setGlareThreshold(5) --this works always


	--ac.setGlareBloomFilterThreshold(0.1) --values higher than 0.1 will not work, with 0.1 you should see a blue bloom
	
	-- set GLARE shape to "Standard" to be sure star is processed
	ac.setGlareStarFilterThreshold(0.70) --put in values from 0-0.90 / higher values will bypass threshold
	-- threshold prevents glare, you must reload the whole filter (switching filter ingame), to force the change !!!
end
