ac.debug("0.RSS Formula Hybrid 2024","Display script")

if car.isAIControlled then
	return nil
end

local SIM = ac.getSim()

local Green = rgbm(0.086,0.741,0,1)
local Yellow = rgbm(1,0.894,0,1)
local Red = rgbm(1,0.1,0.1,1)
local Blue = rgbm(0.2,0.5,0.9,1)
local Black = rgbm(0.1,0.1,0.1,1)
local White = rgbm(0.954,0.954,0.954,1)
local OFF = rgbm(0,0,0,0)
local Total_Energy_Collar = rgbm(0,0.875,1,1)
local Lap_Energy_Collar = rgbm(0.278,1,0.702,1)
local DRS_Collar = Green
local Flag_Collar = Green
local DRS_Text_Collar = Black
local SessionTime = ""
local Fuel = ""
local Pos = ""
local Laps = ""
local PERF = ""
local LapTime = ""
local MGUK_D = ""
local MGUK_R = ""
local Tyre_Temp = {}
local Gear = ""
local Engine_Map = ""
local Speed = ""
local RPM = ""
local BATT = ""
local Bbal = ""
local Bbal_Base = car.brakeBias
local Bbal_Delta = 0
local BMig = ""
local BMig_Ramp = ""
local LastLapTime = ""
local BestLapTime = ""
local Brakes_Temp = {}
local Total_Energy = 0
local Lap_Energy = 0
local FlagTimer = 10
local PitLimiter = false
local MGUK_D_Size = 120

local DrsData = ac.INIConfig.trackData("drs_zones.ini")
local ZonesCount = 0
local DETECTION = {}
local END = {}
local index = 0
local CarPos = car.splinePosition
local DRSD = false

local BootingTimer = 0
local IGTimer = 0
local MFD_SUB = ac.findNodes("carRoot:" .. car.index):findMeshes("GSI_Display_Mesh"):ensureUniqueMaterials()
local Glass = ac.findNodes("carRoot:" .. car.index):findMeshes("GSI_Display_Glass"):ensureUniqueMaterials():setMaterialProperty("ksDiffuse",0.01)

local function initialize()

    repeat
        DETECTION[index] = DrsData:get('ZONE_'..index, 'DETECTION',-1)
        END[index] = DrsData:get('ZONE_'..index, 'END',-1)
        index = index + 1
    until DrsData:get('ZONE_'..index, 'END',nil) == nil
    ZonesCount = index - 1

    ui.drawImage("assets/GSI_Splash.dds", vec2(0,0), vec2(1022,586))
	ui.drawImage("assets/GSI_Display_Race.png", vec2(0,0), vec2(1022,586))
	ui.drawImage("assets/GSI_Display_qualifying.png", vec2(0,0), vec2(1022,586))
	ui.drawImage("assets/GSI_Display_Status.png", vec2(0,0), vec2(1022,586))
    INITIALIZED = true
end

local MFDKey = ac.getCarID(car.index) .. "_mfd"
local MFDsharedData = {
	ac.StructItem.key(MFDKey .. "_" .. car.index),
	SpeedUnit = ac.StructItem.int32(),
	MFDPage =  ac.StructItem.int32(),
	MFDBrt =  ac.StructItem.int32(),
	LEDBrt =  ac.StructItem.int32()
}
MFD = ac.connect(MFDsharedData, false, ac.SharedNamespace.Shared)

IGKey = ac.getCarID(car.index) .. "_Ignition"
local IGsharedData = {
	ac.StructItem.key(IGKey .. "_" .. car.index),
	Mode = ac.StructItem.int32()
}
Ignition = ac.connect(IGsharedData, false, ac.SharedNamespace.Shared)

FHSystemKey = "Formula_Hybrid_System"
local FHSystemsharedData = {
	ac.StructItem.key(FHSystemKey .. "_" .. car.index),
	BrakeMigration = ac.StructItem.float(),
	BrakeMigrationRamp = ac.StructItem.float(),
	DiffEntry = ac.StructItem.int32(),
	DiffMid = ac.StructItem.int32(),
	DiffExit = ac.StructItem.int32(),
	DiffExitSpeed = ac.StructItem.int32(),
	FuelTarget = ac.StructItem.float(),
	StartMode = ac.StructItem.boolean(),
	AntiStall = ac.StructItem.boolean()
}
FHSystem = ac.connect(FHSystemsharedData, false, ac.SharedNamespace.Shared)

local lastBbal = car.brakeBias
local lastBmig = FHSystem.BrakeMigration
local lastBmigRamp = FHSystem.BrakeMigrationRamp
local lastMguh = car.mguhChargingBatteries
local lastMguKD = car.mgukDelivery
local lastMgukR = car.mgukRecovery
local lastDiffEntry = FHSystem.DiffEntry
local lastDiffMid = FHSystem.DiffMid
local lastDiffExit = FHSystem.DiffExit
local lastEngineBrake = car.currentEngineBrakeSetting
local lastEngineMap = car.fuelMap
local laseIgnition = Ignition.Mode
local lastBestLapTimeMs = car.bestLapTimeMs
local lastLapCount = car.lapCount
local EB = car.currentEngineBrakeSetting
local DiffEntry = FHSystem.DiffEntry.."/12"
local DiffMid = FHSystem.DiffMid.."/12"
local DiffExit = FHSystem.DiffExit.."/12"
local MGUH = car.mguhChargingBatteries and "BATT" or "ENG"
local POP = -1
local TimerPOP = 0

function bootingscreen(dt)
	if IGTimer < 0.5 then
		ui.drawRectFilled(vec2(0,0), vec2(1022,586),Black)
		ui.dwriteDrawTextClipped("Gomez Sim Industries Hyper P1", 27, vec2(0,5), vec2(1022,50))
		ui.dwriteDrawTextClipped("Formula Hybrid 2024", 27, vec2(0,50), vec2(1022,95))
	else
		BootingTimer = BootingTimer - dt * 1.2
		TimerPOP = 10
		POP = -1
		if BootingTimer < 0 then
			BootingTimer = 1
		end
		ui.drawImage("assets/GSI_Splash.dds", vec2(0,0), vec2(1022,586))
		ui.drawRectFilled(vec2(380,535), vec2(640,570),rgbm(0,0,0,1-BootingTimer))
	end
end

function popup(dt)

	EB = car.currentEngineBrakeSetting
	DiffEntry = FHSystem.DiffEntry.."/12"
	DiffMid = FHSystem.DiffMid.."/12"
	DiffExit = FHSystem.DiffExit.."/12"
	MGUH = car.mguhChargingBatteries and "BATT" or "ENG"
	BMig = FHSystem.BrakeMigration > 0 and "+"..string.format("%.1f",FHSystem.BrakeMigration*100) or string.format("%.1f",FHSystem.BrakeMigration*100)
	BMig_Ramp = string.format("%.0f",FHSystem.BrakeMigrationRamp*100).."%"
	MGUK_D = ac.getMGUKDeliveryName(0, car.mgukDelivery)..""
	MGUK_R = string.format(car.mgukRecovery)

	if math.abs(FHSystem.BrakeMigration) < 0.004 then
		BMig = "0.0"
	end

	if lastBbal ~= car.brakeBias then
		TimerPOP = 0
		POP = 0
	end

	if lastBmig ~= FHSystem.BrakeMigration then
		TimerPOP = 0
		POP = 1
	end

	if lastBmigRamp ~= FHSystem.BrakeMigrationRamp then
		TimerPOP = 0
		POP = 2
	end

	if lastMguh ~= car.mguhChargingBatteries then
		TimerPOP = 0
		POP = 3
	end

	if lastMguKD ~= car.mgukDelivery then
		TimerPOP = 0
		POP = 4
	end

	if lastMgukR ~= car.mgukRecovery then
		TimerPOP = 0
		POP = 5
	end

	if lastDiffEntry ~= FHSystem.DiffEntry then
		TimerPOP = 0
		POP = 6
	end

	if lastDiffMid ~= FHSystem.DiffMid then
		TimerPOP = 0
		POP = 7
	end

	if lastDiffExit ~= FHSystem.DiffExit then
		TimerPOP = 0
		POP = 8
	end

	if lastEngineBrake ~= car.currentEngineBrakeSetting then
		TimerPOP = 0
		POP = 9
	end

	if lastEngineMap ~= car.fuelMap then
		TimerPOP = 0
		POP = 10
	end

	if laseIgnition ~= Ignition.Mode and Ignition.Mode > 0 then
		TimerPOP = -1
		POP = 11
	end

	if TimerPOP < 2 then
		TimerPOP = TimerPOP + dt
	else
		TimerPOP = 10
		POP = -1
	end

	ui.pushDWriteFont("assets/Roboto-Medium.ttf")
	if POP == 0 then
		ui.drawRectFilled(vec2(59,211), vec2(422,432),rgbm(0.502,0,0.502,1))
		ui.dwriteDrawTextClipped("Brake Bias", 70, vec2(59,211), vec2(422,290),0,0,false,White)
		ui.dwriteDrawTextClipped(Bbal, 120, vec2(59,290), vec2(422,432),0,0,false,White)
	elseif POP == 1 then
		ui.drawRectFilled(vec2(59,211), vec2(422,432),rgbm(0.864,0.814,0.092,1))
		ui.dwriteDrawTextClipped("B-MIG", 70, vec2(59,211), vec2(422,290),0,0,false,Black)
		ui.dwriteDrawTextClipped(BMig, 120, vec2(59,290), vec2(422,432),0,0,false,Black)
	elseif POP == 2 then
		ui.drawRectFilled(vec2(59,211), vec2(422,432),rgbm(0,0.4,1,1))
		ui.dwriteDrawTextClipped("Ramp", 70, vec2(59,211), vec2(422,290),0,0,false,White)
		ui.dwriteDrawTextClipped(BMig_Ramp, 120, vec2(59,290), vec2(422,432),0,0,false,White)
	elseif POP == 3 then
		ui.drawRectFilled(vec2(59,211), vec2(422,432),rgbm(0.21,0.24,1,1))
		ui.dwriteDrawTextClipped("MGU-H", 70, vec2(59,211), vec2(422,290),0,0,false,White)
		ui.dwriteDrawTextClipped(MGUH, 120, vec2(59,290), vec2(422,432),0,0,false,White)
	elseif POP == 4 then
		MGUK_D_Size = car.mgukDelivery == 0 and 75 or car.mgukDelivery == 3 and 80 or 80
		ui.drawRectFilled(vec2(59,211), vec2(422,432),rgbm(0,0.502,0,1))
		ui.dwriteDrawTextClipped("Delivery", 70, vec2(59,211), vec2(422,290),0,0,false,White)
		ui.dwriteDrawTextClipped(MGUK_D, MGUK_D_Size, vec2(59,290), vec2(422,432),0,0,false,White)
	elseif POP == 5 then
		ui.drawRectFilled(vec2(59,211), vec2(422,432),rgbm(0.1,1,0,1))
		ui.dwriteDrawTextClipped("Recovery", 70, vec2(59,211), vec2(422,290),0,0,false,Black)
		ui.dwriteDrawTextClipped(MGUK_R, 120, vec2(59,290), vec2(422,432),0,0,false,Black)
	elseif POP == 6 then
		ui.drawRectFilled(vec2(59,211), vec2(422,432),rgbm(0.05,0.76,1,1))
		ui.dwriteDrawTextClipped("Diff Entry", 70, vec2(59,211), vec2(422,290),0,0,false,Black)
		ui.dwriteDrawTextClipped(DiffEntry, 120, vec2(59,290), vec2(422,432),0,0,false,Black)
	elseif POP == 7 then
		ui.drawRectFilled(vec2(59,211), vec2(422,432),rgbm(0.996,0.761,0.024,1))
		ui.dwriteDrawTextClipped("Diff Mid", 70, vec2(59,211), vec2(422,290),0,0,false,Black)
		ui.dwriteDrawTextClipped(DiffMid, 120, vec2(59,290), vec2(422,432),0,0,false,Black)
	elseif POP == 8 then
		ui.drawRectFilled(vec2(59,211), vec2(422,432),rgbm(0.996,0.031,0.031,1))
		ui.dwriteDrawTextClipped("Diff Exit", 70, vec2(59,211), vec2(422,290),0,0,false,White)
		ui.dwriteDrawTextClipped(DiffExit, 120, vec2(59,290), vec2(422,432),0,0,false,White)
	elseif POP == 9 then
		ui.drawRectFilled(vec2(59,211), vec2(422,432),rgbm(1,1,1,1))
		ui.dwriteDrawTextClipped("Engine Brake", 60, vec2(59,211), vec2(422,290),0,0,false,Black)
		ui.dwriteDrawTextClipped(EB, 120, vec2(59,290), vec2(422,432),0,0,false,Black)
	elseif POP == 10 then
		ui.drawRectFilled(vec2(59,211), vec2(422,432),rgbm(1,0.039,1,1))
		ui.dwriteDrawTextClipped("Engine Map", 65, vec2(59,211), vec2(422,290),0,0,false,Black)
		ui.dwriteDrawTextClipped(Engine_Map, 120, vec2(59,290), vec2(422,432),0,0,false,Black)
	elseif POP == 11 then
		ui.pushDWriteFont("assets/Roboto-Black.ttf")
		ui.drawRectFilled(vec2(59,67), vec2(963,561),Black)
		ui.dwriteDrawTextClipped(Gear, 190, vec2(428,67), vec2(594,236))
		ui.drawRect(vec2(424.5,63.5), vec2(597.5,239.5),rgbm(1,1,1,1),0,0,6)
		ui.pushDWriteFont("assets/Roboto-Medium.ttf")
		if Ignition.Mode == 2 then
			ui.dwriteDrawTextClipped("ENGINE START", 120, vec2(59,288), vec2(963,561),0,0,false,Green)
		else
			ui.dwriteDrawTextClipped("ENGINE KILL", 120, vec2(59,288), vec2(963,561),0,0,false,rgbm(0.8,0,0,1))
		end
	end

	if PitLimiter and not FHSystem.StartMode then
		ui.pushDWriteFont("assets/Roboto-Black.ttf")
		ui.drawRectFilled(vec2(59,67), vec2(422,288),Blue)
		ui.drawRectFilled(vec2(600,67), vec2(963,288),Blue)
		ui.dwriteDrawTextClipped("PIT SPEED", 70, vec2(59,67), vec2(422,150),0,0,false,Black)
		ui.dwriteDrawTextClipped("ON", 130, vec2(59,150), vec2(422,288),0,0,false,Black)
		ui.dwriteDrawTextClipped(Speed, 200, vec2(600,67), vec2(963,288),0,0,false,Black)
	end

	if lastLapCount ~= car.lapCount then
		DeltaMs = car.previousLapTimeMs - lastBestLapTimeMs
		Delta = lastBestLapTimeMs == 0 and "-.---" or DeltaMs > 0 and "+"..string.format("%.3f",DeltaMs/1000) or string.format("%.3f",DeltaMs/1000)
		FuelDelta = car.fuelPerLap == 0 and "-.-- L" or car.fuelPerLap-FHSystem.FuelTarget > 0 and "+"..string.format("%.2f",car.fuelPerLap-FHSystem.FuelTarget).." L" or string.format("%.2f",car.fuelPerLap-FHSystem.FuelTarget).." L"
	end

	if car.lapTimeMs < 5000 and car.lapCount > 0 then
		ui.pushDWriteFont("assets/Roboto-Medium.ttf")
		ui.drawRectFilled(vec2(59,366), vec2(963,561),rgbm(0.05,0.76,1,1))
		ui.dwriteDrawTextClipped("Lap", 60, vec2(80,388), vec2(200,456),ui.Alignment.Start,0,false,Black)
		ui.dwriteDrawTextClipped(LastLapTime, 60, vec2(200,388), vec2(501,456),ui.Alignment.End,0,false,Black)
		ui.dwriteDrawTextClipped("Delta", 60, vec2(80,464), vec2(230,532),ui.Alignment.Start,0,false,Black)
		ui.dwriteDrawTextClipped(Delta, 60, vec2(230,464), vec2(501,532),ui.Alignment.End,0,false,Black)
		ui.dwriteDrawTextClipped("Fuel Delta", 60, vec2(521,388), vec2(942,456),0,0,false,Black)
		ui.dwriteDrawTextClipped(FuelDelta, 60, vec2(521,464), vec2(942,532),0,0,false,Black)
	end

end

function page0update(dt)

	Fuel = string.format("%.0f",car.fuel).."L"
	Pos = string.format(car.racePosition)
	Laps = string.format(car.lapCount+1)
	PERF = car.performanceMeter > 0 and "+"..string.format("%.3f",car.performanceMeter) or string.format("%.3f",car.performanceMeter)
	LapTime = string.format("%01d:%02d.%03d", math.floor((car.lapTimeMs/(1000*60)))%60, math.floor((car.lapTimeMs/1000))%60, car.lapTimeMs%1000)
	MGUK_D = ac.getMGUKDeliveryName(0, car.mgukDelivery)..""
	MGUK_R = string.format(car.mgukRecovery)
	Gear = car.gear == -1 and "R" or car.gear == 0 and "N" or  string.format(car.gear)
	Engine_Map = string.format(car.fuelMap)
	Speed = MFD.SpeedUnit == 1 and string.format("%.0f",(car.speedKmh*0.62137119)) or string.format("%.0f",car.speedKmh)
	RPM = string.format("%.0f",car.rpm)
	BATT = string.format("%.0f",car.kersCharge*100)
	Bbal_Delta = (car.brakeBias - Bbal_Base)*100
	Bbal = Bbal_Delta > 0 and "+"..string.format("%.1f",Bbal_Delta) or string.format("%.1f",Bbal_Delta)
	BMig = FHSystem.BrakeMigration > 0 and "+"..string.format("%.1f",FHSystem.BrakeMigration*100) or string.format("%.1f",FHSystem.BrakeMigration*100)
	BMig_Ramp = string.format("%.0f",FHSystem.BrakeMigrationRamp*100).."%"
	LastLapTime = car.previousLapTimeMs == 0 and "-:--.---" or string.format("%01d:%02d.%03d", math.floor((car.previousLapTimeMs/(1000*60)))%60, math.floor((car.previousLapTimeMs/1000))%60, car.previousLapTimeMs%1000)
	BestLapTime = car.bestLapTimeMs == 0 and "-:--.---" or string.format("%01d:%02d.%03d", math.floor((car.bestLapTimeMs/(1000*60)))%60, math.floor((car.bestLapTimeMs/1000))%60, car.bestLapTimeMs%1000)
	Total_Energy = car.kersCharge
	Lap_Energy = 1-(car.kersCurrentKJ/car.kersMaxKJ)
	Flag_Collar = SIM.raceFlagType == ac.FlagType.Caution and Yellow or SIM.raceFlagType == ac.FlagType.FasterCar and Blue or FlagTimer < 5 and Green or OFF

	if FlagTimer < 6 then
		FlagTimer = FlagTimer + dt
	end

	if SIM.raceFlagType == ac.FlagType.Caution then
		FlagTimer = 0
	end

	for i = 0,3 do
		Tyre_Temp[i] = string.format("%.0f",car.wheels[i].tyreCoreTemperature - car.wheels[i].tyreOptimumTemperature)
		Brakes_Temp[i] = string.format("%.0f",car.wheels[i].discTemperature)
	end

	if math.abs(car.performanceMeter) > 10 or car.performanceMeter == 0 then
		PERF = "-.---"
	end

	if math.abs(FHSystem.BrakeMigration) < 0.004 then
		BMig = "0.0"
	end

	if math.abs(Bbal_Delta) < 0.4 then
		Bbal = "0.0"
	end

	if DRSD and not PitLimiter then
		DRS_Collar = car.drsActive and Green or car.drsAvailable and Yellow or OFF
		DRS_Text_Collar = car.drsAvailable and Black or White
	else
		DRS_Collar = OFF
		DRS_Text_Collar = OFF
	end

end

function page0(dt)
	page0update(dt)
	ui.pushDWriteFont("assets/Roboto-Medium.ttf")
    ui.drawRectFilled(vec2(267,9), vec2(387,50),DRS_Collar)
	ui.dwriteDrawTextClipped("DRS", 50, vec2(267,9), vec2(387,50),0,0,false,DRS_Text_Collar)
    ui.drawRectFilled(vec2(451,9), vec2(571,50),Flag_Collar)
    ui.drawRectFilled(vec2(24,561-(494*Total_Energy)), vec2(53,561),Total_Energy_Collar)
    ui.drawRectFilled(vec2(969,561-(494*Lap_Energy)), vec2(998,561),Lap_Energy_Collar)
	ui.dwriteDrawTextClipped(Fuel, 50, vec2(591,9), vec2(711,50))
	ui.dwriteDrawTextClipped(Pos, 50, vec2(778,9), vec2(848,50))
	ui.dwriteDrawTextClipped(Laps, 50, vec2(926,9), vec2(996,50))
	ui.dwriteDrawTextClipped(PERF, 60, vec2(125,67), vec2(422,133))
	ui.dwriteDrawTextClipped(LapTime, 60, vec2(125,139), vec2(422,205))
	ui.dwriteDrawTextClipped(MGUK_D, 60, vec2(59,244), vec2(422,314))
	ui.dwriteDrawTextClipped(MGUK_R, 60, vec2(59,342), vec2(422,412))
	ui.dwriteDrawTextClipped(Tyre_Temp[0], 50, vec2(59,438), vec2(240,500))
	ui.dwriteDrawTextClipped(Tyre_Temp[1], 50, vec2(240,438), vec2(422,500))
	ui.dwriteDrawTextClipped(Tyre_Temp[2], 50, vec2(59,500), vec2(240,561))
	ui.dwriteDrawTextClipped(Tyre_Temp[3], 50, vec2(240,500), vec2(422,561))
	ui.dwriteDrawTextClipped(Engine_Map, 60, vec2(428,242), vec2(594,306))
	ui.dwriteDrawTextClipped(Speed, 60, vec2(428,312), vec2(594,376))
	ui.dwriteDrawTextClipped(RPM, 50, vec2(428,382), vec2(594,446))
	ui.dwriteDrawTextClipped(BATT, 70, vec2(428,476), vec2(594,561))
	ui.dwriteDrawTextClipped(Bbal, 58, vec2(683,67), vec2(963,144))
	ui.dwriteDrawTextClipped(BMig, 58, vec2(683,150), vec2(963,216))
	ui.dwriteDrawTextClipped(BMig_Ramp, 58, vec2(683,222), vec2(963,288))
	ui.dwriteDrawTextClipped(LastLapTime, 58, vec2(683,294), vec2(963,360))
	ui.dwriteDrawTextClipped(BestLapTime, 58, vec2(683,366), vec2(963,432))
	ui.dwriteDrawTextClipped(Brakes_Temp[0], 50, vec2(600,438), vec2(781,500))
	ui.dwriteDrawTextClipped(Brakes_Temp[1], 50, vec2(781,438), vec2(963,500))
	ui.dwriteDrawTextClipped(Brakes_Temp[2], 50, vec2(600,500), vec2(781,561))
	ui.dwriteDrawTextClipped(Brakes_Temp[3], 50, vec2(781,500), vec2(963,561))

	ui.pushDWriteFont("assets/Roboto-Black.ttf")
	ui.dwriteDrawTextClipped(Gear, 190, vec2(428,67), vec2(594,236))

	ui.drawImage("assets/GSI_Display_Race.png", vec2(0,0), vec2(1022,586))
end

function page1update(dt)

	Laps = string.format(car.lapCount+1)
	PERF = car.performanceMeter > 0 and "+"..string.format("%.3f",car.performanceMeter) or string.format("%.3f",car.performanceMeter)
	LapTime = string.format("%01d:%02d.%03d", math.floor((car.lapTimeMs/(1000*60)))%60, math.floor((car.lapTimeMs/1000))%60, car.lapTimeMs%1000)
	Gear = car.gear == -1 and "R" or car.gear == 0 and "N" or  string.format(car.gear)
	Engine_Map = string.format(car.fuelMap)
	Speed = MFD.SpeedUnit == 1 and string.format("%.0f",(car.speedKmh*0.62137119)) or string.format("%.0f",car.speedKmh)
	BATT = string.format("%.0f",car.kersCharge*100)
	Bbal_Delta = (car.brakeBias - Bbal_Base)*100
	Bbal = Bbal_Delta > 0 and "+"..string.format("%.1f",Bbal_Delta) or string.format("%.1f",Bbal_Delta)
	LastLapTime = car.previousLapTimeMs == 0 and "-:--.---" or string.format("%01d:%02d.%03d", math.floor((car.previousLapTimeMs/(1000*60)))%60, math.floor((car.previousLapTimeMs/1000))%60, car.previousLapTimeMs%1000)
	BestLapTime = car.bestLapTimeMs == 0 and "-:--.---" or string.format("%01d:%02d.%03d", math.floor((car.bestLapTimeMs/(1000*60)))%60, math.floor((car.bestLapTimeMs/1000))%60, car.bestLapTimeMs%1000)
	Total_Energy = car.kersCharge
	Lap_Energy = 1-(car.kersCurrentKJ/car.kersMaxKJ)
	Flag_Collar = SIM.raceFlagType == ac.FlagType.Caution and Yellow or SIM.raceFlagType == ac.FlagType.FasterCar and Blue or FlagTimer < 5 and Green or OFF

	if FlagTimer < 6 then
		FlagTimer = FlagTimer + dt
	end

	if SIM.raceFlagType == ac.FlagType.Caution then
		FlagTimer = 0
	end

	if math.abs(car.performanceMeter) > 10 or car.performanceMeter == 0 then
		PERF = "-.---"
	end

	if math.abs(Bbal_Delta) < 0.4 then
		Bbal = "0.0"
	end

	if DRSD and not PitLimiter then
		DRS_Collar = car.drsActive and Green or car.drsAvailable and Yellow or OFF
		DRS_Text_Collar = car.drsAvailable and Black or White
	else
		DRS_Collar = OFF
		DRS_Text_Collar = OFF
	end
end

function page1(dt)
	page1update(dt)

	ui.pushDWriteFont("assets/Roboto-Medium.ttf")
    ui.drawRectFilled(vec2(267,9), vec2(387,50),DRS_Collar)
	ui.dwriteDrawTextClipped("DRS", 50, vec2(267,9), vec2(387,50),0,0,false,DRS_Text_Collar)
    ui.drawRectFilled(vec2(451,9), vec2(571,50),Flag_Collar)
    ui.drawRectFilled(vec2(24,561-(494*Total_Energy)), vec2(53,561),Total_Energy_Collar)
    ui.drawRectFilled(vec2(969,561-(494*Lap_Energy)), vec2(998,561),Lap_Energy_Collar)
	ui.dwriteDrawTextClipped(Laps, 32, vec2(926,9), vec2(996,50))
	ui.dwriteDrawTextClipped(PERF, 100, vec2(59,67), vec2(422,205))
	ui.dwriteDrawTextClipped(Engine_Map, 80, vec2(428,242), vec2(594,341))
	ui.dwriteDrawTextClipped(Speed, 80, vec2(428,347), vec2(594,446))
	ui.dwriteDrawTextClipped(BATT, 70, vec2(428,476), vec2(594,561))
	ui.dwriteDrawTextClipped(Bbal, 120, vec2(600,67), vec2(963,186))
	ui.dwriteDrawTextClipped(LapTime, 80, vec2(600,222), vec2(963,311))
	ui.dwriteDrawTextClipped(LastLapTime, 80, vec2(600,344), vec2(963,436))
	ui.dwriteDrawTextClipped(BestLapTime, 80, vec2(600,471), vec2(963,561))

	ui.pushDWriteFont("assets/Roboto-Black.ttf")
	ui.dwriteDrawTextClipped(Gear, 190, vec2(428,67), vec2(594,236))

	ui.drawImage("assets/GSI_Display_qualifying.png", vec2(0,0), vec2(1022,586))
end

function page2update()
	DiffEntry = FHSystem.DiffEntry
	DiffMid = FHSystem.DiffMid
	DiffExit = FHSystem.DiffExit
	DiffExitSpeed = FHSystem.DiffExitSpeed
	Bbal_Delta = (car.brakeBias - Bbal_Base)*100
	Bbal_Number = string.format("%.1f",car.brakeBias*100)
	Bbal = Bbal_Delta > 0 and "+"..string.format("%.1f",Bbal_Delta) or string.format("%.1f",Bbal_Delta)
	BMig = FHSystem.BrakeMigration > 0 and "+"..string.format("%.1f",FHSystem.BrakeMigration*100) or string.format("%.1f",FHSystem.BrakeMigration*100)
	BMig_Ramp = string.format("%.0f",FHSystem.BrakeMigrationRamp*100).."%"
	if math.abs(Bbal_Delta) < 0.4 then
		Bbal = "0.0"
	end
	if math.abs(FHSystem.BrakeMigration) < 0.004 then
		BMig = "0.0"
	end
end

function page2(dt)
	page2update()
	ui.pushDWriteFont("assets/Roboto-Medium.ttf")
	ui.dwriteDrawTextClipped(DiffEntry, 100, vec2(133,120), vec2(386,228),0,0,false,rgbm(1,0.965,0,1))
	ui.dwriteDrawTextClipped(DiffMid, 100, vec2(133,230), vec2(386,338),0,0,false,rgbm(1,0.965,0,1))
	ui.dwriteDrawTextClipped(DiffExit, 100, vec2(123,337), vec2(396,445),0,0,false,rgbm(1,0.965,0,1))
	ui.dwriteDrawTextClipped(DiffExitSpeed, 100, vec2(123,447), vec2(396,555),0,0,false,rgbm(1,0.965,0,1))
	ui.dwriteDrawTextClipped("km/h", 33, vec2(343,499), vec2(440,543),0,0,false,rgbm(1,0.965,0,1))

	ui.dwriteDrawTextClipped(Bbal, 160, vec2(507,130), vec2(916,281),ui.Alignment.End,0,false,rgbm(1,0.424,0,1))
	ui.dwriteDrawTextClipped("%", 65, vec2(933,207), vec2(996,269),0,0,false,rgbm(1,0.424,0,1))
	ui.dwriteDrawTextClipped(Bbal_Number, 160, vec2(507,286), vec2(916,437),ui.Alignment.End,0,false,rgbm(1,0.424,0,1))
	ui.dwriteDrawTextClipped("%", 65, vec2(933,365), vec2(996,427),0,0,false,rgbm(1,0.424,0,1))

	ui.dwriteDrawTextClipped(BMig, 65, vec2(598,482), vec2(730,544),0,0,false,rgbm(1,0.424,0,1))
	ui.dwriteDrawTextClipped(BMig_Ramp, 65, vec2(754,482), vec2(935,544),0,0,false,rgbm(1,0.424,0,1))

	ui.drawImage("assets/GSI_Display_Status.png", vec2(0,0), vec2(1022,586))
end

function startmodeupdate()
	RPM = string.format("%.0f",car.rpm)
	MGUK_D = ac.getMGUKDeliveryName(0, car.mgukDelivery)..""
	MGUK_D_Size = car.mgukDelivery == 0 and 75 or car.mgukDelivery == 3 and 80 or 80
	RPM_Collar = car.rpm < 9550 and Black or car.rpm < 10050 and Red or car.rpm < 10550 and Yellow or car.rpm < 11050 and Green or car.rpm < 11550 and Yellow or Red
	RPM_Text = car.rpm < 10550 and "RPM LOW" or car.rpm < 11050 and "RPM GOOD" or "RPM HIGH"
	RPM_Text_Collar = RPM_Collar == Yellow and Black or White
end

function startmode()
	startmodeupdate()
	ui.drawRectFilled(vec2(59,67), vec2(422,242),Black)
	ui.drawRectFilled(vec2(59,242), vec2(594,561),Black)
	ui.drawLine(vec2(424.5,235),vec2(424.5,313),White,6)
	ui.drawLine(vec2(55,290.5),vec2(596,290.5),White,6)
	ui.drawLine(vec2(55,177.5),vec2(423,177.5),White,6)
	ui.pushDWriteFont("assets/Roboto-Black.ttf")
	ui.drawRectFilled(vec2(59,294), vec2(963,561),RPM_Collar)
	ui.dwriteDrawTextClipped(RPM_Text, 140, vec2(59,294), vec2(963,561),0,0,false,RPM_Text_Collar)
	ui.dwriteDrawTextClipped(RPM, 120, vec2(59,67), vec2(422,175),0,0,false,White)
	ui.dwriteDrawTextClipped(MGUK_D, MGUK_D_Size, vec2(59,181), vec2(422,288),0,0,false,White)
end

function update(dt)

    if not INITIALIZED then initialize() end
    IGMode = Ignition.Mode
    Brightness = MFD.MFDBrt/100
	CarPos = car.splinePosition
    DRSD = false
    for i = 0,ZonesCount do
        if CarPos < END[i] and CarPos > DETECTION[i] then
            DRSD = true
        end

        if END[i] < DETECTION[i] then
            if CarPos < END[i] or CarPos > DETECTION[i] then
                DRSD = true
            end
        end
		if car.drsAvailable then
            DRSD = true
        end
    end

	if (car.manualPitsSpeedLimiterEnabled == true) or (car.isInPitlane == true) then
		PitLimiter = true
	else
		PitLimiter = false
	end

	if SIM.isInMainMenu then
		Bbal_Base = car.brakeBias
	end

    if IGMode > 0 or ac.getSim().isReplayActive then
		if IGTimer < 5 then
			IGTimer = IGTimer + dt
		end
		ui.drawRectFilled(vec2(0,0), vec2(1022,586),Black)
		if MFD.MFDPage == 0  then
			page0(dt)
		elseif MFD.MFDPage == 1 then
			page1(dt)
		elseif MFD.MFDPage == 2 then
			page2(dt)
		end
		if not ac.getSim().isReplayActive and MFD.MFDPage < 2 then
			popup(dt)
			if FHSystem.StartMode then
				startmode()
			end
			if FHSystem.AntiStall then
				ui.drawRectFilled(vec2(59,294), vec2(963,561),rgbm(1,0.1,0.1,1))
				ui.pushDWriteFont("assets/Roboto-Black.ttf")
				ui.dwriteDrawTextClipped("ANTI STALL", 140, vec2(59,294), vec2(963,460),0,0,false,White)
				ui.dwriteDrawTextClipped("PULL CLUTCH", 80, vec2(59,460), vec2(963,561),0,0,false,White)
			end
		end
    else
        ui.drawRectFilled(vec2(0,0), vec2(1022,586),rgbm(0,0,0,1))
        Brightness = 0
        IGTimer = 0
    end

	if IGMode == 1 and IGTimer < 2 then
		bootingscreen(dt)
	else
		BootingTimer = 0
	end

    MFD_SUB:setMaterialProperty("ksEmissive",vec3(10,10,10)*Brightness)

	lastBbal = car.brakeBias
	lastBmig = FHSystem.BrakeMigration
	lastBmigRamp = FHSystem.BrakeMigrationRamp
	lastMguh = car.mguhChargingBatteries
	lastMguKD = car.mgukDelivery
	lastMgukR = car.mgukRecovery
	lastDiffEntry = FHSystem.DiffEntry
	lastDiffMid = FHSystem.DiffMid
	lastDiffExit = FHSystem.DiffExit
	lastEngineBrake = car.currentEngineBrakeSetting
	lastEngineMap = car.fuelMap
	laseIgnition = Ignition.Mode
	lastBestLapTimeMs = car.bestLapTimeMs
	lastLapCount = car.lapCount
end