ac.debug("Installation","Check")
local Timer = 0
local flag = true

local ECUKey = ac.getCarID(car.index) .. "_ecu"
local ECUsharedData = {
	ac.StructItem.key(ECUKey .. "_" .. car.index),
	HedeSystemMessage = ac.StructItem.int32(),
	AutoClutch = ac.StructItem.int32(),
	DisableIgnitionSequence = ac.StructItem.int32()
}
ECU = ac.connect(ECUsharedData, false, ac.SharedNamespace.Shared)

local MFDKey = ac.getCarID(car.index) .. "_mfd"
local MFDsharedData = {
	ac.StructItem.key(MFDKey .. "_" .. car.index),
	SpeedUnit = ac.StructItem.int32(),
	MFDPage =  ac.StructItem.int32(),
	MFDBrt =  ac.StructItem.int32(),
	LEDBrt =  ac.StructItem.int32()
}
MFD = ac.connect(MFDsharedData, false, ac.SharedNamespace.Shared)

function update(dt)
    if Timer > 1.5 then
        if MFD.MFDBrt == 0 and MFD.LEDBrt == 0 then
            ECU.DisableIgnitionSequence = 1
            MFD.MFDBrt = 50
            MFD.LEDBrt = 50
        end
        if not ac.getSim().isInMainMenu then
            if not ac.isLuaAppRunning("RSS_Settings") and flag then
                flag = false
                ac.setSystemMessage("RSS Settings app is not installed.","Please download and install the app from the purchase page.")
            end
            return nil
        end
    else
        Timer = Timer + dt
    end

	ac.debug("RSS Settings Running",ac.isLuaAppRunning("RSS_Settings"))
end