'''
tyres_app_ext v5.2 for Assetto Corsa, made by leBluem, McLarenF1Papa
'''

TIME_SwitchBackToDefaultTyre = 6.0

# DOAUTOLOADTYRES = False   ### disables loading tyre-info on car change (Ctrl+NumPad 1/3)
DOAUTOLOADTYRES = True    ### enables loading tyre-info on car change (Ctrl+NumPad 1/3)
####         doesnt work for all params though (some are from players car only)
####         thats why disabled

ALWAYSSHOW_FLATSPOTSBLISTERGRAIN = False

# keep at multiples of each other or same, i messed that up somehow
updateTime1 = 0.02   # slower updated stuff 0.05  = 20 times updated per sec
updateTime2 = 0.01   # faster updated stuff 0.025 = 40 times updated per sec

lockedThreshold = 25

### default
sCustomFontName='Segoe UI'
sCustomFontName2='Segoe UI'

bImgSet = True
bTextWhiteOnBlack = False
cbToggleTextColor = 0
cbToggleImageset = 0
Berror = False

### ABS colors, R,G,B
colR_abs=1.0
colG_abs=0.4
colB_abs=0.4
colA_abs=2.0
### TC colors, R,G,B
colR_tc =0.5
colG_tc =0.5
colB_tc =1.0
colA_tc =2.0
### ABS/TC colors, inactive
colR_EE =0.25
colG_EE =0.25
colB_EE =0.25
colA_EE =1.0

marginX = 100
marginY = 100
fMaxs = [0.0]*(30)
fMins = [999999.0]*(30)
fMaxsTimer = [-1.0]*(30)
fMinsTimer = [-1.0]*(30)
bAutoShowMinMax = False

slipratiolimit     = 0.005    # at which limit to show SlipRatio # very low to show gripping tyres
tyresliplimit      = 0.1      # at which limit to show TyreSlip
bGripAvailable     = True

histCount          = 20
histVisi           = 2
maxHistCount       = 20
rtIndex1 = -1
bFancyMode = True

# defaults, overwritten when succesfully read from tyres.ini
# maybe not with encrypted cars (CSP encryption), ie p13 doesnt have tyre temps avail
# defaults, a bit wider range than ideal for gt3 tyres 70-95
maxTF              = 115   # max tyre temp front
maxTR              = 115   # max tyre temp rear
minTR              = 55    # min tyre temp rear
minTF              = 55    # min tyre temp front

cbFancy=0
fontSizeMult=1.0
fontOffsetY = 0
fontOffsetYRear = 0

TOAppSize=1.5
TOoffsetx=25
TOoffsety=0.0
TOfntSize=12
TOhw=0.0
TOhh=0.0
TOminwidth=0.0
TOminheight=0.0
TOgraphwidth=75
TOoffset=0
tyreID=0
tyreIDcurr=0
tyreIDMAX=0
thread = 0
ac_TVfl=0.0
ac_TVfr=0.0
ac_TVrl=0.0
ac_TVrr=0.0

###

lastXYZ    = [[111.0,111.0,111.0,111.0] * maxHistCount for i in range(maxHistCount)]
currID     = 0
slipCircleMult   = 0.5  ## 0.1
bFirst                   = True
bTimerResetTyreToCurrent = False
TimerReset               = 0.0

bWheelSpeedVSSlip  = False
bDRAG              = True # orange DRAG bar, only with CSP, True/False
bDOWNFORCE         = True # blue DOWNFORCE bar, only with CSP, True/False
bMz                = True # brown self aligning torque, True/False, small triangle from each wheel-center to the left/right

maxDownForce     = 150 # thats around a quarter of gt3 level, will be adjusted dynamically
maxDrag          = 500 # adjusted dynamically

import ac, acsys, os, platform, sys, traceback, math, threading, codecs, time
from configparser import ConfigParser
sysdir=os.path.dirname(__file__)+'/stdlib'
if platform.architecture()[0] == '64bit':
    sysdir=os.path.dirname(__file__)+'/stdlib64'
sys.path.insert(0, sysdir)
os.environ['PATH'] = os.environ['PATH'] + ';.'
import ctypes
from ctypes.wintypes import MAX_PATH
from struct import *

from tysim_info import tyinfo
from ty_lt_acd import ACD, get_tire_namelong, get_val_from_lut, get_float, get_tire_id_max, get_tire_name_by_id, get_tire_id
userDir=''
CSIDL_PERSONAL = 5 # My Documents
SHGFP_TYPE_CURRENT = 0 # Get current, not default value
# buf = ctypes.create_unicode_buffer(ctypes.wintypes.MAX_PATH)
buf = ctypes.create_unicode_buffer(MAX_PATH)
ctypes.windll.shell32.SHGetFolderPathW(None, CSIDL_PERSONAL, None, SHGFP_TYPE_CURRENT, buf)
userDir = buf.value # bingo, userdir/documents!



global ACD_FILE

settingsFilePath    = "apps/python/tyres_app_ext/settings.ini"
settingsDefFilePath = "apps/python/tyres_app_ext/settings_defaults.ini"

### from here on - all is read from settings.ini
gUnits           = { "temp" : "C", "pressure" : "psi", "speed" : "kmh", "volume" : "L" }

# not really dynamic, it resets aero if speed<5 km/h
bDynAero              = True
bHideTimerOn          = False
hideTimer             = -1.0
MinslipStreamLevel    = 0.01 # 0.01 is like 10% higher airpressure than base
### not used anymore since 1.9.9a
DiffModeSwitchEnabled = True
bDiffMode             = False
DiffModeSwitchtime    = 2.5
TimeCount             = 0.0

PRACTICAL_TEMP_RATIO = -1000.0

### csp damper function buggy, disabled
### also down below, not enough to set =True
bDAMPERsON            = True    ###False

btnCarcassText = 0
btnRMORE      = 0
btnRadiuses   = 0
btnMZ         = 0
btnMoveLeft   = 0
btnMoveRight  = 0
btnMoveUp     = 0
btnMoveDown   = 0
btnTOWidthDn  = 0
btnTOWidthUp  = 0
btnTOHeigthDn = 0
btnTOHeightUp = 0
TravelOffsetX = 0
TravelOffsetY = 0
btnFontPlus  = 0
btnFontMinus = 0
btnFontOffsetPlus  = 0
btnFontOffsetMinus = 0
btnFontSizeMinus = 0
btnFontSizePlus = 0

gGAPSIZE         = 0
tyregraphwidth       = 0.75  # percent
gOpacity         = 0.0   # percent
gOpacityFG       = 100   # percent
gAppSizeW         = 1.0   # percent
gAppSizeH         = 1.0   # percent
offsetPercent    = 0.25  # percent
offsetOMI        = 0.0   # off
CURRTorque       = 0.0
locOff           = 0
colorpng = -1

# ac.log(str(dir(ac)))

SuspensionForceEnabled = False
if 'ext_getSusForce' in dir(ac):
    SuspensionForceEnabled = True

#if 'ext_getNumberOfTyresOut' in dir(ac): # from csp 0.2.2-prev4 and up
newtyrewear = False
if 'ext_getTyreWear' in dir(ac) and 'ext_getCGHeight' in dir(ac): # from csp 0.2.2-prev3 and up
    newtyrewear = True


frict_limit_angF = 5.0
frict_limit_angR = 5.0
sTextDrag      = '\n'
sTextDownforce = '\n'
sTextDiff = ''
sTextSlipStream = ''
tyresVersion = ''

maxDownForce     = 150 # thats around a quarter of gt3 level, will be adjusted dynamically
maxDrag          = 500 # adjusted dynamically
maxBrakeTorque   = 0.0
maxTorque        = 0.0
maxDampTravFRONT =-100000.0
minDampTravFRONT = 100000.0
maxDampTravREAR  =-100000.0
minDampTravREAR  = 100000.0

maxSuspTravFRONT =-100000.0
minSuspTravFRONT = 100000.0
maxSuspTravREAR  =-100000.0
minSuspTravREAR  = 100000.0

maxSuspForceFRONT=-1000000.0
minSuspForceFRONT= 1000000.0
maxSuspForceREAR =-1000000.0
minSuspForceREAR = 1000000.0

rh    = [0.0,0.0]
rhMax = [-10000.0,-10000.0]
rhMin = [ 10000.0, 10000.0]

x=0
try:
    i=tyinfo.physics.localVelocity
    x+=1
    i=tyinfo.graphics.windDirection
    x+=2
    i=tyinfo.static.pitWindowEnd
    x+=4
except:
    ac.log("")
    ac.log("tyre_app_ext: WARNING sim_info.py conflict (index "+str(x)+") with older version loaded by previous app")
    ac.log("tyre_app_ext: This could cause tyre_app_ext to fail, update other apps 'sim_info.py' or untick previous loaded apps")
    ac.console("tyre_app_ext: WARNING sim_info.py conflict (index "+str(x)+") with older version loaded by previous app")
    ac.console("tyre_app_ext: This could cause tyre_app_ext to fail, update other apps 'sim_info.py' or untick previous loaded apps")
    ac.log("")

class FontMeasures:
    def __init__(self, name, italic, bold, size, ratio, distance, heightCompensation, widthCompensation):
        self.n = name					#font name
        self.i = italic					#font italic
        self.b = bold					#font bold
        self.s = size					#font multiplier for one pixel height
        self.r = ratio					#font width compared to height
        self.d = distance				#font distance between the leftmost point of one letter and another, avareage
        self.h = heightCompensation		#font height offset to put it centered vertically
        self.w = widthCompensation		#font width offset to put it centered horizontally
        self.f = 0						#font object to be used in rendering
        return

class ExtGL:
    CULL_MODE_FRONT = 0
    CULL_MODE_BACK = 1
    CULL_MODE_NONE = 2
    CULL_MODE_WIREFRAME = 4
    CULL_MODE_WIREFRAME_SMOOTH = 7
    BLEND_MODE_OPAQUE = 0
    BLEND_MODE_ALPHA_BLEND = 1
    BLEND_MODE_ALPHA_TEST = 2
    BLEND_MODE_ALPHA_ADD = 4
    BLEND_MODE_MULTIPLY_BOTH = 5
    FONT_ALIGN_LEFT = 0
    FONT_ALIGN_RIGHT = 1
    FONT_ALIGN_CENTER = 2

temp_curveF=[0.0,0.0]
temp_curveR=[0.0,0.0]
wear_curveF=[0.0,0.0]
wear_curveR=[0.0,0.0]
accG=[1.0,1.0,1.0]
lastaccG=[1.0,1.0,1.0]
tempFtemp=[]
tempRtemp=[]
tempFgrip=[]
tempRgrip=[]
wearFkm=[]
wearRkm=[]
wearFperc=[]
wearRperc=[]
xsinFL=0.0
xsinFR=0.0
ycosFL=0.0
ycosFR=0.0
xsinRL=0.0
xsinRR=0.0
ycosRL=0.0
ycosRR=0.0
dataDict = {}


#######################################################################################################

customFonts = [] # filled dynamically
# customFonts = ["Consolas","Arial Monospace","Segoe UI","Arial","Digital-7","Ticking Timebomb BB","Bahnschrift","LCDMono","NovaMono","Orbitron","Oxygen Mono"]

# https://bytes.com/topic/python/answers/839254-extracting-hte-font-name-truetype-font-file
# Here's the code to parse the spec.
def getTTFFontName(path, fname, fonts):
    try:
        f = open( os.path.join(path + fname), 'rb' )
        #header
        shead= Struct( '>IHHHH' )
        fhead= f.read( shead.size )
        dhead= shead.unpack_from( fhead, 0 )
        #font directory
        stable= Struct( '>4sIII' )
        ftable= f.read( stable.size* dhead[ 1 ] )
        for i in range( dhead[1] ): #directory records
            dtable= stable.unpack_from(ftable, i* stable.size )
            if str(dtable[0])== "b'name'": break
        #name table
        f.seek( dtable[2] ) #at offset
        fnametable = f.read( dtable[3] ) #length
        snamehead = Struct( '>HHH' ) #name table head
        dnamehead = snamehead.unpack_from( fnametable, 0 )
        sname = Struct( '>HHHHHH' )
        ss1=''
        ss2=''
        for i in range( dnamehead[1] ): #name table records
            if snamehead.size+ (i+1)* sname.size < len(fnametable):
                dname = sname.unpack_from(fnametable, snamehead.size+ i* sname.size )
                # key==4 for fontname
                # 64 or 32 chars for fontname?

                ### font name
                if ss1=='' and dname[3]==4 and dname[4] < 64 and dnamehead[2]+ dname[5] + 64 < len(fnametable):
                #if dname[4] < 64 and dnamehead[2]+ dname[5] + 64 < len(fnametable):
                    s  = unpack_from('%is'% dname[4], fnametable, dnamehead[2]+ dname[5] )[0]
                    ss1 = codecs.decode(s)
                    #print( fname + '  -  ' + ss1 + ' - ' + str(dname[3]) )

                ### font name style
                if ss2=='' and dname[3]==2 and dname[4] < 16 and dnamehead[2]+ dname[5] + 16 < len(fnametable):
                #if dname[4] < 64 and dnamehead[2]+ dname[5] + 64 < len(fnametable):
                    s  = unpack_from('%is'% dname[4], fnametable, dnamehead[2]+ dname[5] )[0]
                    ss2 = codecs.decode(s)
                    #print( fname + '  -  ' + ss2 + ' - ' + str(dname[3]) )
            if ss1!='' and ss2!='': break

        lf = len(fonts)
        ss = str( ss1 ).replace('\x00', '')+' '+str( ss2 ).replace('\x00', '')
        #ss = str( ss ).replace(ss2, '')
        if ( (lf==0)  or  (lf>0 and not fonts[lf-1] in ss) or ('mono' in ss.lower() and not fonts[lf-1] in ss and not ss in fonts[lf-1]) ) and not 'ingdings' in ss:
            ss = ss.replace(' Negreta','').replace(' Cursiva','').replace(' Normal','').replace(' Regular','').replace(' Bold','').replace(' Medium','').replace(' Semibold','').replace(' Italic','').replace(' Light','').replace(' Black','').replace(' Semilight','')
            fonts.append( ss )
    except:
        ac.log("MultiLaps: Error in refreshAndWriteParameters: " + traceback.format_exc())

def findFonts(subdirectory, mask, fonts):
    for root, dirs, names in os.walk(subdirectory):
        for name in names:
            if mask in name:
                getTTFFontName(root, name, fonts)

###################################################

def luminance(r,g,b):
    return 0.2126*r + 0.7152*g + 0.0722*b
def hex2rgb(h, order=0):
    h = h.lstrip('#')
    if order==0:
        return tuple(int(h[i:i+2], 16) for i in (0, 2, 4))
    else:
        return tuple(int(h[i:i+2], 16) for i in (4, 2, 0))
def rgb2hex(s):
    rgb=s.split(',')
    return '#%02x%02x%02x' % (int(float(rgb[0])*255.), int(float(rgb[1])*255), int(float(rgb[2])*255))
def InterpolateColors(c1, c2, x, max):
    r1 = c1[0]/255
    g1 = c1[1]/255
    b1 = c1[2]/255
    r2 = c2[0]/255
    g2 = c2[1]/255
    b2 = c2[2]/255
    r=r1 + (r2-r1)*x/max
    g=g1 + (g2-g1)*x/max
    b=b1 + (b2-b1)*x/max
    return [r,g,b]
def GetPaletteFromSomeColors(cols,order=0):
    cPal1=[]
    d = math.ceil( 256/(len(cols)-1) )  ### how many steps from color to color
    dd = (d * (len(cols)-1) - 256) / 2  ### count to not insert too much colors at start + begin
    idd = 0
    for x in range(len(cols)-1):
        for y in range(d):
            if idd>dd and idd<=256+dd:
                col1 = InterpolateColors( hex2rgb(cols[x], order), hex2rgb(cols[x+1], order), y, d )
                cPal1.append(col1)
            idd+=1
    # really make sure we got 256# color palette
    if len(cPal1)>0:
        while len(cPal1)<256:
            cPal1.append(col1)
    return cPal1
#######################################################################################################


### kunos default
# FAR_COLD=0,0,1
# NEAR_COLD=0,0.5,1
# OPTIMAL=0,1,0
# NEAR_HOT=1,0.5,0
# FAR_HOT=1,0,0
# WEAR1=0,1,0
# WEAR2=1,1,0
# WEAR3=1,0,0

# not all colors are taken from those palettes
### for preview image
# |    |    |    |    |    |    |    |    |    |    |    |    |
# Kunos    Sunset* Iridescent* Rainbow*   YlOrBr*  Pastell
#   ▼         ▼         ▼         ▼         ▼         ▼
#      Kunos2  NightFall* Incandecent* BRGn*   Energy    Jungle
#        ▼         ▼         ▼         ▼         ▼         ▼

### count must be equal to colors listed below
ColorNames = ["Kunos", "Kunos2",
              "Sunset*", "NightFall*", "Iridescent*", "Incandecent*", "Rainbow_PuRd*", "BRGn*", "YlOrBr*",
              "Energy", "Pastell", "Jungle"]
ColorsKunos        = [           "#0000ff", "#007fff",            "#00ff00",            "#ff7f00", "#ff0000"           ]
### kunos and added violet, aqua, yellow, dark red
ColorsKunos2       = ["#7F00FF", "#0000FF", "#007FFF", "#00CCCC", "#00FF00", "#CCCC00", "#FF7F00", "#FF0000", "#8F0000"]
### colorblind safe - https://github.com/drammock/colorblind
ColorsSunset       = ['#364B9A', '#4A7BB7', '#6EA6CD', '#98CAE1', '#C2E4EF', '#EAECCC', '#FEDA8B', '#FDB366', '#F67E4B', '#DD3D2D', '#A50026']
ColorsNightFall    = ['#125A56', '#238F9D', '#60BCE9', '#C6DBED', '#ECEADA', '#F9D576', '#FD9A44', '#E94C1F', '#A01813']
ColorsIridescent   = ['#FEFBE9', '#FCF7D5', '#F5F3C1', '#EAF0B5', '#DDECBF','#D0E7CA', '#C2E3D2', '#B5DDD8', '#A8D8DC', '#9BD2E1','#8DCBE4', '#81C4E7', '#7BBCE7', '#7EB2E4', '#88A5DD','#9398D2', '#9B8AC4', '#9D7DB2', '#9A709E', '#906388','#805770', '#684957', '#46353A']
ColorsIncandecent  = ['#cdffff', '#c6f7d5', '#a2f59a', '#bbe453', '#d5cd03','#e6b503', '#f19903', '#f7780b', '#f94901', '#e40314','#a80001']
ColorsRainbow_PuRd = ['#6F4C9B', '#6059A9', '#5568B8', '#4E79C5', '#4D8AC6','#4E96BC', '#549EB3', '#59A5A9', '#60AB9E', '#69B190','#77B77D', '#8CBC68', '#A6BE54', '#BEBC48', '#D1B541','#DDAA3C', '#E49C39', '#E78C35', '#E67932', '#E4632D','#DF4828', '#DA2222']
ColorsBRGn         = ['#762A83', '#9970AB', '#C2A5CF', '#E7D4E8', '#F7F7F7', '#D9F0D3', '#ACD39E', '#5AAE61', '#1B7837']
ColorsYlOrBr       = ['#FFFFFF', '#FFFFE5', '#FFF7BC', '#FEE391', '#FEC44F', '#FB9A29', '#EC7014', '#CC4C02', '#993404', '#662506']
### next are not rgb, but bgr :(
ColorsEnergy       = ["#000677","#002BBB","#0077FF","#55CCFF","#AAFFFF","#FFFFFF"]
ColorsPastell      = ["#880044","#888800","#00CC10","#30EEA0","#0080FF","#000080"]
ColorsJungle       = ["#63a8aD","#18681A","#00AA00","#00FFFF","#0090FF","#2020FF"]
ColorsWear         = ["#00ff00", "#ffff00", "#ff0000"]

### read actual values from
tyres_app_ini = "system/cfg/tyres_app.ini"
if os.path.isfile(tyres_app_ini):
    tyini = ConfigParser(empty_lines_in_values=False, strict=False, allow_no_value=True, inline_comment_prefixes=(";","#","/","_"), comment_prefixes=(";","#","/","_"))
    tyini.optionxform = str
    tyini.read(tyres_app_ini)

    ColorsKunosRead = []
    for s in ["FAR_COLD", "NEAR_COLD", "OPTIMAL", "NEAR_HOT", "FAR_HOT"]:
        if tyini.has_option('OPTIONS',s):
            ColorsKunosRead.append(tyini['OPTIONS'][s])
        else:
            ColorsKunosRead.append(ColorsKunos[i])
    ColorsKunos=[]
    for i, s in enumerate(ColorsKunosRead):
        if not "#" in s:
            ColorsKunos.append(rgb2hex(s))
        else:
            ColorsKunos.append(s)

    ColorsWearRead = []
    for s in ["WEAR1", "WEAR2", "WEAR3"]:
        if tyini.has_option('OPTIONS',s):
            ColorsWearRead.append(tyini['OPTIONS'][s])
        else:
            ColorsWearRead.append(ColorsWear[i])
    ColorsWear=[]
    for i, s in enumerate(ColorsWearRead):
        if not "#" in s:
            ColorsWear.append(rgb2hex(s))
        else:
            ColorsWear.append(s)


### create color palettes
colorPal1 = GetPaletteFromSomeColors(ColorsKunos)
colorPal2 = GetPaletteFromSomeColors(ColorsKunos2)
colorPal3 = GetPaletteFromSomeColors(ColorsSunset)
colorPal4 = GetPaletteFromSomeColors(ColorsNightFall)
colorPal5 = GetPaletteFromSomeColors(ColorsIridescent)
colorPal6 = GetPaletteFromSomeColors(ColorsIncandecent)
colorPal7 = GetPaletteFromSomeColors(ColorsRainbow_PuRd)
colorPal8 = GetPaletteFromSomeColors(ColorsBRGn)
colorPal9 = GetPaletteFromSomeColors(ColorsYlOrBr)
colorPal10= GetPaletteFromSomeColors(ColorsEnergy,1)
colorPal11= GetPaletteFromSomeColors(ColorsPastell,1)
colorPal12= GetPaletteFromSomeColors(ColorsJungle,1)

gColor = 0 # global color var
currPal = colorPal1
colorPalWear = GetPaletteFromSomeColors(ColorsWear)

###palette end###






flashFlag = False
appWindow = 0
appInfo = 0
appSettingstyapp = 0
b_settings = 0
b_maxs = 0
b_resetMinMax = 0
b_presstoggle = 0
b_presstext = 0
bPressureGraph = False
btnPressureGraph = 0
btn_FBG=0
btn_AbsTc = 0
lbCenter = 0
lbCenter2 = 0
lbInfo = 0
lbInfo2 = 0
lbAero = 0
lbAero2 = 0
btnTyreNext = 0
btnTyrePrev = 0
b_Reset = 0
b_MultUp = 0
b_MultDn = 0
b_IMO = 0
b_IMOtext = 0
btnAppWidthDn = 0
btnAppWidthUp = 0
btnAppHeightDn = 0
btnAppHeightUp = 0
btnTOAppSizeDn = 0
btnTOAppSizeUp = 0
b_transpUp   = 0
b_transpDn   = 0
b_transpFGUp = 0
b_transpFGDn = 0
b_widthUp      = 0
b_widthDn      = 0
b_Load       = 0
b_Travel     = 0
b_SlipR      = 0
b_SlipT      = 0
b_Camber     = 0
b_Directions = 0
b_Aero       = 0
b_More       = 0
b_Vals       = 0
b_GapT       = 0
b_color      = 0
b_color2     = 0
b_nm         = 0
b_nmbrake    = 0
b_slipCircle = 0
b_less       = 0
b_GAPSIZEUp  = 0
b_GAPSIZEDn  = 0
b_wearT      = 0
b_aeroT      = 0
b_wearG      = 0
b_ShowBGText = 0
b_GripToggle = 0
b_GripTextToggle = 0

bSHOWTYREINFO = True
bCSPactive  = True
cspCodeNo   = 0
STEERtorque = 0.0

ac_LocalAngV    = [0.0,0.0,0.0]
ac_LocalVelocity= [0.0,0.0,0.0]
bSHOWHOTG = True
bSHOWHOTT = True
btnSHOWHOTG = True
btnSHOWHOTT = True
bSHOWIMO = True
bSHOWIMOTEXT = True
bShowABS = False
bShowLess = False
bShowWearGraph= False
bShowWearText= False
bShowAeroText= False
bShowBGText  = False

bCPhysicsActive      = False
bCPhysCarcassEnabled = False
bCPhysCarcassText    = False
bShowTyreload        = False
bShowCamber          = False
bShowDirections      = False
bShowLocked          = True
bShowSlipRect        = True
bShowSlipText        = False
bNewTyreParams       = False
bFlatBlistGrain      = True
bShowTravel          = False
bShowAero            = False
bShowMore            = False
bShowVals            = True
bShowNM              = False
bShowNM_brake        = False
bShowCircles         = True
bShowRadiuses        = False
bShowPressureDiff    = True
bShowPressure        = True
bShowPressureText    = True
bShowGrip            = False
bShowGripText        = False

currBrake = 0.0
brakestempsConfigured = True
brakeDetection = True
bCPhysBrakesEnabled  = True
bCPhysBrakesText  = True
bCoreTempsEnabled = True

btnBRAKES     = 0
btnBrakeText = 0
# brake temps min/max, dynamically set
maxBT            = 300   # max brake temp
minBT            = 20    # min brake temp

btn_ShowPressure     = 0
isSlipStream = False
slipstreamTime=0.0

f1=0
f2=0
gl_font = None
sDesc=""
compNameShort = ''
tirenameLong = ''
fntSize = 12
currcar = 0
lastCar = -1
cgHeight = 0.0
currspeed = 0.0
theemulti = 1.0
texture_circle = 0
texture_circlefilled = 0
texture_soliddot = 0
texture_dot = 0
texture_rect = 0
texture_rect_inner = 0
texture_inner_top = 0
texture_inner_bot = 0
texture_outer_top = 0
texture_outer_bot = 0
hw=0 # half width
hh=0 # half heigth
minwidth = 0
minheight = 0
offset = 0
AEROCDv=0.0
AEROCLf=0.0
AEROCLr=0.0
AEROdens=0.0
baseAEROdens = -1.0
basecgHeight = -1.0
timer1  = 0.0
timer2 = 0.0
timerRenderer = 0.0
dataCounter = 0
dataCounter1 = 0
dataCounter2 = 0
sIdealTemps = ""
sIdealPress = ""
sIdealGrip = ""
extraHeight = 0
AERODownforce = -1.0
AERODrag      = -1.0

wheels = ["FL", "FR", "RL", "RR"]
WHEELS = {
    "coldRead" : False,
    "BG" : 0,
    "FL" : {
        "dirt"      : 0,
        "dvis"      : False, # dirt visible
        "slip"      : 0,
        "svis"      : False, # slip visible
        "temp"      : { "cold"  : 0, "value" : 0 }, # core temps value
        "tempc"     : { "cold"  : 0, "value" : 0 }, # core temps colored rectangle
        "ctemp"     : { "cold"  : 0, "value" : 0 }, # carcass temps value
        "ctmpc"     : { "cold"  : 0, "value" : 0 }, # carcass temps colored rectangle
        "tempI"     : { "cold"  : 0, "value" : 0 },
        "tempM"     : { "cold"  : 0, "value" : 0 },
        "tempO"     : { "cold"  : 0, "value" : 0 },
        "pres"      : { "label" : 0, "value" : 0 },
        "load"      : { "label" : 0, "value" : 0 },
        "details"   : { "label" : 0, "value" : 0 },
        "brake"     : { "label" : 0, "value" : 0 },
        "brakeD"    : { "label" : 0, "value" : 0 },
        "brakeL"    : { "label" : 0, "value" : 0 },
        "wear"      : { "label" : 0, "value" : 0, "last": -1.0 },
        "wearInner" : { "label" : 0 },
        "wearLabel" : { "label" : 0 }
    },
    "FR" : {
        "dirt"      : 0,
        "dvis"      : False, # dirt visible
        "slip"      : 0,
        "svis"      : False, # slip visible
        "temp"      : { "cold"  : 0, "value" : 0 },
        "tempc"     : { "cold"  : 0, "value" : 0 },
        "ctemp"     : { "cold"  : 0, "value" : 0 },
        "ctmpc"     : { "cold"  : 0, "value" : 0 },
        "tempI"     : { "cold"  : 0, "value" : 0 },
        "tempM"     : { "cold"  : 0, "value" : 0 },
        "tempO"     : { "cold"  : 0, "value" : 0 },
        "pres"      : { "label" : 0, "value" : 0 },
        "load"      : { "label" : 0, "value" : 0 },
        "details"   : { "label" : 0, "value" : 0 },
        "brake"     : { "label" : 0, "value" : 0 },
        "brakeD"    : { "label" : 0, "value" : 0 },
        "brakeL"    : { "label" : 0, "value" : 0 },
        "wear"      : { "label" : 0, "value" : 0, "last": -1.0 },
        "wearInner" : { "label" : 0 },
        "wearLabel" : { "label" : 0 }
    },
    "RL" : {
        "dirt"      : 0,
        "dvis"      : False, # dirt visible
        "slip"      : 0,
        "svis"      : False, # slip visible
        "temp"      : { "cold"  : 0, "value" : 0 },
        "tempc"     : { "cold"  : 0, "value" : 0 },
        "ctemp"     : { "cold"  : 0, "value" : 0 },
        "ctmpc"     : { "cold"  : 0, "value" : 0 },
        "tempI"     : { "cold"  : 0, "value" : 0 },
        "tempM"     : { "cold"  : 0, "value" : 0 },
        "tempO"     : { "cold"  : 0, "value" : 0 },
        "pres"      : { "label" : 0, "value" : 0 },
        "load"      : { "label" : 0, "value" : 0 },
        "details"   : { "label" : 0, "value" : 0 },
        "brake"     : { "label" : 0, "value" : 0 },
        "brakeD"    : { "label" : 0, "value" : 0 },
        "brakeL"    : { "label" : 0, "value" : 0 },
        "wear"      : { "label" : 0, "value" : 0, "last": -1.0 },
        "wearInner" : { "label" : 0 },
        "wearLabel" : { "label" : 0 }
    },
    "RR" : {
        "dirt"      : 0,
        "dvis"      : False, # dirt visible
        "slip"      : 0,
        "svis"      : False, # slip visible
        "temp"      : { "cold"  : 0, "value" : 0 },
        "tempc"     : { "cold"  : 0, "value" : 0 },
        "ctemp"     : { "cold"  : 0, "value" : 0 },
        "ctmpc"     : { "cold"  : 0, "value" : 0 },
        "tempI"     : { "cold"  : 0, "value" : 0 },
        "tempM"     : { "cold"  : 0, "value" : 0 },
        "tempO"     : { "cold"  : 0, "value" : 0 },
        "pres"      : { "label" : 0, "value" : 0 },
        "load"      : { "label" : 0, "value" : 0 },
        "details"   : { "label" : 0, "value" : 0 },
        "brake"     : { "label" : 0, "value" : 0 },
        "brakeD"    : { "label" : 0, "value" : 0 },
        "brakeL"    : { "label" : 0, "value" : 0 },
        "wear"      : { "label" : 0, "value" : 0, "last": -1.0 },
        "wearInner" : { "label" : 0 },
        "wearLabel" : { "label" : 0 }
    }
}

ac_temp           = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_carc           = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }  # cphys new
ac_isHot          = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }  # cphys new
ac_TempMult       = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }  # cphys new
tyreTempI         = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
tyreTempM         = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
tyreTempO         = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_dirt           = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_ndslip         = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_pres           = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_presOpt        = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_load           = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_loadmax        = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_wear           = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_virtkm         = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_flat           = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_blister        = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_grain          = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_brake          = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_brakeC         = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_camb           = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_wspeed         = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_angle          = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_bradius        = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_radius         = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_wspeedCalc     = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_DampTrav       = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_SuspTrav       = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_SuspForce      = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_dy             = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_TyreSlip       = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_Mz             = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_SlipRatio      = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_anglePatch     = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_MaxNonSlipRatio= { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_Grip           = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }
ac_pressLvl       = { "FL" : 0.0, "FR" : 0.0, "RL" : 0.0, "RR" : 0.0 }

bActiveTimer = True
fTimer = 15.0
lbTimer = 0

# main at the end

def clamp(n, minn, maxn):
    if n < minn:
        return minn
    elif n > maxn:
        return maxn
    else:
        return n

def lerp(a, b, n):
    n = clamp(n, 0, 1)
    return a*(1-n)+b*n

def mapFromTo(val,a,b,x,y):
   return (val-a)/(b-a)*(y-x)+x

def C_to_F(C):
    return 9 / 5 * C + 32

def PSI_to(val, to = "BAR"):
    if to == "BAR":
        return val * (6.8948 * 10**-2)
    elif to == "KPA":
        return val * 6.89475729
    else:
        return val

#################################################

def appMultUp(*args):
    global theemulti
    if theemulti<4.0:
        #theemulti = round( (theemulti*100.0 + 5)/100.0, 2) #
        theemulti = round( (theemulti + 0.05), 2)
    appResize()
    appUpdateValues()
def appMultDn(*args):
    global theemulti
    if theemulti>0.1:
        #theemulti = round( (theemulti*100.0 - 5)/100.0, 2) #
        theemulti = round( (theemulti - 0.05), 2)
    appUpdateValues()
    appResize()

def appGAPSIZEUp(*args):
    global gGAPSIZE
    if gGAPSIZE<4000:
        if gGAPSIZE>500:
            gGAPSIZE = gGAPSIZE + 20
        elif gGAPSIZE>100:
            gGAPSIZE = gGAPSIZE + 10
        else:
            gGAPSIZE = gGAPSIZE + 5
    appResize()

def appGAPSIZEDn(*args):
    global gGAPSIZE
    if gGAPSIZE>=-30:
        if gGAPSIZE>500:
            gGAPSIZE = gGAPSIZE - 20
        elif gGAPSIZE>100:
            gGAPSIZE = gGAPSIZE - 10
        else:
            gGAPSIZE = gGAPSIZE - 5
    appResize()

def appSizeWUp(*args):
    global gAppSizeW
    if gAppSizeW<4.0:
        #gAppSizeW = round( (gAppSizeW*100.0 + 5)/100.0, 2) #
        gAppSizeW = round( (gAppSizeW + 0.05), 2)
    appResize()
def appSizeWDn(*args):
    global gAppSizeW
    if gAppSizeW>0.1:
        #gAppSizeW = round( (gAppSizeW*100.0 - 5)/100.0, 2) #
        gAppSizeW = round( (gAppSizeW - 0.05), 2)
    appResize()

def appSizeHUp(*args):
    global gAppSizeH
    if gAppSizeH<4.0:
        gAppSizeH = round( (gAppSizeH + 0.05), 2)
    appResize()
def appSizeHDn(*args):
    global gAppSizeH
    if gAppSizeH>0.1:
        gAppSizeH = round( (gAppSizeH - 0.05), 2)
    appResize()

def appTyreWidthUp(*args):
    global tyregraphwidth
    if tyregraphwidth<2:
        #graphwidth = round( (graphwidth*100.0 + 5)/100.0, 2) #
        tyregraphwidth = round( (tyregraphwidth + 0.05), 2)
    appResize()
def appTyreWidthDn(*args):
    global tyregraphwidth
    if tyregraphwidth>0.1:
        #graphwidth = round( (graphwidth*100.0 - 5)/100.0, 2) #
        tyregraphwidth = round( (tyregraphwidth - 0.05), 2)
    appResize()

def appLoadToggle(*args):
    global bShowTyreload
    bShowTyreload = not bShowTyreload
    appUpdateValues()
    #appResize()
def appTravelToggle(*args):
    global bShowTravel
    bShowTravel = not bShowTravel
    appUpdateValues()
    #appResize()
def appSlipRToggle(*args):
    global bShowSlipRect
    bShowSlipRect = not bShowSlipRect
    appResize()
def appSlipTToggle(*args):
    global bShowSlipText
    bShowSlipText = not bShowSlipText
    appResize()
def appCambToggle(*args):
    global bShowCamber
    bShowCamber = not bShowCamber
    appResize()
def appAeroToggle(*args):
    global bShowAero
    bShowAero = not bShowAero
    appResize()
def appMoreToggle(*args):
    global bShowMore
    bShowMore = not bShowMore
    appResize()
def appGripToggle(*args):
    global bShowGrip
    bShowGrip = not bShowGrip
    appResize()
def appGripTextToggle(*args):
    global bShowGripText
    bShowGripText = not bShowGripText
    appResize()
def appValsToggle(*args):
    global bShowVals
    bShowVals = not bShowVals
    appResize()
def appGapToggle(*args):
    global offsetOMI
    if offsetOMI>0.0:
        offsetOMI=0.0
    else:
        offsetOMI=0.02
    appResize()
def appDirectionsToggle(*args):
    global bShowDirections
    bShowDirections = not bShowDirections
    appResize()

def appToggleTransparencyUp(*args):
    global gOpacity
    if gOpacity<100:
        gOpacity += 10
    if gOpacity>100:
        gOpacity=100
    appResize()
def appToggleTransparencyDn(*args):
    global gOpacity
    if gOpacity>0:
        gOpacity -= 10
    if gOpacity<0:
        gOpacity=0
    appResize()

def appFGTransparencyUp(*args):
    global gOpacityFG
    if gOpacityFG<100:
        gOpacityFG += 10
    if gOpacityFG>100:
        gOpacityFG=100
    appResize()
def appFGTransparencyDn(*args):
    global gOpacityFG
    if gOpacityFG>0:
        gOpacityFG -= 10
    if gOpacityFG<0:
        gOpacityFG=0
    appResize()

def appToggleColor(*args):
    global gColor, ColorNames, currPal
    gColor += 1
    if gColor>len(ColorNames)-1:
        gColor = 0
    currPal = globals()['colorPal'+str(gColor+1)]
    appUpdateValues()
    # appResize()

def appToggleColor2(*args):
    global gColor, ColorNames, currPal
    gColor -= 1
    if gColor<0:
        gColor = len(ColorNames)-1
    currPal = globals()['colorPal'+str(gColor+1)]
    appUpdateValues()
    # appResize()

def appToggleNM(*args):
    global bShowNM
    bShowNM       = not bShowNM
    appResize()

def appToggleNMbrake(*args):
    global bShowNM_brake
    bShowNM_brake = not bShowNM_brake
    appResize()

def appToggleCircles(*args):
    global bShowCircles
    bShowCircles       = not bShowCircles
    appResize()

def appToggleLess(*args):
    global bShowLess
    bShowLess       = not bShowLess
    appResize()

def appwearTextToggle(*args):
    global bShowWearText
    bShowWearText       = not bShowWearText
    appResize()

def appaeroTextToggle(*args):
    global bShowAeroText
    bShowAeroText       = not bShowAeroText
    appResize()

def appBGTextToggle(*args):
    global bShowBGText
    bShowBGText = not bShowBGText
    appResize()

def appwearBarToggle(*args):
    global bShowWearGraph
    bShowWearGraph       = not bShowWearGraph
    appResize()

def appIMOToggle(*args):
    global bSHOWIMO
    bSHOWIMO = not bSHOWIMO
    appResize()

def appIMOTextToggle(*args):
    global bSHOWIMOTEXT
    bSHOWIMOTEXT = not bSHOWIMOTEXT
    appResize()

def apppressdiffmode(*args):
    global bShowPressureDiff, bShowPressure
    bShowPressureDiff = not bShowPressureDiff
    bShowPressure = True
    appResize()

def apppressureenabled(*args):
    global bShowPressure
    bShowPressure = not bShowPressure
    appResize()

def apppressureText(*args):
    global bShowPressureText
    bShowPressureText = not bShowPressureText
    appResize()

def apppressureGraph(*args):
    global bPressureGraph
    bPressureGraph = not bPressureGraph
    appResize()

def appabstctoggle(*args):
    global bShowABS
    bShowABS = not bShowABS
    appResize()

def appflgrbltoggle(*args):
    global bFlatBlistGrain
    bFlatBlistGrain = not bFlatBlistGrain
    appResize()


def appHotTtoggle(*args):
    global bSHOWHOTT
    bSHOWHOTT = not bSHOWHOTT
    appResize()
def appHotGtoggle(*args):
    global bSHOWHOTG
    bSHOWHOTG = not bSHOWHOTG
    appResize()

#########################################################################################
# separation vars

def onMoveLeft(*args):
    global TravelOffsetX
    TravelOffsetX-=5
    appResize()
    #on_click_app_window()

def onMoveRight(*args):
    global TravelOffsetX
    TravelOffsetX+=5
    appResize()
    #on_click_app_window()

def onMoveUp(*args):
    global TravelOffsetY
    TravelOffsetY-=5
    appResize()
    #on_click_app_window()

def onMoveDown(*args):
    global TravelOffsetY
    TravelOffsetY+=5
    appResize()
    #on_click_app_window()

def appTOSizeUp(*args):
    global TOAppSize
    if TOAppSize<4.0:
        TOAppSize = round( (TOAppSize + 0.05), 2)
    appResize()
def appTOSizeDn(*args):
    global TOAppSize
    if TOAppSize>0.1:
        TOAppSize = round( (TOAppSize - 0.05), 2)
    appResize()

def appTOWidthUp(*args):
    global TOgraphwidth
    TOgraphwidth = TOgraphwidth + 5
    appResize()
def appTOWidthDn(*args):
    global TOgraphwidth
    TOgraphwidth = TOgraphwidth - 5
    appResize()

def onTOWidthDn(*args):
    global TOoffsetx
    TOoffsetx-=5
    appResize()
    #on_click_app_window()

def onTOWidthUp(*args):
    global TOoffsetx
    TOoffsetx+=5
    appResize()
    #on_click_app_window()

def onTOHeigthDn(*args):
    global TOoffsety
    TOoffsety+=5
    appResize()
    #on_click_app_window()

def onTOHeightUp(*args):
    global TOoffsety
    TOoffsety-=5
    appResize()
    #on_click_app_window()

#########################################################################################

def appBlendImage(x, y, img, cval, ishot=False, mult=1.0):
    # ac_isHot[wheel] , ac_TempMult[wheel]
    global gColor, currPal, gOpacityFG, bNewTyreParams, dataCounter1, theemulti, maxTR, minTR, minTF, maxTF
    global gAppSizeW, gAppSizeH
    cval = ( max(0,min(maxTR, cval-minTR)))/(maxTR-minTR) * theemulti
    # cval2 = ( max(0,min(maxTF, cval-minTF)))/(maxTF-minTF) * theemulti
    try:
        if bNewTyreParams:
            colorThreshold=0.95
            multThing = 1/(1-colorThreshold)
            if ishot: # interpolate cval red-green
                #cval = lerp(0.0, 1.0, max((mult-colorThreshold)*multThing,0))
                #cval = lerp(1.0, 0.5, max((mult-colorThreshold)*multThing,0))
                # cval = max((mult-colorThreshold)*multThing,0)
                #cval = clamp(cval, 0.75, 1.0)
                #cval = 0.5 + lerp(0.5, 1.0, mult/10)

                ### cheating here, skip stuff and just mult and clamp
                cval *= mult + 0.2
        cval = clamp(cval, 0.0, 1.0)

        ac.glColor4f(currPal[int(cval*255)][0],
                     currPal[int(cval*255)][1],
                     currPal[int(cval*255)][2],
                     1)
                     #gOpacityFG/100.0)
        ac.glQuadTextured(x, y, gAppSizeW*240/2.5, gAppSizeH*240, img)
        #ac.glQuadTextured(x, y, gAppSizeW*300/2.5, gAppSizeH*300, img)
        # ac.glQuadTextured(x/marginX, y/marginY, gAppSizeW*300/2.5, gAppSizeH*50, img)
        # if not bSHOWIMO or not bSHOWIMOTEXT:
        #     ac.glQuadTextured(x, y, gAppSizeW*300/2.5, gAppSizeH*300, img)
        # else:
        #     ac.glQuadTextured(x, y, gAppSizeW*300/2.5, gAppSizeH*300, img)
    except:
        ac.log('tyre_app_ext blend: ' + traceback.format_exc() )


def appSetControlBGColorBrakes(l_tyre, cval, ishot=False, mult=1.0):
    global currPal, gOpacityFG
    cval = clamp(cval, 0.0, 1.0)
    ac.setBackgroundColor(l_tyre, currPal[int(cval*255)][0], currPal[int(cval*255)][1], currPal[int(cval*255)][2])
    l = luminance(currPal[int(cval*255)][0], currPal[int(cval*255)][1], currPal[int(cval*255)][2])*100
    if l>50:
        ac.setFontColor(l_tyre, 0,0,0,gOpacityFG/100.0)
    else:
        ac.setFontColor(l_tyre, 1,1,1,gOpacityFG/100.0)
    ac.setBackgroundOpacity(l_tyre, gOpacityFG/100.0)

def appSetControlBGColor(l_tyre, cval, ishot=False, mult=1.0):
    global gColor, currPal, gOpacityFG, bNewTyreParams, dataCounter1, theemulti, maxTR, minTR, minTF, maxTF
    # ac_isHot[wheel] , ac_TempMult[wheel]
    # cval = ( max(0,min(maxTR, cval-minTR)))/(maxTR-minTR) * theemulti

    if bNewTyreParams:
        colorThreshold=0.95
        multThing = 1/(1-colorThreshold)
        if ishot: # interpolate cval red-green
            #cval = lerp(0.0, 1.0, max((mult-colorThreshold)*multThing,0))
            #cval = lerp(1.0, 0.5, max((mult-colorThreshold)*multThing,0))
            # cval = max((mult-colorThreshold)*multThing,0)
            #cval = clamp(cval, 0.75, 1.0)
            #cval = 0.5 + lerp(0.5, 1.0, mult/10)

            ### cheating here, skip stuff and just mult and clamp
            cval *= mult + 0.2
    cval = clamp(cval, 0.0, 1.0)


    # ac.setBackgroundColor(l_tyre, currPal[int(cval)][0], currPal[int(cval)][1], currPal[int(cval)][2])
    ac.setBackgroundColor(l_tyre, currPal[int(cval*255)][0], currPal[int(cval*255)][1], currPal[int(cval*255)][2])
    # ac.setBackgroundColor(l_tyre, 0, 0, 0)

    l = luminance(currPal[int(cval*255)][0], currPal[int(cval*255)][1], currPal[int(cval*255)][2])*100
    # ac.setTitle(appWindow, str(round(l, 4)))

    if l>50:
        ac.setFontColor(l_tyre, 0,0,0,gOpacityFG/100.0)
    else:
        ac.setFontColor(l_tyre, 1,1,1,gOpacityFG/100.0)
    ac.setBackgroundOpacity(l_tyre, gOpacityFG/100.0)


#################################################

def appDrawLine2(r,g,b,a,x1,y1,width=10,height=10):
    global bCSPactive
    ac.glColor4f(r,g,b,a)
    ac.glQuad(x1,y1,width,height)

def appDrawRectOutline(r,g,b,a,x,y,w,h):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(0)
    ac.glVertex2f(x  , y)
    ac.glVertex2f(x+w, y)
    ac.glVertex2f(x-1, y+h)
    ac.glVertex2f(x+w, y+h)
    ac.glVertex2f(x+w, y)
    ac.glVertex2f(x+w, y+h)
    ac.glVertex2f(x  , y)
    ac.glVertex2f(x  , y+h)
    ac.glEnd()

def appDrawRectLeftRightOnly(r,g,b,a,x,y,w,h):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(0)
    #ac.glVertex2f(x  , y)
    #ac.glVertex2f(x+w, y)
    #ac.glVertex2f(x-1, y+h)
    #ac.glVertex2f(x+w, y+h)
    ac.glVertex2f(x+w, y)
    ac.glVertex2f(x+w, y+h)
    ac.glVertex2f(x  , y)
    ac.glVertex2f(x  , y+h)
    ac.glEnd()

def appDrawLine3(r,g,b,a,x1,y1,x2,y2,height=4):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x1,y1-height/2)
    ac.glVertex2f(x2,y2-height/2)
    ac.glVertex2f(x2,y2+height/2)
    ac.glVertex2f(x1,y1+height/2)
    ac.glEnd()

def appDrawLine3b(r,g,b,a,x1,y1,x2,y2,height=4):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x1,y1)
    ac.glVertex2f(x2,y2-3)
    ac.glVertex2f(x2,y2+3)
    ac.glVertex2f(x1,y1)
    ac.glEnd()

def appDrawLine3c(r,g,b,a,x1,y1,x2,y2,height=4):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x2,y1         )
    ac.glVertex2f(x1,y2-height)
    ac.glVertex2f(x1,y2+height)
    ac.glVertex2f(x2,y1)
    ac.glEnd()

def appDrawLine3d(r,g,b,a,x1,y1,x2,y2,height=4):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x1,y1)
    ac.glVertex2f(x2,y2)
    ac.glVertex2f(x2,y2)
    ac.glVertex2f(x1,y1)
    ac.glEnd()

def appDrawLine4(r,g,b,a,x1,y1,x2,y2): # simple non filled rectangle
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x1,y1)
    ac.glVertex2f(x1,y2)
    ac.glVertex2f(x2,y2)
    ac.glVertex2f(x2,y1)
    ac.glEnd()

def appDrawLine5(r,g,b,a,x1,y1,x2,y2,y3):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x1,y1)
    ac.glVertex2f(x1,y3)
    ac.glVertex2f(x2,y2)
    ac.glVertex2f(x2,y1)
    ac.glEnd()

def appDrawLine6(r,g,b,a,h,x1,x2,y1,y2):
    global cspActive
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(h-x1,y1)
    ac.glVertex2f(h+x1,y1)
    ac.glVertex2f(h+x2,y2)
    ac.glVertex2f(h-x2,y2)
    ac.glEnd()

def appDrawDot(r,g,b,a,x1,y1,size):
    global texture_dot, hw, hh
    ac.glColor4f(r,g,b,a)
    ac.glQuadTextured(x1-size/2*hw, y1-size/2*hw, size*hw, size*hw, texture_dot)

def appDrawDot2(r,g,b,a,x1,y1,size):
    global texture_soliddot, hw, hh
    ac.glColor4f(r,g,b,a)
    ac.glQuadTextured(x1-size/2*hw, y1-size/2*hw, size*hw, size*hw, texture_soliddot)

def appDrawDot3(r,g,b,a,x1,y1,size):
    global texture_dot, hw, hh
    ac.glColor4f(r,g,b,a)
    ac.glQuadTextured(x1-size/2, y1-size/2, size, size, texture_dot)

def appDrawCircle(       r,g,b,a,x1,y1,sizex,sizey):
    global texture_circle
    ac.glColor4f(r,g,b,1)
    ac.glQuadTextured(x1-max(5,sizex), y1-max(5,sizey), max(5,sizex)*2, max(5,sizey)*2, texture_circle)

def appDrawCircleFilled(       r,g,b,a,x1,y1,sizex,sizey):
    global texture_circlefilled
    ac.glColor4f(r,g,b,1)
    ac.glQuadTextured(x1-max(5,sizex), y1-max(5,sizey), max(5,sizex)*2, max(5,sizey)*2, texture_circlefilled)

def appDrawCircleNoMin(       r,g,b,a,x1,y1,sizex,sizey):
    if sizex and sizey<1:
        return
    global texture_circle
    ac.glColor4f(r,g,b,1)
    ac.glQuadTextured(x1-sizex, y1-sizey, sizex*2, sizey*2, texture_circle)

def appDrawCircleCorrect(r,g,b,a,x1,y1,sizex,sizey):
    global texture_circle
    ac.glColor4f(r,g,b,1)
    ac.glQuadTextured(x1-max(5,sizex), y1-max(5,sizey), max(5,sizex)*2, max(5,sizey)*2, texture_circle)

def appDrawTextureRect(r,g,b,a,x1,y1,w,h, tex1=texture_rect):
    global hw, hh
    ac.glColor4f(r,g,b,a)
    ac.glQuadTextured(x1-w/2*hw, y1-h/2*hh-1, w*hw, h*hh, tex1)

def appDrawText(c, t, x, y, sz=12, align=ExtGL.FONT_ALIGN_CENTER):
    global f1
    ac.ext_glFontColor(f1.f, c, c, c, 1)
    ac.ext_glFontUse(f1.f, t, x, y, sz, align)

def appDrawTextShadow(t, x, y, sz=12, align=ExtGL.FONT_ALIGN_LEFT):
    global f1
    ac.ext_glFontUse(f1.f, t, x, y, sz, align)

def appToggleTextWhiteOnBlack(*args):
    global bTextWhiteOnBlack
    bTextWhiteOnBlack = not bTextWhiteOnBlack
    appResize()
    appSaveSettings()

def appToggleImgSet(*args):
    global bImgSet
    bImgSet = not bImgSet
    appResize()
    appSaveSettings()

def appDrawRectFilled(r,g,b,a,x1,y1,w,h):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x1  ,y1)
    ac.glVertex2f(x1+w,y1)
    ac.glVertex2f(x1+w,y1+h)
    ac.glVertex2f(x1  ,y1+h)
    ac.glEnd()

#################################################

def appDrawTextWithRect(t, x, y, sz, rectsz, align=ExtGL.FONT_ALIGN_LEFT, shadow=True, isHot=False):
    global f1, f2
    if t=="":
        return
    if bTextWhiteOnBlack:
        ac.glColor4f(0,0,0,0.75)
    else:
        ac.glColor4f(1,1,1,0.75)
    w2 = rectsz
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x-w2,y        - fontOffsetY)
    ac.glVertex2f(x+w2,y        - fontOffsetY)
    ac.glVertex2f(x+w2,y+sz*1.3 - fontOffsetY)
    ac.glVertex2f(x-w2,y+sz*1.3 - fontOffsetY)
    ac.glEnd()
    if bTextWhiteOnBlack:
        ac.ext_glFontColor(f1.f, 1,1,1,1)
    else:
        ac.ext_glFontColor(f1.f, 0,0,0,1)
    ac.ext_glFontUse(f1.f, t, x, y-sz*0.05, sz, align)

def appDrawTextWithRectL(t, x, y, sz, rectsz, align=ExtGL.FONT_ALIGN_LEFT, shadow=True, isHot=False):
    global f1, f2
    if t=="":
        return
    if bTextWhiteOnBlack:
        ac.glColor4f(0,0,0,0.75)
    else:
        ac.glColor4f(1,1,1,0.75)
    w2 = rectsz
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x-w2*2,y        - fontOffsetY)
    ac.glVertex2f(x     ,y        - fontOffsetY)
    ac.glVertex2f(x     ,y+sz*1.3 - fontOffsetY)
    ac.glVertex2f(x-w2*2,y+sz*1.3 - fontOffsetY)
    ac.glEnd()

    if bTextWhiteOnBlack:
        ac.ext_glFontColor(f1.f, 1,1,1,1)
    else:
        ac.ext_glFontColor(f1.f, 0,0,0,1)
    ac.ext_glFontUse(f1.f, t, x, y-sz*0.05, sz, align)

def appDrawTextWithRectR(t, x, y, sz, rectsz, align=ExtGL.FONT_ALIGN_LEFT, shadow=True, isHot=False):
    global f1, f2
    if t=="":
        return
    if bTextWhiteOnBlack:
        ac.glColor4f(0,0,0,0.75)
    else:
        ac.glColor4f(1,1,1,0.75)
    w2 = rectsz
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x     ,y        - fontOffsetY)
    ac.glVertex2f(x+w2*2,y        - fontOffsetY)
    ac.glVertex2f(x+w2*2,y+sz*1.3 - fontOffsetY)
    ac.glVertex2f(x     ,y+sz*1.3 - fontOffsetY)
    ac.glEnd()
    if bTextWhiteOnBlack:
        ac.ext_glFontColor(f1.f, 1,1,1,1)
    else:
        ac.ext_glFontColor(f1.f, 0,0,0,1)
    ac.ext_glFontUse(f1.f, t, x, y-sz*0.05, sz, align)




def appDrawTextWithShadows(t, x, y, sz, align=ExtGL.FONT_ALIGN_LEFT, shadow=True, isHot=False):
    global f1, f2
    if bTextWhiteOnBlack:
        ac.ext_glFontColor(f1.f, 0,0,0,0.9)
    else:
        ac.ext_glFontColor(f1.f, 1,1,1,0.9)
    appDrawTextShadow(t, x+1, y, sz, align)
    appDrawTextShadow(t, x+1, y-1, sz, align)
    appDrawTextShadow(t, x+1, y+1, sz, align)
    appDrawTextShadow(t, x-1, y-1, sz, align)
    appDrawTextShadow(t, x-1, y+1, sz, align)

    if bTextWhiteOnBlack:
        ac.ext_glFontColor(f1.f, 0,0,0,0.5)
    else:
        ac.ext_glFontColor(f1.f, 1,1,1,0.5)

    appDrawTextShadow(t, x+2, y, sz, align)
    appDrawTextShadow(t, x+2, y+2, sz, align)
    appDrawTextShadow(t, x+2, y-2, sz, align)
    appDrawTextShadow(t, x-2, y, sz, align)
    appDrawTextShadow(t, x-2, y+2, sz, align)
    appDrawTextShadow(t, x-2, y-2, sz, align)

    if bTextWhiteOnBlack:
        ac.ext_glFontColor(f1.f, 1,1,1,1)
    else:
        ac.ext_glFontColor(f1.f, 0,0,0,1)
    ac.ext_glFontUse(f1.f, t, x, y, sz, align)

def appDrawTextWithShadowsColor(r,g,b,a,t, x, y, sz, align=ExtGL.FONT_ALIGN_LEFT, shadow=True):
    global f1, f2
    if bTextWhiteOnBlack:
        ac.ext_glFontColor(f1.f, 0,0,0,a)
    else:
        ac.ext_glFontColor(f1.f, 1,1,1,a)
    appDrawTextShadow(t, x+1, y-1, sz, align)
    appDrawTextShadow(t, x+1, y+1, sz, align)
    appDrawTextShadow(t, x+2, y+2, sz, align)
    #appDrawTextShadow(t, x-1, y  , sz, align)
    appDrawTextShadow(t, x-1, y-1, sz, align)
    appDrawTextShadow(t, x-1, y+1, sz, align)
    ac.ext_glFontColor(f1.f, r,g,b,a)
    if bTextWhiteOnBlack:
        ac.ext_glFontColor(f1.f, 1,1,1,a)
    else:
        ac.ext_glFontColor(f1.f, 0,0,0,a)
    ac.ext_glFontUse(f1.f, t, x, y, sz, align)

def appDrawTextWithShadowsColorABSTC(r,g,b,a,t, x, y, sz, align=ExtGL.FONT_ALIGN_LEFT, shadow=True):
#def appDrawTextWithShadows(c, t, x, y, sz=12, align=ExtGL.FONT_ALIGN_CENTER):
    global f1, f2
    ac.ext_glFontColor(f1.f, 0,0,0,a)
    appDrawTextShadow(t, x+1, y-1, sz, align)
    appDrawTextShadow(t, x+1, y+1, sz, align)
    appDrawTextShadow(t, x+2, y+2, sz, align)
    #appDrawTextShadow(t, x-1, y  , sz, align)
    appDrawTextShadow(t, x-1, y-1, sz, align)
    appDrawTextShadow(t, x-1, y+1, sz, align)
    ac.ext_glFontColor(f1.f, r,g,b,a)
    ac.ext_glFontUse(f1.f, t, x, y, sz, align)

def appDrawTextCol(r,g,b,a, t, x, y, sz=12, align=ExtGL.FONT_ALIGN_CENTER):
    global f2
    ac.ext_glFontColor(f2.f, r,g,b,a)
    ac.ext_glFontUse(f2.f, t, x, y, sz, align)

def appDrawTextColFont1(r,g,b,a, t, x, y, sz=12, align=ExtGL.FONT_ALIGN_CENTER):
    global f1
    ac.ext_glFontColor(f1.f, r,g,b,a)
    ac.ext_glFontUse(f1.f, t, x, y, sz, align)

def extGetBrakeTorque(id):
    global maxBrakeTorque
    bt = ac.ext_getBrakeTorque(id)
    if bt > maxBrakeTorque:
        maxBrakeTorque = bt
    return bt

def appDrawLine1old(r,g,b,a,x1,y1,x2,y2,width=4):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x1        ,y1+1)
    ac.glVertex2f(x2-width/2,y2-1)
    ac.glVertex2f(x2        ,y2-1)
    ac.glVertex2f(x1+width/2,y1+1)
    ac.glEnd()

def appDrawLine0(r,g,b,a,x1,y1,x2,y2,width=4):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x1        ,y1)
    ac.glVertex2f(x2,y2-width/2)
    ac.glVertex2f(x2        ,y2)
    ac.glVertex2f(x1,y1+width/2)
    ac.glEnd()

def appDrawLineTri0(r,g,b,a,x1,y1,x2,y2,width=4):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Triangles)
    if x1>x2:
        ac.glVertex2f(x1,y1)
        ac.glVertex2f(x2,y2-width/2)
        ac.glVertex2f(x2,y2+width/2)
    else:
        ac.glVertex2f(x2,y2-width/2)
        ac.glVertex2f(x1,y1)
        ac.glVertex2f(x2,y2+width/2)
    ac.glEnd()

def appDrawLine(r,g,b,a,x1,y1,x2,y2,width=4):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x1        ,y1)
    ac.glVertex2f(x2-width/2,y2)
    ac.glVertex2f(x2        ,y2)
    ac.glVertex2f(x1+width/2,y1)
    ac.glEnd()

def appDrawLineWAngle(r,g,b,a,x,y,angle,len,width=4):
    sinv = -max(-1.0, min(1.0, math.sin( math.radians(angle)) ))
    cosv = -max(-1.0, min(1.0, math.cos( math.radians(angle)) ))
    sinl = sinv * TOhw/2 #max(-TOhw/2,min(abs(sinv) * TOhw/2, TOhw/2))
    cosl = cosv * TOhh
    ac.glColor4f(r,g,b,a)
    # if abs(sinv)>0.8:
    #     # appDrawLineLEB0(x,y,x+len+width/2,y+len+width/2)
    #     #appDrawLine1(r,g,b,a,x,y,angle,len,width)
    # else:
    ac.glBegin(acsys.GL.Quads)
    ac.glVertex2f(x-sinl-width/2, y-cosl-len/2)
    ac.glVertex2f(x-sinl+width/2, y-cosl-len/2)
    ac.glVertex2f(x+sinl+width/2, y+cosl+len/2)
    ac.glVertex2f(x+sinl-width/2, y+cosl+len/2)
    ac.glEnd()

def appDrawLineTriHori(r,g,b,a,x1,y1,x2,height=4):
    ac.glColor4f(r,g,b,a)
    ac.glBegin(acsys.GL.Triangles)
    ac.glVertex2f(x1        ,y1-height/2)
    ac.glVertex2f(x2        ,y1)
    ac.glVertex2f(x1        ,y1+height/2)
    ac.glEnd()

def appDrawLine1(r,g,b,a,x1,y1,x2,y2,width=4):
    ac.glColor4f(r,g,b,a)
    # triangle growing to the sides
    ac.glBegin(acsys.GL.Triangles)
    ac.glVertex2f(x1,y2)
    ac.glVertex2f(x2,y2)
    ac.glVertex2f(x1,y1)
    ac.glEnd()

def appDrawLineSlipAngle(r,g,b,a,x1,y1,x2,y2,width=4):
    ac.glColor4f(r,g,b,a)
    # triangle growing to the sides
    ac.glBegin(acsys.GL.Triangles)
    ac.glVertex2f(x1,y2)
    ac.glVertex2f(x2,y2)
    ac.glVertex2f(x1,y1)
    ac.glEnd()


def appDrawLineLEB0(x1,y1,x2,y2,width=4):
  ac.glBegin(acsys.GL.Lines)
  ac.glVertex2f(    x1     , y1)
  ac.glVertex2f(    x2     , y2)
  for i in range(1,int(width)):
    ac.glVertex2f(  x1, y1+i)
    ac.glVertex2f(  x2, y2+i)
  ac.glEnd()

def appDrawLineLEB1(x1,y1,x2,y2,width=4):
  ac.glBegin(acsys.GL.Lines)
  ac.glVertex2f(    x1     , y1)
  ac.glVertex2f(    x2     , y2)
  for i in range(1,int(width)):
    ac.glVertex2f(  x1+i, y1)
    ac.glVertex2f(  x2+i, y2)
  ac.glEnd()

def appDrawLineCalced(x1,y1,x2,y2, width=2):
    if y1==y2:
        appDrawLineLEB0(x1,y1,x2,y2,width)
    elif x1==x2:
        appDrawLineLEB1(x1,y1,x2,y2,width)
    else:
        direction = ( -math.degrees( math.atan2(y1 - y2, x2 - x1)))
        dx1 = math.cos((-direction + 90) * math.pi / 180) * width*0.5
        dy1 = math.sin((-direction + 90) * math.pi / 180) * width*0.5
        dx2 = math.cos((-direction - 90) * math.pi / 180) * width*0.5
        dy2 = math.sin((-direction - 90) * math.pi / 180) * width*0.5
        ac.glBegin(acsys.GL.Quads)
        ac.glVertex2f(x1+dx1, y1-dy1)
        ac.glVertex2f(x2-dx2, y2+dy2)
        ac.glVertex2f(x2+dx2, y2-dy2)
        ac.glVertex2f(x1-dx1, y1+dy1)
        ac.glEnd()


################################################################################################################################


def on_click_app_info(*args):
    global lbTimer, bActiveTimer
    bActiveTimer=False
    ac.setVisible(lbTimer,0)

def on_click_app_window(*args):
    global bHideTimerOn, hideTimer, appWindow, b_settings, b_maxs, b_resetMinMax, lbAero2, lbAero
    bHideTimerOn = True
    hideTimer = 5.0
    ac.setIconPosition(appWindow, 0, -30)
    ac.setVisible(b_settings, 1)
    ac.setVisible(b_maxs, 1)
    ac.setVisible(b_resetMinMax, 1)
    ac.setVisible(lbAero,0)
    ac.setVisible(lbAero2,0)

def onappResetMinMax(*args):
    global fMaxsTimer, fMinsTimer, fMins, fMaxs
    global maxDownForce, maxDrag, maxBrakeTorque, maxTorque, maxDampTravFRONT, minDampTravFRONT, maxDampTravREAR, minDampTravREAR, maxSuspTravFRONT, minSuspTravFRONT, maxSuspTravREAR, minSuspTravREAR, maxSuspForceFRONT, minSuspForceFRONT, maxSuspForceREAR, minSuspForceREAR
    fMaxsTimer = [-1.0]*30
    fMinsTimer = [-1.0]*30
    fMins = [9999999.0]*30
    fMaxs = [0.0]*30
    maxDownForce     = 150 # thats around a quarter of gt3 level, will be adjusted dynamically
    maxDrag          = 500 # adjusted dynamically
    maxBrakeTorque   = 0.0
    maxTorque        = 0.0
    maxDampTravFRONT =-100000.0
    minDampTravFRONT = 100000.0
    maxDampTravREAR  =-100000.0
    minDampTravREAR  = 100000.0
    maxSuspTravFRONT =-100000.0
    minSuspTravFRONT = 100000.0
    maxSuspTravREAR  =-100000.0
    minSuspTravREAR  = 100000.0
    maxSuspForceFRONT=-1000000.0
    minSuspForceFRONT= 1000000.0
    maxSuspForceREAR =-1000000.0
    minSuspForceREAR = 1000000.0

    on_click_app_window(*args)

def onappMaxs(*args):
    global fMaxsTimer, fMinsTimer
    fMaxsTimer = [5.0]*30
    fMinsTimer = [-1.0]*30
    on_click_app_window(*args)

def onappMins(*args):
    global fMaxsTimer, fMinsTimer
    fMinsTimer = [5.0]*30
    fMaxsTimer = [-1.0]*30
    on_click_app_window(*args)

def getLevelPressureDiff(ac_press, ac_pressOpt, wantedscale, wantedwidth):
    press_diff = ac_press - ac_pressOpt
    lv = max(-wantedwidth, min(wantedwidth, mapFromTo( press_diff, -wantedscale, wantedscale, -wantedwidth, wantedwidth) ))
    return lv

def getTyreColorID(press_diff):
    lv = 128
    if abs(press_diff) < 0.25:
        lv = 128
    else:
        lv = max(0, min(255, int(mapFromTo(press_diff, -5, 5, 0, 255)) ))
    return int(lv)

def appGetPressureText(val, unit=True):
    if unit:
        if   gUnits["pressure"] == "BAR":
            return str(round(PSI_to(val),1)            ) + "bar"
        elif gUnits["pressure"] == "KPA":
            return str(round(PSI_to(val, to = "KPA"),1)) + "kPa"
        else:
            return str(round(val,1)                    ) + "psi"
    else:
        if   gUnits["pressure"] == "BAR":
            return str(round(PSI_to(val),1)            )
        elif gUnits["pressure"] == "KPA":
            return str(round(PSI_to(val, to = "KPA"),1))
        else:
            return str(round(val,1)                    )
    return s

def appGetPressureDiffText(val, unit=False):
    if val>=0:
        return "+" + appGetPressureText(val,unit)
    else:
        return       appGetPressureText(val,unit)

def appGetTempText(temp, decimals=True, units=False):
    if decimals:
        if units:
            return ("%.1f°C" % temp ) if gUnits["temp"] == "C" else "%.1f°F" % C_to_F(temp)
        else:
            return ("%.1f" % temp ) if gUnits["temp"] == "C" else "%.1f" % C_to_F(temp)
    else:
        if units:
            return ("%d°C"   % int(temp) ) if gUnits["temp"] == "C" else "%d°C" % int(C_to_F(temp))
        else:
            return ("%d"   % int(temp) ) if gUnits["temp"] == "C" else "%d" % int(C_to_F(temp))
    #        temperature = "\n%.1f°C" % ac_temp[wheel] if gUnits["temp"] == "C" else "\n%.1f°F" % C_to_F(ac_temp[wheel])
    #    else:
    #        temperature = "\n%.1f"   % ac_temp[wheel] if gUnits["temp"] == "C" else "\n%.1f" % C_to_F(ac_temp[wheel])

def appGetTempTextUnits(temp, decimals=True, units=True):
    if decimals:
        if units:
            return ("%.1f°C" % temp ) if gUnits["temp"] == "C" else "%.1f°F" % C_to_F(temp)
        else:
            return ("%.1f" % temp ) if gUnits["temp"] == "C" else "%.1f" % C_to_F(temp)
    else:
        if units:
            return ("%d°C"   % int(temp) ) if gUnits["temp"] == "C" else "%d°C" % int(C_to_F(temp))
        else:
            return ("%d"   % int(temp) ) if gUnits["temp"] == "C" else "%d" % int(C_to_F(temp))


def appMinMaxTimerActive(*args):
    global fMaxsTimer, fMinsTimer
    if fMaxsTimer[0]>=0.0 or fMinsTimer[0]>=0.0:
        return True
    else:
        return False

def appMaxTimerActive(*args):
    global fMaxsTimer
    if fMaxsTimer[0]>=0.0:
        return True
    else:
        return False

def appMinTimerActive(*args):
    global fMinsTimer
    if fMinsTimer[0]>=0.0:
        return True
    else:
        return False

def appCheckMinMax(deltaT, id, descr, x, y, ftsize, val, align=ExtGL.FONT_ALIGN_CENTER):
    global fMaxs, fMins, fMinsTimer, fMaxsTimer, bAutoShowMinMax
    res=False
    s=""
    if  fMaxs[id] < round(val,1):
        fMaxs[id] = round(val,1)
        if bAutoShowMinMax:
            fMaxsTimer[id] = 5.0
    if fMaxsTimer[id]>=0.0:
        fMaxsTimer[id] -= deltaT
        if id in [16,17,18,19]:
            s+=appGetPressureText( round(fMaxs[id],1) )
        else:
            s+=appGetTempText( round(fMaxs[id],1) , True, True)

    if  fMins[id] > round(val,1):
        fMins[id] = round(val,1)
        if bAutoShowMinMax:
            fMinsTimer[id] = 5.0
    if fMinsTimer[id]>=0.0:
        fMinsTimer[id] -= deltaT
        if id in [16,17,18,19]:
            s+=appGetPressureText( round(fMins[id],1) )
        else:
            s+=appGetTempText( round(fMins[id],1), True, True )
    # if s!="":
    #     appDrawTextWithShadows(descr +" "+ s, x, y, ftsize, align)


def getBrakeTempText(ac_brake_val, ac_brake_val2):
    global bCoreTempsEnabled
    brakeT = "%.0f" % ac_brake_val if gUnits["temp"] == "C" else "%.0f" % C_to_F(ac_brake_val)
    brakeDT=""
    if bCoreTempsEnabled:
        brakeDT = "%.0f" % ac_brake_val2 if gUnits["temp"] == "C" else "%.0f" % C_to_F(ac_brake_val2)
    return brakeT + "\n\n" + brakeDT

def appInsertLabel(app, desc,align="left",ftsize=12):
    l = ac.addLabel(app, desc)
    ac.setFontAlignment(l,align)
    ac.setFontSize(l,ftsize)
    return l

def appInsertButton(app, desc, x, y, w, h, fsize, fn, align="center"):
    global sCustomFontName2
    btn = ac.addButton(app, desc)
    ac.setPosition(btn, x, y)
    ac.setSize(btn, w, h)
    ac.setFontSize(btn, fsize)
    ac.addOnClickedListener(btn, fn)
    ac.setFontAlignment(btn, align)
    ac.setCustomFont(btn, sCustomFontName2, 0, 0)
    return btn

def appInsertCheckbox(appWindow, text, value, x, y, width, height, visible=False, fn=None):
    newCB = ac.addCheckBox(appWindow, text)
    ac.setFontSize(newCB, 10)
    ac.setPosition(newCB, x, y)
    ac.setSize(newCB, width, height)
    ac.setValue(newCB, value)
    ac.setVisible(newCB, visible)
    if fn!=None:
        ac.addOnClickedListener(newCB, fn)
    return newCB


def appRMORE(*args):
    global TravelOffsetX, TravelOffsetY, TOoffsetx, TOoffsety, TOAppSize
    TravelOffsetX = 0
    TravelOffsetY = 0
    TOoffsetx = 20
    TOoffsety = 0
    TOAppSize = 1.0
    appResize()

def appMZtoggle(*args):
    global bMz
    bMz = not bMz
    appResize()

def appRadiusesToggle(*args):
    global bShowRadiuses
    bShowRadiuses = not bShowRadiuses
    appResize()

def onFancyClick(*args):
    global bFancyMode
    bFancyMode = not bFancyMode
    appResize()
    appSaveSettings()

def fontSizePlus(dummy, variable):
    global fontSizeMult
    if fontSizeMult<=4.0:
        fontSizeMult = round(fontSizeMult + 0.05, 2)
    appResize()

def fontSizeMinus(dummy, variable):
    global fontSizeMult
    if fontSizeMult >= 0.2:
        fontSizeMult = round(fontSizeMult - 0.05, 2)
    appResize()

def fontOffsetPlus(dummy, variable):
    global fontOffsetY
    fontOffsetY += 1
    # refreshAndWriteParameters()
    appResize()

def fontOffsetMinus(dummy, variable):
    global fontOffsetY
    fontOffsetY -= 1
    # refreshAndWriteParameters()
    appResize()

def toggleFontPlus(d, v):
    global customFonts, sCustomFontName
    global f1, f2
    if sCustomFontName in customFonts:
        id = customFonts.index(sCustomFontName) + 1
        if id >= len(customFonts) or id<0: id = 0
        sCustomFontName = customFonts[id]
    else:
        sCustomFontName = "Segoe UI"
    # refreshAndWriteParameters()
    # ac.log("sCustomFontName " + sCustomFontName)
    f1 = FontMeasures(sCustomFontName, 0, 0, 1.25, 0.69, 0.629, 0.616, 0.066)
    f1.f = ac.ext_glFontCreate(f1.n, f1.s, f1.i, f1.b)
    f2 = FontMeasures(sCustomFontName2, 0, 1, 1.25, 0.69, 0.75, 0.5, 0.5)
    f2.f = ac.ext_glFontCreate(f2.n, f2.s, f2.i, f2.b)
    appResize()

def toggleFontMinus(d, v):
    global customFonts, sCustomFontName
    global f1, f2
    if sCustomFontName in customFonts:
        id = customFonts.index(sCustomFontName) - 1
        if id < 0: id = len(customFonts)-1
        sCustomFontName = customFonts[id]
    else:
        sCustomFontName = "Segoe UI"
    # refreshAndWriteParameters()
    f1 = FontMeasures(sCustomFontName, 0, 0, 1.25, 0.69, 0.629, 0.616, 0.066)
    f1.f = ac.ext_glFontCreate(f1.n, f1.s, f1.i, f1.b)
    f2 = FontMeasures(sCustomFontName2, 0, 1, 1.25, 0.69, 0.75, 0.5, 0.5)
    f2.f = ac.ext_glFontCreate(f2.n, f2.s, f2.i, f2.b)
    appResize()

def getSetting(cfgdef, cfg, sect, value, valdef):
    res = valdef
    if cfgdef!=None and cfgdef.has_option(sect, value):
        res = cfgdef[sect][value]
        if ';' in res:
            res = res.split(';')[0]
    if cfg.has_option(sect, value):
        res = cfg[sect][value]
        if ';' in res:
            res = res.split(';')[0]
    return str(res)

def str2bool(v):
    return str(v).lower() in ("yes", "true", "t", "1")

def appOnActivated(*args):
    on_click_app_window()




####################

def appHideButtons():
    global gAppSizeW, gAppSizeH, gOpacityFG, appWindow, fntSize, locOffNM, bShowNM
    global b_Reset, b_MultUp, b_MultDn, b_GAPSIZEUp, b_GAPSIZEDn, btnAppWidthDn, btnAppWidthUp, b_transpUp, b_transpDn, b_transpFGUp, b_transpFGDn, b_widthUp, b_widthDn
    global btnTOAppSizeDn, btnTOAppSizeUp, b_settings, b_presstoggle, b_maxs, b_resetMinMax
    global b_Load, b_Travel, b_SlipR, b_SlipT, b_Camber, b_Directions, b_Aero, b_More, b_Vals, b_GapT, b_color2, b_color, b_nm, b_nmbrake, b_slipCircle, b_less, b_wearT, b_aeroT, b_IMO, b_IMOtext
    global b_wearG, b_ShowBGText, btnMoveLeft, btnMoveRight, btnMoveUp, btnMoveDown, lbCenter, lbCenter2, lbInfo, lbInfo2, lbAero, lbAero2, bShowLess, bShowAero, locOff, fntSize, bMz, b_GripToggle, b_GripTextToggle
    global btnTOWidthDn, btnTOWidthUp, btnTOHeigthDn, btnTOHeightUp, btnTyreNext, btnTyrePrev
    global btnRadiuses, btnMZ, btnRMORE, btnBRAKES, hideTimer, bHideTimerOn

    try:
        hideTimer = 0.0
        bHideTimerOn = False

        locOff = 0
        if bShowAero:
            locOff = -fntSize*1.5
        if bShowLess:
            locOff += fntSize*2.1
        locOffNM = locOff
        if bShowNM:   ### and bShowAero:
            locOffNM -= fntSize*1.5

        if bShowBGText:
            ac.setVisible(lbCenter,1)
            ac.setVisible(lbCenter2,1)
        else:
            ac.setVisible(lbCenter,0)
            ac.setVisible(lbCenter2,0)

        ac.setIconPosition(appWindow, 0, -20000)
        if bShowAeroText:
            ac.setVisible(lbAero, 1)
            ac.setVisible(lbAero2, 1)
        else:
            ac.setVisible(lbAero, 0)
            ac.setVisible(lbAero2, 0)

        ac.setVisible(b_settings, 0)
        ac.setVisible(b_maxs, 0)
        ac.setVisible(b_resetMinMax, 0)
    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )


def appUpdateValues(*args):
    global appWindow, bShowGrip
    global bShowSlipText, bShowSlipRect, gColor, bShowTyreload, offsetOMI, bShowTravel, bShowCamber, bShowDirections, bHideTimerOn, hideTimer, gOpacity, gOpacityFG, gAppSizeW, gAppSizeH, tyregraphwidth
    global btnAppWidthDn, btnAppWidthUp, b_widthUp, b_widthDn, b_SlipR, b_SlipT, b_GapT, b_Camber, b_Directions, b_More, b_Vals, b_Aero, b_transpFGUp, b_transpFGDn, b_transpUp, b_transpDn
    global btnTOAppSizeDn, btnTOAppSizeUp, bShowPressure, btn_ShowPressure, b_presstext, bShowPressureText
    global theemulti, b_MultDn, b_MultUp, bShowAero, b_Reset, fntSize, b_GripToggle, bSHOWIMO, b_GripTextToggle
    global b_GAPSIZEUp, b_GAPSIZEDn, b_slipCircle, bShowCircles, b_nm, b_nmbrake, extraHeight, b_wearT, b_less, b_wearG, b_IMO, b_IMOtext
    global locOff, btnMoveLeft, btnMoveRight, btnMoveUp, btnMoveDown, bShowWearText, b_ShowBGText, bShowWearGraph, bShowAeroText, lbCenter, lbCenter2, lbInfo, lbInfo2, TravelOffsetX, TravelOffsetY
    global btnTOWidthDn, btnTOWidthUp, btnTOHeigthDn, btnTOHeightUp, TOAppSize, bCPhysBrakesEnabled, sCustomFontName
    global btnRadiuses, btnMZ, bMz, bShowRadiuses, btnRMORE, btnBRAKES, b_settings, b_presstoggle, btn_FBG, btn_AbsTc, b_maxs
    global btnFontPlus, customFonts, fontOffsetY, btnFontOffsetMinus, fontSizeMult, btnFontSizeMinus, btnFontSizePlus, btnFontOffsetPlus, btnFontOffsetMinus
    global cbFancy, bFancyMode, bTextWhiteOnBlack, cbToggleTextColor, cbToggleImageset, btnSHOWHOTG, btnSHOWHOTT
    global bSHOWHOTG, bSHOWHOTT, btnCarcassText, btnBrakeText, bCPhysBrakesText, bCPhysCarcassEnabled, bCPhysCarcassText
    global btnAppHeightDn, btnAppHeightUp, bPressureGraph, btnPressureGraph

    try:
        ac.setValue(cbFancy, bFancyMode)
        locOff = fntSize*20
        if bCSPactive:
            ac.setVisible(cbFancy          , 1)
            ac.setVisible(cbToggleTextColor, 1)
            ac.setVisible(cbToggleImageset, 1)
        else:
            ac.setVisible(cbFancy          , 0)
            ac.setVisible(cbToggleTextColor, 0)
            ac.setVisible(cbToggleImageset, 0)

        # ac.setBackgroundOpacity(appWindow, 0)
        # ac.drawBorder(appWindow, 0)
        # ac.setIconPosition(appWindow, 0, -30)

        ac.setText(btnFontOffsetMinus, '^    font offset\n      ' + str(fontOffsetY) + ' pixel')
        ac.setText(btnFontSizeMinus  , '-     font size mult\n      '+ str(int(fontSizeMult*100)) + '%')
        # ac.log(str(customFonts))
        if len(customFonts)==0 or not sCustomFontName in customFonts:
            ac.setVisible(btnFontMinus, 0)
            ac.setVisible(btnFontPlus, 0)
        else:
            ac.setText(btnFontMinus    , '-\nfont ('+ str( customFonts.index(sCustomFontName)+1 ) +'/'+ str(len(customFonts)) +')\n' + sCustomFontName)
        ac.setText(b_color         , '- col\n    '                     + str(int(gColor+1)) + ' / ' + str(len(ColorNames))+ '\n           ' + ColorNames[gColor])
        #ac.setText(b_color2        , 'col\n'                     + str(int(gColor)) + ' / ' + str(len(colnames))+ '\n' + colnames[gColor-1])
        ac.setText(b_MultDn        , '- color\n   mult\n    '    + str(int(theemulti*100) )+'%' )
        ac.setText(b_GAPSIZEDn     , '-\n           wheelgap '   + str(gGAPSIZE) + 'px'         )
        ac.setText(btnAppWidthDn   , '-\nwidth    ' + str(int(gAppSizeW*100)  )+'%' )
        ac.setText(btnAppHeightUp  , '+ heigth\n\n\n' + str(int(gAppSizeH*100)  )+'%' )
        ac.setText(btnTOAppSizeDn  , '- size\n    '              + str(int(TOAppSize*100)  )+'%')
        ac.setText(b_transpDn      , '-  bg\n    '               + str(int(gOpacity)      )+'%' )
        ac.setText(b_transpFGDn    , '-  fg\n    '               + str(int(gOpacityFG)    )+'%' )
        ac.setText(b_widthDn       , '- width\n    '             + str(int(tyregraphwidth*100))     )
        ac.setText(b_Aero          , 'aeroG\n'                   + str(bShowAero)               )
        ac.setText(b_nm            , 'Nm\n'                      + str(bShowNM)                 )
        ac.setText(b_nmbrake       , 'NmB\n'                     + str(bShowNM_brake)           )
        ac.setText(b_Load          , 'load\n'                    + str(bShowTyreload)           )
        ac.setText(b_slipCircle    , 'slipC\n'                   + str(bShowCircles)            )
        ac.setText(b_SlipR         , 'slipG\n'                   + str(bShowSlipRect)           )
        ac.setText(b_SlipT         , 'slipT\n'                   + str(bShowSlipText)           )
        ac.setText(b_More          , 'more\n'                    + str(bShowMore)               )
        ac.setText(b_GapT          , 'gap\n'                     + str(offsetOMI!=0.0)          )
        ac.setText(b_Travel        , '↑↓\n'                      + str(bShowTravel)             )
        ac.setText(b_Camber        , 'camb\n'                    + str(bShowCamber)             )
        ac.setText(b_Directions    , 'star\n'                    + str(bShowDirections)         )
        ac.setText(b_Vals          , 'text\n'                    + str(bShowVals)               )
        ac.setText(b_wearG         , 'wearG\n '                  + str(bShowWearGraph)          )
        ac.setText(b_wearT         , 'wearT\n '                  + str(bShowWearText)           )
        ac.setText(b_aeroT         , 'aeroT\n '                  + str(bShowAeroText)           )
        ac.setText(b_ShowBGText    , 'bgTxt\n '                  + str(bShowBGText)             )
        ac.setText(b_GripTextToggle, 'gripTx\n '                 + str(bShowGripText)           )
        ac.setText(b_GripToggle    , 'gripG\n '                  + str(bShowGrip)               )
        ac.setText(btnMZ           , 'MZ-G\n '                   + str(bMz)                     )
        ac.setText(btn_FBG  , 'grain+\n '          + str(bFlatBlistGrain)         )
        ac.setText(btn_AbsTc           , 'abs/tC\n '             + str(bShowABS)                )

        ac.setText(btnBRAKES       , 'brake\n '                 + str(bCPhysBrakesEnabled)     )
        ac.setText(btnCarcassText  , 'carcT\n '                 + str(bCPhysCarcassText)     )
        ac.setText(btnBrakeText    , 'brakeT\n '                + str(bCPhysBrakesText)     )

        if bFancyMode:
            ac.setVisible(cbToggleTextColor,1)
            ac.setVisible(cbToggleImageset,1)
        else:
            ac.setVisible(cbToggleTextColor,0)
            ac.setVisible(cbToggleImageset,0)


        if bShowPressure:
            ac.setText(btn_ShowPressure, 'press\nON')

            ac.setVisible(btnPressureGraph,1)
            ac.setVisible(b_presstoggle,1)
            ac.setVisible(b_presstext,1)
            if bShowPressureText:
                ac.setText(b_presstext, 'pressT\nON')
            else:
                ac.setText(b_presstext, 'pressT\noff')
            if bPressureGraph:
                ac.setVisible(b_presstoggle,0)
            else:
                ac.setVisible(b_presstoggle,1)

            if bPressureGraph:
                ac.setText(btnPressureGraph, 'pressG\nON')
            else:
                ac.setText(btnPressureGraph, 'pressG\noff')

            if bShowPressureDiff:
                ac.setText(b_presstoggle   , 'press\ndiff')
            else:
                ac.setText(b_presstoggle   , 'press\nsimple')
        else:
            ac.setText(btn_ShowPressure, 'press\noff')
            ac.setVisible(b_presstoggle,0)
            ac.setVisible(btnPressureGraph,0)
            ac.setVisible(b_presstoggle,0)
            ac.setVisible(b_presstext,0)

        ac.setVisible(btnBrakeText, 0)
        ac.setVisible(btnBRAKES, 0)
        if brakestempsConfigured:
            ac.setVisible(btnBRAKES, 1)
            ac.setVisible(btnBrakeText, 1)

        if bCSPactive:
            if bCPhysCarcassEnabled:
                ac.setVisible(btnCarcassText, 1)
            else:
                ac.setVisible(btnCarcassText, 0)
            ac.setVisible(btnSHOWHOTG, 1)
            ac.setVisible(btnSHOWHOTT, 1)
            if bSHOWHOTT:
                ac.setText(btnSHOWHOTT, 'hotT\nON')
            else:
                ac.setText(btnSHOWHOTT, 'hotT\noff')
            if bSHOWHOTG:
                ac.setText(btnSHOWHOTG, 'hotG\nON')
            else:
                ac.setText(btnSHOWHOTG, 'hotG\noff')
        else:
            ac.setVisible(btnCarcassText, 0)
            ac.setVisible(btnSHOWHOTG, 0)
            ac.setVisible(btnSHOWHOTT, 0)

        ac.setText(btnRadiuses     , 'rad-G\n '                  + str(bShowRadiuses)           )
        ac.setText(b_less          , 'less\n'                    + str(bShowLess)               )
        ac.setText(b_IMO           , 'IMObig\n'                     + str(bSHOWIMO)               )
        ac.setText(b_IMOtext       , 'IMO temp\n'                   + str(bSHOWIMOTEXT)               )
        ac.setText(btnRMORE        , '   r     --Separation--      height '           + str(TOoffsety) + '\n                     width  ' + str(TOoffsetx)+'\n\n\n                        Position')

        ## ac.setFontColor(lbCenter, 0.8, 0.8, 0.8, gOpacityFG/100)
        ac.setVisible(lbCenter,1)
        ac.setVisible(lbCenter2,1)
        ac.setVisible(lbInfo,1)
        ac.setVisible(lbInfo2,1)

        if bCSPactive:
            ac.setVisible(b_GripTextToggle, 1)
            ac.setVisible(b_SlipT, 1)
            ac.setVisible(b_aeroT, 1)

        if not bSHOWIMO:
            ac.setVisible(b_IMOtext, 0)
        else:
            ac.setVisible(b_IMOtext, 1)

        ac.setVisible(btnRMORE, 0)
        ac.setVisible(btnTOAppSizeDn, 0)
        ac.setVisible(btnTOAppSizeUp, 0)
        ac.setVisible(btnMoveLeft,0)
        ac.setVisible(btnMoveRight,0)
        ac.setVisible(btnMoveUp,0)
        ac.setVisible(btnMoveDown,0)
        ac.setVisible(btnTOWidthDn,0)
        ac.setVisible(btnTOWidthUp,0)
        ac.setVisible(btnTOHeigthDn,0)
        ac.setVisible(btnTOHeightUp,0)
        if bShowDirections or bShowRadiuses or bMz or bShowTravel or bShowCircles or bShowMore:
            ac.setVisible(btnRMORE, 1)
            ac.setVisible(btnTOAppSizeDn, 1)
            ac.setVisible(btnTOAppSizeUp, 1)
            ac.setVisible(btnMoveLeft,1)
            ac.setVisible(btnMoveRight,1)
            ac.setVisible(btnMoveUp,1)
            ac.setVisible(btnMoveDown,1)
            ac.setVisible(btnTOWidthDn,1)
            ac.setVisible(btnTOWidthUp,1)
            ac.setVisible(btnTOHeigthDn,1)
            ac.setVisible(btnTOHeightUp,1)

        ac.setVisible(b_GapT, 0)
        if bFancyMode:
            # ac.setVisible(b_GAPSIZEUp, 0)
            # ac.setVisible(b_GAPSIZEDn, 0)
            ac.setVisible(b_widthUp, 0)
            ac.setVisible(b_widthDn, 0)
            ac.setVisible(btnFontOffsetMinus, 1)
            ac.setVisible(btnFontOffsetPlus, 1)
            ac.setVisible(b_GapT, 0)
        else:
            # ac.setVisible(b_GAPSIZEUp, 1)
            # ac.setVisible(b_GAPSIZEDn, 1)
            ac.setVisible(b_GapT, 1)
            ac.setVisible(b_widthUp, 1)
            ac.setVisible(b_widthDn, 1)
            ac.setVisible(btnFontOffsetMinus, 0)
            ac.setVisible(btnFontOffsetPlus, 0)


        ac.setVisible(b_Reset, 1)
        ac.setVisible(b_MultUp, 1)
        ac.setVisible(b_MultDn, 1)
        ac.setVisible(btnAppWidthDn, 1)
        ac.setVisible(btnAppWidthUp, 1)
        ac.setVisible(btnAppHeightDn, 1)
        ac.setVisible(btnAppHeightUp, 1)
        ac.setVisible(b_transpUp, 1)
        ac.setVisible(b_transpDn, 1)
        ac.setVisible(b_transpFGUp, 1)
        ac.setVisible(b_transpFGDn, 1)
        ac.setVisible(b_Load, 1)
        ac.setVisible(b_Travel, 1)
        ac.setVisible(b_SlipR, 1)
        ac.setVisible(b_Camber, 1)
        ac.setVisible(b_Directions, 1)
        ac.setVisible(b_Aero, 1)
        ac.setVisible(b_More, 1)
        ac.setVisible(b_Vals, 1)
        ac.setVisible(b_color, 1)
        ac.setVisible(b_color2, 1)
        ac.setVisible(b_nm, 1)
        ac.setVisible(b_nmbrake, 1)
        ac.setVisible(b_slipCircle, 1)
        ac.setVisible(b_wearT, 1)
        ac.setVisible(b_wearG, 1)
        ac.setVisible(b_ShowBGText, 1)
        ac.setVisible(b_GripToggle, 1)
        ac.setVisible(btnRadiuses, 1)
        ac.setVisible(btnMZ, 1)
        ac.setVisible(b_less, 1)
        ac.setVisible(b_IMO, 1)
    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )


def appRenderPressure(*args):
    global bDiffMode, bShowPressure, bShowPressureText, gGAPSIZE, marginY, marginX, fntSize, gOpacityFG, hh, hw, gGAPSIZE, currPal, bCSPactive
    try:
        if bShowPressure:
            # pressure text
            if bShowPressureText and bCSPactive:
                if bDiffMode:
                    appDrawTextWithRectL(appGetPressureDiffText(ac_pres["FL"] - ac_presOpt["FL"], True), marginX + hw - hw*1.2 - gGAPSIZE, marginY + hh - fntSize*2  , fntSize*1.2, fntSize*2.8, ExtGL.FONT_ALIGN_RIGHT)
                    appDrawTextWithRectR(appGetPressureDiffText(ac_pres["FR"] - ac_presOpt["FR"], True), marginX + hw + hw*1.2 + gGAPSIZE, marginY + hh - fntSize*2  , fntSize*1.2, fntSize*2.8, ExtGL.FONT_ALIGN_LEFT)
                    appDrawTextWithRectL(appGetPressureDiffText(ac_pres["RL"] - ac_presOpt["RL"], True), marginX + hw - hw*1.2 - gGAPSIZE, marginY + hh + 1          , fntSize*1.2, fntSize*2.8, ExtGL.FONT_ALIGN_RIGHT)
                    appDrawTextWithRectR(appGetPressureDiffText(ac_pres["RR"] - ac_presOpt["RR"], True), marginX + hw + hw*1.2 + gGAPSIZE, marginY + hh + 1          , fntSize*1.2, fntSize*2.8, ExtGL.FONT_ALIGN_LEFT)
                else:
                    appDrawTextWithRectL(appGetPressureText( ac_pres["FL"])                      , marginX + hw - hw*1.2 - gGAPSIZE, marginY + hh - fntSize*2  , fntSize*1.2, fntSize*2.8, ExtGL.FONT_ALIGN_RIGHT)
                    appDrawTextWithRectR(appGetPressureText( ac_pres["FR"])                      , marginX + hw + hw*1.2 + gGAPSIZE, marginY + hh - fntSize*2  , fntSize*1.2, fntSize*2.8, ExtGL.FONT_ALIGN_LEFT)
                    appDrawTextWithRectL(appGetPressureText( ac_pres["RL"])                      , marginX + hw - hw*1.2 - gGAPSIZE, marginY + hh + 1          , fntSize*1.2, fntSize*2.8, ExtGL.FONT_ALIGN_RIGHT)
                    appDrawTextWithRectR(appGetPressureText( ac_pres["RR"])                      , marginX + hw + hw*1.2 + gGAPSIZE, marginY + hh + 1          , fntSize*1.2, fntSize*2.8, ExtGL.FONT_ALIGN_LEFT)

            # pressure bg bar
            appDrawLine2(0.0,0.0,0.0,gOpacityFG/200, marginX +    0             , marginY + hh-fntSize*1.7, hw-1-gGAPSIZE-4, fntSize*1.4)
            appDrawLine2(0.0,0.0,0.0,gOpacityFG/200, marginX + hw+gGAPSIZE+4    , marginY + hh-fntSize*1.7, hw-1-gGAPSIZE  , fntSize*1.4)
            appDrawLine2(0.0,0.0,0.0,gOpacityFG/200, marginX +    0             , marginY + hh+fntSize*0.3, hw-1-gGAPSIZE-4, fntSize*1.4)
            appDrawLine2(0.0,0.0,0.0,gOpacityFG/200, marginX + hw+gGAPSIZE+4    , marginY + hh+fntSize*0.3, hw-1-gGAPSIZE  , fntSize*1.4)
            # pressure green ideal marker
            appDrawLine2(0, 1, 0, gOpacityFG/200,  marginX                 + (hw-1-gGAPSIZE)/2 - hw*0.01-1, marginY + hh-fntSize*2, hw*0.02+2, fntSize*4)
            appDrawLine2(0, 1, 0, gOpacityFG/200,  marginX + hw + gGAPSIZE + (hw-1-gGAPSIZE)/2 - hw*0.01-1, marginY + hh-fntSize*2, hw*0.02+2, fntSize*4)
            # pressure current marker
            if len(currPal)>0 and int((ac_pressLvl["FL"]+1)*56)>=0 and int((ac_pressLvl["FL"]+1)*56)<256:
                palID = getTyreColorID(ac_pres["FL"] - ac_presOpt["FL"])
                appDrawLine2(currPal[palID][0], currPal[palID][1], currPal[palID][2], gOpacityFG/100,  marginX                , marginY + hh-fntSize*1.4, hw/2 -4 +  getLevelPressureDiff(ac_pres["FL"], ac_presOpt["FL"], 4, (hw-1-gGAPSIZE)/2) - hw*0.075, fntSize*0.8)
                palID = getTyreColorID(ac_pres["FR"] - ac_presOpt["FR"])
                appDrawLine2(currPal[palID][0], currPal[palID][1], currPal[palID][2], gOpacityFG/100,  marginX + hw + gGAPSIZE+4, marginY + hh-fntSize*1.4, hw/2 + getLevelPressureDiff(ac_pres["FR"], ac_presOpt["FR"], 4, (hw-1-gGAPSIZE)/2) - hw*0.075, fntSize*0.8)
                palID = getTyreColorID(ac_pres["RL"] - ac_presOpt["RL"])
                appDrawLine2(currPal[palID][0], currPal[palID][1], currPal[palID][2], gOpacityFG/100,  marginX                , marginY + hh+fntSize*0.6, hw/2 -4 +  getLevelPressureDiff(ac_pres["RL"], ac_presOpt["RL"], 4, (hw-1-gGAPSIZE)/2) - hw*0.075, fntSize*0.8)
                palID = getTyreColorID(ac_pres["RR"] - ac_presOpt["RR"])
                appDrawLine2(currPal[palID][0], currPal[palID][1], currPal[palID][2], gOpacityFG/100,  marginX + hw + gGAPSIZE+4, marginY + hh+fntSize*0.6, hw/2 + getLevelPressureDiff(ac_pres["RR"], ac_presOpt["RR"], 4, (hw-1-gGAPSIZE)/2) - hw*0.075, fntSize*0.8)

    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )

def appHandleMinMaxValues(deltaT):
    global brakestempsConfigured
    # appDrawTextWithShadows("maximas", hw, fntSize, fntSize*1.2, align=ExtGL.FONT_ALIGN_CENTER)
    # appDrawTextWithShadows("minimas", hw, fntSize, fntSize*1.2, align=ExtGL.FONT_ALIGN_CENTER)
    # if appMinMaxTimerActive():

    #     appDrawRectFilled(0,0,0,0.95, marginX - hw/2 - fntSize*2, marginY - hh/8 - fntSize*5, hw*3+fntSize*4, hh*2.5+fntSize*10)
    #     if appMaxTimerActive():
    #         appDrawTextWithShadows("maximas", marginX + hw, marginY - fntSize*4, fntSize*2, align=ExtGL.FONT_ALIGN_CENTER)
    #         # if bCPhysBrakesEnabled:
    #         if brakestempsConfigured:
    #             appDrawTextWithShadows("Brakes: " + str(int(maxBT)), marginX + hw - hw/4             , marginY + hh + fntSize*2            +fntSize*8.5          , fntSize*1.2, align=ExtGL.FONT_ALIGN_RIGHT)
    #     if appMinTimerActive():
    #         appDrawTextWithShadows("minimas", marginX + hw, marginY - fntSize*4, fntSize*2, align=ExtGL.FONT_ALIGN_CENTER)
    #         # if bCPhysBrakesEnabled:
    #         if brakestempsConfigured:
    #             appDrawTextWithShadows("Brakes: " + str(int(minBT)), marginX + hw - hw/4             , marginY + hh + fntSize*2            +fntSize*8.5          , fntSize*1.2, align=ExtGL.FONT_ALIGN_RIGHT)
    #     # appDrawRectFilled(0,0,0,0.9, marginX + hw - hw*1.25 - fntSize* 5, marginY + hh - fntSize*6 + fontOffsetY, hw, hh)
    #     # appDrawRectFilled(0,0,0,0.9, marginX + hw + hw/4*1.50 + fntSize*10, marginY + hh - fntSize*6 + fontOffsetY, hw, hh)
    #     # appDrawRectFilled(0,0,0,0.9, marginX + hw - hw*1.25 - fntSize* 5, marginY + hh + fntSize*6 + fontOffsetY, hw, hh)
    #     # appDrawRectFilled(0,0,0,0.9, marginX + hw + hw/4*1.50 + fntSize*10, marginY + hh + fntSize*6 + fontOffsetY, hw, hh)

    appCheckMinMax(        deltaT,  4, "omi"    , marginX + hw - hw/4             , marginY + hh - fntSize*6 + fontOffsetY+fntSize*2, fntSize*1.2, max(tyreTempI["FL"], tyreTempM["FL"], tyreTempO["FL"]), align=ExtGL.FONT_ALIGN_RIGHT)
    appCheckMinMax(        deltaT,  5, "   "    , marginX + hw + hw/4 + fntSize*10, marginY + hh - fntSize*6 + fontOffsetY+fntSize*2, fntSize*1.2, max(tyreTempI["FR"], tyreTempM["FR"], tyreTempO["FR"]), align=ExtGL.FONT_ALIGN_RIGHT)
    appCheckMinMax(        deltaT,  6, "omi"    , marginX + hw - hw/4             , marginY + hh + fntSize*6 + fontOffsetY+fntSize*2, fntSize*1.2, max(tyreTempI["RL"], tyreTempM["RL"], tyreTempO["RL"]), align=ExtGL.FONT_ALIGN_RIGHT)
    appCheckMinMax(        deltaT,  7, "   "    , marginX + hw + hw/4 + fntSize*10, marginY + hh + fntSize*6 + fontOffsetY+fntSize*2, fntSize*1.2, max(tyreTempI["RR"], tyreTempM["RR"], tyreTempO["RR"]), align=ExtGL.FONT_ALIGN_RIGHT)
    if bCPhysicsActive and bCPhysCarcassEnabled:
        if bShowPressure:
            appCheckMinMax(deltaT,  8, "carcass", marginX + hw - hw/4             , marginY + hh - fntSize*4.5+fontOffsetY+fntSize*2, fntSize*1.2, ac_carc["FL"],align=ExtGL.FONT_ALIGN_RIGHT)
            appCheckMinMax(deltaT,  9, "       ", marginX + hw + hw/4 + fntSize*10, marginY + hh - fntSize*4.5+fontOffsetY+fntSize*2, fntSize*1.2, ac_carc["FR"],align=ExtGL.FONT_ALIGN_RIGHT)
            appCheckMinMax(deltaT, 10, "carcass", marginX + hw - hw/4             , marginY + hh + fntSize*4.5+fontOffsetY+fntSize*2, fntSize*1.2, ac_carc["RL"],align=ExtGL.FONT_ALIGN_RIGHT)
            appCheckMinMax(deltaT, 11, "       ", marginX + hw + hw/4 + fntSize*10, marginY + hh + fntSize*4.5+fontOffsetY+fntSize*2, fntSize*1.2, ac_carc["RR"],align=ExtGL.FONT_ALIGN_RIGHT)
        else:
            appCheckMinMax(deltaT,  8, "carcass", marginX + hw - hw/4             , marginY + hh - fntSize*4.5+fontOffsetY+fntSize*2, fntSize*1.2, ac_carc["FL"],align=ExtGL.FONT_ALIGN_RIGHT)
            appCheckMinMax(deltaT,  9, "       ", marginX + hw + hw/4 + fntSize*10, marginY + hh - fntSize*4.5+fontOffsetY+fntSize*2, fntSize*1.2, ac_carc["FR"],align=ExtGL.FONT_ALIGN_RIGHT)
            appCheckMinMax(deltaT, 10, "carcass", marginX + hw - hw/4             , marginY + hh + fntSize*4.5+fontOffsetY+fntSize*2, fntSize*1.2, ac_carc["RL"],align=ExtGL.FONT_ALIGN_RIGHT)
            appCheckMinMax(deltaT, 11, "       ", marginX + hw + hw/4 + fntSize*10, marginY + hh + fntSize*4.5+fontOffsetY+fntSize*2, fntSize*1.2, ac_carc["RR"],align=ExtGL.FONT_ALIGN_RIGHT)
    if bShowPressure:
        appCheckMinMax(    deltaT,  0, "core"   , marginX + hw - hw/4             , marginY + hh - fntSize*3 + fontOffsetY+fntSize*2, fntSize*1.2, ac_temp["FL"], align=ExtGL.FONT_ALIGN_RIGHT)
        appCheckMinMax(    deltaT,  1, "    "   , marginX + hw + hw/4 + fntSize*10, marginY + hh - fntSize*3 + fontOffsetY+fntSize*2, fntSize*1.2, ac_temp["FR"], align=ExtGL.FONT_ALIGN_RIGHT)
        appCheckMinMax(    deltaT,  2, "core"   , marginX + hw - hw/4             , marginY + hh + fntSize*3 + fontOffsetY+fntSize*2, fntSize*1.2, ac_temp["RL"], align=ExtGL.FONT_ALIGN_RIGHT)
        appCheckMinMax(    deltaT,  3, "    "   , marginX + hw + hw/4 + fntSize*10, marginY + hh + fntSize*3 + fontOffsetY+fntSize*2, fntSize*1.2, ac_temp["RR"], align=ExtGL.FONT_ALIGN_RIGHT)
    else:
        appCheckMinMax(    deltaT,  0, "core"   , marginX + hw - hw/4             , marginY + hh - fntSize*3 + fontOffsetY+fntSize*2, fntSize*1.2, ac_temp["FL"], align=ExtGL.FONT_ALIGN_RIGHT)
        appCheckMinMax(    deltaT,  1, "    "   , marginX + hw + hw/4 + fntSize*10, marginY + hh - fntSize*3 + fontOffsetY+fntSize*2, fntSize*1.2, ac_temp["FR"], align=ExtGL.FONT_ALIGN_RIGHT)
        appCheckMinMax(    deltaT,  2, "core"   , marginX + hw - hw/4             , marginY + hh + fntSize*3 + fontOffsetY+fntSize*2, fntSize*1.2, ac_temp["RL"], align=ExtGL.FONT_ALIGN_RIGHT)
        appCheckMinMax(    deltaT,  3, "    "   , marginX + hw + hw/4 + fntSize*10, marginY + hh + fntSize*3 + fontOffsetY+fntSize*2, fntSize*1.2, ac_temp["RR"], align=ExtGL.FONT_ALIGN_RIGHT)
    appCheckMinMax(        deltaT, 12, "press"  , marginX + hw - hw/4             , marginY + hh - fntSize*1.5            +fntSize*2, fntSize*1.2, ac_pres["FL"], align=ExtGL.FONT_ALIGN_RIGHT)
    appCheckMinMax(        deltaT, 13, "     "  , marginX + hw + hw/4 + fntSize*10, marginY + hh - fntSize*1.5            +fntSize*2, fntSize*1.2, ac_pres["FR"], align=ExtGL.FONT_ALIGN_RIGHT)
    appCheckMinMax(        deltaT, 14, "press"  , marginX + hw - hw/4             , marginY + hh + fntSize*1.5            +fntSize*2, fntSize*1.2, ac_pres["RL"], align=ExtGL.FONT_ALIGN_RIGHT)
    appCheckMinMax(        deltaT, 15, "     "  , marginX + hw + hw/4 + fntSize*10, marginY + hh + fntSize*1.5            +fntSize*2, fntSize*1.2, ac_pres["RR"], align=ExtGL.FONT_ALIGN_RIGHT)
    appCheckMinMax(        deltaT, 12, "press"  , marginX + hw - hw/4             , marginY + hh - fntSize*1.5            +fntSize*2, fntSize*1.2, ac_pres["FL"], align=ExtGL.FONT_ALIGN_RIGHT)
    appCheckMinMax(        deltaT, 13, "     "  , marginX + hw + hw/4 + fntSize*10, marginY + hh - fntSize*1.5            +fntSize*2, fntSize*1.2, ac_pres["FR"], align=ExtGL.FONT_ALIGN_RIGHT)
    appCheckMinMax(        deltaT, 14, "press"  , marginX + hw - hw/4             , marginY + hh + fntSize*1.5            +fntSize*2, fntSize*1.2, ac_pres["RL"], align=ExtGL.FONT_ALIGN_RIGHT)
    appCheckMinMax(        deltaT, 15, "     "  , marginX + hw + hw/4 + fntSize*10, marginY + hh + fntSize*1.5            +fntSize*2, fntSize*1.2, ac_pres["RR"], align=ExtGL.FONT_ALIGN_RIGHT)

    # appDrawTextWithShadows("rideheight Front " + str(round(rhMax[0]*1000, 1)) + " / " + str(round(rhMin[0]*1000, 1)) + "mm" , marginX + hw*2             , marginY + hh - fntSize*8.5            +fntSize*2, fntSize*1.2, align=ExtGL.FONT_ALIGN_RIGHT)
    # appDrawTextWithShadows("rideheight Rear  " + str(round(rhMax[1]*1000, 1)) + " / " + str(round(rhMin[1]*1000, 1)) + "mm" , marginX + hw*2             , marginY + hh + fntSize*8.5            +fntSize*2, fntSize*1.2, align=ExtGL.FONT_ALIGN_RIGHT)

    appCheckMinMax(        deltaT, 16, "brake "    , hw - hw*0.1175, hh - hh*0.5 + fontOffsetY                  , fntSize*0.6, ac_brake["FL"])
    appCheckMinMax(        deltaT, 17, "brake "    , hw + hw*0.1175, hh - hh*0.4 + fontOffsetY                  , fntSize*0.6, ac_brake["FR"])
    appCheckMinMax(        deltaT, 18, "brake "    , hw - hw*0.1175, hh + hh*0.5 + fontOffsetY-fontOffsetYRear/3, fntSize*0.6, ac_brake["RL"])
    appCheckMinMax(        deltaT, 19, "brake "    , hw + hw*0.1175, hh + hh*0.4 + fontOffsetY-fontOffsetYRear/3, fntSize*0.6, ac_brake["RR"])
    appCheckMinMax(        deltaT, 20, "brake core", hw - hw*0.1175, hh - hh*0.7 + fontOffsetY                  , fntSize*0.6, ac_brakeC["FL"])
    appCheckMinMax(        deltaT, 21, "brake core", hw + hw*0.1175, hh - hh*0.6 + fontOffsetY                  , fntSize*0.6, ac_brakeC["FR"])
    appCheckMinMax(        deltaT, 22, "brake core", hw - hw*0.1175, hh + hh*0.7 + fontOffsetY-fontOffsetYRear/3, fntSize*0.6, ac_brakeC["RL"])
    appCheckMinMax(        deltaT, 23, "brake core", hw + hw*0.1175, hh + hh*0.6 + fontOffsetY-fontOffsetYRear/3, fntSize*0.6, ac_brakeC["RR"])


def acUpdate(deltaT):
    global WHEELS, wheels, ac_Grip, bGripAvailable, marginX, marginY
    global appWindow, timer1, timer2, updateTime1, updateTime2, gOpacity, gUnits, appInfo
    global bCPhysicsActive, b_transpFGUp, b_transpFGDn, b_transpUp, b_transpDn, b_widthUp, b_widthDn, b_Load, b_Travel, b_GapT, b_Camber, b_Directions, b_More, b_Aero, b_Vals, b_SlipR, b_SlipT
    global bHideTimerOn, hideTimer, hw, hh, lbCenter, lbCenter2, lbInfo, lbInfo2, lbAero, lbAero2, b_color2, b_color, b_nm, b_nmbrake, b_less, b_slipCircle, b_wearT, b_aeroT, bShowWearText, b_ShowBGText, bShowWearGraph, b_wearG, bShowAeroText
    global ac_dirt,ac_temp,ac_carc,tyreTempI,tyreTempM,tyreTempO,ac_pres,ac_load,ac_wear,ac_virtkm,ac_flat,ac_blister,ac_grain,ac_brake,ac_brakeC
    global maxTF, maxTR, minTF, minTR, maxBT, minBT, bCPhysCarcassEnabled, bCPhysBrakesEnabled, bShowTyreload, bShowCamber, bShowDirections, dataCounter1, dataCounter2, bFlatBlistGrain
    global ac_bradius, ac_radius, ac_presOpt, cgHeight
    global bNewTyreParams, ac_isHot, ac_TempMult, theemulti, offsetOMI, gGAPSIZE
    global AEROCDv, AEROCLf, AEROCLr, sDesc, AEROdens, b_MultUp, b_MultDn, bShowAero, b_Reset, bShowVals, bShowMore, bShowPressureDiff, bShowPressure
    global timerRenderer, dataCounter, baseAEROdens, bDynAero, bShowLess, bShowBGText
    global bShowTravel, ac_DampTrav, ac_SuspTrav, ac_SuspForce, CURRTorque, angle_steerwheel, ac_ndslip, ac_TyreSlip, currspeed, ac_wspeed, b_GAPSIZEUp, b_GAPSIZEDn
    global TimeCount, bDiffMode, DiffModeSwitchtime, DiffModeSwitchEnabled
    global maxDampTravFRONT, minDampTravFRONT, maxSuspTravFRONT, minSuspTravFRONT, maxDampTravREAR, minDampTravREAR, maxSuspTravREAR, minSuspTravREAR
    global maxSuspForceFRONT, minSuspForceFRONT, maxSuspForceREAR, minSuspForceREAR, SuspensionForceEnabled
    global ac_LocalAngV, ac_LocalVelocity, ac_dy, lastCar, currcar, compNameShort, brakeDetection
    global tempFtemp, tempRtemp, tempFgrip, tempRgrip, wearFkm, wearRkm, wearFperc, wearRperc
    global xsinFL, xsinFR, ycosFL, ycosFR, xsinRL, xsinRR, ycosRL, ycosRR
    global sIdealTemps, sIdealPress, sIdealGrip, rh, rhMax, rhMin, btnMoveLeft, btnMoveRight, btnMoveUp, btnMoveDown
    global AERODownforce, maxDownForce, AERODrag, maxDrag
    global sTextDrag, sTextDownforce, sTextDiff, sTextSlipStream, slipCircleMult, ac_MaxNonSlipRatio
    global bActiveTimer, fTimer, lbTimer, settingsFilePath, bSHOWIMO, bSHOWIMOTEXT
    global PRACTICAL_TEMP_RATIO, isSlipStream
    global btnTOWidthDn, btnTOWidthUp, btnTOHeigthDn, btnTOHeightUp, tyresVersion
    global bTimerResetTyreToCurrent, TimerReset, ac_pressLvl
    global tyreIDcurr, slipstreamTime, bDAMPERsON
    global ac_TVfl, ac_TVfr, ac_TVrl, ac_TVrr
    global bCoreTempsEnabled, currBrake, newtyrewear
    global rtIndex1, bFancyMode, bCPhysCarcassText
    global tSurfRL, tSurfFL, tSurfRM, tSurfFM, tSurfRR, tSurfFR, tCarcassR, tCarcassF, tCoreCarcassR, tCoreCarcassF, tCoreF, tCoreR
    global Berror, brakestempsConfigured

    try:
        if DiffModeSwitchEnabled:
            TimeCount+=deltaT
            if TimeCount>=DiffModeSwitchtime:
                TimeCount = 0.0
                bDiffMode = not bDiffMode

        if bHideTimerOn:
            hideTimer -= deltaT
            if hideTimer <= 0.0:
                bHideTimerOn = False
                appHideButtons()

        if bTimerResetTyreToCurrent:
            TimerReset -= deltaT
            ac.setVisible(lbTimer, 1)
            ac.setText(lbTimer, str(round(TimerReset))+'s')
            if TimerReset<=0.0:
                bTimerResetTyreToCurrent = False
                # currNameShort = "" ### reset to current tyres
                tyreIDcurr = -1   ### ACD.get_tire_id(compNameShort)
                ac.setText(lbTimer, "")
                #appReset() #threaded
                appResetGo() #non threaded


        ### hide tyre info window
        if bActiveTimer == True:
            fTimer -= deltaT
            if fTimer <= 0.0 or currspeed>50:
                bActiveTimer = False
                ac.setVisible(appInfo,0)
            elif timerRenderer == 0.0:
                ac.setText(lbTimer, str(round(fTimer))+'s' )
                # ac.setTitle(appInfo, str(round(fTimer,1)))

        # dont update data every time for smoother display,
        # update data once in a while
        timerRenderer+=deltaT
        if timerRenderer>0.05 and currcar>-1:
            timerRenderer=0.0

            currspeed = ac.getCarState(currcar, acsys.CS.SpeedKMH)
            ac_Mz ["FL"], ac_Mz ["FR"], ac_Mz ["RL"], ac_Mz ["RR"]                             = ac.getCarState(currcar, acsys.CS.Mz)
            ac_dy ["FL"], ac_dy ["FR"], ac_dy ["RL"], ac_dy ["RR"]                             = ac.getCarState(currcar, acsys.CS.DY)
            # ac_cast = ac.getCarState(currcar,acsys.CS.Caster)
            # ac_anglePatch["FL"], ac_anglePatch["FR"], ac_anglePatch["RL"], ac_anglePatch["RR"] = ac.getCarState(currcar, acsys.CS.SlipAngleContactPatch)
            #ac_anglePatch["FL"], ac_anglePatch["FR"], ac_anglePatch["RL"], ac_anglePatch["RR"] = ac.getCarState(currcar, acsys.CS.SlipAngleContactPatch)

            ac_angle["FL"], ac_angle["FR"], ac_angle["RL"], ac_angle["RR"]                     = ac.getCarState(currcar, acsys.CS.SlipAngle)
            ac_SlipRatio ["FL"], ac_SlipRatio ["FR"], ac_SlipRatio ["RL"], ac_SlipRatio ["RR"] = ac.getCarState(currcar, acsys.CS.SlipRatio)
            ac_wspeed["FL"], ac_wspeed["FR"], ac_wspeed["RL"], ac_wspeed["RR"]                 = ac.getCarState(currcar, acsys.CS.WheelAngularSpeed)
            ac_LocalAngV                                                                       = ac.getCarState(currcar, acsys.CS.LocalAngularVelocity) # only xyz
            ac_LocalVelocity                                                                   = ac.getCarState(currcar, acsys.CS.LocalVelocity)        # only xyz
            # #ac_wspeed["FL"], ac_wspeed["FR"], ac_wspeed["RL"], ac_wspeed["RR"]                 = tyinfo.physics.wheelAngularSpeed
            if bShowRadiuses:
                ac_radius["FL"], ac_radius["FR"], ac_radius["RL"], ac_radius["RR"]             = ac.getCarState(currcar, acsys.CS.TyreLoadedRadius)

            currBrake                                                                          = ac.getCarState(currcar,acsys.CS.Brake)

            if CURRTorque+5>=maxTorque:
                if       ac_SlipRatio ['FL']<0.5 and ac_MaxNonSlipRatio['FL'] < ac_SlipRatio ['FL'] and ac_angle["FL"]<0.1:
                    ac_MaxNonSlipRatio['FL'] =                                  ac_SlipRatio ['FL']
                if       ac_SlipRatio ['FR']<0.5 and ac_MaxNonSlipRatio['FR'] < ac_SlipRatio ['FR'] and ac_angle["FR"]<0.1:
                    ac_MaxNonSlipRatio['FR'] =                                  ac_SlipRatio ['FR']
                if       ac_SlipRatio ['RL']<0.5 and ac_MaxNonSlipRatio['RL'] < ac_SlipRatio ['RL'] and ac_angle["RL"]<0.1:
                    ac_MaxNonSlipRatio['RL'] =                                  ac_SlipRatio ['RL']
                if       ac_SlipRatio ['RR']<0.5 and ac_MaxNonSlipRatio['RR'] < ac_SlipRatio ['RR'] and ac_angle["RR"]<0.1:
                    ac_MaxNonSlipRatio['RR'] =                                  ac_SlipRatio ['RR']


            if bShowAero or bShowAeroText:
                #if newtyrewear:
                #    AEROdens=ac.ext_getAirDensity(currcar)
                #else:
                AEROdens=tyinfo.physics.airDensity

                if baseAEROdens == -1.0:
                    baseAEROdens = AEROdens
                # bDynAero
                if currspeed<5 and bDynAero and AEROdens>0.0:
                    # baseAEROdens = AEROdens
                    AEROCDv=0
                    AEROCLf=0
                    AEROCLr=0
                else:
                    AEROCDv=ac.getCarState(currcar, acsys.AERO.CD      )        # / (0.5*AEROdens*ac_LocalVelocity[2]*ac_LocalVelocity[2]) # drag Coefficient
                    AEROCLf=ac.getCarState(currcar, acsys.AERO.CL_Front)  # / (0.5*AEROdens*ac_LocalVelocity[2]*ac_LocalVelocity[2]) # lift Coefficient front
                    AEROCLr=ac.getCarState(currcar, acsys.AERO.CL_Rear )   # / (0.5*AEROdens*ac_LocalVelocity[2]*ac_LocalVelocity[2]) # lift Coefficient rear

                if bCSPactive:
                    AERODownforce   = ac.ext_getDownforce(2)  ###  * 0.102 # / 9.81   ### todo: div by g or not?
                    if maxDownForce < AERODownforce:
                        if AERODownforce<500:
                            maxDownForce = AERODownforce * 2
                        else:
                            maxDownForce = AERODownforce + AERODownforce/4
                    AERODrag        = ac.ext_getDrag()        ### * 0.102 # / 9.81   ### todo: div by g or not?
                    if maxDrag < AERODrag:
                        if AERODrag<500:
                            maxDrag = AERODrag * 2
                        else:
                            maxDrag = AERODrag + AERODrag/4

                sTextDrag       = '\n'
                sTextDownforce  = '\n'
                sTextDiff       = ''
                sTextSlipStream = ''

                # DRAG in orange
                if bCSPactive and bDRAG and maxDrag>0.0:
                    sTextDrag = 'Drag: '+ str(int(AERODrag)) +'\n'

                # DOWNFORCE kg in blue
                if bCSPactive and bDOWNFORCE and maxDownForce>0.0:
                    sTextDownforce = '    downForce: ' + str(int(AERODownforce)) + ' kg\t\n'

                # SLIPSTREAM
                if baseAEROdens!=0.0:
                    if AEROdens>baseAEROdens and currspeed>15:
                        isSlipStream=False
                        slipstreamTime=0.0
                        sTextDiff = str(round(baseAEROdens-AEROdens,4))

                    elif AEROdens<baseAEROdens and currspeed>15:
                        ### slipstream detection sensitivity level
                        if baseAEROdens-AEROdens > MinslipStreamLevel:
                            isSlipStream=True
                            slipstreamTime+=deltaT
                            sTextSlipStream = '\nslipstream ' + str(round(slipstreamTime,1))+'s'
                        else:
                            isSlipStream=False
                            slipstreamTime=0.0
                        sTextDiff = '+' + str(round(baseAEROdens-AEROdens,3))
                    else:
                        isSlipStream=False
                        slipstreamTime=0.0
                        sTextDiff = ''

                if not bCSPactive and bShowAero and currspeed>15:
                    sTextDownforce= 'CD    : ' + str(round(AEROCDv, 1)) + '\n'







            if bShowTyreload:
                ac_load["FL"], ac_load["FR"], ac_load["RL"], ac_load["RR"]                         = ac.getCarState(currcar, acsys.CS.Load)
                if ac_loadmax["FL"]<ac_load["FL"]:
                    ac_loadmax["FL"] = ac_load["FL"]
                if ac_loadmax["FR"]<ac_load["FR"]:
                    ac_loadmax["FR"] = ac_load["FR"]
                if ac_loadmax["RL"]<ac_load["RL"]:
                    ac_loadmax["RL"] = ac_load["RL"]
                if ac_loadmax["RR"]<ac_load["RR"]:
                    ac_loadmax["RR"] = ac_load["RR"]
                # ac_load["FL"]=min(30000.0, ac_load["FL"])
                # ac_load["FR"]=min(30000.0, ac_load["FR"])
                # ac_load["RL"]=min(30000.0, ac_load["RL"])
                # ac_load["RR"]=min(30000.0, ac_load["RR"])

            if dataCounter==0:
                # ac_radius["FL"], ac_radius["FR"], ac_radius["RL"], ac_radius["RR"]                 = ac.getCarState(currcar, acsys.CS.TyreLoadedRadius)
                # ac_radius["FL"], ac_radius["FR"], ac_radius["RL"], ac_radius["RR"]                 = tyinfo.physics.
                # ac_TLRfl, ac_TLRfr, ac_TLRrl, ac_TLRrr = ac.getCarState(currcar, acsys.CS.TyreLoadedRadius) # TyreRadius
                pass

            elif dataCounter==1:

                ac_camb["FL"], ac_camb["FR"], ac_camb["RL"], ac_camb["RR"]                         = ac.getCarState(currcar, acsys.CS.CamberDeg)
                #ac_camb["FL"], ac_camb["FR"], ac_camb["RL"], ac_camb["RR"]                         = ac.getCarState(currcar, acsys.CS.CamberRad)
                #ac_camb["FL"], ac_camb["FR"], ac_camb["RL"], ac_camb["RR"]                         = ac.getCarState(currcar, acsys.CS.ToeInDeg)

            elif dataCounter==2:
                ac_ndslip["FL"], ac_ndslip["FR"], ac_ndslip["RL"], ac_ndslip["RR"]                 = ac.getCarState(currcar, acsys.CS.NdSlip) # Nd NormalDirection ? Slip
                # if newtyrewear:
                if False:
                    ac_TyreSlip["FL"] = ac.ext_getTyreSlip(currcar, 0)
                    ac_TyreSlip["FR"] = ac.ext_getTyreSlip(currcar, 1)
                    ac_TyreSlip["RL"] = ac.ext_getTyreSlip(currcar, 2)
                    ac_TyreSlip["RR"] = ac.ext_getTyreSlip(currcar, 3)
                    # rh[0] = ac.ext_getRideHeight(currcar, 0)
                    # rh[1] = ac.ext_getRideHeight(currcar, 1)
                else:
                    ### always 0
                    # ac_TyreSlip["FL"], ac_TyreSlip["FR"], ac_TyreSlip["RL"], ac_TyreSlip["RR"]         = ac.getCarState(currcar, acsys.CS.TyreSlip)
                    ### only from player
                    ac_TyreSlip["FL"], ac_TyreSlip["FR"], ac_TyreSlip["RL"], ac_TyreSlip["RR"]         = tyinfo.physics.wheelSlip
                    rh = tyinfo.physics.rideHeight

                rh = tyinfo.physics.rideHeight
                if rh[0]>rhMax[0]:
                    rhMax[0] = rh[0]
                if rh[1]>rhMax[1]:
                    rhMax[1] = rh[1]
                if rh[0]<rhMin[0]:
                    rhMin[0] = rh[0]
                if rh[1]<rhMin[1]:
                    rhMin[1] = rh[1]

            dataCounter += 1
            if dataCounter>3:
                dataCounter=0
                if currcar>-1:
                    currNameShort = str(ac.getCarTyreCompound(currcar))
                    # if tyinfo.graphics.tyreCompound!=None and tyinfo.graphics.tyreCompound!="":
                    if (DOAUTOLOADTYRES and lastCar!=currcar) or currNameShort!=compNameShort:
                        # if lastCar == -1:
                        #     config = ConfigParser(empty_lines_in_values=False, strict=False, allow_no_value=True, inline_comment_prefixes=(";","#","/","_",","), comment_prefixes=(";","#","/","_",","))
                        #     config.optionxform = str
                        #     config.read(settingsFilePath)
                        #     carname = ac.getCarName(currcar)
                        #     theemulti= float( getSetting(None, config, 'COLORMULT', carname, str( theemulti )) )
                        compNameShort = currNameShort
                        lastCar = currcar
                        tyreIDcurr = -1   ### ACD.get_tire_id(compNameShort)
                        appReset()

        timer1 += deltaT
        timer2 += deltaT
        if timer1 > updateTime1:  # slow timer1
            currcar = ac.getFocusedCar()
            dataCounter1 += 1
            if dataCounter1 > 2:
                dataCounter1 = 0

            if bShowAeroText:
                # ac.setVisible(lbAero, 1)
                ac.setText(lbAero, sTextDrag
                    + sTextDownforce
                    # +'  CL: '+ str(round(AEROCDv,1))
                    + '     ' + sTextDiff
                    + '\n\n     AP: '+ str(round(AEROdens,4))
                    + sTextSlipStream)
                ac.setText(lbAero2, sTextDrag
                    + sTextDownforce
                    # +'  CL: '+ str(round(AEROCDv,1))
                    + '     ' + sTextDiff
                    + '\n\n     AP: '+ str(round(AEROdens,4))
                    + sTextSlipStream)

            # if bShowTravel:
            if True:
                ### both ac.ext_getDamperTravel and ac.ext_getSuspensionTravel are buggy and return same FL for all wheels
                # ac_SuspTrav["FL"], ac_SuspTrav["FR"], ac_SuspTrav["RL"], ac_SuspTrav["RR"] =  ac.getCarState(currcar, acsys.CS.SuspensionTravel)
                ac_SuspTrav["FL"], ac_SuspTrav["FR"], ac_SuspTrav["RL"], ac_SuspTrav["RR"] =  ac.getCarState(currcar, acsys.CS.SuspensionTravel)

                # if not bCSPactive and not bCPhysicsActive:
                # else:
                #     ac_SuspTrav["FL"] = ac.ext_getSuspensionTravel(0)
                #     ac_SuspTrav["FR"] = ac.ext_getSuspensionTravel(1)
                #     ac_SuspTrav["RL"] = ac.ext_getSuspensionTravel(2)
                #     ac_SuspTrav["RR"] = ac.ext_getSuspensionTravel(3)

                if ac_SuspTrav["FL"]<minSuspTravFRONT:
                    minSuspTravFRONT=ac_SuspTrav["FL"]
                if ac_SuspTrav["FR"]<minSuspTravFRONT:
                    minSuspTravFRONT=ac_SuspTrav["FR"]
                if ac_SuspTrav["RL"]<minSuspTravREAR:
                    minSuspTravREAR=ac_SuspTrav["RL"]
                if ac_SuspTrav["RR"]<minSuspTravREAR:
                    minSuspTravREAR=ac_SuspTrav["RR"]
                if ac_SuspTrav["FL"]>maxSuspTravFRONT:
                    maxSuspTravFRONT=ac_SuspTrav["FL"]
                if ac_SuspTrav["FR"]>maxSuspTravFRONT:
                    maxSuspTravFRONT=ac_SuspTrav["FR"]
                if ac_SuspTrav["RL"]>maxSuspTravREAR:
                    maxSuspTravREAR=ac_SuspTrav["RL"]
                if ac_SuspTrav["RR"]>maxSuspTravREAR:
                    maxSuspTravREAR=ac_SuspTrav["RR"]

                if bDAMPERsON and bCSPactive:
                    ### both ac.ext_getDamperTravel and ac.ext_getSuspensionTravel are buggy
                    ### and return same FL for all wheels
                    ac_DampTrav["FL"] = ac.ext_getDamperTravel(0)
                    ac_DampTrav["FR"] = ac.ext_getDamperTravel(1)
                    ac_DampTrav["RL"] = ac.ext_getDamperTravel(2)
                    ac_DampTrav["RR"] = ac.ext_getDamperTravel(3)
                    if ac_DampTrav["FL"]<minDampTravFRONT:
                        minDampTravFRONT=ac_DampTrav["FL"]
                    if ac_DampTrav["FR"]<minDampTravFRONT:
                        minDampTravFRONT=ac_DampTrav["FR"]
                    if ac_DampTrav["RL"]<minDampTravREAR:
                        minDampTravREAR=ac_DampTrav["RL"]
                    if ac_DampTrav["RR"]<minDampTravREAR:
                        minDampTravREAR=ac_DampTrav["RR"]
                    if ac_DampTrav["FL"]>maxDampTravFRONT:
                        maxDampTravFRONT=ac_DampTrav["FL"]
                    if ac_DampTrav["FR"]>maxDampTravFRONT:
                        maxDampTravFRONT=ac_DampTrav["FR"]
                    if ac_DampTrav["RL"]>maxDampTravREAR:
                        maxDampTravREAR=ac_DampTrav["RL"]
                    if ac_DampTrav["RR"]>maxDampTravREAR:
                        maxDampTravREAR=ac_DampTrav["RR"]

                if currspeed>5 and SuspensionForceEnabled:
                    ac_SuspForce["FL"] = ac.ext_getSusForce(0)
                    ac_SuspForce["FR"] = ac.ext_getSusForce(1)
                    ac_SuspForce["RL"] = ac.ext_getSusForce(2)
                    ac_SuspForce["RR"] = ac.ext_getSusForce(3)
                    # global maxSuspForceFRONT, minSuspForceFRONT, maxSuspForceREAR, minSuspForceREAR
                    if ac_SuspForce["FL"]<minSuspForceFRONT:
                        minSuspForceFRONT=ac_SuspForce["FL"]
                    if ac_SuspForce["FR"]<minSuspForceFRONT:
                        minSuspForceFRONT=ac_SuspForce["FR"]
                    if ac_SuspForce["RL"]<minSuspForceREAR:
                        minSuspForceREAR=ac_SuspForce["RL"]
                    if ac_SuspForce["RR"]<minSuspForceREAR:
                        minSuspForceREAR=ac_SuspForce["RR"]
                    if ac_SuspForce["FL"]>maxSuspForceFRONT:
                        maxSuspForceFRONT=ac_SuspForce["FL"]
                    if ac_SuspForce["FR"]>maxSuspForceFRONT:
                        maxSuspForceFRONT=ac_SuspForce["FR"]
                    if ac_SuspForce["RL"]>maxSuspForceREAR:
                        maxSuspForceREAR=ac_SuspForce["RL"]
                    if ac_SuspForce["RR"]>maxSuspForceREAR:
                        maxSuspForceREAR=ac_SuspForce["RR"]

                    if ac_SuspForce["FL"]==ac_SuspForce["FL"] and ac_SuspForce["RL"]==ac_SuspForce["RR"] and ac_SuspForce["FL"]==ac_SuspForce["RL"]:
                        SuspensionForceEnabled = False

            if bShowBGText or bHideTimerOn:
                s = (     "road: "      + str(appGetTempText(tyinfo.physics.roadTemp, True, False) )
                        +"    air: "       + str(appGetTempText(tyinfo.physics.airTemp, True, False) )
                        +"    grip: "      + str(round(tyinfo.graphics.surfaceGrip*100,1)) + "%"
                        +"\nTyres: "     + tirenameLong   ### includes long+shortname
                        )
                ac.setVisible(lbCenter, 1)
                ac.setVisible(lbCenter2, 1)
                ac.setText(lbCenter, s)
                ac.setText(lbCenter2, s)
            else:
                s=""
                ac.setVisible(lbCenter, 0)
                ac.setVisible(lbCenter2, 0)

            tyreTempO["FL"], tyreTempO["FR"], tyreTempO["RL"], tyreTempO["RR"] = tyinfo.physics.tyreTempO
            tyreTempM["FL"], tyreTempM["FR"], tyreTempM["RL"], tyreTempM["RR"] = tyinfo.physics.tyreTempM
            tyreTempI["FL"], tyreTempI["FR"], tyreTempI["RL"], tyreTempI["RR"] = tyinfo.physics.tyreTempI


            if dataCounter1 == 0:
                ac.drawBorder(appWindow, 0)
                if gOpacity < 10:
                    ac.setBackgroundOpacity(appWindow, 0)
                    ac.setBackgroundOpacity(lbCenter, 0)
                    ac.setBackgroundOpacity(lbCenter2, 0)
                else:
                    # ac.drawBorder(appWindow, 1)
                    ac.setBackgroundOpacity(appWindow, float(gOpacity/100.0) )
                    ac.setBackgroundOpacity(lbCenter, float(gOpacity/100.0))
                    ac.setBackgroundOpacity(lbCenter2, float(gOpacity/100.0))

                angle_steerwheel = ac.getCarState(currcar, acsys.CS.Steer)

                # if tyinfo.graphics.status == tyinfo.AC_LIVE: ### 2

                # updating the tyre CORE TEMPs
                ac_temp["FL"], ac_temp["FR"], ac_temp["RL"], ac_temp["RR"] = ac.getCarState(currcar, acsys.CS.CurrentTyresCoreTemp)
                # ac_temp["FL"], ac_temp["FR"], ac_temp["RL"], ac_temp["RR"] = tyinfo.physics.tyreCoreTemperature

                # updating the tyre CARCASS TEMPs
                if bCPhysicsActive: # skipped without CPHYSICS
                    if bCPhysCarcassEnabled:
                        ac_carc["FL"] = ac.ext_getTyreCarcassTemp(0,0)
                        if ac_carc["FL"] == 0.0:
                            bCPhysCarcassEnabled = False
                            appResize()
                        else:
                            ac_carc["FR"] = ac.ext_getTyreCarcassTemp(0,1)
                            ac_carc["RL"] = ac.ext_getTyreCarcassTemp(0,2)
                            ac_carc["RR"] = ac.ext_getTyreCarcassTemp(0,3)

                if not WHEELS["coldRead"]:
                    WHEELS["coldRead"] = True # only once
                    WHEELS["FL"]["temp"]["cold"] = ac_temp["FL"]
                    WHEELS["FR"]["temp"]["cold"] = ac_temp["FR"]
                    WHEELS["RL"]["temp"]["cold"] = ac_temp["RL"]
                    WHEELS["RR"]["temp"]["cold"] = ac_temp["RR"]
                    WHEELS["FL"]["tempI"]["cold"] = tyreTempI["FL"]
                    WHEELS["FR"]["tempI"]["cold"] = tyreTempI["FR"]
                    WHEELS["RL"]["tempI"]["cold"] = tyreTempI["RL"]
                    WHEELS["RR"]["tempI"]["cold"] = tyreTempI["RR"]
                    WHEELS["FL"]["tempM"]["cold"] = tyreTempM["FL"]
                    WHEELS["FR"]["tempM"]["cold"] = tyreTempM["FR"]
                    WHEELS["RL"]["tempM"]["cold"] = tyreTempM["RL"]
                    WHEELS["RR"]["tempM"]["cold"] = tyreTempM["RR"]
                    WHEELS["FL"]["tempO"]["cold"] = tyreTempO["FL"]
                    WHEELS["FR"]["tempO"]["cold"] = tyreTempO["FR"]
                    WHEELS["RL"]["tempO"]["cold"] = tyreTempO["RL"]
                    WHEELS["RR"]["tempO"]["cold"] = tyreTempO["RR"]
                    if bCPhysicsActive:
                        WHEELS["FL"]["ctemp"]["cold"] = ac_temp["FL"]
                        WHEELS["FR"]["ctemp"]["cold"] = ac_temp["FR"]
                        WHEELS["RL"]["ctemp"]["cold"] = ac_temp["RL"]
                        WHEELS["RR"]["ctemp"]["cold"] = ac_temp["RR"]
                # updating tyre PRESSURE
                ac_pres["FL"], ac_pres["FR"], ac_pres["RL"], ac_pres["RR"] = ac.getCarState(currcar, acsys.CS.DynamicPressure)
                # ac_pres["FL"], ac_pres["FR"], ac_pres["RL"], ac_pres["RR"] = tyinfo.physics.wheelsPressure

            elif dataCounter1 == 1:

                if bCSPactive:
                    ac_virtkm["FL"] = ac.ext_getTyreVirtualKM(currcar, 0)
                    ac_virtkm["FR"] = ac.ext_getTyreVirtualKM(currcar, 1)
                    ac_virtkm["RL"] = ac.ext_getTyreVirtualKM(currcar, 2)
                    ac_virtkm["RR"] = ac.ext_getTyreVirtualKM(currcar, 3)

                # updating the tyre WEAR data
                ac_wear["FL"], ac_wear["FR"], ac_wear["RL"], ac_wear["RR"] = tyinfo.physics.tyreWear
                #ac_wear["FL"], ac_wear["FR"], ac_wear["RL"], ac_wear["RR"] = tyinfo.physics.tyreWear
                #if newtyrewear:
                #    ac_wear["FL"] = 100-ac.ext_getTyreWear(currcar, 0)
                #    ac_wear["FR"] = 100-ac.ext_getTyreWear(currcar, 1)
                #    ac_wear["RL"] = 100-ac.ext_getTyreWear(currcar, 2)
                #    ac_wear["RR"] = 100-ac.ext_getTyreWear(currcar, 3)
                #else:
                #    #ac_wear["FL"], ac_wear["FR"], ac_wear["RL"], ac_wear["RR"] = tyinfo.physics.tyreWear
                #    ac_wear["FL"], ac_wear["FR"], ac_wear["RL"], ac_wear["RR"] = tyinfo.physics.tyreWear

                # grip
                # if bShowGrip:
                if bNewTyreParams and bCPhysicsActive:
                    try:
                        # cphys new extended params
                        ac_isHot["FL"]    = ac.ext_getTyreIsHot   (currcar, 0)
                        ac_isHot["FR"]    = ac.ext_getTyreIsHot   (currcar, 1)
                        ac_isHot["RL"]    = ac.ext_getTyreIsHot   (currcar, 2)
                        ac_isHot["RR"]    = ac.ext_getTyreIsHot   (currcar, 3)
                        ac_TempMult["FL"] = ac.ext_getTyreTempMult(currcar, 0)
                        ac_TempMult["FR"] = ac.ext_getTyreTempMult(currcar, 1)
                        ac_TempMult["RL"] = ac.ext_getTyreTempMult(currcar, 2)
                        ac_TempMult["RR"] = ac.ext_getTyreTempMult(currcar, 3)
                    except:
                        bNewTyreParams = False
                    ac_Grip["FL"] = (ac_TempMult["FL"])*100
                    ac_Grip["FR"] = (ac_TempMult["FR"])*100
                    ac_Grip["RL"] = (ac_TempMult["RL"])*100
                    ac_Grip["RR"] = (ac_TempMult["RR"])*100
                elif len(tempFgrip)>0 and len(tempRgrip)>0 and len(tempFtemp)>0 and len(tempRtemp):
                    if bCSPactive and PRACTICAL_TEMP_RATIO!=-1000:
                        if bCPhysCarcassEnabled:
                            # surface x practical_temp_ratio + CARCASStemp x (1-practical_temp_ratio)
                            ac_Grip["FL"] = 100 * get_val_from_lut(tyreTempM["FL"], tempFtemp, tempFgrip)*PRACTICAL_TEMP_RATIO + (1-PRACTICAL_TEMP_RATIO) * get_val_from_lut(ac_carc["FL"], tempFtemp, tempFgrip)
                            ac_Grip["FR"] = 100 * get_val_from_lut(tyreTempM["FR"], tempFtemp, tempFgrip)*PRACTICAL_TEMP_RATIO + (1-PRACTICAL_TEMP_RATIO) * get_val_from_lut(ac_carc["FR"], tempFtemp, tempFgrip)
                            ac_Grip["RL"] = 100 * get_val_from_lut(tyreTempM["RL"], tempRtemp, tempRgrip)*PRACTICAL_TEMP_RATIO + (1-PRACTICAL_TEMP_RATIO) * get_val_from_lut(ac_carc["RL"], tempRtemp, tempRgrip)
                            ac_Grip["RR"] = 100 * get_val_from_lut(tyreTempM["RR"], tempRtemp, tempRgrip)*PRACTICAL_TEMP_RATIO + (1-PRACTICAL_TEMP_RATIO) * get_val_from_lut(ac_carc["RR"], tempRtemp, tempRgrip)
                        else:
                            # surface x practical_temp_ratio + COREtemp x (1-practical_temp_ratio)
                            ac_Grip["FL"] = 100 * get_val_from_lut(tyreTempM["FL"], tempFtemp, tempFgrip)*PRACTICAL_TEMP_RATIO + (1-PRACTICAL_TEMP_RATIO) * get_val_from_lut(ac_temp["FL"], tempFtemp, tempFgrip)
                            ac_Grip["FR"] = 100 * get_val_from_lut(tyreTempM["FR"], tempFtemp, tempFgrip)*PRACTICAL_TEMP_RATIO + (1-PRACTICAL_TEMP_RATIO) * get_val_from_lut(ac_temp["FR"], tempFtemp, tempFgrip)
                            ac_Grip["RL"] = 100 * get_val_from_lut(tyreTempM["RL"], tempRtemp, tempRgrip)*PRACTICAL_TEMP_RATIO + (1-PRACTICAL_TEMP_RATIO) * get_val_from_lut(ac_temp["RL"], tempRtemp, tempRgrip)
                            ac_Grip["RR"] = 100 * get_val_from_lut(tyreTempM["RR"], tempRtemp, tempRgrip)*PRACTICAL_TEMP_RATIO + (1-PRACTICAL_TEMP_RATIO) * get_val_from_lut(ac_temp["RR"], tempRtemp, tempRgrip)
                    else:
                        # from temp lut, 25% surface temp, 75% core temp
                        ac_Grip["FL"] = 100 * get_val_from_lut(tyreTempM["FL"]*0.25 + ac_temp["FL"]*0.75, tempFtemp, tempFgrip)
                        ac_Grip["FR"] = 100 * get_val_from_lut(tyreTempM["FR"]*0.25 + ac_temp["FR"]*0.75, tempFtemp, tempFgrip)
                        ac_Grip["RL"] = 100 * get_val_from_lut(tyreTempM["RL"]*0.25 + ac_temp["RL"]*0.75, tempRtemp, tempRgrip)
                        ac_Grip["RR"] = 100 * get_val_from_lut(tyreTempM["RR"]*0.25 + ac_temp["RR"]*0.75, tempRtemp, tempRgrip)

                for wheel in wheels:
                    press_diff = ac_pres[wheel] - ac_presOpt[wheel]
                    ac_pressLvl[wheel] = abs( mapFromTo( press_diff, -40, 40, -1.0, 1.0 ) ) * 10
                    # ac_Grip[wheel] = (ac_Grip[wheel] * (ac_wear[wheel]/100.0)) - ac_pressLvl[wheel]
                    ac_Grip[wheel] = ac_Grip[wheel] - ac_wear[wheel]/100.0 - ac_pressLvl[wheel]



                # updating the tyre DIRT dirt
                ac_dirt["FL"], ac_dirt["FR"], ac_dirt["RL"], ac_dirt["RR"] = tyinfo.physics.tyreDirtyLevel

                # if newtyrewear:
                #     ac_dirt["FL"] = ac.ext_getDirtyLevel(currcar, 0)
                #     ac_dirt["FR"] = ac.ext_getDirtyLevel(currcar, 1)
                #     ac_dirt["RL"] = ac.ext_getDirtyLevel(currcar, 2)
                #     ac_dirt["RR"] = ac.ext_getDirtyLevel(currcar, 3)
                # else:
                #     ac_dirt["FL"], ac_dirt["FR"], ac_dirt["RL"], ac_dirt["RR"] = tyinfo.physics.tyreDirtyLevel

                # update detail BLISTER FLATSPOTS GRAIN data
                if bFlatBlistGrain and bCPhysicsActive:
                    try:
                        ac_flat["FL"]    = ac.ext_getTyreFlatSpot(0,0)
                        ac_flat["FR"]    = ac.ext_getTyreFlatSpot(0,1)
                        ac_flat["RL"]    = ac.ext_getTyreFlatSpot(0,2)
                        ac_flat["RR"]    = ac.ext_getTyreFlatSpot(0,3)
                        ac_blister["FL"] = ac.ext_getTyreBlister (0,0)
                        ac_blister["FR"] = ac.ext_getTyreBlister (0,1)
                        ac_blister["RL"] = ac.ext_getTyreBlister (0,2)
                        ac_blister["RR"] = ac.ext_getTyreBlister (0,3)
                        ac_grain["FL"]   = ac.ext_getTyreGrain   (0,0)
                        ac_grain["FR"]   = ac.ext_getTyreGrain   (0,1)
                        ac_grain["RL"]   = ac.ext_getTyreGrain   (0,2)
                        ac_grain["RR"]   = ac.ext_getTyreGrain   (0,3)
                    except:
                        bCPhysCarcassEnabled = False

                svKM=""
                if bCSPactive:
                    lvFL = str( round ( ac_Grip["FL"], 2 ) )
                    lvFR = str( round ( ac_Grip["FR"], 2 ) )
                    lvRL = str( round ( ac_Grip["RL"], 2 ) )
                    lvRR = str( round ( ac_Grip["RR"], 2 ) )
                    svKM = (      "\nvirtKM: Front l/r   "  + str(round(ac_virtkm["FL"],3))+'vkm   -   ' + str(round(ac_virtkm["FR"],3))+'vkm'
                            + "\n             Rear l/r   "  + str(round(ac_virtkm["RL"],3))+'vkm   -   ' + str(round(ac_virtkm["RR"],3))+'vkm'
                            + "\nGrip      Front l/r   "    + lvFL + '%   ' + lvFR + '%'
                            + "\n              Rear l/r   " + lvRL + '%   ' + lvRR + '%')
                    # svKM = svKM + (
                    #           "\nvirtKM: Front l/r   "  + str(round(ac_virtkm["FL"],3))+'vkm   -   ' + str(round(ac_virtkm["FR"],3))+'vkm'
                    #         + "\n         Rear l/r   "  + str(round(ac_virtkm["RL"],3))+'vkm   -   ' + str(round(ac_virtkm["RR"],3))+'vkm'
                    #         + "\nGrip    Front l/r   "    + lvFL + '%   ' + lvFR + '%'
                    #         + "\n         Rear l/r   "    + lvRL + '%   ' + lvRR + '%')



                #if newtyrewear:
                #    ac.setText(lbInfo,
                #              "\nsession distance traveled: " + str(round(ac.ext_getDistanceTraveled(currcar)/1000,2))+'km'
                #            + "\n"     + sIdealTemps
                #            + "\n"     + sIdealPress
                #            + "\n"     + sIdealGrip
                #            + "\nmax SlipAngle    "     + str(round(frict_limit_angF,2)) + ' / ' + str(round(frict_limit_angF,2)) + "°"
                #            # PRESSURE_STATIC
                #            + svKM
                #            # + "\nroad: " +str(round(tyinfo.physics.roadTemp,1))
                #            # + " air: "   +str(round(tyinfo.physics.airTemp,1))
                #            # + " grip: "  +str(round(tyinfo.graphics.surfaceGrip*100,1))
                #            )
                #else:



                # appCheckMinMax(        deltaT,  0, "core"   , ac_temp["FL"], align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT,  1, "    "   , ac_temp["FR"], align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT,  2, "core"   , ac_temp["RL"], align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT,  3, "    "   , ac_temp["RR"], align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT,  4, "omi"    , max(tyreTempI["FL"], tyreTempM["FL"], tyreTempO["FL"]), align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT,  5, "   "    , max(tyreTempI["FR"], tyreTempM["FR"], tyreTempO["FR"]), align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT,  6, "omi"    , max(tyreTempI["RL"], tyreTempM["RL"], tyreTempO["RL"]), align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT,  7, "   "    , max(tyreTempI["RR"], tyreTempM["RR"], tyreTempO["RR"]), align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT,  8, "carcass", ac_carc["FL"],align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT,  9, "       ", ac_carc["FR"],align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT, 10, "carcass", ac_carc["RL"],align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT, 11, "       ", ac_carc["RR"],align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT, 12, "press"  , ac_pres["FL"], align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT, 13, "     "  , ac_pres["FR"], align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT, 14, "press"  , ac_pres["RL"], align=ExtGL.FONT_ALIGN_RIGHT)
                # appCheckMinMax(        deltaT, 15, "     "  , ac_pres["RR"], align=ExtGL.FONT_ALIGN_RIGHT)

                sMinMax2 =("\nMin/Max                    R            \t        L\n")
                if brakestempsConfigured:
                    sMinMax2+="Brakes Front       "      + appGetTempTextUnits(fMins[16],False) + " / " + appGetTempTextUnits(fMaxs[ 16],False) + "        " + appGetTempTextUnits(fMins[17],False) + " / " + appGetTempTextUnits(fMaxs[ 17],False) + "\n"
                    sMinMax2+="           Rear         "   + appGetTempTextUnits(fMins[18],False) + " / " + appGetTempTextUnits(fMaxs[ 18],False) + "        " + appGetTempTextUnits(fMins[19],False) + " / " + appGetTempTextUnits(fMaxs[ 19],False) + "\n"
                    if bCoreTempsEnabled and bCPhysicsActive:
                        sMinMax2+="Brakes Core F     " + appGetTempTextUnits(fMins[20],False) + " / " + appGetTempTextUnits(fMaxs[ 20],False) + "        " + appGetTempTextUnits(fMins[21],False) + " / " + appGetTempTextUnits(fMaxs[ 21],False)+ "\n"
                        sMinMax2+="                    R     " + appGetTempTextUnits(fMins[22],False) + " / " + appGetTempTextUnits(fMaxs[ 22],False) + "        " + appGetTempTextUnits(fMins[23],False) + " / " + appGetTempTextUnits(fMaxs[ 23],False)+ "\n"
                # round(fMins[id],1)
                sMinMax2+=("Core Front       " + appGetTempTextUnits(fMins[ 0]) + " / " + appGetTempTextUnits(fMaxs[ 0]) + "        " + appGetTempTextUnits(fMins[ 1]) + " / " + appGetTempTextUnits(fMaxs[ 1]) + "\n")
                sMinMax2+=("          Rear       " + appGetTempTextUnits(fMins[ 2]) + " / " + appGetTempTextUnits(fMaxs[ 2]) + "        " + appGetTempTextUnits(fMins[ 3]) + " / " + appGetTempTextUnits(fMaxs[ 3]) + "\n")
                sMinMax2+=("OMI Front       " + appGetTempTextUnits(fMins[ 4]) + " / " + appGetTempTextUnits(fMaxs[ 4]) + "        " + appGetTempTextUnits(fMins[ 5]) + " / " + appGetTempTextUnits(fMaxs[ 5]) + "\n")
                sMinMax2+=("         Rear       " + appGetTempTextUnits(fMins[ 6]) + " / " + appGetTempTextUnits(fMaxs[ 6]) + "        " + appGetTempTextUnits(fMins[ 7]) + " / " + appGetTempTextUnits(fMaxs[ 7]) + "\n")
                if bCPhysCarcassEnabled and bCPhysicsActive:
                    sMinMax2+=("Carcass Front  " + appGetTempTextUnits(fMins[ 8]) + " / " + appGetTempTextUnits(fMaxs[ 8]) + "        " + appGetTempTextUnits(fMins[ 9]) + " / " + appGetTempTextUnits(fMaxs[ 9]) + "\n")
                    sMinMax2+=("             Rear    " + appGetTempTextUnits(fMins[10]) + " / " + appGetTempTextUnits(fMaxs[10]) + "        " + appGetTempTextUnits(fMins[11]) + " / " + appGetTempTextUnits(fMaxs[11]) + "\n")
                sMinMax2+=("Press Front      "     + appGetPressureText(fMins[12]) + " / " + appGetPressureText(fMaxs[12]) + "      " + appGetPressureText(fMins[13]) + " / " + appGetPressureText(fMaxs[13]) + "\n")
                sMinMax2+=("           Rear      " + appGetPressureText(fMins[14]) + " / " + appGetPressureText(fMaxs[14]) + "      " + appGetPressureText(fMins[15]) + " / " + appGetPressureText(fMaxs[15]) + "\n")

                sMinMax="\nMin/Max\n"
                sMinMax+=("Ride height F              " + str(round(rhMin[0]*1000, 1)) + "mm / " + str(round(rhMax[0]*1000, 1)) + "mm"+ "\n")
                sMinMax+=("                  R              " + str(round(rhMin[1]*1000, 1)) + "mm / " + str(round(rhMax[1]*1000, 1)) + "mm"+ "\n")
                if bDAMPERsON and bCSPactive:
                    sMinMax+="Damper Travel F        "           + str(round(minDampTravFRONT *1000,1)) + "mm / " + str(round(maxDampTravFRONT *1000,1)) + "mm\n"
                    sMinMax+="                        R        " + str(round(minDampTravREAR  *1000,1)) + "mm / " + str(round(maxDampTravREAR  *1000,1)) + "mm\n"
                sMinMax+="Susp Travel F             "       + str(round(minSuspTravFRONT *1000,1)) + "mm / " + str(round(maxSuspTravFRONT *1000,1)) + "mm\n"
                sMinMax+="                  R             " + str(round(minSuspTravREAR  *1000,1)) + "mm / " + str(round(maxSuspTravREAR  *1000,1)) + "mm\n"
                if SuspensionForceEnabled and bCPhysicsActive:
                    sMinMax+="Susp Force F              "        + str(int(minSuspForceFRONT)) + "Nm / " + str(int(maxSuspForceFRONT)) + "Nm\n"
                    sMinMax+="                   R             " + str(int(minSuspForceREAR )) + "Nm / " + str(int(maxSuspForceREAR )) + "Nm\n"

                ac.setText(lbInfo2, svKM + sMinMax2)
                ac.setText(lbInfo,
                              "\nsession distance traveled: " + str(round(tyinfo.graphics.distanceTraveled/1000,2))+'km'
                            + "\n"     + sIdealTemps
                            + "\n"     + sIdealPress
                            + "\n"     + sIdealGrip
                            + "\nmax SlipAngle    "     + str(round(frict_limit_angF,2)) + ' / ' + str(round(frict_limit_angF,2)) + "°"
                            # PRESSURE_STATIC
                            # + svKM
                            + sMinMax
                            # + "\nroad: " +str(round(tyinfo.physics.roadTemp,1))
                            # + " air: "   +str(round(tyinfo.physics.airTemp,1))
                            # + " grip: "  +str(round(tyinfo.graphics.surfaceGrip*100,1))
                            )

                ac_TVfl, ac_TVfr, ac_TVrl, ac_TVrr     = ac.getCarState(currcar, acsys.CS.WheelAngularSpeed)
                #ac_TVfl, ac_TVfr, ac_TVrl, ac_TVrr     = tyinfo.physics.wheelAngularSpeed
                ### SLIP CIRCLE GRAPH values
                ### only slip-circle coords from angle, not any mult
                xsinFL = -max(-1.0, min(1.0, math.sin( math.radians(ac_angle['FL'])) ))
                xsinFR = -max(-1.0, min(1.0, math.sin( math.radians(ac_angle['FR'])) ))
                xsinRL = -max(-1.0, min(1.0, math.sin( math.radians(ac_angle['RL'])) ))
                xsinRR = -max(-1.0, min(1.0, math.sin( math.radians(ac_angle['RR'])) ))
                ycosFL = -max(-1.0, min(1.0, math.cos( math.radians(ac_angle['FL'])) ))
                ycosFR = -max(-1.0, min(1.0, math.cos( math.radians(ac_angle['FR'])) ))
                ycosRL = -max(-1.0, min(1.0, math.cos( math.radians(ac_angle['RL'])) ))
                ycosRR = -max(-1.0, min(1.0, math.cos( math.radians(ac_angle['RR'])) ))

            elif dataCounter1 == 2:
                # update BRAKE TEMPs
                # get BRAKE TEMPS by shared memory, not vail for other cars than players
                ###brakeTemp
                if brakestempsConfigured and bCPhysBrakesEnabled:
                    if newtyrewear:
                        ac_brake["FL"] = ac.ext_getBrakeTemp(currcar, 0)
                        ac_brake["FR"] = ac.ext_getBrakeTemp(currcar, 1)
                        ac_brake["RL"] = ac.ext_getBrakeTemp(currcar, 2)
                        ac_brake["RR"] = ac.ext_getBrakeTemp(currcar, 3)
                    else:
                        ac_brake["FL"], ac_brake["FR"], ac_brake["RL"], ac_brake["RR"] = tyinfo.physics.brakeTemp

                    if currBrake>0.5 and currspeed>30:
                        tair = tyinfo.physics.airTemp
                        if ((int(ac_brake["FR"])==int(tair) and int(ac_brake["FL"])==int(tair)) and
                            (int(ac_brake["RL"])==int(tair) and int(ac_brake["RR"])==int(tair))    ):
                            brakestempsConfigured = False
                            ac.setVisible(WHEELS["FL"]["brake"]["value"],0)
                            ac.setVisible(WHEELS["FR"]["brake"]["value"],0)
                            ac.setVisible(WHEELS["RL"]["brake"]["value"],0)
                            ac.setVisible(WHEELS["RR"]["brake"]["value"],0)
                            ac.setVisible(WHEELS["FL"]["brakeL"]["value"],0)
                            ac.setVisible(WHEELS["FR"]["brakeL"]["value"],0)
                            ac.setVisible(WHEELS["RL"]["brakeL"]["value"],0)
                            ac.setVisible(WHEELS["RR"]["brakeL"]["value"],0)
                    try:
                        if bCoreTempsEnabled and bCSPactive:
                            # get BRAKE CORE TEMPS from CSP, not vail for other cars than players
                            ac_brakeC["FL"] = ac.ext_getBrakeCoreTemp(0)
                            ac_brakeC["FR"] = ac.ext_getBrakeCoreTemp(1)
                            ac_brakeC["RL"] = ac.ext_getBrakeCoreTemp(2)
                            ac_brakeC["RR"] = ac.ext_getBrakeCoreTemp(3)
                            if ac_brakeC["FL"]==0.0 and ac_brakeC["RL"]==0.0 and ac_brakeC["FR"]==0.0 and ac_brakeC["RR"]==0.0:
                                bCoreTempsEnabled = False
                                ac.setVisible(WHEELS["FL"]["brakeD"]["value"],0)
                                ac.setVisible(WHEELS["FR"]["brakeD"]["value"],0)
                                ac.setVisible(WHEELS["RL"]["brakeD"]["value"],0)
                                ac.setVisible(WHEELS["RR"]["brakeD"]["value"],0)
                    except:
                        ac.log('tyres_app_ext: reported values=0, core brake temps disabled' + traceback.format_exc())
                        bCoreTempsEnabled = False
                        ac.setVisible(WHEELS["FL"]["brake" ]["value"],0)
                        ac.setVisible(WHEELS["FR"]["brake" ]["value"],0)
                        ac.setVisible(WHEELS["RL"]["brake" ]["value"],0)
                        ac.setVisible(WHEELS["RR"]["brake" ]["value"],0)

        #if timer2 > updateTime2:
        #    ac.setText(lbCenter, "%.3f\n%.3f\n%.3f\n%.3f\n%.3f" % (carDamage1, cd2, cd3, cd4, cd5))

        if timer2 > updateTime2: # fast timer2
            dataCounter2 += 1
            # update tyre OMI TEMPs
            if dataCounter2 > 2:
                dataCounter2 = 0

            appHandleMinMaxValues(deltaT)

            if bCSPactive and bFancyMode and rtIndex1>-1 and not Berror:
                try:
                    ### temps new
                    ### tSurfRL, tSurfFL, tSurfRM, tSurfFM, tSurfRR, tSurfFR
                    ### tCarcassR, tCarcassF, tCoreCarcassR, tCoreCarcassF, tCoreF, tCoreR

                    ### clear 2nd buffer
                    ac.ext_clearRenderTarget(rtIndex1)
                    ac.ext_bindRenderTarget(rtIndex1)
                    ac.ext_glSetBlendMode(1)

                    ### paint on 2nd buffer
                    imoOffset = 0
                    if not bShowPressure:
                        imoOffset += hw/7
                    if bSHOWIMOTEXT and bSHOWIMO:
                        imoOffset += hw/7
                    #if not bShowPressure:
                    #    imoOffset += hw/7
                    appBlendImage(marginX +           0, marginY +  imoOffset                , tSurfFL, tyreTempI["FL"], ac_isHot["FL"], ac_TempMult["FL"])
                    appBlendImage(marginX +           0, marginY +  imoOffset                , tSurfFL, tyreTempI["FL"], ac_isHot["FL"], ac_TempMult["FL"])
                    appBlendImage(marginX +           0, marginY +  imoOffset                , tSurfFR, tyreTempO["FL"], ac_isHot["FL"], ac_TempMult["FL"])
                    appBlendImage(marginX + hw  + hw/5 , marginY +  imoOffset                , tSurfFL, tyreTempI["FR"], ac_isHot["FR"], ac_TempMult["FR"])
                    appBlendImage(marginX + hw-2+ hw/5 , marginY +  imoOffset                , tSurfFR, tyreTempO["FR"], ac_isHot["FR"], ac_TempMult["FR"])
                    appBlendImage(marginX +           0, marginY   -imoOffset-fontOffsetYRear, tSurfRL, tyreTempI["RL"], ac_isHot["RL"], ac_TempMult["RL"])
                    appBlendImage(marginX +           0, marginY   -imoOffset-fontOffsetYRear, tSurfRR, tyreTempO["RL"], ac_isHot["RL"], ac_TempMult["RL"])
                    appBlendImage(marginX + hw  + hw/5 , marginY   -imoOffset-fontOffsetYRear, tSurfRL, tyreTempI["RR"], ac_isHot["RR"], ac_TempMult["RR"])
                    appBlendImage(marginX + hw-2+ hw/5 , marginY   -imoOffset-fontOffsetYRear, tSurfRR, tyreTempO["RR"], ac_isHot["RR"], ac_TempMult["RR"])
                    appBlendImage(marginX +           0, marginY +  imoOffset                , tSurfFM, tyreTempM["FL"], ac_isHot["FL"], ac_TempMult["FL"])
                    appBlendImage(marginX + hw-1+ hw/5 , marginY +  imoOffset                , tSurfFM, tyreTempM["FR"], ac_isHot["FR"], ac_TempMult["FR"])
                    appBlendImage(marginX +           0, marginY   -imoOffset-fontOffsetYRear, tSurfRM, tyreTempM["RL"], ac_isHot["RL"], ac_TempMult["RL"])
                    appBlendImage(marginX + hw-1+ hw/5 , marginY   -imoOffset-fontOffsetYRear, tSurfRM, tyreTempM["RR"], ac_isHot["RR"], ac_TempMult["RR"])
                    if bCPhysicsActive and bCPhysCarcassEnabled:
                        appBlendImage(marginX +           0, marginY +  imoOffset                  , tCarcassF, ac_carc["FL"])
                        appBlendImage(marginX + hw  + hw/5 , marginY +  imoOffset                  , tCarcassF, ac_carc["FR"])
                        appBlendImage(marginX +           0, marginY + -imoOffset - fontOffsetYRear, tCarcassR, ac_carc["RL"])
                        appBlendImage(marginX + hw  + hw/5 , marginY + -imoOffset - fontOffsetYRear, tCarcassR, ac_carc["RR"])
                        appBlendImage(marginX +           0, marginY +  imoOffset                  , tCoreCarcassF, ac_temp["FL"])
                        appBlendImage(marginX + hw  + hw/5 , marginY +  imoOffset                  , tCoreCarcassF, ac_temp["FR"])
                        appBlendImage(marginX +           0, marginY + -imoOffset - fontOffsetYRear, tCoreCarcassR, ac_temp["RL"])
                        appBlendImage(marginX + hw  + hw/5 , marginY + -imoOffset - fontOffsetYRear, tCoreCarcassR, ac_temp["RR"])
                        ### carcass temps text
                        if bCPhysCarcassText:
                            if bShowPressure:
                                appDrawTextWithShadows(appGetTempText(ac_carc["FL"], False), marginX + hw - hw*0.85, marginY + hh - hh*0.70 + fontOffsetY, fntSize*1, ExtGL.FONT_ALIGN_CENTER)
                                appDrawTextWithShadows(appGetTempText(ac_carc["FR"], False), marginX + hw + hw*0.85, marginY + hh - hh*0.70 + fontOffsetY, fntSize*1, ExtGL.FONT_ALIGN_CENTER)
                                appDrawTextWithShadows(appGetTempText(ac_carc["RL"], False), marginX + hw - hw*0.85, marginY + hh + hh*0.55 + fontOffsetY, fntSize*1, ExtGL.FONT_ALIGN_CENTER)
                                appDrawTextWithShadows(appGetTempText(ac_carc["RR"], False), marginX + hw + hw*0.85, marginY + hh + hh*0.55 + fontOffsetY, fntSize*1, ExtGL.FONT_ALIGN_CENTER)
                            else:
                                appDrawTextWithShadows(appGetTempText(ac_carc["FL"], False), marginX + hw - hw*0.85, marginY + hh - hh*0.65 + fontOffsetY, fntSize*1, ExtGL.FONT_ALIGN_CENTER)
                                appDrawTextWithShadows(appGetTempText(ac_carc["FR"], False), marginX + hw + hw*0.85, marginY + hh - hh*0.65 + fontOffsetY, fntSize*1, ExtGL.FONT_ALIGN_CENTER)
                                appDrawTextWithShadows(appGetTempText(ac_carc["RL"], False), marginX + hw - hw*0.85, marginY + hh + hh*0.50 + fontOffsetY, fntSize*1, ExtGL.FONT_ALIGN_CENTER)
                                appDrawTextWithShadows(appGetTempText(ac_carc["RR"], False), marginX + hw + hw*0.85, marginY + hh + hh*0.50 + fontOffsetY, fntSize*1, ExtGL.FONT_ALIGN_CENTER)
                    else:
                        appBlendImage(marginX +           0, marginY +  imoOffset                  , tCoreF, ac_temp["FL"])
                        appBlendImage(marginX + hw  + hw/5 , marginY +  imoOffset                  , tCoreF, ac_temp["FR"])
                        appBlendImage(marginX +           0, marginY + -imoOffset - fontOffsetYRear, tCoreR, ac_temp["RL"])
                        appBlendImage(marginX + hw  + hw/5 , marginY + -imoOffset - fontOffsetYRear, tCoreR, ac_temp["RR"])

                    ### text
                    if bShowVals:
                        # core temps
                        if bShowPressure:
                            appDrawTextWithRect(appGetTempText(ac_temp["FL"],True), marginX + hw - hw*0.6, marginY + hh - fntSize*3.90 + fontOffsetY, fntSize*1.5, fntSize*3, ExtGL.FONT_ALIGN_CENTER, True, ac_isHot["FL"])
                            appDrawTextWithRect(appGetTempText(ac_temp["FR"],True), marginX + hw + hw*0.6, marginY + hh - fntSize*3.90 + fontOffsetY, fntSize*1.5, fntSize*3, ExtGL.FONT_ALIGN_CENTER, True, ac_isHot["FR"])
                            appDrawTextWithRect(appGetTempText(ac_temp["RL"],True), marginX + hw - hw*0.6, marginY + hh + fntSize*1.90 + fontOffsetY, fntSize*1.5, fntSize*3, ExtGL.FONT_ALIGN_CENTER, True, ac_isHot["RL"])
                            appDrawTextWithRect(appGetTempText(ac_temp["RR"],True), marginX + hw + hw*0.6, marginY + hh + fntSize*1.90 + fontOffsetY, fntSize*1.5, fntSize*3, ExtGL.FONT_ALIGN_CENTER, True, ac_isHot["RR"])
                        else:
                            appDrawTextWithRect(appGetTempText(ac_temp["FL"],True), marginX + hw - hw*0.6, marginY + hh - fntSize*2.00 + fontOffsetY, fntSize*1.5, fntSize*2.5, ExtGL.FONT_ALIGN_CENTER, True, ac_isHot["FL"])
                            appDrawTextWithRect(appGetTempText(ac_temp["FR"],True), marginX + hw + hw*0.6, marginY + hh - fntSize*2.00 + fontOffsetY, fntSize*1.5, fntSize*2.5, ExtGL.FONT_ALIGN_CENTER, True, ac_isHot["FR"])
                            appDrawTextWithRect(appGetTempText(ac_temp["RL"],True), marginX + hw - hw*0.6, marginY + hh + fntSize*0.00 + fontOffsetY, fntSize*1.5, fntSize*2.5, ExtGL.FONT_ALIGN_CENTER, True, ac_isHot["RL"])
                            appDrawTextWithRect(appGetTempText(ac_temp["RR"],True), marginX + hw + hw*0.6, marginY + hh + fntSize*0.00 + fontOffsetY, fntSize*1.5, fntSize*2.5, ExtGL.FONT_ALIGN_CENTER, True, ac_isHot["RR"])

                    if bSHOWIMO and bSHOWIMOTEXT:
                        ### imo temps three per line
                        appDrawTextWithRect(appGetTempText(tyreTempI["FL"],False) + " " + appGetTempText(tyreTempM["FL"],False) + " " + appGetTempText(tyreTempO["FL"],False), marginX + hw - hw*0.6, marginY + 0    + fntSize*0.05 + fontOffsetY, fntSize*1, fntSize*3.5, ExtGL.FONT_ALIGN_CENTER)
                        appDrawTextWithRect(appGetTempText(tyreTempI["FR"],False) + " " + appGetTempText(tyreTempM["FR"],False) + " " + appGetTempText(tyreTempO["FR"],False), marginX + hw + hw*0.6, marginY + 0    + fntSize*0.05 + fontOffsetY, fntSize*1, fntSize*3.5, ExtGL.FONT_ALIGN_CENTER)
                        appDrawTextWithRect(appGetTempText(tyreTempI["RL"],False) + " " + appGetTempText(tyreTempM["RL"],False) + " " + appGetTempText(tyreTempO["RL"],False), marginX + hw - hw*0.6, marginY + hh*2 - fntSize*1.35 + fontOffsetY, fntSize*1, fntSize*3.5, ExtGL.FONT_ALIGN_CENTER)
                        appDrawTextWithRect(appGetTempText(tyreTempI["RR"],False) + " " + appGetTempText(tyreTempM["RR"],False) + " " + appGetTempText(tyreTempO["RR"],False), marginX + hw + hw*0.6, marginY + hh*2 - fntSize*1.35 + fontOffsetY, fntSize*1, fntSize*3.5, ExtGL.FONT_ALIGN_CENTER)
                    if brakestempsConfigured and bCPhysBrakesEnabled and bCPhysBrakesText:
                        appDrawTextWithShadows(getBrakeTempText(ac_brake["FL"], ac_brakeC["FL"]), marginX + hw - hw*0.1175, marginY + hh - hh*0.825 + fontOffsetY                  , fntSize, ExtGL.FONT_ALIGN_CENTER)
                        appDrawTextWithShadows(getBrakeTempText(ac_brake["FR"], ac_brakeC["FR"]), marginX + hw + hw*0.1175, marginY + hh - hh*0.825 + fontOffsetY                  , fntSize, ExtGL.FONT_ALIGN_CENTER)
                        appDrawTextWithShadows(getBrakeTempText(ac_brake["RL"], ac_brakeC["RL"]), marginX + hw - hw*0.1175, marginY + hh + hh*0.375 + fontOffsetY-fontOffsetYRear/3, fntSize, ExtGL.FONT_ALIGN_CENTER)
                        appDrawTextWithShadows(getBrakeTempText(ac_brake["RR"], ac_brakeC["RR"]), marginX + hw + hw*0.1175, marginY + hh + hh*0.375 + fontOffsetY-fontOffsetYRear/3, fntSize, ExtGL.FONT_ALIGN_CENTER)

                    ### pressure bars
                    if bShowPressure and bPressureGraph:
                        appRenderPressure()

                    ac.ext_restoreRenderTarget()
                    ac.ext_generateMips(rtIndex1)
                except:
                    Berror = True
                    ac.log('tyre_app_ext blend: ' + traceback.format_exc() )



        ### info
        # "tempc"  # core temps colored rectangle
        # "ctmpc"  # carcass temps colored rectangle
        # "temp"   # core temps text value
        # "ctemp"  # carcass temps text value

        # going through each wheel
        for wheel in wheels:
            if timer1 > updateTime1:
                if dataCounter1==0:
                    if bCPhysicsActive:
                        if bCPhysCarcassEnabled:
                            # CARCASS colored
                            if wheel=="FR" or wheel=="FL":
                                cval = ( max(0,min(maxTF, ac_carc[wheel]-minTF)))/(maxTF-minTF) * theemulti
                            else:
                                cval = ( max(0,min(maxTR, ac_carc[wheel]-minTR)))/(maxTR-minTR) * theemulti
                            appSetControlBGColor( WHEELS[wheel]["tempc"]["value"] , cval) #  , ac_isHot[wheel]) # , ac_TempMult[wheel])
                        else:
                            # CORE TEMPs colored
                            if wheel=="FR" or wheel=="FL":
                                cval = ( max(0,min(maxTF, ac_temp[wheel]-minTF)))/(maxTF-minTF) * theemulti
                            else:
                                cval = ( max(0,min(maxTR, ac_temp[wheel]-minTR)))/(maxTR-minTR) * theemulti
                            #cval = ac_temp[wheel]
                            appSetControlBGColor( WHEELS[wheel]["temp"]["value"]  , cval )

                        # updating the CORE TEMPs
                        #       we set CORE TEMPs here with CARCASS TEMPs enabled
                        if wheel=="FR" or wheel=="FL":
                            cval = ( max(0,min(maxTF, ac_temp[wheel]-minTF)))/(maxTF-minTF) * theemulti
                        else:
                            cval = ( max(0,min(maxTR, ac_temp[wheel]-minTR)))/(maxTR-minTR) * theemulti
                        # cval = ac_temp[wheel]
                        appSetControlBGColor( WHEELS[wheel]["ctmpc"]["value"], cval )
                        # appSetControlBGColor( WHEELS[wheel]["ctmpc"]["value"], cval , ac_isHot[wheel] )
                        # ac.setFontColor(WHEELS[wheel]["ctemp"]["value"], 0,0.5,0.5,gOpacityFG/100.0)
                        # ac.setBackgroundOpacity(WHEELS[wheel]["ctmpc"]["value"], 1 )
                        if bShowVals and not bShowLess:
                            # ac.setFontColor(l_tyre, 0.5,0.5,0.5,gOpacityFG/100.0)
                            #temperature2 = ""
                            #temperature2 = " %.1f " % ac_carc[wheel] if gUnits["temp"] == "C" else " %.1f " % C_to_F(ac_carc[wheel])
                            temperature2 = appGetTempText(ac_carc[wheel])
                            ac.setText(WHEELS[wheel]["ctemp"]["value"], temperature2)
                            #ac.setText(WHEELS[wheel]["ctemp"]["value"], temperature2 + (" - %.2f" % (cval)))
                    else:
                        if wheel=="FR" or wheel=="FL":
                            cval = ( max(0,min(maxTF, ac_temp[wheel]-minTF)))/(maxTF-minTF) * theemulti
                        else:
                            cval = ( max(0,min(maxTR, ac_temp[wheel]-minTR)))/(maxTR-minTR) * theemulti
                        appSetControlBGColor( WHEELS[wheel]["temp"]["value"], cval )

                    # CORE TEMPs text
                    if bShowVals and not bFancyMode:   ###  and not bShowLess:
                        # °C or Fahrenheit
                        temperature = appGetTempText(ac_temp[wheel]) # "%.1f"   % ac_temp[wheel] if gUnits["temp"] == "C" else "%.1f" % C_to_F(ac_temp[wheel])
                                #else:
                                #    if minwidth>50:
                                #        temperature = "\n%.1f°C" % ac_temp[wheel] if gUnits["temp"] == "C" else "\n%.1f°F" % C_to_F(ac_temp[wheel])
                                #    else:
                                #        temperature = "\n%.1f"   % ac_temp[wheel] if gUnits["temp"] == "C" else "\n%.1f" % C_to_F(ac_temp[wheel])
                        ac.setText(WHEELS[wheel]["temp"]["value"], temperature )
                        ac.setFontColor(WHEELS[wheel]["temp"]["value"], 0,0,0,gOpacityFG/100.0)

                    # tyre pressure
                    if bShowPressure:
                        # tyre PRESSURE color
                        if ac_presOpt[wheel]!=0.0:
                            ### color
                            palID = getTyreColorID(ac_pres[wheel] - ac_presOpt[wheel])
                            if palID == 128:
                                if bShowPressureText:
                                    ac.setFontColor(        WHEELS[wheel]["pres"]["value"], 0, 1, 0, gOpacityFG/100.0)
                                else:
                                    ac.setBackgroundColor(  WHEELS[wheel]["pres"]["value"], 0, 1, 0   )
                            else:
                                if bShowPressureText:
                                    ac.setFontColor(        WHEELS[wheel]["pres"]["value"], currPal[palID][0]   , currPal[palID][1],  currPal[palID][2], gOpacityFG/100.0)
                                else:
                                    ac.setBackgroundColor(  WHEELS[wheel]["pres"]["value"], currPal[palID][0]   , currPal[palID][1],  currPal[palID][2]   )
                        ac.setBackgroundOpacity(WHEELS[wheel]["pres"]["value"], gOpacityFG/100*0.8)

                        # tyre PRESSURE text
                        if bShowPressureText:
                            pressure  = appGetPressureText(ac_pres[wheel], True)
                            if bShowPressureDiff:
                                pressdiff = appGetPressureDiffText(ac_pres[wheel] - ac_presOpt[wheel], False)
                                ac.setText(WHEELS[wheel]["pres"]["value"], pressure + "  " + pressdiff)
                            else:
                                ac.setText(WHEELS[wheel]["pres"]["value"], pressure)

                elif dataCounter1==1:
                    if bCPhysicsActive:
                        if bFlatBlistGrain:
                            # update FLATSPOT BLISTER GRAIN details
                            detailsS=""
                            if ALWAYSSHOW_FLATSPOTSBLISTERGRAIN or ac_flat[wheel]>=0.0001:
                                detailsS += "Fs: %.4f" % (ac_flat[wheel])
                                detailsS+="\n"
                            if ALWAYSSHOW_FLATSPOTSBLISTERGRAIN or ac_blister[wheel]>0.0005:
                                detailsS += "Bl: %.4f" % (ac_blister[wheel])
                                detailsS+="\n"
                            if ALWAYSSHOW_FLATSPOTSBLISTERGRAIN or ac_grain[wheel]>0.0005:
                                detailsS += "Gr: %.4f" % (ac_grain[wheel])
                            # if not bFancyMode:
                            if detailsS!="":
                                ac.setVisible(WHEELS[wheel]["details"]["value"], 1)
                                ### todo make grain/blister/flatspots visual; edit : no
                                if wheel=="FR" or wheel=="FL":
                                    if bSHOWIMO:
                                        ac.setText(WHEELS[wheel]["details"]["value"], detailsS)
                                    else:
                                        ac.setText(WHEELS[wheel]["details"]["value"], '\n'+detailsS)
                                else:
                                    ac.setText(WHEELS[wheel]["details"]["value"], "\n" + detailsS)
                            else:
                                ac.setVisible(WHEELS[wheel]["details"]["value"], 0)

                    # tyre WEAR updating WEAR level graph
                    if WHEELS[wheel]["wear"]["last"] != round(ac_wear[wheel],2):
                        WHEELS[wheel]["wear"]["last"] = round(ac_wear[wheel],2)
                        colid = 0    ### max(255,min(0, (5-(ac_wear[wheel]-100))*255 ))
                        if ac_wear[wheel]>=95:
                            colid = max(0,min(255, int ( (5+(ac_wear[wheel]-100) ) ) *50  ))
                        if bShowWearText:
                            ac.setFontColor(        WHEELS[wheel]["wearLabel"], colorPalWear[255-colid][0], colorPalWear[255-colid][1], colorPalWear[255-colid][2], gOpacityFG/100.0)
                            # ac.setFontColor(        WHEELS[wheel]["wear"]["value"], 1,1,1, gOpacityFG/100.0)
                            ac.setText(             WHEELS[wheel]["wearLabel"], str(round( 100-(ac_wear[wheel]), 2)) )
                            ac.setBackgroundOpacity(WHEELS[wheel]["wearLabel"],gOpacityFG/100)

                        if bShowWearGraph:
                            ac.setBackgroundColor(  WHEELS[wheel]["wearInner"], colorPalWear[255-colid][0], colorPalWear[255-colid][1], colorPalWear[255-colid][2])
                            if ac_wear[wheel]>=95:
                                ratio = ( ((100-ac_wear[wheel])/5 ) ) * (hh-fntSize*2.5)
                            else:
                                ratio = hh-fntSize*2.5
                            if   wheel=="FL":
                                ac.setPosition(WHEELS["FL"]["wearInner"]     , hw   - offset-minwidth-minwidth*0.25+1,            0+ratio +fontOffsetYRear/4)
                            elif wheel=="FR":
                                ac.setPosition(WHEELS["FR"]["wearInner"]     , hw   + offset+minwidth+minwidth*0.15+1,            0+ratio +fontOffsetYRear/4)
                            elif wheel=="RL":
                                ac.setPosition(WHEELS["RL"]["wearInner"]     , hw   - offset-minwidth-minwidth*0.25+1, hh+fntSize*3+ratio -fontOffsetYRear/4)
                            else:
                                ac.setPosition(WHEELS["RR"]["wearInner"]     , hw   + offset+minwidth+minwidth*0.15+1, hh+fntSize*3+ratio -fontOffsetYRear/4)
                            ac.setSize(WHEELS[wheel]["wearInner"], max(2,minwidth*0.1-4), int((hh-fntSize*3.0) - ratio) )
                            ac.setBackgroundOpacity(WHEELS[wheel]["wear"]["value"], gOpacityFG/100)
                            ac.setBackgroundOpacity(WHEELS[wheel]["wearInner"],gOpacityFG/100)


                    # updating the tyre DIRT level
                    if ac_dirt[wheel]>0.001:
                        if not WHEELS[wheel]["dvis"]:
                            WHEELS[wheel]["dvis"]=True
                            ac.setVisible(WHEELS[wheel]["dirt"],1)

                        lv = 0.7 + (ac_dirt[wheel]/5)*4
                        if lv<1:
                            ac.setBackgroundColor( WHEELS[wheel]["dirt"], 0,   min(1,max(0.5,lv)), max(0.25,1-lv) )
                        elif lv<2:
                            ac.setBackgroundColor( WHEELS[wheel]["dirt"], max(0, -1+lv), max(0,1-(-1+lv)),  0)
                        else:
                            ac.setBackgroundColor( WHEELS[wheel]["dirt"], 1, 0.5, 0.5)

                        #if bShowVals and not bShowLess:
                        if bShowVals and not bShowLess:
                            if (ac_dirt[wheel]/5*100)>1.0:
                                dirt = " %.0f%% dirt" % (ac_dirt[wheel]/5*100)
                            else:
                                dirt = " %.1f%% dirt" % (ac_dirt[wheel]/5*100)
                            ac.setText(WHEELS[wheel]["dirt"], dirt ) #  + progStr[:(int(dirt_level*50))]

                        #ac.setBackgroundOpacity(WHEELS[wheel]["dirt"],ac_dirt[wheel]/2)
                        ac.setBackgroundOpacity(WHEELS[wheel]["dirt"],min(5,ac_dirt[wheel]+0.5)/5)
                    else:
                        if WHEELS[wheel]["dvis"]:
                            WHEELS[wheel]["dvis"]=False
                            ac.setVisible(WHEELS[wheel]["dirt"],0)

                elif dataCounter1==2 and bCPhysBrakesEnabled and brakestempsConfigured:
                    # update BRAKE temps
                    if ac_brake[wheel]>maxBT:
                        maxBT = ac_brake[wheel]
                    if ac_brakeC[wheel]>maxBT:
                        maxBT = ac_brakeC[wheel]
                    if ac_brake[wheel]<minBT:
                        minBT = ac_brake[wheel]
                    if ac_brakeC[wheel]<minBT:
                        minBT = ac_brakeC[wheel]

                    #cval = ( max(0,min(600, (ac_brake[wheel]-minBT)/(600-minBT))))
                    cval = ( max(0,min(550, (ac_brake[wheel]-minBT)/(550-minBT))))
                    appSetControlBGColorBrakes( WHEELS[wheel]["brake"]["value"], cval)
                    brakeT = getBrakeTempText(ac_brake[wheel], ac_brakeC[wheel])
                    if bCoreTempsEnabled:
                        #cvalD = ( max(0,min(600, (ac_brakeC[wheel]-minBT)/(600-minBT))))
                        cvalD = ( max(0,min(550, (ac_brakeC[wheel]-minBT)/(550-minBT))))
                        appSetControlBGColorBrakes( WHEELS[wheel]["brakeD"]["value"], cvalD)
                        ac.setFontColor(WHEELS[wheel]["brakeL"]["value"], 0,0,0, gOpacityFG/100.0)
                    if bCPhysBrakesText and not bFancyMode:
                        ac.setText(WHEELS[wheel]["brakeL"]["value"], brakeT)



                    # wrap around data update counter if needed
                    if wheel=="RR" and timer1 > updateTime1:
                        timer1 = 0.0



            if timer2 > updateTime2:
                if not bFancyMode:
                    temperature=""
                    ###if dataCounter2 == 0:
                    # Outer temps
                    if wheel=="FL": # here using inner temp not outer bc its ac
                        cval = ( max(0,min(maxTF, tyreTempI[wheel]-minTF)))/(maxTF-minTF) * theemulti
                        #cval = tyreTempI[wheel] * theemulti
                        appSetControlBGColor( WHEELS[wheel]["tempO"]["value"] , cval , ac_isHot[wheel], ac_TempMult[wheel] )
                        temperature = "%.0f" % tyreTempI[wheel] if gUnits["temp"] == "C" else "%.0f" % C_to_F(tyreTempI[wheel])
                    elif wheel=="FR":
                        cval = ( max(0,min(maxTF, tyreTempO[wheel]-minTF)))/(maxTF-minTF) * theemulti
                        #cval = tyreTempO[wheel] * theemulti
                        appSetControlBGColor( WHEELS[wheel]["tempO"]["value"] , cval , ac_isHot[wheel], ac_TempMult[wheel] )
                        temperature = "%.0f" % tyreTempO[wheel] if gUnits["temp"] == "C" else "%.0f" % C_to_F(tyreTempO[wheel])
                    elif wheel=="RL": # here using inner temp not outer bc its ac
                        cval = ( max(0,min(maxTR, tyreTempI[wheel]-minTR))) /(maxTR-minTR) * theemulti
                        #cval = tyreTempI[wheel] * theemulti
                        appSetControlBGColor( WHEELS[wheel]["tempO"]["value"] , cval , ac_isHot[wheel], ac_TempMult[wheel] )
                        temperature = "%.0f" % tyreTempI[wheel] if gUnits["temp"] == "C" else "%.0f" % C_to_F(tyreTempI[wheel])
                    else:
                        cval = ( max(0,min(maxTR, tyreTempO[wheel]-minTR))) / (maxTR-minTR) * theemulti
                        #cval = tyreTempO[wheel] * theemulti
                        appSetControlBGColor( WHEELS[wheel]["tempO"]["value"] , cval , ac_isHot[wheel], ac_TempMult[wheel] )
                        temperature = "%.0f" % tyreTempO[wheel] if gUnits["temp"] == "C" else "%.0f" % C_to_F(tyreTempO[wheel])
                    if bSHOWIMOTEXT and bSHOWIMO:
                        ac.setText(WHEELS[wheel]["tempO"]["value"], temperature)
                    ###elif dataCounter2 == 1:
                    # Middle temps
                    if wheel=="FR" or wheel=="FL":
                        cval = ( max(0,min(maxTF, tyreTempM[wheel]-minTF)))/(maxTF-minTF) * theemulti
                        #cval = tyreTempM[wheel] * theemulti
                        appSetControlBGColor( WHEELS[wheel]["tempM"]["value"] , cval , ac_isHot[wheel], ac_TempMult[wheel] )
                        temperature = "%.0f" % tyreTempM[wheel] if gUnits["temp"] == "C" else "%.0f" % C_to_F(tyreTempM[wheel])
                    else:
                        cval = ( max(0,min(maxTR, tyreTempM[wheel]-minTR))) /(maxTR-minTR) * theemulti
                        #cval = tyreTempM[wheel] * theemulti
                        appSetControlBGColor( WHEELS[wheel]["tempM"]["value"] , cval , ac_isHot[wheel], ac_TempMult[wheel] )
                        temperature = "%.0f" % tyreTempM[wheel] if gUnits["temp"] == "C" else "%.0f" % C_to_F(tyreTempM[wheel])
                    if bSHOWIMOTEXT and bSHOWIMO:
                        ac.setText(WHEELS[wheel]["tempM"]["value"], temperature)

                    ###elif dataCounter2 == 2:
                    # Inner temps
                    if wheel=="FR" or wheel=="FL":
                        if wheel=="FL": # here using outer temp not inner bc its ac
                            cval = ( max(0,min(maxTF, tyreTempO[wheel]-minTF)))/(maxTF-minTF) * theemulti
                            #cval = tyreTempO[wheel] * theemulti
                            appSetControlBGColor( WHEELS[wheel]["tempI"]["value"] , cval , ac_isHot[wheel], ac_TempMult[wheel] )
                            temperature = "%.0f" % tyreTempO[wheel] if gUnits["temp"] == "C" else "%.0f" % C_to_F(tyreTempO[wheel])
                        else:
                            cval = ( max(0,min(maxTF, tyreTempI[wheel]-minTF)))/(maxTF-minTF) * theemulti
                            #cval = tyreTempI[wheel] * theemulti
                            appSetControlBGColor( WHEELS[wheel]["tempI"]["value"] , cval , ac_isHot[wheel], ac_TempMult[wheel] )
                            temperature = "%.0f" % tyreTempI[wheel] if gUnits["temp"] == "C" else "%.0f" % C_to_F(tyreTempI[wheel])
                    else:
                        if wheel=="RL": # here using outer temp not inner bc its ac
                            cval = ( max(0,min(maxTR, tyreTempO[wheel]-minTR))) /(maxTR-minTR) * theemulti
                            #cval = tyreTempO[wheel] * theemulti
                            appSetControlBGColor( WHEELS[wheel]["tempI"]["value"] , cval , ac_isHot[wheel], ac_TempMult[wheel] )
                            temperature = "%.0f" % tyreTempO[wheel] if gUnits["temp"] == "C" else "%.0f" % C_to_F(tyreTempO[wheel])
                        else:
                            cval = ( max(0,min(maxTR, tyreTempI[wheel]-minTR))) /(maxTR-minTR) * theemulti
                            #cval = tyreTempI[wheel] * theemulti
                            appSetControlBGColor( WHEELS[wheel]["tempI"]["value"] , cval , ac_isHot[wheel], ac_TempMult[wheel] )
                            temperature = "%.0f" % tyreTempI[wheel] if gUnits["temp"] == "C" else "%.0f" % C_to_F(tyreTempI[wheel])
                            if timer2 > updateTime2:
                                timer2 = 0.0
                    if bSHOWIMOTEXT and bSHOWIMO:
                        ac.setText(WHEELS[wheel]["tempI"]["value"], temperature)
    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )

#acupdate() end





######################################################################################################






def onFormRenderSettings(deltaT):
    global colorpng, theemulti, gColor, Berror
    if colorpng==-1:
        return
    # display 'colors.png' on settings dialog
    if not Berror:
        ac.glColor4f(1,1,1,0.9)
        xx=theemulti*127/8
        appDrawLineCalced(80+20, 350 + 127/2 - xx, 40+40 + 520, 350 + 127/2 - xx, 2)
        ac.glQuadTextured(90+20,350,460+20,255/4,colorpng)
        xx=gColor*40
        appDrawLineCalced( 95 + xx+20, 340, 105 + xx+20, 350, 4)
        appDrawLineCalced(105 + xx+20, 350, 115 + xx+20, 340, 4)



def onFormRender(deltaT):
    global fntSize, currcar, hh, hw, ac_load, ac_loadmax, ac_camb, timerRenderer, dataCounter, minwidth, minheight, offset, tyresliplimit, slipratiolimit, wheels, WHEELS
    global bShowDirections, bShowCamber, bShowTyreload, bShowLocked, ac_wspeed, bShowSlipRect, bShowSlipText, ac_angle, ac_bradius, ac_radius, ac_wspeedCalc, bNewTyreParams, ac_DampTrav, ac_SuspTrav, ac_SuspForce, bShowTravel
    global texture_inner_top, texture_inner_bot, texture_outer_top, texture_outer_bot, tyregraphwidth, cgHeight, currspeed
    global AEROCDv, AEROCLf, AEROCLr, ac_dy, ac_Mz, ac_SlipRatio, f1, f2, AEROdens, baseAEROdens, basecgHeight, ac_ndslip, ac_TyreSlip, bCSPactive, bShowAero, bShowMore, bShowVals, hideTimer, bShowLess, bShowWearText, bShowAeroText, bShowWearGraph, bSHOWIMO, bSHOWIMOTEXT
    global bDynAero, bHideTimerOn, STEERtorque, maxBrakeTorque, maxTorque, currPal, CURRTorque, angle_steerwheel, locOff
    global ac_anglePatch
    global maxDampTravFRONT, minDampTravFRONT, maxSuspTravFRONT, minSuspTravFRONT, maxDampTravREAR, minDampTravREAR, maxSuspTravREAR, minSuspTravREAR
    global maxSuspForceFRONT, minSuspForceFRONT, maxSuspForceREAR, minSuspForceREAR
    global ac_LocalAngV, ac_LocalVelocity
    global accG, lastaccG
    global tempFtemp, tempRtemp, tempFgrip, tempRgrip
    global wearFkm, wearRkm, wearFperc, wearRperc, ac_virtkm
    global xsinFL, xsinFR, ycosFL, ycosFR, xsinRL, xsinRR, ycosRL, ycosRR
    global TravelOffsetX, TravelOffsetY
    global rh, rhMax, rhMin, bDAMPERsON, bShowRadiuses
    global AERODownforce, maxDownForce, AERODrag, maxDrag
    global bDRAG, bDOWNFORCE, bMz, ac_isHot, slipCircleMult
    global sTextDrag , sTextDownforce, sTextDiff, sTextSlipStream, MinslipStreamLevel
    global SuspensionForceEnabled, locOffNM, locOff, ac_MaxNonSlipRatio
    global bShowGrip, ac_Grip, bWheelSpeedVSSlip, currID, bShowGripText
    global TOAppSize, TOoffsetx, TOoffsety, TOfntSize, TOhw, TOhh, TOminwidth, TOminheight, bGripAvailable, TOoffset
    global ac_TVfl, ac_TVfr, ac_TVrl, ac_TVrr, ac_pressLvl, ColorNames
    global rtIndex1, bFancyMode, marginX, marginY, bPressureGraph, bSHOWHOTG, bSHOWHOTT
    global gGAPSIZE, Berror

    try:
        # empty/dummy text draw, else it would break!?
        if bCSPactive and not Berror:
            appDrawText(0, '.', 0, 0, fntSize*0.1)

        # if rtIndex1>-1:
        #     ac_ai_line_drawer()

        ### special/debug stuff first
        if bWheelSpeedVSSlip:  #  and bShowRadiuses:
            if True:
            #if False:
                wdspeedF = ac_wspeed["FL"]-ac_wspeed["FR"]
                wdspeedR = ac_wspeed["RL"]-ac_wspeed["RR"]
                valFL = minwidth * xsinFL * wdspeedF * ac_TyreSlip["FL"] * ac_SlipRatio["FL"] * ac_ndslip["FL"]  ### ac_load["FL"] / 1000
                valFR = minwidth * xsinFR * wdspeedF * ac_TyreSlip["FR"] * ac_SlipRatio["FR"] * ac_ndslip["FR"]  ### ac_load["FR"] / 1000
                valRL = minwidth * xsinRL * wdspeedR * ac_TyreSlip["RL"] * ac_SlipRatio["RL"] * ac_ndslip["RL"]  ### ac_load["RL"] / 1000
                valRR = minwidth * xsinRR * wdspeedR * ac_TyreSlip["RR"] * ac_SlipRatio["RR"] * ac_ndslip["RR"]  ### ac_load["RR"] / 1000

                if histCount!=0: # with trail
                    lastXYZ[currID][0] = valFL
                    lastXYZ[currID][1] = valFR
                    lastXYZ[currID][2] = valRL
                    lastXYZ[currID][3] = valRR
                    localID = currID + 1
                    if localID >= histCount: # wrap around the history array
                        localID = 0
                    count = 0
                    while count < histCount:
                        if lastXYZ[localID][0] != 111.0:
                            a=0.99
                            if histVisi>0:
                                a=count/histCount/histVisi*5
                            appDrawLine3b(1-lastXYZ[localID][0]/100,lastXYZ[localID][0]/100,0.5,a,
                                TravelOffsetX - TOoffsetx + hw-minwidth-offset  ,
                                2+TravelOffsetY - TOoffsety+hh*2,
                                TravelOffsetX - TOoffsetx + hw-minwidth-offset- max(-minwidth*2, min(minwidth*2, lastXYZ[localID][0])),
                                2+TravelOffsetY - TOoffsety+hh*2                - max(-minwidth*2, min(minwidth*2, lastXYZ[localID][0])) )
                            appDrawLine3b(1-lastXYZ[localID][1]/100,lastXYZ[localID][1]/100,0.5,a,
                                TravelOffsetX + TOoffsetx + hw+minwidth+offset  ,
                                2+TravelOffsetY - TOoffsety + hh*2,
                                TravelOffsetX + TOoffsetx + hw+minwidth+offset+ max(-minwidth*2, min(minwidth*2, lastXYZ[localID][1])),
                                2+TravelOffsetY - TOoffsety + hh*2              - max(-minwidth*2, min(minwidth*2, lastXYZ[localID][1])) )
                            appDrawLine3b(1-lastXYZ[localID][2]/100,lastXYZ[localID][2]/100,0.5,a,
                                TravelOffsetX - TOoffsetx + hw-minwidth-offset  ,
                                2+TravelOffsetY + TOoffsety + hh*2,
                                TravelOffsetX - TOoffsetx + hw-minwidth-offset- max(-minwidth*2, min(minwidth*2, lastXYZ[localID][2])),
                                2+TravelOffsetY + TOoffsety + hh*2              + max(-minwidth*2, min(minwidth*2, lastXYZ[localID][2])) )
                            appDrawLine3b(1-lastXYZ[localID][3]/100,lastXYZ[localID][3]/100,0.5,a,
                                TravelOffsetX + TOoffsetx + hw+minwidth+offset  ,
                                2+TravelOffsetY + TOoffsety + hh*2 ,
                                TravelOffsetX + TOoffsetx + hw+minwidth+offset+ max(-minwidth*2, min(minwidth*2, lastXYZ[localID][3])),
                                2+TravelOffsetY + TOoffsety + hh*2              + max(-minwidth*2, min(minwidth*2, lastXYZ[localID][3])) )
                            appDrawLine3((lastXYZ[localID][0]+lastXYZ[localID][1])/2 /100,1-(lastXYZ[localID][0]+lastXYZ[localID][1])/2/100,0.5,a,
                                TravelOffsetX - TOoffsetx + hw-minwidth-offset        - max(-minwidth*2, min(minwidth*2, lastXYZ[localID][0])) ,
                                2+TravelOffsetY - TOoffsety + hh  + max(-minwidth*2, min(minwidth*2, lastXYZ[localID][0])),
                                TravelOffsetX + TOoffsetx + hw+minwidth+offset        + max(-minwidth*2, min(minwidth*2, lastXYZ[localID][1])) ,
                                2+TravelOffsetY - TOoffsety + hh  + max(-minwidth*2, min(minwidth*2, lastXYZ[localID][1])), minwidth/30)
                            appDrawLine3((lastXYZ[localID][2]+lastXYZ[localID][3])/2/100,1-(lastXYZ[localID][2]+lastXYZ[localID][3])/2/100,0.5,a,
                                TravelOffsetX - TOoffsetx + hw-minwidth-offset        - max(-minwidth*2, min(minwidth*2, lastXYZ[localID][2])) ,
                                2+TravelOffsetY + TOoffsety + hh*2 + max(-minwidth*2, min(minwidth*2, lastXYZ[localID][2])),
                                TravelOffsetX + TOoffsetx + hw+minwidth+offset        + max(-minwidth*2, min(minwidth*2, lastXYZ[localID][3])) ,
                                2+TravelOffsetY + TOoffsety + hh*2 + max(-minwidth*2, min(minwidth*2, lastXYZ[localID][3])), minwidth/30)
                        count += 1
                        localID += 1
                        if localID >= histCount: # wrap around the history array
                            localID = 0
                    #lastXYZ[localID][0], lastXYZ[localID][1]
                    # DrawXYZForce(lastXYZ[currID][0], lastXYZ[currID][1], lastXYZ[currID][2], 1)
                    a=1
                    currID += 1
                    if currID >= histCount:
                        currID = 0
                else: # without trail
                    appDrawLine3b(1-valFL/100,valFL/100,0.5,1,
                        hw-minwidth-offset  , TravelOffsetY + TOoffsety+hh   - minwidth/2 - fntSize*2,
                        hw-minwidth-offset-                  max(-minwidth*2, min(minwidth*2, valFL)),
                        TravelOffsetY + TOoffsety+hh   - minwidth/2 - fntSize*2 + max(-minwidth*2, min(minwidth*2, valFL)) )
                    appDrawLine3b(1-valFR/100,valFR/100,0.5,1,
                        hw+minwidth+offset  , TravelOffsetY + TOoffsety+hh   - minwidth/2 - fntSize*2,
                        hw+minwidth+offset+                  max(-minwidth*2, min(minwidth*2, valFR)),
                        TravelOffsetY + TOoffsety+hh   - minwidth/2 - fntSize*2 + max(-minwidth*2, min(minwidth*2, valFR)) )
                    appDrawLine3b(1-valRL/100,valRL/100,0.5,1,
                        hw-minwidth-offset  , TravelOffsetY + TOoffsety+hh*2 - minwidth/2 - fntSize*2,
                        hw-minwidth-offset-                  max(-minwidth*2, min(minwidth*2, valRL)),
                        TravelOffsetY + TOoffsety+hh*2 - minwidth/2 - fntSize*2 + max(-minwidth*2, min(minwidth*2, valRL)) )
                    appDrawLine3b(1-valRR/100,valRR/100,0.5,1,
                        hw+minwidth+offset  , TravelOffsetY + TOoffsety+hh*2 - minwidth/2 - fntSize*2,
                        hw+minwidth+offset+                  max(-minwidth*2, min(minwidth*2, valRR)),
                        TravelOffsetY + TOoffsety+hh*2 - minwidth/2 - fntSize*2 + max(-minwidth*2, min(minwidth*2, valRR)) )
                    appDrawLine3((valFL+valFR)/2/100,1-(valFL+valFR)/2/100,0.5,1,
                        hw-minwidth-offset-max(-minwidth*2, min(minwidth*2, valFL)) , TravelOffsetY + TOoffsety+hh   - minwidth/2 - fntSize*2 + max(-minwidth*2, min(minwidth*2, valFL)),
                        hw+minwidth+offset+max(-minwidth*2, min(minwidth*2, valFR)) , TravelOffsetY + TOoffsety+hh   - minwidth/2 - fntSize*2 + max(-minwidth*2, min(minwidth*2, valFR)), minwidth/10)
                    appDrawLine3((valRL+valRR)/100,1-(valRL+valRR)/2/100,0.5,1,
                        hw-minwidth-offset-max(-minwidth*2, min(minwidth*2, valRL))  , TravelOffsetY + TOoffsety+hh*2 - minwidth/2 - fntSize*2 + max(-minwidth*2, min(minwidth*2, valRL)),
                        hw+minwidth+offset+max(-minwidth*2, min(minwidth*2, valRR))  , TravelOffsetY + TOoffsety+hh*2 - minwidth/2 - fntSize*2 + max(-minwidth*2, min(minwidth*2, valRR)), minwidth/10)


        # BRAKE TORQUE
        if bShowNM_brake and bCSPactive:
            BRAKEtorqueFL = extGetBrakeTorque(0)
            BRAKEtorqueFR = extGetBrakeTorque(1)
            BRAKEtorqueRL = extGetBrakeTorque(2)
            BRAKEtorqueRR = extGetBrakeTorque(3)
            if maxBrakeTorque>0:
                if BRAKEtorqueFL>0:
                    dy = BRAKEtorqueFL/maxBrakeTorque
                    appDrawLine2(BRAKEtorqueFL/maxBrakeTorque, 1-BRAKEtorqueFL/maxBrakeTorque, 0.5-BRAKEtorqueFL/maxBrakeTorque/2, 1 , hw - offset/2-2,    hh/2-dy*hh/2, offset/2, dy*hh-fntSize*1.75)
                if BRAKEtorqueFR>0:
                    dy = BRAKEtorqueFR/maxBrakeTorque
                    appDrawLine2(BRAKEtorqueFR/maxBrakeTorque, 1-BRAKEtorqueFR/maxBrakeTorque, 0.5-BRAKEtorqueFR/maxBrakeTorque/2, 1 , hw +          2,    hh/2-dy*hh/2, offset/2, dy*hh-fntSize*1.75)
                if BRAKEtorqueRL>0:
                    dy = BRAKEtorqueRL/maxBrakeTorque
                    appDrawLine2(BRAKEtorqueRL/maxBrakeTorque, 1-BRAKEtorqueRL/maxBrakeTorque, 0.5-BRAKEtorqueRL/maxBrakeTorque/2, 1 , hw - offset/2-2, hh + hh/2-dy*hh/2 +fntSize*1.75, offset/2, dy*hh-fntSize*1.75)
                if BRAKEtorqueRR>0:
                    dy = BRAKEtorqueRR/maxBrakeTorque
                    appDrawLine2(BRAKEtorqueRR/maxBrakeTorque, 1-BRAKEtorqueRR/maxBrakeTorque, 0.5-BRAKEtorqueRR/maxBrakeTorque/2, 1 , hw +          2, hh + hh/2-dy*hh/2 +fntSize*1.75, offset/2, dy*hh-fntSize*1.75)




        if bCSPactive and bFancyMode and rtIndex1>-1 and not Berror:
            try:
                ### use csp graph - bitblit (blend) painted memory image to screen
                ac.glBegin(acsys.GL.Quads)
                ac.ext_glSetBlendMode(1)
                ac.glColor4f(1,1,1,gOpacityFG/100.0)
                ac.ext_glSetTexture(rtIndex1, 0)
                ac.ext_glVertexTex(     -marginX,     -marginY, 0, 0)
                ac.ext_glVertexTex(     -marginX, hh*2+marginY, 0, 1)
                ac.ext_glVertexTex(hw*2 +marginX, hh*2+marginY, 1, 1)
                ac.ext_glVertexTex(hw*2 +marginX,     -marginY, 1, 0)
                ac.glEnd()
            except:
                Berror=True
        elif bPressureGraph: ### and bCSPactive:
            appRenderPressure()




        # LOCKED tyres
        if (bShowLocked and currspeed>lockedThreshold):
            if abs(ac_wspeed["FL"])<25:
                appDrawLine0(1-ac_wspeed["FL"]/lockedThreshold,ac_wspeed["FL"]/lockedThreshold,0.5-lockedThreshold/2,1-ac_wspeed["FL"]/lockedThreshold, hw-offset-minwidth,  hh - fntSize*2, hw-offset                 , 0           , minwidth/4)
            if abs(ac_wspeed["FR"])<25:
                appDrawLine0(1-ac_wspeed["FR"]/lockedThreshold,ac_wspeed["FR"]/lockedThreshold,0.5-lockedThreshold/2,1-ac_wspeed["FR"]/lockedThreshold, hw+offset         ,               0, hw*2-(hw-minwidth-offset) , hh-fntSize*2, minwidth/4)
            if abs(ac_wspeed["RL"])<25:
                appDrawLine0(1-ac_wspeed["RL"]/lockedThreshold,ac_wspeed["RL"]/lockedThreshold,0.5-lockedThreshold/2,1-ac_wspeed["RL"]/lockedThreshold, hw-minwidth-offset,  hh  +fntSize*2.2, hw-offset                 , hh*2        , minwidth/4)
            if abs(ac_wspeed["RR"])<25:
                appDrawLine0(1-ac_wspeed["RR"]/lockedThreshold,ac_wspeed["RR"]/lockedThreshold,0.5-lockedThreshold/2,1-ac_wspeed["RR"]/lockedThreshold, hw+offset         ,  hh*2-fntSize    , hw*2-(hw-minwidth-offset) , hh+fntSize*2.9, minwidth/4)


        # tyre LOAD
        if bShowTyreload:
            if ac_load["FL"]>0 and ac_load["FR"]>0 and ac_load["RL"]>0 and ac_load["RR"]>0:
                appDrawDot(ac_load["FL"]/15000.0,1-ac_load["FL"]/15000,0,min(0.8,ac_load["FL"]/5000),hw-minwidth/2-offset,     hh/2, min(minwidth/3, ac_load["FL"]/30000.0) )
                appDrawDot(ac_load["FR"]/15000.0,1-ac_load["FR"]/15000,0,min(0.8,ac_load["FR"]/5000),hw+minwidth/2+offset,     hh/2, min(minwidth/3, ac_load["FR"]/30000.0) )
                appDrawDot(ac_load["RL"]/15000.0,1-ac_load["RL"]/15000,0,min(0.8,ac_load["RL"]/5000),hw-minwidth/2-offset,  hh+hh/2, min(minwidth/3, ac_load["RL"]/30000.0) )
                appDrawDot(ac_load["RR"]/15000.0,1-ac_load["RR"]/15000,0,min(0.8,ac_load["RR"]/5000),hw+minwidth/2+offset,  hh+hh/2, min(minwidth/3, ac_load["RR"]/30000.0) )


        # new SLIPANGLE vis with direction and circle
        if bShowCircles:
            # if False:
            if True:
                ### slipangle correctly
                aTop=1.0
                aBot=1.0
                if ac_SlipRatio['FL']<0:
                    aTop=0.25
                else:
                    aBot=0.25
                appDrawLineSlipAngle(    0.25, 0.25, max(1   , abs(xsinFL)),             aTop, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY - TOoffsety +     TOhh/2, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize - xsinFL*TOminwidth/2, TravelOffsetY - TOoffsety +    TOhh/2 - ycosFL * TOminwidth/2, 4)
                appDrawLineSlipAngle(                1.0                   , 0.25, 0.25, aBot, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY - TOoffsety +     TOhh/2, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize + xsinFL*TOminwidth/2, TravelOffsetY - TOoffsety +    TOhh/2 + ycosFL * TOminwidth/2, 4)
                aTop=1.0
                aBot=1.0
                if ac_SlipRatio['FR']<0:
                    aTop=0.25
                else:
                    aBot=0.25
                appDrawLineSlipAngle(    0.25, 0.25, max(1   , abs(xsinFR)),             aTop, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY - TOoffsety +     TOhh/2, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize - xsinFR*TOminwidth/2, TravelOffsetY - TOoffsety +    TOhh/2 - ycosFR * TOminwidth/2, 4)
                appDrawLineSlipAngle(                1.0                   , 0.25, 0.25, aBot, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY - TOoffsety +     TOhh/2, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize + xsinFR*TOminwidth/2, TravelOffsetY - TOoffsety +    TOhh/2 + ycosFR * TOminwidth/2, 4)
                aTop=1.0
                aBot=1.0
                if ac_SlipRatio['RL']<0:
                    aTop=0.25
                else:
                    aBot=0.25
                appDrawLineSlipAngle(    0.25, 0.25, max(1   , abs(xsinRL)),             aTop, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+TOhh/2, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize - xsinRL*TOminwidth/2, TravelOffsetY + TOoffsety + TOhh+TOhh/2 - ycosRL * TOminwidth/2, 4)
                appDrawLineSlipAngle(                1.0                   , 0.25, 0.25, aBot, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+TOhh/2, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize + xsinRL*TOminwidth/2, TravelOffsetY + TOoffsety + TOhh+TOhh/2 + ycosRL * TOminwidth/2, 4)
                aTop=1.0
                aBot=1.0
                if ac_SlipRatio['RR']<0:
                    aTop=0.25
                else:
                    aBot=0.25
                appDrawLineSlipAngle(    0.25, 0.25, max(1   , abs(xsinRR)),             aTop, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+TOhh/2, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize - xsinRR*TOminwidth/2, TravelOffsetY + TOoffsety + TOhh+TOhh/2 - ycosRR*TOminwidth/2, 4)
                appDrawLineSlipAngle(                1.0                   , 0.25, 0.25, aBot, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+TOhh/2, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize + xsinRR*TOminwidth/2, TravelOffsetY + TOoffsety + TOhh+TOhh/2 + ycosRR*TOminwidth/2, 4)

                bFullSlipAngle = True
                if abs(ac_SlipRatio["FL"])>slipratiolimit:
                    currMult = 200 #1/ac_SlipRatio['FL']/100 if ac_SlipRatio['FL']>slipratiolimit*2 else hh
                    if bFullSlipAngle:
                        angMult = TOminwidth   ###   hh # min(hh, 100.0*ac_SlipRatio["FL"])
                    else:
                        angMult=ac_SlipRatio["FL"]
                    if ac_SlipRatio["FL"]>0:
                        appDrawCircle(0.3, 0.3,      max(0.75, abs(ac_SlipRatio['FL']*currMult)),       1, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY - TOoffsety + TOhh/2, max(-TOhw/2,min(abs(xsinFL*ac_SlipRatio['FL']) * abs(slipCircleMult) * TOhw/2, TOhw/2)),            max(-TOhh/2,min(abs(ycosFL) * abs(slipCircleMult) * TOhh/2, TOhh/2))     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircleNoMin(0.75, 0.75, max(1.0, abs(ac_SlipRatio['FL']*currMult)),        1, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY - TOoffsety + TOhh/2, max(-TOhh/2,min(slipCircleMult*ac_SlipRatio['FL']/frict_limit_angF   * TOhw/2, TOhw/2)),            max(-TOhh/2,min(slipCircleMult*ac_SlipRatio['FL']/frict_limit_angF * TOhh/2, TOhh/2))     )
                    else:
                        appDrawCircle(               max(0.75, abs(ac_SlipRatio['FL']*currMult)), 0, 0, 1, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY - TOoffsety + TOhh/2, max(-TOhw/2,min(abs(xsinFL*ac_SlipRatio['FL']) * abs(slipCircleMult) * TOhw/2, TOhw/2)),            max(-TOhh/2,min(abs(ycosFL) * abs(slipCircleMult) * TOhh/2, TOhh/2))     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircleNoMin(          max(1.0, abs(ac_SlipRatio['FL']*currMult)),0.75,0.75,1, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY - TOoffsety + TOhh/2, max(-TOhw/2,min(slipCircleMult*ac_SlipRatio['FL']/frict_limit_angF   * TOhw/2, TOhw/2)),            max(-TOhh/2,min(slipCircleMult*ac_SlipRatio['FL']/frict_limit_angF * TOhh/2, TOhh/2))     )
                if abs(ac_SlipRatio["FR"])>slipratiolimit:
                    currMult = 200 #1/ac_SlipRatio['FR']/100 if ac_SlipRatio['FR']>slipratiolimit*2 else hh
                    if bFullSlipAngle:
                        angMult = TOminwidth   ###   hh # min(hh, 100.0*ac_SlipRatio["FR"])
                    else:
                        angMult=ac_SlipRatio["FR"]
                    if ac_SlipRatio["FR"]>0:
                        appDrawCircle(0.3, 0.3,      max(0.75, abs(ac_SlipRatio['FR']*currMult)),       1, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY - TOoffsety + TOhh/2, max(-TOhw/2,min(abs(xsinFR*ac_SlipRatio['FR']) * abs(slipCircleMult) * TOhw/2, TOhw/2)),            max(-TOhh/2,min(abs(ycosFR) * abs(slipCircleMult) * TOhh/2, TOhh/2))     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircleNoMin(0.75, 0.75, max(1.0, abs(ac_SlipRatio['FR']*currMult)),        1, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY - TOoffsety + TOhh/2, max(-TOhw/2,min(slipCircleMult*ac_SlipRatio['FR']/frict_limit_angF   * TOhw/2, TOhw/2)),            max(-TOhh/2,min(slipCircleMult*ac_SlipRatio['FR']/frict_limit_angF * TOhh/2, TOhh/2))     )
                    else:
                        appDrawCircle(               max(0.75, abs(ac_SlipRatio['FR']*currMult)), 0, 0, 1, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY - TOoffsety + TOhh/2, max(-TOhw/2,min(abs(xsinFR*ac_SlipRatio['FR']) * abs(slipCircleMult) * TOhw/2, TOhw/2)),            max(-TOhh/2,min(abs(ycosFR) * abs(slipCircleMult) * TOhh/2, TOhh/2))     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircleNoMin(          max(1.0, abs(ac_SlipRatio['FR']*currMult)),0.75,0.75,1, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY - TOoffsety + TOhh/2, max(-TOhw/2,min(slipCircleMult*ac_SlipRatio['FR']/frict_limit_angF   * TOhw/2, TOhw/2)),            max(-TOhh/2,min(slipCircleMult*ac_SlipRatio['FR']/frict_limit_angF * TOhh/2, TOhh/2))     )
                if abs(ac_SlipRatio["RL"])>slipratiolimit:
                    currMult = 200 #1/ac_SlipRatio['RL']/100 if ac_SlipRatio['RL']>slipratiolimit*2 else hh
                    if bFullSlipAngle:
                        angMult = TOminwidth   ###   hh # min(hh, 100.0*ac_SlipRatio["RL"])
                    else:
                        angMult=ac_SlipRatio["RL"]
                    if ac_SlipRatio["RL"]>0:
                        appDrawCircle(0.3, 0.3,      max(0.75, abs(ac_SlipRatio['RL']*currMult)),           1, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+hh/2, max(-TOhh/2,min(abs(xsinRL*ac_SlipRatio['RL']) * abs(slipCircleMult) * TOhw/2, TOhw/2)),            max(-TOhh/2,min(abs(ycosRL) * abs(slipCircleMult) * TOhh/2, TOhh/2))     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircleNoMin(0.75, 0.75, max(1.0, abs(ac_SlipRatio['RL']*currMult)),            1, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+hh/2, max(-TOhh/2,min(slipCircleMult*ac_SlipRatio['RL']/frict_limit_angR   * TOhw/2, TOhw/2)),            max(-TOhh/2,min(slipCircleMult*ac_SlipRatio['RL']/frict_limit_angR * TOhh/2, TOhh/2))     )
                    else:
                        appDrawCircle(               max(0.75, abs(ac_SlipRatio['RL']*currMult)), 0, 0,     1, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+hh/2, max(-TOhh/2,min(abs(xsinRL*ac_SlipRatio['RL']) * abs(slipCircleMult) * TOhw/2, TOhw/2)),            max(-TOhh/2,min(abs(ycosRL) * abs(slipCircleMult) * TOhh/2, TOhh/2))     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircleNoMin(          max(1.0, abs(ac_SlipRatio['RL']*currMult)),   0.75, 0.75,1, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+hh/2, max(-TOhh/2,min(slipCircleMult*ac_SlipRatio['RL']/frict_limit_angR   * TOhw/2, TOhw/2)),            max(-TOhh/2,min(slipCircleMult*ac_SlipRatio['RL']/frict_limit_angR * TOhh/2, TOhh/2))     )
                if abs(ac_SlipRatio["RR"])>slipratiolimit:
                    currMult = 200 #1/ac_SlipRatio['RR']/100 if ac_SlipRatio['RR']>slipratiolimit*2 else hh
                    if bFullSlipAngle:
                        angMult = TOminwidth   ###   hh # min(hh, 100.0*ac_SlipRatio["RR"])
                    else:
                        angMult=ac_SlipRatio["RR"]
                    if ac_SlipRatio["RR"]>0:
                        appDrawCircle(0.3, 0.3,      max(0.75, abs(ac_SlipRatio['RR']*currMult)),         1, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+hh/2, max(-TOhw/2,min(abs(xsinRR*ac_SlipRatio['RR']) * abs(slipCircleMult) * TOhw/2, TOhw/2)),            max(-TOhh/2,min(abs(ycosRR) * abs(slipCircleMult) * TOhh/2, TOhh/2))     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircleNoMin(0.75, 0.75, max(1.0, abs(ac_SlipRatio['RR']*currMult)),          1, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+hh/2, max(-TOhw/2,min(slipCircleMult*ac_SlipRatio['RR']/frict_limit_angR   * TOhw/2, TOhw/2)),            max(-TOhh/2,min(slipCircleMult*ac_SlipRatio['RR']/frict_limit_angR * TOhh/2, TOhh/2))     )
                    else:
                        appDrawCircle(               max(0.75, abs(ac_SlipRatio['RR']*currMult)),   0, 0, 1, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+hh/2, max(-TOhw/2,min(abs(xsinRR*ac_SlipRatio['RR']) * abs(slipCircleMult) * TOhw/2, TOhw/2)),            max(-TOhh/2,min(abs(ycosRR) * abs(slipCircleMult) * TOhh/2, TOhh/2))     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircleNoMin(          max(1.0, abs(ac_SlipRatio['RR']*currMult)),0.75, 0.75, 1, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+hh/2, max(-TOhw/2,min(slipCircleMult*ac_SlipRatio['RR']/frict_limit_angR   * TOhw/2, TOhw/2)),            max(-TOhh/2,min(slipCircleMult*ac_SlipRatio['RR']/frict_limit_angR * TOhh/2, TOhh/2))     )
            else:
                ### slipangle more visible
                if abs(ac_SlipRatio["FL"]) > slipratiolimit:
                    if ac_SlipRatio["FL"]>0:
                        #appDrawLine1( 0.3, 0.3, abs(ac_SlipRatio['FL']*5) ,         1, hw-minwidth/2-offset,     hh/2, hw-minwidth/2-offset + max(-hw/2,min(    xsinFL  *     ac_SlipRatio['FL']  * hw, hw/2)),     hh/2 + max(-hh/2,min(    ycosFL  *     ac_SlipRatio['FL']  * hh, hh/2)), 3)
                        appDrawCircle(0.3, 0.3, abs(ac_SlipRatio['FL']*5) ,       0.8, hw-minwidth/2-offset,     hh/2,                                  min(abs(xsinFL) * abs(ac_SlipRatio['FL']) * hw, hw/2) ,                      min(abs(ycosFL) * abs(ac_SlipRatio['FL']) * hh, hh/2)     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircle(0.5, 0.5, abs(ac_SlipRatio['FL']*5), 1, hw-minwidth/2-offset,     hh/2, min(ac_SlipRatio['FL']/frict_limit_angF * hw, hw/2) , min(ac_SlipRatio['FL']/frict_limit_angF * hh, hh/2)     )
                    else:
                        #appDrawLine1(           abs(ac_SlipRatio['FL']*5) , 0, 0,   1, hw-minwidth/2-offset,     hh/2, hw-minwidth/2-offset + max(-hw/2,min(    xsinFL  *     ac_SlipRatio['FL']  * hw, hw/2)),     hh/2 + max(-hh/2,min(    ycosFL  *     ac_SlipRatio['FL']  * hh, hh/2)), 3)
                        appDrawCircle(          abs(ac_SlipRatio['FL']*5) , 0, 0, 0.8, hw-minwidth/2-offset,     hh/2,                                  min(abs(xsinFL) * abs(ac_SlipRatio['FL']) * hw, hw/2) ,                      min(abs(ycosFL) * abs(ac_SlipRatio['FL']) * hh, hh/2)     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircle(          abs(ac_SlipRatio['FL']*5), 0.5, 0.5, 1, hw-minwidth/2-offset,     hh/2, min(ac_SlipRatio['FL']/frict_limit_angF * hw, hw/2) , min(ac_SlipRatio['FL']/frict_limit_angF * hh, hh/2)     )

                if abs(ac_SlipRatio["FR"]) > slipratiolimit:
                    if ac_SlipRatio["FR"]>0:
                        #appDrawLine1( 0.3, 0.3, abs(ac_SlipRatio['FR']*5) ,         1, hw+minwidth/2+offset,     hh/2, hw+minwidth/2+offset + max(-hw/2,min(    xsinFR  *     ac_SlipRatio['FR']  * hw, hw/2)),     hh/2 + max(-hh/2,min(    ycosFR  *     ac_SlipRatio['FR']  * hh, hh/2)), 3)
                        appDrawCircle(0.3, 0.3, abs(ac_SlipRatio['FR']*5) ,       0.8, hw+minwidth/2+offset,     hh/2,                                  min(abs(xsinFR) * abs(ac_SlipRatio['FR']) * hw, hw/2) ,                      min(abs(ycosFR) * abs(ac_SlipRatio['FR']) * hh, hh/2)     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircle(0.5, 0.5, abs(ac_SlipRatio['FR']*5) , 1, hw+minwidth/2+offset,     hh/2, min(ac_SlipRatio['FR']/frict_limit_angF * hw, hw/2) , min(ac_SlipRatio['FR']/frict_limit_angF * hh, hh/2)     )
                    else:
                        #appDrawLine1(           abs(ac_SlipRatio['FR']*5) , 0, 0,   1, hw+minwidth/2+offset,     hh/2, hw+minwidth/2+offset + max(-hw/2,min(    xsinFR  *     ac_SlipRatio['FR']  * hw, hw/2)),     hh/2 + max(-hh/2,min(    ycosFR  *     ac_SlipRatio['FR']  * hh, hh/2)), 3)
                        appDrawCircle(          abs(ac_SlipRatio['FR']*5) , 0, 0, 0.8, hw+minwidth/2+offset,     hh/2,                                  min(abs(xsinFR) * abs(ac_SlipRatio['FR']) * hw, hw/2) ,                      min(abs(ycosFR) * abs(ac_SlipRatio['FR']) * hh, hh/2)     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircle(abs(ac_SlipRatio['FR']*5) , 0.5, 0.5, 1, hw+minwidth/2+offset,     hh/2, min(ac_SlipRatio['FR']/frict_limit_angF * hw, hw/2) , min(ac_SlipRatio['FR']/frict_limit_angF * hh, hh/2)     )

                if abs(ac_SlipRatio["RL"]) > slipratiolimit:
                    if ac_SlipRatio["RL"]>0:
                        #appDrawLine1( 0.3, 0.3, abs(ac_SlipRatio['RL']*5) ,         1, hw-minwidth/2-offset,  hh+hh/2, hw-minwidth/2-offset + max(-hw/2,min(    xsinRL  *     ac_SlipRatio['RL']  * hw, hw/2)),  hh+hh/2 + max(-hh/2,min(    ycosRL  *     ac_SlipRatio['RL']  * hh, hh/2)), 3)
                        appDrawCircle(0.3, 0.3, abs(ac_SlipRatio['RL']*5) ,       0.8, hw-minwidth/2-offset,  hh+hh/2,                                  min(abs(xsinRL) * abs(ac_SlipRatio['RL']) * hw, hw/2) ,                      min(abs(ycosRL) * abs(ac_SlipRatio['RL']) * hh, hh/2)     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircle(0.5, 0.5, abs(ac_SlipRatio['RL']*5) , 1, hw-minwidth/2-offset,  hh+hh/2, min(ac_SlipRatio['RL']/frict_limit_angR * hw, hw/2) , min(ac_SlipRatio['RL']/frict_limit_angR * hh, hh/2)     )
                    else:
                        #appDrawLine1(           abs(ac_SlipRatio['RL']*5) , 0, 0,   1, hw-minwidth/2-offset,  hh+hh/2, hw-minwidth/2-offset +-max(-hw/2,min(    xsinRL  *     ac_SlipRatio['RL']  * hw, hw/2)),  hh+hh/2 + max(-hh/2,min(    ycosRL  *     ac_SlipRatio['RL']  * hh, hh/2)), 3)
                        appDrawCircle(          abs(ac_SlipRatio['RL']*5) , 0, 0, 0.8, hw-minwidth/2-offset,  hh+hh/2,                                  min(abs(xsinRL) * abs(ac_SlipRatio['RL']) * hw, hw/2) ,                      min(abs(ycosRL) * abs(ac_SlipRatio['RL']) * hh, hh/2)     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircle(abs(ac_SlipRatio['RL']*5) , 0.5, 0.5, 1, hw-minwidth/2-offset,  hh+hh/2, min(ac_SlipRatio['RL']/frict_limit_angR * hw, hw/2) , min(ac_SlipRatio['RL']/frict_limit_angR * hh, hh/2)     )

                if abs(ac_SlipRatio["RR"]) > slipratiolimit:
                    if ac_SlipRatio["RR"]>0:
                        #appDrawLine1( 0.3, 0.3, abs(ac_SlipRatio['RR']*5)       ,   1, hw+minwidth/2+offset,  hh+hh/2, hw+minwidth/2+offset + max(-hw/2,min(    xsinRR  *     ac_SlipRatio['RR']  * hw, hw/2)),  hh+hh/2 + max(-hh/2,min(    ycosRR  *     ac_SlipRatio['RR']  * hh, hh/2)), 3)
                        appDrawCircle(0.3, 0.3, abs(ac_SlipRatio['RR']*5)       , 0.8, hw+minwidth/2+offset,  hh+hh/2,                                  min(abs(xsinRR) * abs(ac_SlipRatio['RR']) * hw, hw/2) ,                      min(abs(ycosRR) * abs(ac_SlipRatio['RR']) * hh, hh/2)     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircle(0.5, 0.5, abs(ac_SlipRatio['RR']*5), 1, hw+minwidth/2+offset,  hh+hh/2, min(ac_SlipRatio['RR']/frict_limit_angR * hw, hw/2) , min(ac_SlipRatio['RR']/frict_limit_angR * hh, hh/2)     )
                    else:
                        #appDrawLine1(           abs(ac_SlipRatio['RR']*5) , 0, 0,   1, hw+minwidth/2+offset,  hh+hh/2, hw+minwidth/2+offset + max(-hw/2,min(    xsinRR  *     ac_SlipRatio['RR']  * hw, hw/2)),  hh+hh/2 + max(-hh/2,min(    ycosRR  *     ac_SlipRatio['RR']  * hh, hh/2)), 3)
                        appDrawCircle(          abs(ac_SlipRatio['RR']*5) , 0, 0, 0.8, hw+minwidth/2+offset,  hh+hh/2,                                  min(abs(xsinRR) * abs(ac_SlipRatio['RR']) * hw, hw/2) ,                      min(abs(ycosRR) * abs(ac_SlipRatio['RR']) * hh, hh/2)     )
                        # FRICTION_LIMIT_ANGLE
                        appDrawCircle(abs(ac_SlipRatio['RR']*5), 0.5, 0.5, 1, hw+minwidth/2+offset,  hh+hh/2, min(ac_SlipRatio['RR']/frict_limit_angR * hw, hw/2) , min(ac_SlipRatio['RR']/frict_limit_angR * hh, hh/2)     )



        # Mz self aligning torque
        if bMz:
            if ac_Mz["FL"]>0:
                appDrawLineTriHori (0.7,0.5,0.25,0.7, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY - TOoffsety +      TOhh/2, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize + ac_Mz["FL"]/10, 8)
            if ac_Mz["FR"]>0:
                appDrawLineTriHori (0.7,0.5,0.25,0.7, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY - TOoffsety +      TOhh/2, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset/2 + ac_Mz["FR"]/10, 8)
            if ac_Mz["RL"]>0:
                appDrawLineTriHori (0.7,0.5,0.25,0.7, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+TOhh/2, TravelOffsetX - TOoffsetx + TOhw-TOminwidth/2-TOoffset*TOAppSize + ac_Mz["RL"]/10, 8)
            if ac_Mz["RR"]>0:
                appDrawLineTriHori (0.7,0.5,0.25,0.7, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset*TOAppSize, TravelOffsetY + TOoffsety + TOhh+TOhh/2, TravelOffsetX + TOoffsetx + TOhw+TOminwidth/2+TOoffset/2 + ac_Mz["RR"]/10, 8)


        # TC and ABS
        if bCSPactive and bShowABS:
            lvl_abs = ac.ext_getStateAbs(currcar)
            lvl_tc  = ac.ext_getStateTc(currcar)
            # s_abs = 'siminfo.physics.abs: ' + str(round(tyinfo.physics.abs,4)) + "\next_getStateAbs():" + str(round(ac.ext_getStateAbs(currcar),4))
            # s_tc  = 'siminfo.physics.tc: '  + str(round(tyinfo.physics.tc,4))  + "\next_getStateTc(): " + str(round(ac.ext_getStateTc(currcar),4))
            # appDrawTextCol(1,1,1,gOpacityFG/100, s_abs, hw-minwidth*1.80-offset*2   , hh*2+fntSize*3.25, fntSize*1.5, ExtGL.FONT_ALIGN_RIGHT)
            # appDrawTextCol(1,1,1,gOpacityFG/100, s_tc, hw+minwidth*1.60+offset*2   , hh*2+fntSize*3.25, fntSize*1.5, ExtGL.FONT_ALIGN_RIGHT)

            # s_abs = str(int(ac.ext_getStateAbs(currcar)))
            # s_tc  = str(int(ac.ext_getStateTc(currcar)))
            appDrawTextColFont1(colR_EE,colG_EE,colB_EE,gOpacityFG/100                          , str(lvl_abs), hw-minwidth*1.6          , hh*2-fntSize*0.2, fntSize*1.25)
            appDrawTextColFont1(colR_EE,colG_EE,colB_EE,gOpacityFG/100                          , str(lvl_tc ), hw+minwidth*1.6          , hh*2-fntSize*0.2, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
            appDrawTextColFont1(colR_EE,colG_EE,colB_EE,gOpacityFG/100                          , 'ABS'       , hw-minwidth*1.60-offset*2, hh*2-fntSize*1.50, fntSize*2  , ExtGL.FONT_ALIGN_CENTER)
            appDrawTextColFont1(colR_EE,colG_EE,colB_EE,gOpacityFG/100                          , 'TC'        , hw+minwidth*1.45+offset*2, hh*2-fntSize*1.50, fntSize*2  , ExtGL.FONT_ALIGN_CENTER)
            if lvl_abs>0:
                if ac.ext_getStateAbsActive(currcar):
                    appDrawTextWithShadowsColorABSTC(colR_abs,colG_abs,colB_abs, gOpacityFG/100 , 'ABS'       , hw-minwidth*1.50-offset*2-1 , hh*2-fntSize*1.50+2, fntSize*2.1, ExtGL.FONT_ALIGN_CENTER)
            if lvl_tc>0:
                if ac.ext_getStateTcActive(currcar):
                    appDrawTextWithShadowsColorABSTC(colR_tc,colG_tc,colB_tc, gOpacityFG/100    , 'TC'        , hw+minwidth*1.50+offset*2-1 , hh*2-fntSize*1.50+2, fntSize*2.1, ExtGL.FONT_ALIGN_CENTER)


        ### direction star, more of a playfull thing
        if bShowDirections:
            angle_front = (ac_angle["FL"] + ac_angle["FR"]) / 2.0
            angle_rear  = (ac_angle["RL"] + ac_angle["RR"]) / 2.0
            appDrawLineWAngle (1,0.3,0.3,1.0, TravelOffsetX + TOhw, TravelOffsetY + TOhh/2, -angle_steerwheel/5.5, TOhh/2+40)
            appDrawLineWAngle (0.3,0.3,1,0.9, TravelOffsetX + TOhw, TravelOffsetY + TOhh/2, angle_front      , TOhh/2+20)
            appDrawLineWAngle (0.3,1,0.3,0.8, TravelOffsetX + TOhw, TravelOffsetY + TOhh/2, angle_rear       , TOhh/2)

            # cgheight + cars localvelocity
            if newtyrewear:
                cgHeight = ac.ext_getCGHeight(currcar)
            else:
                cgHeight = tyinfo.physics.cgHeight
            if basecgHeight == -1:
                basecgHeight = cgHeight

        if bShowRadiuses:
            # base tyre radius white lines
            cent = 0.25*TOAppSize
            appDrawLine2(1.0, 1.0, 1.0, 0.25, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.5, TravelOffsetY - TOoffsety + TOhh   ,   TOhw*cent*2.0,   2*TOAppSize )
            appDrawLine2(1.0, 1.0, 1.0, 0.25, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*0.5, TravelOffsetY - TOoffsety + TOhh   ,   TOhw*cent*2.0,   2*TOAppSize )
            appDrawLine2(1.0, 1.0, 1.0, 0.25, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.5, TravelOffsetY + TOoffsety + TOhh*2 ,   TOhw*cent*2.0,   2*TOAppSize )
            appDrawLine2(1.0, 1.0, 1.0, 0.25, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*0.5, TravelOffsetY + TOoffsety + TOhh*2 ,   TOhw*cent*2.0,   2*TOAppSize )

            xv = ( ac_radius["FL"] - ac_bradius["FL"] ) * 500*TOAppSize
            if xv>0:
                ###leftup
                appDrawLineTri0(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.5, TravelOffsetY+TOhh - TOoffsety+xv-5-xv/2, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.0, TravelOffsetY+TOhh - TOoffsety +        xv+2, 2 *TOAppSize)
                # center
                appDrawLine2(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.0, TravelOffsetY+TOhh - TOoffsety+xv       ,                                                 TOhw*cent*1.0,                                  2 *TOAppSize)
                ###rightup
                appDrawLineTri0(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*0.5, TravelOffsetY+TOhh - TOoffsety+xv-5-xv/2, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*1.0, TravelOffsetY+TOhh - TOoffsety +        xv+2, 2 *TOAppSize)
            else:
                ##leftup
                appDrawLineTri0(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.5, TravelOffsetY+TOhh - TOoffsety+xv-5-xv/2, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.0, TravelOffsetY+TOhh - TOoffsety +        xv+2, 2 *TOAppSize)
                # center
                appDrawLine2(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.0, TravelOffsetY+TOhh - TOoffsety+xv       ,                                                  TOhw*cent*1.0,                                 2 *TOAppSize)
                ##rightup
                appDrawLineTri0(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*0.5, TravelOffsetY+TOhh - TOoffsety+xv-5-xv/2, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*1.0, TravelOffsetY+TOhh - TOoffsety +        xv+2, 2 *TOAppSize)

            xv = ( ac_radius["FR"] - ac_bradius["FR"] ) * 500*TOAppSize
            if xv>0:
                ##leftup
                appDrawLineTri0(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*2.5, TravelOffsetY+TOhh - TOoffsety+xv-5-xv/2,   TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*2.0, TravelOffsetY+TOhh - TOoffsety+        xv+2, 2 *TOAppSize)
                # center
                appDrawLine2(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*1.0, TravelOffsetY+TOhh - TOoffsety+xv       ,                                                  TOhw*cent*1.0,                                  2 *TOAppSize)
                ##rightup
                appDrawLineTri0(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*0.5, TravelOffsetY+TOhh - TOoffsety+xv-5-xv/2,   TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*1.0, TravelOffsetY+TOhh - TOoffsety+        xv+2, 2 *TOAppSize)
            else:
                ##leftup
                appDrawLineTri0(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*2.5, TravelOffsetY+TOhh - TOoffsety+xv-5-xv/2,   TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*2.0, TravelOffsetY+TOhh - TOoffsety+        xv+2, 2 *TOAppSize)
                # center
                appDrawLine2(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*1.0, TravelOffsetY+TOhh - TOoffsety+xv       ,                                                  TOhw*cent*1.0,                                  2 *TOAppSize)
                ##rightup
                appDrawLineTri0(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*0.5, TravelOffsetY+TOhh - TOoffsety+xv-5-xv/2,   TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*1.0, TravelOffsetY+TOhh - TOoffsety+        xv+2, 2 *TOAppSize)

            xv = ( ac_radius["RL"] - ac_bradius["RL"] ) * 500*TOAppSize
            if xv>0:
                ##leftup
                appDrawLineTri0(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.5, TravelOffsetY+TOoffsety + TOhh*2+xv-5-xv/2, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.0, TravelOffsetY+TOoffsety + TOhh*2 + xv+2, 2 *TOAppSize)
                # center
                appDrawLine2(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.0, TravelOffsetY+TOoffsety + TOhh*2+xv       ,                                          TOhw*cent*1.0,                                    2 *TOAppSize)
                ##rightup
                appDrawLineTri0(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*0.5, TravelOffsetY+TOoffsety + TOhh*2+xv-5-xv/2, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*1.0, TravelOffsetY+TOoffsety + TOhh*2 + xv+2, 2 *TOAppSize)
            else:
                ##leftup
                appDrawLineTri0(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.5, TravelOffsetY+TOoffsety + TOhh*2+xv-5-xv/2, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.0, TravelOffsetY+TOoffsety + TOhh*2 + xv+2, 2 *TOAppSize)
                # center
                appDrawLine2(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*2.0, TravelOffsetY+TOoffsety + TOhh*2+xv       ,                                          TOhw*cent*1.0,                                    2 *TOAppSize)
                ##rightup
                appDrawLineTri0(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*0.5, TravelOffsetY+TOoffsety + TOhh*2+xv-5-xv/2, TravelOffsetX + TOhw - TOoffsetx - TOhw*cent*1.0, TravelOffsetY+TOoffsety + TOhh*2 + xv+2, 2 *TOAppSize)

            xv = ( ac_radius["RR"] - ac_bradius["RR"] ) * 500*TOAppSize
            if xv>0:
                ##leftup
                appDrawLineTri0(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*2.5, TravelOffsetY+TOoffsety + TOhh*2+xv-5-xv/2, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*2.0, TravelOffsetY+TOoffsety + TOhh*2 + xv+2, 2 *TOAppSize)
                # center
                appDrawLine2(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*1.0, TravelOffsetY+TOoffsety + TOhh*2+xv       ,                                          TOhw*cent*1.0,                                    2 *TOAppSize)
                ##rightup
                appDrawLineTri0(0.2, 1.0, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*0.5, TravelOffsetY+TOoffsety + TOhh*2+xv-5-xv/2, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*1.0, TravelOffsetY+TOoffsety + TOhh*2 + xv+2, 2 *TOAppSize)
            else:
                ##leftup
                appDrawLineTri0(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*2.5, TravelOffsetY+TOoffsety + TOhh*2+xv-5-xv/2, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*2.0, TravelOffsetY+TOoffsety + TOhh*2 + xv+2, 2 *TOAppSize)
                # center
                appDrawLine2(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*1.0, TravelOffsetY+TOoffsety + TOhh*2+xv       ,                                          TOhw*cent*1.0,                                    2 *TOAppSize)
                ##rightup
                appDrawLineTri0(1.0, 0.2, 0.2, 0.9, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*0.5, TravelOffsetY+TOoffsety + TOhh*2+xv-5-xv/2, TravelOffsetX + TOhw + TOoffsetx + TOhw*cent*1.0, TravelOffsetY+TOoffsety + TOhh*2 + xv+2, 2 *TOAppSize)

        if bShowMore:
            # Dy
            appDrawLine2( 1-(ac_dy["FL"]/4), 1-ac_dy["FL"]/6, ac_dy["FL"]/5, ac_dy["FL"] , TravelOffsetX + TOhw - TOoffsetx - TOhw*0.5, TravelOffsetY        - TOoffsety + TOhh*0.85 - min(TOminheight  , TOAppSize * ac_dy["FL"]*TOhh/10),   TOhw*0.1,   min(TOminheight  , ac_dy["FL"]*TOhh/8) )
            appDrawLine2( 1-(ac_dy["FR"]/4), 1-ac_dy["FR"]/6, ac_dy["FR"]/5, ac_dy["FR"] , TravelOffsetX + TOhw + TOoffsetx + TOhw*0.4, TravelOffsetY        - TOoffsety + TOhh*0.85 - min(TOminheight  , TOAppSize * ac_dy["FR"]*TOhh/10),   TOhw*0.1,   min(TOminheight  , ac_dy["FR"]*TOhh/8) )
            appDrawLine2( 1-(ac_dy["RL"]/4), 1-ac_dy["RL"]/6, ac_dy["RL"]/5, ac_dy["RL"] , TravelOffsetX + TOhw - TOoffsetx - TOhw*0.5, TravelOffsetY + TOhh + TOoffsety + TOhh*0.85 - min(TOminheight  , TOAppSize * ac_dy["RL"]*TOhh/10),   TOhw*0.1,   min(TOminheight  , ac_dy["RL"]*TOhh/8) )
            appDrawLine2( 1-(ac_dy["RR"]/4), 1-ac_dy["RR"]/6, ac_dy["RR"]/5, ac_dy["RR"] , TravelOffsetX + TOhw + TOoffsetx + TOhw*0.4, TravelOffsetY + TOhh + TOoffsety + TOhh*0.85 - min(TOminheight  , TOAppSize * ac_dy["RR"]*TOhh/10),   TOhw*0.1,   min(TOminheight  , ac_dy["RR"]*TOhh/8) )
            if bShowVals and bCSPactive and not bShowLess:
                ac.ext_glFontColor(f1.f, 1, 1, 0.5, 1)
                ac.ext_glFontUse(f1.f, "Dy\n"+str(round(ac_dy["FL"], 2)), TravelOffsetX + TOhw - TOoffsetx - TOhw*0.4, TravelOffsetY - TOoffsety + TOhh*0.2 - TOfntSize*0.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                ac.ext_glFontUse(f1.f, "Dy\n"+str(round(ac_dy["FR"], 2)), TravelOffsetX + TOhw + TOoffsetx + TOhw*0.4, TravelOffsetY - TOoffsety + TOhh*0.2 - TOfntSize*0.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                ac.ext_glFontUse(f1.f,        str(round(ac_dy["RL"], 2)), TravelOffsetX + TOhw - TOoffsetx - TOhw*0.4, TravelOffsetY + TOoffsety + TOhh*1.4 - TOfntSize*0.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                ac.ext_glFontUse(f1.f,        str(round(ac_dy["RR"], 2)), TravelOffsetX + TOhw + TOoffsetx + TOhw*0.4, TravelOffsetY + TOoffsety + TOhh*1.4 - TOfntSize*0.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_CENTER)

            ### rideheight
            ## rideheight max
            appDrawLine2 (1.0, 0.8, 0.6, 0.8, TravelOffsetX + TOhw - TOhw/2, TravelOffsetY - TOoffsety + TOhh  -rhMax[0]*TOhw+1, TOhw, max(1,TOAppSize) )
            appDrawLine2 (1.0, 0.8, 0.6, 0.8, TravelOffsetX + TOhw - TOhw/2, TravelOffsetY + TOoffsety + TOhh*2-rhMax[1]*TOhw+1, TOhw, max(1,TOAppSize) )
            ## rideheight min
            appDrawLine2 (1.0, 0.8, 0.6, 0.8, TravelOffsetX                , TravelOffsetY - TOoffsety + TOhh                +1, TOhw*2, max(1,TOAppSize) )
            appDrawLine2 (1.0, 0.8, 0.6, 0.8, TravelOffsetX                , TravelOffsetY + TOoffsety + TOhh*2              +1, TOhw*2, max(1,TOAppSize) )

            ## rideheight curr
            if rh[0]>0.01:
                appDrawLine2 (1.0, 0.8, 0.6,                 0.8, TravelOffsetX + TOhw-TOminwidth/4, TravelOffsetY  -TOoffsety + TOhh  -rh[0]*TOhw, TOminwidth/2, 3*TOAppSize )
            else:
                appDrawLine2 (1        ,       1,         1, 0.8, TravelOffsetX + TOhw-TOminwidth/4, TravelOffsetY  -TOoffsety + TOhh  -rh[0]*TOhw, TOminwidth/2, 3*TOAppSize )
            if rh[1]>0.01:
                appDrawLine2 (1.0, 0.8, 0.6                , 0.8, TravelOffsetX + TOhw-TOminwidth/4, TravelOffsetY  +TOoffsety + TOhh*2-rh[1]*TOhw, TOminwidth/2, 3*TOAppSize )
            else:
                appDrawLine2 (1        ,       1,         1, 0.8, TravelOffsetX + TOhw-TOminwidth/4, TravelOffsetY  +TOoffsety + TOhh*2-rh[1]*TOhw, TOminwidth/2, 3*TOAppSize )


            ## rideheight text values
            if bShowVals and bCSPactive and not bShowLess:
                ac.ext_glFontColor(f1.f, 1.0, 0.8, 0.6, 1)
                # max
                ac.ext_glFontUse(f1.f,                    str(int(rhMax[0]*1000))                                         , TravelOffsetX  + TOhw                 , TravelOffsetY - TOoffsety + TOhh   -rhMax[0]*TOhw-TOfntSize*1.5 , TOfntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                ac.ext_glFontUse(f1.f,                    str(int(rhMax[1]*1000))                                         , TravelOffsetX  + TOhw                 , TravelOffsetY + TOoffsety + TOhh*2 -rhMax[1]*TOhw-TOfntSize*1.5 , TOfntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                # curr and min
                ac.ext_glFontUse(f1.f, 'rideheight    ' + str(int(rh[0]*1000)) + '    min: ' + str(round(rhMin[0]*1000,1)), TravelOffsetX  + TOhw-TOfntSize*0.625 , TravelOffsetY - TOoffsety + TOhh   , TOfntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                ac.ext_glFontUse(f1.f, 'rideheight    ' + str(int(rh[1]*1000)) + '    min: ' + str(round(rhMin[1]*1000,1)), TravelOffsetX  + TOhw-TOfntSize*0.625 , TravelOffsetY + TOoffsety + TOhh*2 , TOfntSize*0.8, ExtGL.FONT_ALIGN_CENTER)

        if bShowTravel:
            ### dark blue
            # min/max suspension travel markers
            appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw*0.7+TOoffsetx , TravelOffsetY-TOoffsety + TOhh   - (minSuspTravFRONT)*TOAppSize*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
            appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw*0.7+TOoffsetx , TravelOffsetY-TOoffsety + TOhh   - (maxSuspTravFRONT)*TOAppSize*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
            appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw*0.7+TOoffsetx , TravelOffsetY+TOoffsety + TOhh*2 - (minSuspTravREAR )*TOAppSize*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
            appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw*0.7+TOoffsetx , TravelOffsetY+TOoffsety + TOhh*2 - (maxSuspTravREAR )*TOAppSize*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
            if TOoffsetx!=0 or TOoffsety!=0:
                appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw-TOoffsetx , TravelOffsetY-TOoffsety + TOhh   - (minSuspTravFRONT)*TOAppSize*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw-TOoffsetx , TravelOffsetY-TOoffsety + TOhh   - (maxSuspTravFRONT)*TOAppSize*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw-TOoffsetx , TravelOffsetY+TOoffsety + TOhh*2 - (minSuspTravREAR )*TOAppSize*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw-TOoffsetx , TravelOffsetY+TOoffsety + TOhh*2 - (maxSuspTravREAR )*TOAppSize*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
            # curr suspension travel
            appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw - TOminwidth/4 - TOoffsetx + TOhw*0.27      , TravelOffsetY-TOoffsety + TOhh   - (ac_SuspTrav["FL"])/(1+maxSuspTravFRONT)*TOAppSize*TOhh*2-TOfntSize*3, 10, 3*TOAppSize)
            appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw + TOminwidth/4 + TOoffsetx - TOhw*0.27-10   , TravelOffsetY-TOoffsety + TOhh   - (ac_SuspTrav["FR"])/(1+maxSuspTravFRONT)*TOAppSize*TOhh*2-TOfntSize*3, 10, 3*TOAppSize)
            appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw - TOminwidth/4 - TOoffsetx + TOhw*0.27      , TravelOffsetY+TOoffsety + TOhh*2 - (ac_SuspTrav["RL"])/(1+maxSuspTravREAR )*TOAppSize*TOhh*2-TOfntSize*3, 10, 3*TOAppSize)
            appDrawLine2(    0.0,0.4,1.0,0.8, TravelOffsetX + TOhw + TOminwidth/4 + TOoffsetx - TOhw*0.27-10   , TravelOffsetY+TOoffsety + TOhh*2 - (ac_SuspTrav["RR"])/(1+maxSuspTravREAR )*TOAppSize*TOhh*2-TOfntSize*3, 10, 3*TOAppSize)

            if bDAMPERsON:
                ### light blue
                # min/max damper travel markers
                appDrawLine2(0.4,0.7,1.0,0.8, TravelOffsetX + TOhw-TOoffsetx-TOfntSize*6 , TravelOffsetY-TOoffsety + TOhh   - (minDampTravFRONT)*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                appDrawLine2(0.4,0.7,1.0,0.8, TravelOffsetX + TOhw-TOoffsetx-TOfntSize*6 , TravelOffsetY-TOoffsety + TOhh   - (maxDampTravFRONT)*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                appDrawLine2(0.4,0.7,1.0,0.8, TravelOffsetX + TOhw-TOoffsetx-TOfntSize*6 , TravelOffsetY+TOoffsety + TOhh*2 - (minDampTravREAR )*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                appDrawLine2(0.4,0.7,1.0,0.8, TravelOffsetX + TOhw-TOoffsetx-TOfntSize*6 , TravelOffsetY+TOoffsety + TOhh*2 - (maxDampTravREAR )*TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                # curr damper travel
                appDrawLine2(0.4,0.7,1.0,0.8, TravelOffsetX + TOhw-TOoffsetx-6 , TravelOffsetY-TOoffsety + TOhh  -(ac_DampTrav["FL"])/(1+maxDampTravFRONT)*TOAppSize*TOhh*2-TOfntSize*3, 10, 3*TOAppSize)
                appDrawLine2(0.4,0.7,1.0,0.8, TravelOffsetX + TOhw+TOoffsetx-7 , TravelOffsetY-TOoffsety + TOhh  -(ac_DampTrav["FR"])/(1+maxDampTravFRONT)*TOAppSize*TOhh*2-TOfntSize*3, 10, 3*TOAppSize)
                appDrawLine2(0.4,0.7,1.0,0.8, TravelOffsetX + TOhw-TOoffsetx-6 , TravelOffsetY+TOoffsety + TOhh*2-(ac_DampTrav["RL"])/(1+maxDampTravREAR )*TOAppSize*TOhh*2-TOfntSize*3, 10, 3*TOAppSize)
                appDrawLine2(0.4,0.7,1.0,0.8, TravelOffsetX + TOhw+TOoffsetx-7 , TravelOffsetY+TOoffsety + TOhh*2-(ac_DampTrav["RR"])/(1+maxDampTravREAR )*TOAppSize*TOhh*2-TOfntSize*3, 10, 3*TOAppSize)

            if SuspensionForceEnabled:
                ### green
                # min/max suspension travel markers
                appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw*1.1 - TOoffsetx-TOfntSize*0.75, TravelOffsetY-TOoffsety + TOhh   - (minSuspForceFRONT/40000)*TOAppSize * TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw*1.1 - TOoffsetx-TOfntSize*0.75, TravelOffsetY-TOoffsety + TOhh   - (maxSuspForceFRONT/40000)*TOAppSize * TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw*1.1 - TOoffsetx-TOfntSize*0.75, TravelOffsetY+TOoffsety + TOhh*2 - (minSuspForceREAR /40000)*TOAppSize * TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw*1.1 - TOoffsetx-TOfntSize*0.75, TravelOffsetY+TOoffsety + TOhh*2 - (maxSuspForceREAR /40000)*TOAppSize * TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                if TOoffsetx!=0 or TOoffsety!=0:
                    appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw*0.7 + TOoffsetx, TravelOffsetY-TOoffsety + TOhh   - (minSuspForceFRONT/40000)*TOAppSize * TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                    appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw*0.7 + TOoffsetx, TravelOffsetY-TOoffsety + TOhh   - (maxSuspForceFRONT/40000)*TOAppSize * TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                    appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw*0.7 + TOoffsetx, TravelOffsetY+TOoffsety + TOhh*2 - (minSuspForceREAR /40000)*TOAppSize * TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                    appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw*0.7 + TOoffsetx, TravelOffsetY+TOoffsety + TOhh*2 - (maxSuspForceREAR /40000)*TOAppSize * TOhh*2-TOfntSize*3, 10*TOAppSize+TOfntSize*2, 3*TOAppSize)
                # curr suspension travel
                if maxSuspForceFRONT!=-1.0:
                    appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw - TOoffsetx + TOhw*0.17      , TravelOffsetY-TOoffsety + TOhh   - (ac_SuspForce["FL"]/40000) * TOAppSize *TOhh*2-TOfntSize*3, 10, 3*TOAppSize)
                    appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw + TOoffsetx - TOhw*0.17-10   , TravelOffsetY-TOoffsety + TOhh   - (ac_SuspForce["FR"]/40000) * TOAppSize *TOhh*2-TOfntSize*3, 10, 3*TOAppSize)
                if maxSuspForceREAR!=-1.0:
                    appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw - TOoffsetx + TOhw*0.17      , TravelOffsetY+TOoffsety + TOhh*2 - (ac_SuspForce["RL"]/40000) * TOAppSize *TOhh*2-TOfntSize*3, 10, 3*TOAppSize)
                    appDrawLine2(    0.4,1.0,0.7, 0.8, TravelOffsetX + TOhw + TOoffsetx - TOhw*0.17-10   , TravelOffsetY+TOoffsety + TOhh*2 - (ac_SuspForce["RR"]/40000) * TOAppSize *TOhh*2-TOfntSize*3, 10, 3*TOAppSize)

            ### text
            #if True:
            if bCSPactive and (bShowVals and not bShowLess):
                # SuspTravel dark blue
                appDrawTextCol(0.0,0.4,1.0, 1, '\nsusp. travel\n' + str(round(maxSuspTravFRONT*1000, 1)) + ' max F' , TravelOffsetX + TOhw*1.75 + TOoffsetx, TravelOffsetY-TOoffsety + TOhh      - maxSuspTravFRONT        *TOhh*2 -TOfntSize*5.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_LEFT)
                appDrawTextCol(0.0,0.4,1.0, 1,                      str(round(minSuspTravFRONT*1000, 1)) + ' min'   , TravelOffsetX + TOhw*1.75 + TOoffsetx, TravelOffsetY-TOoffsety + TOhh      - minSuspTravFRONT        *TOhh*2 -TOfntSize*2.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_LEFT)
                appDrawTextCol(0.0,0.4,1.0, 1,                      str(round(minSuspTravREAR *1000, 1)) + ' min'   , TravelOffsetX + TOhw*1.75 + TOoffsetx, TravelOffsetY+TOoffsety + TOhh*2    - minSuspTravREAR         *TOhh*2 -TOfntSize*2.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_LEFT)
                appDrawTextCol(0.0,0.4,1.0, 1,                      str(round(maxSuspTravREAR *1000, 1)) + ' max R' , TravelOffsetX + TOhw*1.75 + TOoffsetx, TravelOffsetY+TOoffsety + TOhh*2    - maxSuspTravREAR         *TOhh*2 -TOfntSize*4.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_LEFT)

                # dampers Travel light blue
                if bDAMPERsON:
                    appDrawTextCol(0.4,0.7,1.0,1,'\ndamp. travel\n' + 'F max ' + str(round(maxDampTravFRONT*1000, 1)), TravelOffsetX-TOoffsetx + TOhw - TOhw, TravelOffsetY-TOoffsety + TOhh   - maxDampTravFRONT        *TOhh*2 -TOfntSize*5.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_RIGHT)
                    appDrawTextCol(0.4,0.7,1.0,1,'min '                        + str(round(minDampTravFRONT*1000, 1)), TravelOffsetX+TOoffsetx + TOhw - TOhw/2  , TravelOffsetY-TOoffsety + TOhh   - minDampTravFRONT        *TOhh*2 -TOfntSize*2.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_RIGHT)
                    appDrawTextCol(0.4,0.7,1.0,1,'R max '                      + str(round(maxDampTravREAR *1000, 1)), TravelOffsetX-TOoffsetx + TOhw - TOhw, TravelOffsetY+TOoffsety + TOhh*2 - maxDampTravREAR         *TOhh*2 -TOfntSize*4.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_RIGHT)
                    appDrawTextCol(0.4,0.7,1.0,1,'min '                        + str(round(minDampTravREAR *1000, 1)), TravelOffsetX+TOoffsetx + TOhw - TOhw/  2, TravelOffsetY+TOoffsety + TOhh*2 - minDampTravREAR         *TOhh*2 -TOfntSize*2.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_RIGHT)

                if SuspensionForceEnabled:
                    # text SuspForce green
                    appDrawTextCol(0.4,0.8,0.4,1,'\nsusp. force\n'+'F max '    + str(int(maxSuspForceFRONT))         , TravelOffsetX-TOoffsetx + TOhw*0.25    , TravelOffsetY-TOoffsety + TOhh   - maxSuspForceFRONT/40000 *TOhh*2 -TOfntSize*5.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_RIGHT)
                    appDrawTextCol(0.4,0.8,0.4,1,'min '                        + str(int(minSuspForceFRONT))         , TravelOffsetX-TOoffsetx + TOhw*0.25    , TravelOffsetY-TOoffsety + TOhh   - minSuspForceFRONT/40000 *TOhh*2 -TOfntSize*2.0, TOfntSize*0.8, ExtGL.FONT_ALIGN_RIGHT)
                    appDrawTextCol(0.4,0.8,0.4,1,'R max '                      + str(int(maxSuspForceREAR ))         , TravelOffsetX-TOoffsetx + TOhw*0.25    , TravelOffsetY+TOoffsety + TOhh*2 - maxSuspForceREAR /40000 *TOhh*2 -TOfntSize*4.5, TOfntSize*0.8, ExtGL.FONT_ALIGN_RIGHT)
                    appDrawTextCol(0.4,0.8,0.4,1,'min '                        + str(int(minSuspForceREAR ))         , TravelOffsetX-TOoffsetx + TOhw*0.25    , TravelOffsetY+TOoffsety + TOhh*2 - minSuspForceREAR /40000 *TOhh*2 -TOfntSize*2.0, TOfntSize*0.8, ExtGL.FONT_ALIGN_RIGHT)



        if bShowCamber:
            # camber vertical bar, leaning left right
            # if bShowWearGraph and bShowGrip:
            #     appDrawLine  (0,0.8,0,0.8,hw-minwidth-offset-fntSize*4-ac_camb["FL"]*2,               0, hw-minwidth-offset-fntSize*4,  hh-fntSize*3.5, 4)
            #     appDrawLine  (0,0.8,0,0.8,hw+minwidth+offset+fntSize*4+ac_camb["FR"]*2,               0, hw+minwidth+offset+fntSize*4,  hh-fntSize*3.5, 4)
            #     appDrawLine  (0,0.8,0,0.8,hw-minwidth-offset-fntSize*4-ac_camb["RL"]*2,  hh+fntSize*3.5, hw-minwidth-offset-fntSize*4,  hh*2          , 4)
            #     appDrawLine  (0,0.8,0,0.8,hw+minwidth+offset+fntSize*4+ac_camb["RR"]*2,  hh+fntSize*3.5, hw+minwidth+offset+fntSize*4,  hh*2          , 4)
            if bShowWearGraph or bShowGrip:
                appDrawLine  (0,0.8,0,0.8,hw-minwidth-offset-fntSize*4-ac_camb["FL"]*2,     fntSize  , hw-minwidth-offset-fntSize*4,  hh  -fntSize*4, 4)
                appDrawLine  (0,0.8,0,0.8,hw+minwidth+offset+fntSize*4+ac_camb["FR"]*2,     fntSize  , hw+minwidth+offset+fntSize*4,  hh  -fntSize*4, 4)
                appDrawLine  (0,0.8,0,0.8,hw-minwidth-offset-fntSize*4-ac_camb["RL"]*2,  hh+fntSize*4, hw-minwidth-offset-fntSize*4,  hh*2-fntSize  , 4)
                appDrawLine  (0,0.8,0,0.8,hw+minwidth+offset+fntSize*4+ac_camb["RR"]*2,  hh+fntSize*4, hw+minwidth+offset+fntSize*4,  hh*2-fntSize  , 4)
            else:
                appDrawLine  (0,0.8,0,0.8,hw-minwidth-offset-fntSize*1-ac_camb["FL"]*2,             0, hw-minwidth-offset-fntSize*1,  hh-fntSize*2, 4)
                appDrawLine  (0,0.8,0,0.8,hw+minwidth+offset+fntSize*1+ac_camb["FR"]*2,             0, hw+minwidth+offset+fntSize*1,  hh-fntSize*2, 4)
                appDrawLine  (0,0.8,0,0.8,hw-minwidth-offset-fntSize*1-ac_camb["RL"]*2,  hh+fntSize*2, hw-minwidth-offset-fntSize*1,  hh*2        , 4)
                appDrawLine  (0,0.8,0,0.8,hw+minwidth+offset+fntSize*1+ac_camb["RR"]*2,  hh+fntSize*2, hw+minwidth+offset+fntSize*1,  hh*2        , 4)

        if bShowSlipRect:
            for wheel in wheels:
                # TyreSlip as outer rectangle in red
                if abs(ac_TyreSlip[wheel])>=tyresliplimit:
                    if wheel=="FR" or wheel=="RR":
                        if wheel=="FR":
                          appDrawTextureRect(0.5+abs(ac_TyreSlip[wheel])/10,1-(abs(ac_TyreSlip[wheel]))/10,0,1,hw+minwidth/2+offset,       1, tyregraphwidth, (min(1.0, abs(ac_TyreSlip[wheel])/4)), texture_inner_top)
                        else:
                          appDrawTextureRect(0.5+abs(ac_TyreSlip[wheel])/10,1-(abs(ac_TyreSlip[wheel]))/10,0,1,hw+minwidth/2+offset,  hh*2+1, tyregraphwidth, (min(1.0, abs(ac_TyreSlip[wheel])/4)), texture_inner_bot)
                    else:
                        if wheel=="FL":
                          appDrawTextureRect(0.5+abs(ac_TyreSlip[wheel])/10,1-(abs(ac_TyreSlip[wheel]))/10,0,1,hw-minwidth/2-offset,       1, tyregraphwidth, (min(1.0, abs(ac_TyreSlip[wheel])/4)), texture_inner_top)
                        else:
                          appDrawTextureRect(0.5+abs(ac_TyreSlip[wheel])/10,1-(abs(ac_TyreSlip[wheel]))/10,0,1,hw-minwidth/2-offset,  hh*2+1, tyregraphwidth, (min(1.0, abs(ac_TyreSlip[wheel])/4)), texture_inner_bot)

                # ndSlip as inner rectangle in blue
                if abs(ac_ndslip[wheel])>=tyresliplimit:
                    if wheel=="FR":
                      appDrawTextureRect(0,0.5,0.5+abs(ac_ndslip["FR"])/5,1,hw+minwidth/2+offset,       1                               , tyregraphwidth, (min(1.0, abs(ac_ndslip["FR"])/4)), texture_inner_bot )
                    elif wheel=="RR":
                      appDrawTextureRect(0,0.5,0.5+abs(ac_ndslip["RR"])/5,1,hw+minwidth/2+offset,  hh*2+1                               , tyregraphwidth, (min(1.0, abs(ac_ndslip["RR"])/4)), texture_inner_top )
                    elif wheel=="FL":
                      appDrawTextureRect(0,0.5,0.5+abs(ac_ndslip["FL"])/5,1,hw-minwidth/2-offset,       1                               , tyregraphwidth, (min(1.0, abs(ac_ndslip["FL"])/4)), texture_inner_bot )
                    else:
                      appDrawTextureRect(0,0.5,0.5+abs(ac_ndslip["RL"])/5,1,hw-minwidth/2-offset,  hh*2+1                               , tyregraphwidth, (min(1.0, abs(ac_ndslip["RL"])/4)), texture_inner_top )

        if bCSPactive and bShowSlipText:
            appDrawText(1,str(round(ac_TyreSlip["FL"], 1)), hw-minwidth/2-offset+fntSize/2,    -fntSize*2.2, fntSize*0.75)
            appDrawText(1,str(round(ac_TyreSlip["FR"], 1)), hw+minwidth/2+offset          ,    -fntSize*2.2, fntSize*0.75)
            appDrawText(1,str(round(ac_TyreSlip["RL"], 1)), hw-minwidth/2-offset+fntSize/2, hh*2+fntSize   , fntSize*0.75)
            appDrawText(1,str(round(ac_TyreSlip["RR"], 1)), hw+minwidth/2+offset          , hh*2+fntSize   , fntSize*0.75)
            if bFancyMode:
                appDrawText(0,str(round(ac_ndslip["FL"], 1)), hw-minwidth/2-offset+fntSize/2,              20*gAppSizeW, fntSize*0.75)
                appDrawText(0,str(round(ac_ndslip["FR"], 1)), hw+minwidth/2+offset          ,              20*gAppSizeW, fntSize*0.75)
                appDrawText(0,str(round(ac_ndslip["RL"], 1)), hw-minwidth/2-offset+fntSize/2, hh*2-fntSize*1.2-20*gAppSizeW, fntSize*0.75)
                appDrawText(0,str(round(ac_ndslip["RR"], 1)), hw+minwidth/2+offset          , hh*2-fntSize*1.2-20*gAppSizeW, fntSize*0.75)
            else:
                appDrawText(0,str(round(ac_ndslip["FL"], 1)), hw-minwidth/2-offset+fntSize/2,              2, fntSize*0.75)
                appDrawText(0,str(round(ac_ndslip["FR"], 1)), hw+minwidth/2+offset          ,              2, fntSize*0.75)
                appDrawText(0,str(round(ac_ndslip["RL"], 1)), hw-minwidth/2-offset+fntSize/2, hh*2-fntSize*1.2, fntSize*0.75)
                appDrawText(0,str(round(ac_ndslip["RR"], 1)), hw+minwidth/2+offset          , hh*2-fntSize*1.2, fntSize*0.75)


        # AERO
        if (bShowAero or bShowAeroText) and not bHideTimerOn:
            # SLIPSTREAM
            if bShowAero:
                # DRAG in orange
                if bCSPactive and bDRAG and maxDrag>0.0:
                    # Drag in orange
                    appDrawLine2(0.8, 0.5, 0.1, gOpacityFG/100, # rgba
                        hw - (AERODrag/maxDrag)*hw  , -fntSize*6.7, # x,y
                            (AERODrag/maxDrag)*hw*2,  fntSize*1.1)  # w,h

                # DOWNFORCE kg in blue
                if bCSPactive and bDOWNFORCE and maxDownForce>0.0:
                    # Downforce in blue-ish
                    appDrawLine2(0.4,0.5,0.9,gOpacityFG/100, # rgba
                        hw - (AERODownforce/maxDownForce)*hw  , -fntSize*5.55, # x,y
                            (AERODownforce/maxDownForce)*hw*2,  fntSize*1.1)  # w,h

                # draw CDv drag Coefficient
                if not bCSPactive and currspeed>15:
                    appDrawLine2(0.5,0.5,0.5,gOpacityFG/200, hw-AEROCDv     ,  -fntSize*5.6, AEROCDv*2, fntSize*1.2)

                if baseAEROdens!=0.0 and bShowAero:
                    if AEROdens>baseAEROdens and currspeed>15:
                        ww = min( minwidth+offset , (1-AEROdens/baseAEROdens)*5*(minwidth+offset) )
                        # draw current lower airdensity in red
                        appDrawLine2(min(1,0.7+(-1+AEROdens/baseAEROdens)*5),max(0,0.7-(-1+AEROdens/baseAEROdens)*5), max(0,0.7-(-1+AEROdens/baseAEROdens)*5), gOpacityFG/100, hw-minwidth-offset+ww   , -fntSize*4.40            , offset*2+minwidth*2-ww*2  , fntSize*1.2)
                    elif AEROdens<baseAEROdens and currspeed>15:
                        ww = min(minwidth/3*2+offset, (1-AEROdens/baseAEROdens)*5*(minwidth+offset) )
                        # draw current higher airdensity in green
                        appDrawLine2(max(0,0.7-(1-AEROdens/baseAEROdens)*2),min(1,0.7+(1-AEROdens/baseAEROdens)*2), max(0,0.7-(1-AEROdens/baseAEROdens)*2), gOpacityFG/100,  hw-minwidth-offset+ww   , -fntSize*4.40            , offset*2+minwidth*2-ww*2   , fntSize*1.2)
                    else:
                        # draw default airdensity, current 100%
                        appDrawLine2(0.7,0.7,0.7,                 gOpacityFG/100, hw-(minwidth+offset)    , -fntSize*4.40            , (minwidth+offset)*2        , fntSize*1.2)

                    # draw airdensity baseline above current
                    appDrawLine2(0.15,0.15,0.15,   gOpacityFG/200, hw-(minwidth+offset)    , -fntSize*4.2            , (minwidth+offset)*2        , fntSize*0.8)

            ### aero debug
            # appDrawText(0.8,' AEROCDv     ' + str(ac.getCarState(0, acsys.AERO.CD                           ))  , hw*2+300, fntSize*  0, fntSize*2, ExtGL.FONT_ALIGN_LEFT)
            # appDrawText(0.8,' AEROCLf     ' + str(ac.getCarState(0, acsys.AERO.CL_Front                     ))  , hw*2+300, fntSize*  2, fntSize*2, ExtGL.FONT_ALIGN_LEFT)
            # appDrawText(0.8,' AEROCLr     ' + str(ac.getCarState(0, acsys.AERO.CL_Rear                      ))  , hw*2+300, fntSize*  4, fntSize*2, ExtGL.FONT_ALIGN_LEFT)
            # appDrawText(0.8,' AEROCDv p '   + str(ac.getCarState(0, acsys.AERO.CD      ,      0             ))  , hw*2+300, fntSize*  6, fntSize*2, ExtGL.FONT_ALIGN_LEFT)
            # appDrawText(0.8,' AEROCLf p '   + str(ac.getCarState(0, acsys.AERO.CL_Front,      0             ))  , hw*2+300, fntSize*  8, fntSize*2, ExtGL.FONT_ALIGN_LEFT)
            # appDrawText(0.8,' AEROCLr p '   + str(ac.getCarState(0, acsys.AERO.CL_Rear ,      0             ))  , hw*2+300, fntSize* 10, fntSize*2, ExtGL.FONT_ALIGN_LEFT)
            # appDrawText(0.8,' AEROCDv c '   + str(ac.getCarState(0, acsys.CS.Aero      , acsys.AERO.CD      ))  , hw*2+300, fntSize* 12, fntSize*2, ExtGL.FONT_ALIGN_LEFT)
            # appDrawText(0.8,' AEROCLf c '   + str(ac.getCarState(0, acsys.CS.Aero      , acsys.AERO.CL_Front))  , hw*2+300, fntSize* 14, fntSize*2, ExtGL.FONT_ALIGN_LEFT)
            # appDrawText(0.8,' AEROCLr c '   + str(ac.getCarState(0, acsys.CS.Aero      , acsys.AERO.CL_Rear ))  , hw*2+300, fntSize* 16, fntSize*2, ExtGL.FONT_ALIGN_LEFT)
            ### appDrawText(0.8,' AEROCLT ' + str(int(AEROCLT))  , hw*2+300, fntSize* 6, fntSize*2, ExtGL.FONT_ALIGN_LEFT)




        # ENGINE TORQUE
        if bShowNM and bCSPactive and not bHideTimerOn:
            CURRTorque = ac.ext_getCurrentTorque(currcar)
            if CURRTorque>maxTorque:
                maxTorque=CURRTorque
            if maxTorque>0.1:
                if bShowAeroText or bShowAero: # only values if needed
                    appDrawLine2(   0.5, 0.5+CURRTorque/maxTorque/4, 1-CURRTorque/maxTorque/2, 0.75, hw-CURRTorque/maxTorque*(minwidth+offset), -fntSize*7+locOffNM, CURRTorque/maxTorque*2*(minwidth+offset), fntSize*1.2)
                    if bShowLess:
                        if bTextWhiteOnBlack:
                            appDrawText(1,str(int(CURRTorque))+' Nm'                                     , hw, -fntSize*7+locOffNM, fntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                        else:
                            appDrawText(0,str(int(CURRTorque))+' Nm'                                     , hw, -fntSize*7+locOffNM, fntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                    else:
                        if bTextWhiteOnBlack:
                            appDrawText(1,str(int(CURRTorque))+' Nm\nmax: '+str(int(maxTorque)) + ' Nm'  , hw, -fntSize*7+locOffNM, fntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                        else:
                            appDrawText(0,str(int(CURRTorque))+' Nm\nmax: '+str(int(maxTorque)) + ' Nm'  , hw, -fntSize*7+locOffNM, fntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                else:
                    appDrawLine2(   0.5, 0.5+CURRTorque/maxTorque/4, 1-CURRTorque/maxTorque/2, 0.75, hw-CURRTorque/maxTorque*(minwidth+offset), -fntSize*3+locOffNM, CURRTorque/maxTorque*2*(minwidth+offset), fntSize*1.2)
                    if bShowLess:
                        if bTextWhiteOnBlack:
                            appDrawText(1,str(int(CURRTorque))+' Nm'                                     , hw, -fntSize*3+locOffNM, fntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                        else:
                            appDrawText(0,str(int(CURRTorque))+' Nm'                                     , hw, -fntSize*3+locOffNM, fntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                    else:
                        if bTextWhiteOnBlack:
                            appDrawText(1,str(int(CURRTorque))+' Nm\nmax: '+str(int(maxTorque)) + ' Nm'  , hw, -fntSize*3+locOffNM, fntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
                        else:
                            appDrawText(0,str(int(CURRTorque))+' Nm\nmax: '+str(int(maxTorque)) + ' Nm'  , hw, -fntSize*3+locOffNM, fntSize*0.8, ExtGL.FONT_ALIGN_CENTER)

            # STEERtorque = abs(ac.ext_getSteerTorque())
            # if STEERtorque > 0.0:
            #     appDrawLine2(0.9, 0.9, 0.9, 0.9 , hw-STEERtorque, -fntSize*6, STEERtorque*2 , fntSize+6)
            #     if bShowVals and not bShowLess:
            #         appDrawText(1,"SteeringTorque: " + str(round(STEERtorque,1))+' Nm'                                     , hw, -fntSize*4, fntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
            #         # ac.ext_glFontColor(f1.f, 0.9, 0.9, 0.9, 0.95)
            #         # ac.ext_glFontUse(f1.f,"steer = "+ str(round(STEERtorque,1))              , hw*2          , -fntSize*4+locOff, fntSize*0.8   , ExtGL.FONT_ALIGN_CENTER)
            # FFBlast = abs(50*ac.getCarState(currcar, acsys.CS.LastFF))
            # if FFBlast > 0.0:
            #     appDrawLine2(               0.1, 0.1, 0.1, 0.9                                    , hw-FFBlast    , -fntSize*6+fntSize*0.2, FFBlast*2     , fntSize)
            #     if bShowVals and not bShowLess:
            #         appDrawText(1,"FFB                   : " + str(round(FFBlast,1))+' Nm'                                     , hw, -fntSize*3, fntSize*0.8, ExtGL.FONT_ALIGN_CENTER)
            #     #     ac.ext_glFontColor(f1.f, 0.1, 0.1, 0.1, 0.75)
            #     #     ac.ext_glFontUse(f1.f,"ffb = "+ str(round(FFBlast,1)), 0                                                                , -fntSize*4+locOff, fntSize*0.8   , ExtGL.FONT_ALIGN_CENTER)





        ### grip level
        if (bShowGrip or bShowGripText) and bGripAvailable:
            if bShowGrip: ### black bg
                appDrawLine2(0, 0, 0, gOpacityFG/100.0, hw   - offset-minwidth- minwidth*0.4-1, 0              + fontOffsetYRear/4, max(4,minwidth*0.1), hh-fntSize*3)
                appDrawLine2(0, 0, 0, gOpacityFG/100.0, hw   + offset+minwidth+ minwidth*0.3-1, 0              + fontOffsetYRear/4, max(4,minwidth*0.1), hh-fntSize*3)
                appDrawLine2(0, 0, 0, gOpacityFG/100.0, hw   - offset-minwidth- minwidth*0.4-1, hh+fntSize*3.0 - fontOffsetYRear/4, max(4,minwidth*0.1), hh-fntSize*3)
                appDrawLine2(0, 0, 0, gOpacityFG/100.0, hw   + offset+minwidth+ minwidth*0.3-1, hh+fntSize*3.0 - fontOffsetYRear/4, max(4,minwidth*0.1), hh-fntSize*3)

            rt = max(0.05, 1-(100-ac_Grip['FL'])/5)
            if bShowGrip:
                appDrawLine2(              1-rt, rt, 0, gOpacityFG/100.0, hw   - offset-minwidth- minwidth*0.4+1, 0+ fontOffsetYRear/3, max(2,minwidth*0.1-4), rt*(hh-fntSize*3))
            if bShowGripText and bCSPactive:
                appDrawTextWithShadowsColor(1-rt, rt, 0, gOpacityFG/100.0, str(round(ac_Grip['FL'],1)),     -minwidth*0.7-offset/3,     -fontOffsetYRear/3, fntSize*0.9, ExtGL.FONT_ALIGN_LEFT)

            rt = max(0.05, 1-(100-ac_Grip['FR'])/5)
            if bShowGrip:
                appDrawLine2(              1-rt, rt, 0, gOpacityFG/100.0, hw   + offset+minwidth+ minwidth*0.3+1, 0+ fontOffsetYRear/3, max(2,minwidth*0.1-4), rt*(hh-fntSize*3))
            if bShowGripText and bCSPactive:
                appDrawTextWithShadowsColor(1-rt, rt, 0, gOpacityFG/100.0, str(round(ac_Grip['FR'],1)), hw*2+minwidth*0.7+offset/3,     -fontOffsetYRear/3, fntSize*0.9, ExtGL.FONT_ALIGN_RIGHT)

            rt = max(0.05, 1-(100-ac_Grip['RL'])/5)
            if bShowGrip:
                appDrawLine2(              1-rt, rt, 0, gOpacityFG/100.0, hw   - offset-minwidth- minwidth*0.4+1, hh+fntSize*3 -fontOffsetYRear/4, max(2,minwidth*0.1-4), rt*(hh-fntSize*3))
            if bShowGripText and bCSPactive:
                appDrawTextWithShadowsColor(1-rt, rt, 0, gOpacityFG/100.0, str(round(ac_Grip['RL'],1)),     -minwidth*0.7-offset/3, hh*2-fntSize*1.5-fontOffsetYRear/4, fntSize*0.9, ExtGL.FONT_ALIGN_LEFT)

            rt = max(0.05, 1-(100-ac_Grip['RR'])/5)
            if bShowGrip:
                appDrawLine2(              1-rt, rt, 0, gOpacityFG/100.0, hw   + offset+minwidth+ minwidth*0.3+1, hh+fntSize*3-fontOffsetYRear/4, max(2,minwidth*0.1-4), rt*(hh-fntSize*3))
            if bShowGripText and bCSPactive:
                appDrawTextWithShadowsColor(1-rt, rt, 0, gOpacityFG/100.0, str(round(ac_Grip['RR'],1)), hw*2+minwidth*0.7+offset/3, hh*2-fntSize*1.5-fontOffsetYRear/4, fntSize*0.9, ExtGL.FONT_ALIGN_RIGHT)

            # appDrawTextWithShadows(1, 1, 1, gOpacityFG/100.0, str(round(ac_pressLvl["FL"],2))+'%',     -minwidth*0.7-offset, hh-fntSize*1.5, fntSize*0.9, ExtGL.FONT_ALIGN_LEFT)
            # appDrawTextWithShadows(1, 1, 1, gOpacityFG/100.0, str(round(ac_pressLvl["FR"],2))+'%', hw*2+minwidth*0.7+offset, hh-fntSize*1.5, fntSize*0.9, ExtGL.FONT_ALIGN_RIGHT)
            # appDrawTextWithShadows(1, 1, 1, gOpacityFG/100.0, str(round(ac_pressLvl["RL"],2))+'%',     -minwidth*0.7-offset, hh+fntSize*0.5, fntSize*0.9, ExtGL.FONT_ALIGN_LEFT)
            # appDrawTextWithShadows(1, 1, 1, gOpacityFG/100.0, str(round(ac_pressLvl["RR"],2))+'%', hw*2+minwidth*0.7+offset, hh+fntSize*0.5, fntSize*0.9, ExtGL.FONT_ALIGN_RIGHT)


        #dmg = tyinfo.physics.carDamage
        #appDrawText(0.8,str(round(dmg[0],5)), hw*2+250, fntSize* 0, fntSize* 2, ExtGL.FONT_ALIGN_LEFT)
        #appDrawText(0.8,str(round(dmg[1],5)), hw*2+250, fntSize* 2, fntSize* 2, ExtGL.FONT_ALIGN_LEFT)
        #appDrawText(0.8,str(round(dmg[2],5)), hw*2+250, fntSize* 4, fntSize* 2, ExtGL.FONT_ALIGN_LEFT)
        #appDrawText(0.8,str(round(dmg[3],5)), hw*2+250, fntSize* 6, fntSize* 2, ExtGL.FONT_ALIGN_LEFT)
        #appDrawText(0.8,str(round(dmg[4],5)), hw*2+250, fntSize* 8, fntSize* 2, ExtGL.FONT_ALIGN_LEFT)

        ### debug print
        # appDrawText(0.8,'Lv  ' + str(round(ac_LocalVelocity[0],3)), hw*2+250, fntSize*0)
        # appDrawText(0.8,'Lv  ' + str(round(ac_LocalVelocity[2],3)), hw*2+250, fntSize*2)
        # appDrawText(0.8,'Lv  ' + str(round(ac_LocalVelocity[1],3)), hw*2+250, fntSize*4)
        # appDrawText(0.8,'LAv ' + str(round(ac_LocalAngV[0]    ,3)), hw*2+250, fntSize*8)
        # appDrawText(0.8,'LAv ' + str(round(ac_LocalAngV[2]    ,3)), hw*2+250, fntSize*10)
        # appDrawText(0.8,'LAv ' + str(round(ac_LocalAngV[1]    ,3)), hw*2+250, fntSize*12)
        # appDrawText(0.8,'wF ' + str(round(ac_wspeed["FL"]-ac_wspeed["FR"]    ,5)), hw*2+250, fntSize*14)
        # appDrawText(0.8,'wR ' + str(round(ac_wspeed["RL"]-ac_wspeed["RR"]    ,5)), hw*2+250, fntSize*16)

        #appDrawText(0.8,'wv ' + str(round(ac_wspeed["FL"]    ,5)), hw*2+250, fntSize*14)
        #appDrawText(0.8,'wv ' + str(round(ac_wspeed["FR"]    ,5)), hw*2+250, fntSize*16)
        #appDrawText(0.8,'wv ' + str(round(ac_wspeed["RL"]    ,5)), hw*2+250, fntSize*18)
        #appDrawText(0.8,'wv ' + str(round(ac_wspeed["RR"]    ,5)), hw*2+250, fntSize*20)

        # appDrawText(0.8,str(round(ac.getCarState(0, acsys.CS.TyreRightVector,acsys.WHEELS.FL),2)), hw*2+250, fntSize* 0, fntSize* 2, ExtGL.FONT_ALIGN_LEFT)
        # appDrawText(0.8,str(round(ac.getCarState(0, acsys.CS.TyreRightVector,acsys.WHEELS.FR),2)), hw*2+250, fntSize* 2, fntSize* 2, ExtGL.FONT_ALIGN_LEFT)
        # appDrawText(0.8,str(round(ac.getCarState(0, acsys.CS.TyreRightVector,acsys.WHEELS.RL),2)), hw*2+250, fntSize* 4, fntSize* 2, ExtGL.FONT_ALIGN_LEFT)
        # appDrawText(0.8,str(round(ac.getCarState(0, acsys.CS.TyreRightVector,acsys.WHEELS.RR),2)), hw*2+250, fntSize* 6, fntSize* 2, ExtGL.FONT_ALIGN_LEFT)

        #### print something for debug in BIG font
        # if False and bCSPactive:
        # #if True and bCSPactive:
        #     appDrawText(0.8, "TCError     :" +  str(round(ac.ext_getTCError(currcar)      ,5)   ) , hw*5, fntSize*   8, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)
        #     appDrawText(0.8, "TCSlip      :" +  str(round(ac.ext_getTCSlip(currcar)       ,5)   ) , hw*5, fntSize*   6, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)
        #     appDrawText(0.8, "TCSlipGoal  :" +  str(round(ac.ext_getTCSlipGoal(currcar)   ,5)   ) , hw*5, fntSize*   3, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)
        #     appDrawText(0.8, "TcDTerm     :" +  str(round(ac.ext_getTcDTerm(currcar)      ,5)   ) , hw*5, fntSize* - 0, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)
        #     appDrawText(0.8, "TcGain      :" +  str(round(ac.ext_getTcGain(currcar)       ,5)   ) , hw*5, fntSize* - 2, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)
        #     appDrawText(0.8, "TcITerm     :" +  str(round(ac.ext_getTcITerm(currcar)      ,5)   ) , hw*5, fntSize* - 4, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)
        #     appDrawText(0.8, "TcPTerm     :" +  str(round(ac.ext_getTcPTerm(currcar)      ,5)   ) , hw*5, fntSize* - 6, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)
        #     appDrawText(0.8, "TcSetting1  :" +  str(round(ac.ext_getTcSetting1(currcar)   ,5)   ) , hw*5, fntSize* - 8, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)
        #     appDrawText(0.8, "TcSetting2  :" +  str(round(ac.ext_getTcSetting2(currcar)   ,5)   ) , hw*5, fntSize* -10, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)
        #     appDrawText(0.8, "TcTrqCut    :" +  str(round(ac.ext_getTcTrqCut(currcar)     ,5)   ) , hw*5, fntSize* -12, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)
        #     appDrawText(0.8, "TcTrqRequest:" +  str(round(ac.ext_getTcTrqRequest(currcar) ,5)   ) , hw*5, fntSize* -14, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)


        # if False and bCSPactive:
        #     engineBrakeSettingsCount      = round( tyinfo.static.engineBrakeSettingsCount, 1)
        #     ersPowerControllerCount       = round( tyinfo.static.ersPowerControllerCount, 1)

        #     # engineBrake                   = tyinfo.physics.engineBrake
        #     engineBrake                   = round( ac.getCarState(currcar, acsys.CS.EngineBrake, 1) )

        #     #KersCharge                    = tyinfo.physics.kersCharge
        #     KersCharge                    = round( ac.getCarState(currcar, acsys.CS.KersCharge)*100, 1)
        #     KersInput                     = round( ac.getCarState(currcar, acsys.CS.KersInput)*100, 2)
        #     ERSCurrentKJ                  = round( ac.getCarState(currcar, acsys.CS.ERSCurrentKJ), 1)
        #     ERSMaxJ                       = round( ac.getCarState(currcar, acsys.CS.ERSMaxJ)/100000, 1)

        #     ERSRecovery                   = round( ac.getCarState(currcar, acsys.CS.ERSRecovery), 3)
        #     ERSDelivery                   = round( ac.getCarState(currcar, acsys.CS.ERSDelivery) , 3)
        #     ersPowerLevel                 = tyinfo.physics.ersPowerLevel # same
        #     ERSHeatCharging               = round( ac.getCarState(currcar, acsys.CS.ERSHeatCharging), 5)
        #     #ERSHeatCharging               = round( tyinfo.physics.ersHeatCharging, 3)
        #     Caster                        = round( ac.getCarState(currcar, acsys.CS.Caster), 1)
        #     ToeInDeg                      = round( ac.getCarState(currcar, acsys.CS.ToeInDeg), 1)


        #     appDrawText(0.8,'engineBrakeSettingsCount ' + str(engineBrakeSettingsCount)             , hw*8, fntSize*   8, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'ersPowerControllerCount  ' + str(ersPowerControllerCount)              , hw*8, fntSize*   6, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'engineBrake              ' + str(engineBrake)                          , hw*8, fntSize*   3, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'KersCharge %             ' + str(KersCharge)                           , hw*8, fntSize* - 0, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'KersInput %              ' + str(KersInput)                            , hw*8, fntSize* - 2, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'ERSCurrentKJ             ' + str(ERSCurrentKJ)                         , hw*8, fntSize* - 4, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'ERSMaxJ                  ' + str(ERSMaxJ)                              , hw*8, fntSize* - 6, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'ERSRecovery              ' + str(ERSRecovery)                          , hw*8, fntSize* - 8, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'ERSDelivery              ' + str(ERSDelivery)                          , hw*8, fntSize* -10, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'ersPowerLevel            ' + str(ersPowerLevel)                        , hw*8, fntSize* -12, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'ERSHeatCharging          ' + str(ERSHeatCharging)                      , hw*8, fntSize* -14, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'ERS                      ' + str(tyinfo.static.hasERS)                 , hw*8, fntSize* -16, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'KERS                     ' + str(tyinfo.static.hasKERS)                , hw*8, fntSize* -18, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'Turbo                    ' + str(round(tyinfo.physics.turboBoost,3))   , hw*8, fntSize* -20, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'maxTorque                ' + str(round(tyinfo.static.maxTorque,3))     , hw*8, fntSize* -22, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'maxPower                 ' + str(round(tyinfo.static.maxPower,3))      , hw*8, fntSize* -24, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'maxRpm                   ' + str(round(tyinfo.static.maxRpm,3))        , hw*8, fntSize* -26, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'maxTurbo                 ' + str(round(tyinfo.static.maxTurboBoost,3)) , hw*8, fntSize* -28, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'currentMaxRpm            ' + str(round(tyinfo.physics.currentMaxRpm,3)), hw*8, fntSize* -30, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)

        # # if True:
        # if False:
        #     ### TyreVelocity , Velocity
        #     appDrawLine2(0.4, 0.9, 0.8, 1 , 200, -ac_TVfl/100*hh  , 20, ac_TVfl/100*hh)
        #     appDrawLine2(0.4, 0.9, 0.8, 1 , 400, -ac_TVfr/100*hh  , 20, ac_TVfr/100*hh)
        #     appDrawLine2(0.4, 0.9, 0.8, 1 , 200,          hh*2, 20, ac_TVrl/100*hh)
        #     appDrawLine2(0.4, 0.9, 0.8, 1 , 400,          hh*2, 20, ac_TVrr/100*hh)
        #     appDrawText(0.8,'ac_TVfl  ' + str(round(ac_TVfl,3)), hw*6, fntSize* 32, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'ac_TVfr  ' + str(round(ac_TVfr,3)), hw*8, fntSize* 32, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'ac_TVrl  ' + str(round(ac_TVrl,3)), hw*6, fntSize* 34, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)
        #     appDrawText(0.8,'ac_TVrr  ' + str(round(ac_TVrr,3)), hw*8, fntSize* 34, fntSize*1.25, ExtGL.FONT_ALIGN_LEFT)

            #appDrawText(0.8,'Caster                   ' + str(Caster)                  , hw*8, fntSize* 16, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)
            #appDrawText(0.8,'ToeInDeg                 ' + str(ToeInDeg)                , hw*8, fntSize* 18, fntSize*1.25, ExtGL.FONT_ALIGN_RIGHT)



        # show isHot
        if bSHOWHOTG:
            if ac_isHot["FL"]:
                appDrawTextureRect(1,0.0,0.0,1, hw-minwidth/2-offset,  hh-fntSize*4, tyregraphwidth, (min(1.0, abs(ac_TempMult["FL"])))*fntSize/30, texture_inner_top )
            if ac_isHot["FR"]:
                appDrawTextureRect(1,0.0,0.0,1, hw+minwidth/2+offset,  hh-fntSize*4, tyregraphwidth, (min(1.0, abs(ac_TempMult["FR"])))*fntSize/30, texture_inner_top )
            if ac_isHot["RL"]:
                appDrawTextureRect(1,0.0,0.0,1, hw-minwidth/2-offset,  hh+fntSize*4, tyregraphwidth, (min(1.0, abs(ac_TempMult["RL"])))*fntSize/30, texture_inner_bot )
            if ac_isHot["RR"]:
                appDrawTextureRect(1,0.0,0.0,1, hw+minwidth/2+offset,  hh+fntSize*4, tyregraphwidth, (min(1.0, abs(ac_TempMult["RR"])))*fntSize/30, texture_inner_bot )
        if bSHOWHOTT and bCSPactive:
            if ac_isHot["FL"]==1:
                appDrawTextCol(1,0.3,0.3,1,"HOT!",     -fntSize*6,      +fntSize*2, fntSize*1, ExtGL.FONT_ALIGN_LEFT)
            if ac_isHot["FR"]==1:
                appDrawTextCol(1,0.3,0.3,1,"HOT!", hw*2+fntSize*6,      +fntSize*2, fntSize*1, ExtGL.FONT_ALIGN_RIGHT)
            if ac_isHot["RL"]==1:
                appDrawTextCol(1,0.3,0.3,1,"HOT!",     -fntSize*6, hh*2 -fntSize*3, fntSize*1, ExtGL.FONT_ALIGN_LEFT)
            if ac_isHot["RR"]==1:
                appDrawTextCol(1,0.3,0.3,1,"HOT!", hw*2+fntSize*6, hh*2 -fntSize*3, fntSize*1, ExtGL.FONT_ALIGN_RIGHT)

    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )


######################################################################################################
######################################################################################################
######################################################################################################

def appCreate():
    try:
        global b_MultDn, b_MultUp, b_Reset, lbCenter, lbCenter2, lbInfo, lbInfo2, btnAppWidthUp, btnAppWidthDn, btnAppHeightDn, btnAppHeightUp, appWindow
        global bCPhysicsActive, b_transpFGUp, b_transpFGDn, b_transpUp, b_transpDn, b_widthUp, b_widthDn, b_GripToggle, b_GripTextToggle, btnTOAppSizeUp, btnTOAppSizeDn
        global b_Load, b_Travel, b_GapT, b_Camber, b_Directions, b_More, b_Vals, b_Aero, b_SlipR, b_SlipT, b_color2, b_color, b_nm, b_nmbrake, b_less, b_GAPSIZEUp, b_GAPSIZEDn, b_slipCircle, b_wearT, b_aeroT, b_wearG, b_ShowBGText
        global btnMoveLeft, btnMoveRight, btnMoveUp, btnMoveDown, TravelOffsetX, TravelOffsetY, texture_rect_inner, appInfo, lbTimer, lbAero, lbAero2, b_IMO, b_IMOtext
        global btnTOWidthDn, btnTOWidthUp, btnTOHeigthDn, btnTOHeightUp, b_maxs, b_resetMinMax
        global btnRadiuses, btnMZ, WHEELS, btnRMORE, btnTyreNext, btnTyrePrev, btnBRAKES, btnBrakeText, bCPhysBrakesText, bCPhysCarcassEnabled
        global appSettingstyapp, b_settings, b_presstoggle, btn_ShowPressure, btn_FBG, btn_AbsTc, b_presstext, bShowPressureText
        global btnFontPlus, btnFontMinus, btnFontOffsetPlus, btnFontOffsetMinus, cbFancy, btnFontSizeMinus, btnFontSizePlus, cbToggleTextColor, bTextWhiteOnBlack, cbToggleImageset
        global bPressureGraph, btnPressureGraph, btnSHOWHOTG, btnSHOWHOTT, btnCarcassText, bImgSet

        lbCenter2    = appInsertLabel(appWindow, "")
        lbCenter     = appInsertLabel(appWindow, "")
        lbAero2      = appInsertLabel(appWindow, "")
        lbAero       = appInsertLabel(appWindow, "")
        lbInfo       = appInsertLabel(appInfo, "")
        lbInfo2      = appInsertLabel(appInfo, "")
        lbTimer      = appInsertLabel(appInfo, "")
        btnTyreNext  = appInsertButton(appInfo, ""  , 90,25,40,20,12, appTyreNext)
        btnTyrePrev  = appInsertButton(appInfo, "-" , 50,25,40,20,12, appTyrePrev, "left")

        # "tempc"  # core temps colored rectangle
        # "ctmpc"  # carcass temps colored rectangle
        # "temp"   # core temps text value
        # "ctemp"  # carcass temps text value

        #tyre carcass temps
        WHEELS["FL"]["tempI"]["value"]    = appInsertLabel(appWindow, ""     , "center")
        WHEELS["FR"]["tempI"]["value"]    = appInsertLabel(appWindow, ""     , "center")
        WHEELS["RL"]["tempI"]["value"]    = appInsertLabel(appWindow, ""     , "center")
        WHEELS["RR"]["tempI"]["value"]    = appInsertLabel(appWindow, ""     , "center")
        WHEELS["FL"]["tempM"]["value"]    = appInsertLabel(appWindow, ""     , "center")
        WHEELS["FR"]["tempM"]["value"]    = appInsertLabel(appWindow, ""     , "center")
        WHEELS["RL"]["tempM"]["value"]    = appInsertLabel(appWindow, ""     , "center")
        WHEELS["RR"]["tempM"]["value"]    = appInsertLabel(appWindow, ""     , "center")
        WHEELS["FL"]["tempO"]["value"]    = appInsertLabel(appWindow, ""     , "center")
        WHEELS["FR"]["tempO"]["value"]    = appInsertLabel(appWindow, ""     , "center")
        WHEELS["RL"]["tempO"]["value"]    = appInsertLabel(appWindow, ""     , "center")
        WHEELS["RR"]["tempO"]["value"]    = appInsertLabel(appWindow, ""     , "center")

        # tyre core temps colored rectangle
        WHEELS["FL"]["tempc"]["value"]    = appInsertLabel(appWindow, ""  , "right")
        WHEELS["FR"]["tempc"]["value"]    = appInsertLabel(appWindow, ""  , "left" )
        WHEELS["RL"]["tempc"]["value"]    = appInsertLabel(appWindow, ""  , "right")
        WHEELS["RR"]["tempc"]["value"]    = appInsertLabel(appWindow, ""  , "left" )
        WHEELS["FL"]["ctmpc"]["value"]    = appInsertLabel(appWindow, ""  , "right")        #tyre carcass temps colored rectangle
        WHEELS["FR"]["ctmpc"]["value"]    = appInsertLabel(appWindow, ""  , "left" )
        WHEELS["RL"]["ctmpc"]["value"]    = appInsertLabel(appWindow, ""  , "right")
        WHEELS["RR"]["ctmpc"]["value"]    = appInsertLabel(appWindow, ""  , "left" )
        WHEELS["FL"]["temp"]["value"]     = appInsertLabel(appWindow, "--C"  , "right")     # tyre core temps text
        WHEELS["FR"]["temp"]["value"]     = appInsertLabel(appWindow, "--C"  , "left" )
        WHEELS["RL"]["temp"]["value"]     = appInsertLabel(appWindow, "--C"  , "right")
        WHEELS["RR"]["temp"]["value"]     = appInsertLabel(appWindow, "--C"  , "left" )
        # WHEELS["BG"]                      = appInsertLabel(""     , "center")

        WHEELS["FL"]["ctemp"]["value"]    = appInsertLabel(appWindow, "--C"  , "right")        #tyre carcass temps text
        WHEELS["FR"]["ctemp"]["value"]    = appInsertLabel(appWindow, "--C"  , "left" )
        WHEELS["RL"]["ctemp"]["value"]    = appInsertLabel(appWindow, "--C"  , "right")
        WHEELS["RR"]["ctemp"]["value"]    = appInsertLabel(appWindow, "--C"  , "left" )

        WHEELS["FL"]["pres"]["value"]     = appInsertLabel(appWindow, "--"   , "left" )
        WHEELS["FR"]["pres"]["value"]     = appInsertLabel(appWindow, "--"   , "right")
        WHEELS["RL"]["pres"]["value"]     = appInsertLabel(appWindow, "--"   , "left" )
        WHEELS["RR"]["pres"]["value"]     = appInsertLabel(appWindow, "--"   , "right")

        WHEELS["FL"]["wearLabel"]         = appInsertLabel(appWindow, "" , "left")
        WHEELS["FR"]["wearLabel"]         = appInsertLabel(appWindow, "" , "right")
        WHEELS["RL"]["wearLabel"]         = appInsertLabel(appWindow, "" , "left")
        WHEELS["RR"]["wearLabel"]         = appInsertLabel(appWindow, "" , "right")
        WHEELS["FL"]["wear"]["value"]     = appInsertLabel(appWindow, "100%" , "left")
        WHEELS["FR"]["wear"]["value"]     = appInsertLabel(appWindow, "100%" , "right")
        WHEELS["RL"]["wear"]["value"]     = appInsertLabel(appWindow, "100%" , "left")
        WHEELS["RR"]["wear"]["value"]     = appInsertLabel(appWindow, "100%" , "right")
        WHEELS["FL"]["wearInner"]         = appInsertLabel(appWindow, "" , "left")
        WHEELS["FR"]["wearInner"]         = appInsertLabel(appWindow, "" , "right")
        WHEELS["RL"]["wearInner"]         = appInsertLabel(appWindow, "" , "left")
        WHEELS["RR"]["wearInner"]         = appInsertLabel(appWindow, "" , "right")

        WHEELS["FL"]["slip"]              = appInsertLabel(appWindow, ""     , "center")
        WHEELS["FR"]["slip"]              = appInsertLabel(appWindow, ""     , "center")
        WHEELS["RL"]["slip"]              = appInsertLabel(appWindow, ""     , "center")
        WHEELS["RR"]["slip"]              = appInsertLabel(appWindow, ""     , "center")
        WHEELS["FL"]["details"]["value"]  = appInsertLabel(appWindow, "--"   , "left" )
        WHEELS["FR"]["details"]["value"]  = appInsertLabel(appWindow, "--"   , "right")
        WHEELS["RL"]["details"]["value"]  = appInsertLabel(appWindow, "--"   , "left" )
        WHEELS["RR"]["details"]["value"]  = appInsertLabel(appWindow, "--"   , "right")
        WHEELS["FL"]["dirt"]              = appInsertLabel(appWindow, ""     , "left")
        WHEELS["FR"]["dirt"]              = appInsertLabel(appWindow, ""     , "right")
        WHEELS["RL"]["dirt"]              = appInsertLabel(appWindow, ""     , "left")
        WHEELS["RR"]["dirt"]              = appInsertLabel(appWindow, ""     , "right")
        WHEELS["FL"]["brakeL"]["value"]   = appInsertLabel(appWindow, "--"   , "right" )
        WHEELS["FR"]["brakeL"]["value"]   = appInsertLabel(appWindow, "--"   , "left")
        WHEELS["RL"]["brakeL"]["value"]   = appInsertLabel(appWindow, "--"   , "right" )
        WHEELS["RR"]["brakeL"]["value"]   = appInsertLabel(appWindow, "--"   , "left")
        WHEELS["FL"]["brakeD"]["value"]   = appInsertLabel(appWindow, "--"   , "left" )
        WHEELS["FR"]["brakeD"]["value"]   = appInsertLabel(appWindow, "--"   , "right")
        WHEELS["RL"]["brakeD"]["value"]   = appInsertLabel(appWindow, "--"   , "left" )
        WHEELS["RR"]["brakeD"]["value"]   = appInsertLabel(appWindow, "--"   , "right")
        WHEELS["FL"]["brake"]["value"]    = appInsertLabel(appWindow, "--"   , "right" )
        WHEELS["FR"]["brake"]["value"]    = appInsertLabel(appWindow, "--"   , "left")
        WHEELS["RL"]["brake"]["value"]    = appInsertLabel(appWindow, "--"   , "right" )
        WHEELS["RR"]["brake"]["value"]    = appInsertLabel(appWindow, "--"   , "left")
        WHEELS["FL"]["load"]["value"]     = appInsertLabel(appWindow, "--"   , "left" )
        WHEELS["FR"]["load"]["value"]     = appInsertLabel(appWindow, "--"   , "right")
        WHEELS["RL"]["load"]["value"]     = appInsertLabel(appWindow, "--"   , "left" )
        WHEELS["RR"]["load"]["value"]     = appInsertLabel(appWindow, "--"   , "right")

        b_settings      = appInsertButton(appWindow       , "settings"          ,   40, -40,  90, 30, 16, onappSettings)
        b_resetMinMax   = appInsertButton(appWindow       , "reset"             ,  150, -35,  40, 25, 16, onappResetMinMax)
        b_maxs          = appInsertButton(appWindow       , "tyres & min/max"   ,  200, -35,  150, 25, 16, appclickBars)

        btnAppWidthUp   = appInsertButton(appSettingstyapp, "+"                 ,  70, 40, 39+10, 42, 16, appSizeWUp)
        btnAppWidthDn   = appInsertButton(appSettingstyapp, "size-"             ,  20, 40, 39+10, 42, 16, appSizeWDn)
        btnAppHeightDn  = appInsertButton(appSettingstyapp, "-"                 , 130, 50, 33+30, 39, 16, appSizeHDn)
        btnAppHeightUp  = appInsertButton(appSettingstyapp, "+"                 , 130, 10, 33+30, 39, 16, appSizeHUp)

        b_widthUp       = appInsertButton(appSettingstyapp, "+"                 , 201+40, 30, 33, 45, 16, appTyreWidthUp)
        b_widthDn       = appInsertButton(appSettingstyapp, "width-"            , 165+40, 30, 33, 45, 16, appTyreWidthDn)
        b_GAPSIZEUp     = appInsertButton(appSettingstyapp, "+"                 , 310+40, 30, 43, 45, 16, appGAPSIZEUp)
        b_GAPSIZEDn     = appInsertButton(appSettingstyapp, "wheelgap-"         , 260+40, 30, 43, 45, 16, appGAPSIZEDn)

        b_transpUp      = appInsertButton(appSettingstyapp, "+"                 , 416+40, 30, 33, 45, 16, appToggleTransparencyUp)
        b_transpDn      = appInsertButton(appSettingstyapp, "bg-"               , 380+40, 30, 33, 45, 16, appToggleTransparencyDn)
        b_transpFGUp    = appInsertButton(appSettingstyapp, "+    (pin\n      hidden?)",
                                                                                  506+40, -80+110, 25, 45, 16, appFGTransparencyUp, "left")
        b_transpFGDn    = appInsertButton(appSettingstyapp, "fg-"               , 470+40, 30, 33, 45, 16, appFGTransparencyDn)

        b_Reset         = appInsertButton(appSettingstyapp, "reset\ncurr"       , 100, 210, 50, 45, 16, appReset)
        b_color2        = appInsertButton(appSettingstyapp, "+"                 , 131, 270, 30, 65, 16, appToggleColor)
        b_color         = appInsertButton(appSettingstyapp, "-"                 , 100, 270, 30, 65, 16, appToggleColor2)
        b_MultUp        = appInsertButton(appSettingstyapp, "+"                 ,  51, 270, 30, 65, 16, appMultUp)
        b_MultDn        = appInsertButton(appSettingstyapp, "- mult"            ,  20, 270, 30, 65, 16, appMultDn)

        # 11 ############################################################################################################
        b_IMO        = appInsertButton(appSettingstyapp, "IMO"       ,20 ,    150, 38, 45, 16, apptoggleIMO)
        b_nm         = appInsertButton(appSettingstyapp, "Nm"        ,70 ,    150, 38, 45, 16, appToggleNM)
        btnCarcassText = appInsertButton(appSettingstyapp, "carcT"   ,120,    150, 38, 45, 16, appCarcassToggle)
        b_Vals       = appInsertButton(appSettingstyapp, "Text"      ,170+10,    150, 38, 45, 16, appValsToggle)
        b_less       = appInsertButton(appSettingstyapp, "less"      ,220+10,    150, 38, 45, 16, appToggleLess)
        b_wearT      = appInsertButton(appSettingstyapp, "wearT"     ,280+10,    150, 38, 45, 16, appwearTextToggle)
        b_SlipT      = appInsertButton(appSettingstyapp, "slipT"     ,330+10,    150, 38, 45, 16, appSlipTToggle)
        b_GripTextToggle= appInsertButton(appSettingstyapp, "gripTx" ,380+10,    150, 38, 45, 16, appGripTextToggle)
        b_aeroT      = appInsertButton(appSettingstyapp, "aeroT"     ,430+10,    150, 38, 45, 16, appaeroTextToggle)
        b_ShowBGText = appInsertButton(appSettingstyapp, "bgT"       ,480+10,    150, 38, 45, 16, appBGTextToggle)
        btn_AbsTc=     appInsertButton(appSettingstyapp, "AbsTc"     ,540+10,    150, 38, 45, 16, appabstctoggle)
        b_presstext  = appInsertButton(appSettingstyapp, "pressT"    ,590+20,    150, 38, 45, 16, apppressureText)
        b_presstoggle= appInsertButton(appSettingstyapp, "pressdiff" ,640+20,    150, 38, 45, 16, apppressdiffmode)
        # 11 ############################################################################################################
        b_nmbrake    = appInsertButton(appSettingstyapp, "Nm brake"  , 20,    100, 38, 45, 16, appToggleNMbrake)
        btnBRAKES    = appInsertButton(appSettingstyapp, "brake"     , 70,    100, 38, 45, 16, appBraketoggle)
        btnBrakeText = appInsertButton(appSettingstyapp, "brakeT"    ,120,    100, 38, 45, 16, appBrakeTextToggle)
        b_Load       = appInsertButton(appSettingstyapp, "load"      ,170+10,    100, 38, 45, 16, appLoadToggle)
        b_GapT       = appInsertButton(appSettingstyapp, "gap"       ,220+10,    100, 38, 45, 16, appGapToggle)
        b_wearG      = appInsertButton(appSettingstyapp, "wearG"     ,280+10,    100, 38, 45, 16, appwearBarToggle)
        b_SlipR      = appInsertButton(appSettingstyapp, "slipGraph" ,330+10,    100, 38, 45, 16, appSlipRToggle)
        b_GripToggle = appInsertButton(appSettingstyapp, "gripG"     ,380+10,    100, 38, 45, 16, appGripToggle)
        b_Aero       = appInsertButton(appSettingstyapp, "aeroG"     ,430+10,    100, 38, 45, 16, appAeroToggle)
        b_Camber     = appInsertButton(appSettingstyapp, "camb"      ,480+10,    100, 38, 45, 16, appCambToggle)
        btn_FBG      = appInsertButton(appSettingstyapp, "grain+"    ,540+10,    100, 38, 45, 16, appflgrbltoggle)
        btn_ShowPressure= appInsertButton(appSettingstyapp, "press"  ,590+20,    100, 38, 45, 16, apppressureenabled)
        btnPressureGraph= appInsertButton(appSettingstyapp, "pressG" ,640+20,    100, 38, 45, 16, apppressureGraph)

        btnSHOWHOTT  = appInsertButton(appSettingstyapp, "hotT"      ,640+20,    260, 38, 45, 16, appHotTtoggle)
        btnSHOWHOTG  = appInsertButton(appSettingstyapp, "hotG"      ,640+20,    210, 38, 45, 16, appHotGtoggle)


        b_IMOtext=     appInsertButton(appSettingstyapp, "imo txt"   , 20  ,    210, 68, 45, 16, appIMOTextToggle)

        btnRMORE      = appInsertButton(appSettingstyapp, "r"        , 330 ,    220, 34, 20, 16, appRMORE, "left")
        b_More       = appInsertButton(appSettingstyapp, "more"      , 440-250-5 ,    100+110, 38, 45, 16, appMoreToggle)
        b_Directions = appInsertButton(appSettingstyapp, "star"      , 480-250   ,    100+110, 38, 45, 16, appDirectionsToggle)
        btnMZ        = appInsertButton(appSettingstyapp, "MZ-G"      , 520-250+5 ,    100+110, 38, 45, 16, appMZtoggle)
        b_slipCircle = appInsertButton(appSettingstyapp, "slipC"     , 440-250-5 ,    150+115, 38, 45, 16, appToggleCircles)
        btnRadiuses  = appInsertButton(appSettingstyapp, "rad-G"     , 480-250   ,    150+115, 38, 45, 16, appRadiusesToggle)
        b_Travel     = appInsertButton(appSettingstyapp, "travel"    , 520-250+5 ,    150+115, 38, 45, 16, appTravelToggle)

        btnTOAppSizeUp = appInsertButton(appSettingstyapp, "+"       ,  30+310+20,-180+470, 29, 40, 16, appTOSizeUp)
        btnTOAppSizeDn = appInsertButton(appSettingstyapp, "size-"   ,   0+310+20,-180+470, 29, 40, 16, appTOSizeDn)
        btnMoveLeft  = appInsertButton(appSettingstyapp, "˂"         , -71+530+20,-120+420, 20, 20, 16, onMoveLeft )
        btnMoveRight = appInsertButton(appSettingstyapp, "˃"         , -29+530+20,-120+420, 20, 20, 16, onMoveRight)
        btnMoveUp    = appInsertButton(appSettingstyapp, "˄"         , -50+530+20,-130+420, 20, 20, 16, onMoveUp   )
        btnMoveDown  = appInsertButton(appSettingstyapp, "˅"         , -50+530+20,-110+420, 20, 20, 16, onMoveDown )
        btnTOWidthDn  = appInsertButton(appSettingstyapp, "˂"        , -91+530+20,-160+420, 20, 20, 16, onTOWidthDn)
        btnTOWidthUp  = appInsertButton(appSettingstyapp, "˃"        , -69+530+20,-160+420, 20, 20, 16, onTOWidthUp)
        btnTOHeigthDn = appInsertButton(appSettingstyapp, "˄"        , -30+530+20,-180+420, 20, 20, 16, onTOHeigthDn)
        btnTOHeightUp = appInsertButton(appSettingstyapp, "˅"        , -30+530+20,-160+420, 20, 20, 16, onTOHeightUp)


        btnFontMinus       = appInsertButton(appSettingstyapp, "-\nfont\nsegoe" ,  10, 420   , 39, 20, 16, toggleFontMinus, "left")
        btnFontPlus        = appInsertButton(appSettingstyapp, "+"              ,  50, 420   , 39, 20, 16, toggleFontPlus)
        btnFontSizeMinus   = appInsertButton(appSettingstyapp, "-"              , 120, 420   , 20, 29, 16, fontSizeMinus, "left")
        btnFontSizePlus    = appInsertButton(appSettingstyapp, "+"              , 120, 420+31, 20, 29, 16, fontSizePlus)
        btnFontOffsetMinus = appInsertButton(appSettingstyapp, "^"              , 260, 420   , 20, 29, 16, fontOffsetMinus, "left")
        btnFontOffsetPlus  = appInsertButton(appSettingstyapp, "v"              , 260, 420+31, 20, 29, 16, fontOffsetPlus)
        cbFancy            = appInsertCheckbox(appSettingstyapp, "fancy", int(bFancyMode)         , 400, 420+21, 50, 20, True, onFancyClick)
        cbToggleTextColor  = appInsertCheckbox(appSettingstyapp, "textcolor", int(bTextWhiteOnBlack), 450+60, 420+21, 50, 20, True, appToggleTextWhiteOnBlack)
        cbToggleImageset   = appInsertCheckbox(appSettingstyapp, "imgset", int(bImgSet), 450+60+100, 420+21, 50, 20, True, appToggleImgSet)

        ac.setFontAlignment(b_MultDn    , "left")
        ac.setFontAlignment(btnAppWidthDn, "left")
        ac.setFontAlignment(btnAppHeightUp, "left")
        ac.setFontAlignment(btnTOAppSizeDn, "left")
        ac.setFontAlignment(b_transpDn  , "left")
        ac.setFontAlignment(b_widthDn   , "left")
        ac.setFontAlignment(b_less      , "left")
        ac.setFontAlignment(b_IMO       , "right")
        ac.setFontAlignment(b_IMOtext   , "left")

        ac.setCustomFont(btnMoveLeft , "Consolas", 0, 0)
        ac.setCustomFont(btnMoveRight, "Consolas", 0, 0)
        ac.setCustomFont(btnMoveUp   , "Consolas", 0, 0)
        ac.setCustomFont(btnMoveDown , "Consolas", 0, 0)

        ac.setCustomFont(WHEELS["FL"]["dirt"], sCustomFontName, 0, 1)
        ac.setCustomFont(WHEELS["FR"]["dirt"], sCustomFontName, 0, 1)
        ac.setCustomFont(WHEELS["RL"]["dirt"], sCustomFontName, 0, 1)
        ac.setCustomFont(WHEELS["RR"]["dirt"], sCustomFontName, 0, 1)

        ac.addOnClickedListener(WHEELS["FL"]["pres"]["value"], appclickBars)
        ac.addOnClickedListener(WHEELS["RL"]["pres"]["value"], appclickBars)
        ac.addOnClickedListener(WHEELS["FR"]["pres"]["value"], apptogglePressureDisplay)
        ac.addOnClickedListener(WHEELS["RR"]["pres"]["value"], apptogglePressureDisplay)

        ac.addOnAppActivatedListener(appWindow       , appOnActivated)
        ac.addOnClickedListener     (appWindow       , on_click_app_window)
        ac.addOnClickedListener     (appInfo         , on_click_app_info)

        # ac.addRenderCallback        (lbCenter  , onFormRender)
        ac.addRenderCallback        (appWindow       , onFormRender)
        ac.addRenderCallback        (appSettingstyapp, onFormRenderSettings)

    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )


##############################################################################

def appSaveSettings():
    global settingsFilePath, gColor, gOpacity, gOpacityFG, gAppSizeW, gAppSizeH, tyregraphwidth, bShowGrip, TOAppSize, bCPhysBrakesEnabled
    global bShowTyreload, bShowTravel, bShowLocked, bShowSlipRect, bShowSlipText, offsetOMI, bShowCamber, bShowDirections, bShowMore, theemulti
    global TravelOffsetX, TravelOffsetY, bShowABS, bShowRadiuses, bShowBGText, bShowWearText, bShowWearGraph, bShowAeroText, bSHOWIMO, bShowGripText, bFlatBlistGrain
    global TOAppSize, TOoffsetx, TOoffsety, bShowAero, bShowVals, bShowNM, bShowNM_brake, bShowLess, gGAPSIZE, bShowCircles, bMz, bShowPressureDiff, bShowPressure, bSHOWIMOTEXT
    global bCSPactive, sCustomFontName, bFancyMode, fontOffsetY, fontSizeMult, bTextWhiteOnBlack, bShowPressureText
    global bPressureGraph, bCPhysCarcassEnabled, bCPhysBrakesText, brakestempsConfigured, bImgSet

    try:
        config = ConfigParser(empty_lines_in_values=False, strict=False, allow_no_value=True, inline_comment_prefixes=(";","#","/","_"), comment_prefixes=(";","#","/","_"))
        config.optionxform = str
        config.read(settingsFilePath)
        if not config.has_section('GENERAL'):
            config.add_section('GENERAL')
        if not config.has_section('COLORMULT'):
            config.add_section('COLORMULT')

        car = ac.getCarName(0)
        config['COLORMULT'][car] = str(round(theemulti,2))
        # config['GENERAL']['THEEMULTI'] = str(round(theemulti,1))

        # save stuff on exit
        config['GENERAL']['APPSIZE'] = str(round(gAppSizeW, 2))
        config['GENERAL']['APPSIZEHeight'] = str(round(gAppSizeH, 2))
        config['GENERAL']['APPGAP'] = str(bool(offsetOMI!=0.0))
        config['GENERAL']['GAPSIZE'] = str(int(gGAPSIZE))
        config['GENERAL']['WIDTH'] = str(round(tyregraphwidth, 2))
        config['GENERAL']['OPACITYBG'] = str(round(gOpacity  /100.0,1))
        config['GENERAL']['OPACITYFG'] = str(round(gOpacityFG/100.0,1))
        config['GENERAL']['SHOWABS'] = str(bool(bShowABS))
        config['GENERAL']['SHOWNM_TORQE'] = str(bool(bShowNM))
        config['GENERAL']['SHOWNM_BRAKE'] = str(bool(bShowNM_brake))
        config['GENERAL']['SLIP_RECT_TEXT_ENABLED'] = str(bool(bShowSlipText))
        config['GENERAL']['SLIP_RECT_ENABLED'] = str(bool(bShowSlipRect))
        config['GENERAL']['SHOWCIRCLES'] = str(bool(bShowCircles))
        config['GENERAL']['TYRELOAD_ENABLED'] = str(bool(bShowTyreload))
        config['GENERAL']['LOCK_ENABLED'] = str(bool(bShowLocked))
        config['GENERAL']['COLOR'] = str(gColor)
        config['GENERAL']['SHOWWEARTEXT'] = str(bool(bShowWearText))
        config['GENERAL']['SHOWAEROTEXT'] = str(bool(bShowAeroText))
        config['GENERAL']['SHOWAEROENABLED'] = str(bool(bShowAero))
        config['GENERAL']['SHOWWEARGRAPH'] = str(bool(bShowWearGraph))
        config['GENERAL']['SHOWBGTEXT'] = str(bool(bShowBGText))
        config['GENERAL']['SHOWVALS'] = str(bool(bShowVals))
        config['GENERAL']['DIRECTIONS_ENABLED'] = str(bool(bShowDirections))
        config['GENERAL']['CAMBER_ENABLED'] = str(bool(bShowCamber))
        config['GENERAL']['MOREOFFSETX'] = str(int(TravelOffsetX))
        config['GENERAL']['MOREOFFSETY'] = str(int(TravelOffsetY))
        config['GENERAL']['TRAVEL_ENABLED'] = str(bool(bShowTravel))
        config['GENERAL']['SHOWLESS'] = str(bool(bShowLess))
        config['GENERAL']['SHOWMORE'] = str(bool(bShowMore))
        config['GENERAL']['SHOWGRIP'] = str(bool(bShowGrip))
        config['GENERAL']['SHOWTEXTGRIP'] = str(bool(bShowGripText))
        config['GENERAL']['SHOW_IMO'] = str(bool(bSHOWIMO))
        config['GENERAL']['MORESIZE'] = str(round(TOAppSize, 2))
        config['GENERAL']['MOREWIDTH'] = str(round(TOoffsetx, 2))
        config['GENERAL']['MOREHEIGHT'] = str(round(TOoffsety, 2))
        config['GENERAL']['SHOWRADIUSES'] = str(bool(bShowRadiuses))
        config['GENERAL']['SHOWMZ'] = str(bool(bMz))
        config['GENERAL']['SHOWPRESSUREDIFF'] = str(bool(bShowPressureDiff))
        config['GENERAL']['SHOWPRESSURETEXT'] = str(bool(bShowPressureText))
        config['GENERAL']['PRESSURE'] = str(bool(bShowPressure))
        config['GENERAL']['PRESSUREGRAPHIC'] = str(bool(bPressureGraph))
        config['GENERAL']['FLATSPOTSGRAINBLISTER'] = str(bool(bFlatBlistGrain))
        config['GENERAL']['SHOW_TEMPS_IMO'] = str(bool(bSHOWIMOTEXT))
        config['GENERAL']['FANCYMODE'] = str(bool(bFancyMode))
        config['GENERAL']['fontName'] = sCustomFontName
        config['GENERAL']['fontSizeMult'] = str(round(fontSizeMult,2))
        config['GENERAL']['fontOffsetY'] = str(fontOffsetY)
        config['GENERAL']['TEXTCOLOR'] = str(bool(bTextWhiteOnBlack))
        config['GENERAL']['SHOWHOTGRAPHIC'] = str(bool(bSHOWHOTG))
        config['GENERAL']['SHOWHOTTEXT'] = str(bool(bSHOWHOTT))
        config['GENERAL']['CARCASSTEXT'] = str(bool(bCPhysCarcassText))
        config['GENERAL']['IMGSET'] = str(bool(bImgSet))
        #config['GENERAL']['PRESSID'] = str(gUnits["pressure"]).upper()
        #config['GENERAL']['TEMPID'] = str(gUnits["temp"]).upper()

        #if brakestempsConfigured:
        config['GENERAL']['BRAKES_ENABLED'] = str(bool(bCPhysBrakesEnabled))
        config['GENERAL']['BRAKESTEXT'] = str(bool(bCPhysBrakesText))

        with open(settingsFilePath, 'w') as configfile:
            config.write(configfile, space_around_delimiters=False)
    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )

def acShutdown():
    global bCSPactive, rtIndex1
    appSaveSettings()
    if bCSPactive and rtIndex1 != -1:
        ac.ext_disposeRenderTarget(rtIndex1)

def acMain(ac_version):
    global settingsFilePath, texture_soliddot, texture_dot, texture_circle, texture_rect, texture_rect_inner, appWindow, bCPhysicsActive, bCPhysCarcassEnabled, texture_circlefilled
    global gAppSizeW, gAppSizeH, tyregraphwidth, gOpacity, gOpacityFG, gColor, gUnits, bCPhysBrakesEnabled, bShowTyreload, bShowCamber, bShowDirections, bShowLocked, bShowSlipRect, bShowSlipText, bNewTyreParams, ac_isHot, bFlatBlistGrain, b_nm, b_nmbrake
    global cspCodeNo, texture_inner_top, texture_inner_bot, texture_outer_top, texture_outer_bot, bShowTravel, offsetOMI, bShowMore, theemulti, bCSPactive, bShowAero, bShowVals, bShowLess, bShowWearText, bShowBGText, bShowWearGraph
    global bShowNM_brake, bShowNM, f1, f2, hideTimer, b_GAPSIZEUp, b_GAPSIZEDn, gGAPSIZE, sCustomFontName, bShowCircles
    global bShowABS, bShowRadiuses, bShowAeroText, bShowPressureDiff, currPal, bShowPressure, bShowPressureText
    global TravelOffsetX, TravelOffsetY, bDAMPERsON, bHideTimerOn, appInfo, appSettingstyapp, bPressureGraph
    global bDRAG, bDOWNFORCE, bMz, bSHOWTYREINFO, bShowGrip, bWheelSpeedVSSlip, bSHOWIMO, bShowGripText, TOAppSize, TOoffsetx, TOoffsety
    global hideTimer, bActiveTimer, colorpng, customFonts, bFancyMode, fontSizeMult, bSHOWIMOTEXT, fontOffsetY
    global bTextWhiteOnBlack, bImgSet
    global bSHOWHOTG, bSHOWHOTT, bCPhysBrakesText, bCPhysCarcassText

    ac.log('---tyres_app_ext loading---')

    bCSPactive = True
    try:
        ac.initFont(0, sCustomFontName, 0, 1)
        ac.initFont(0, sCustomFontName2, 0, 1)

        customFonts = []
        findFonts('content\\fonts\\', '.ttf', customFonts)
        for i in range(len(customFonts)):
            ac.initFont(0, customFonts[i], 0, 1)

        f1 = FontMeasures(sCustomFontName, 0, 0, 1.25, 0.69, 0.629, 0.616, 0.066)
        f1.f = ac.ext_glFontCreate(f1.n, f1.s, f1.i, f1.b)
        f2 = FontMeasures(sCustomFontName2, 0, 1, 1.25, 0.69, 0.75, 0.5, 0.5)
        f2.f = ac.ext_glFontCreate(f2.n, f2.s, f2.i, f2.b)
    except:
        bCSPactive = False
        ac.log('tyre_app_ext: CustomShadersPatch not active., some features disabled.')

    try:
        texture_soliddot     = ac.newTexture("apps/python/tyres_app_ext/dotsolid.png")
        texture_circle       = ac.newTexture("apps/python/tyres_app_ext/circle.png")
        #texture_circle       = ac.newTexture("apps/python/tyres_app_ext/circlefilled.png")
        texture_circlefilled = ac.newTexture("apps/python/tyres_app_ext/circlefilled.png")
        texture_dot          = ac.newTexture("apps/python/tyres_app_ext/dot.png")
        texture_rect         = ac.newTexture("apps/python/tyres_app_ext/rect.png")
        texture_inner_top    = ac.newTexture("apps/python/tyres_app_ext/load_inner_top.png")
        texture_inner_bot    = ac.newTexture("apps/python/tyres_app_ext/load_inner_bot.png")
        texture_outer_top    = ac.newTexture("apps/python/tyres_app_ext/load_outer_top.png")
        texture_outer_bot    = ac.newTexture("apps/python/tyres_app_ext/load_outer_bot.png")
        texture_rect_inner   = ac.newTexture("apps/python/tyres_app_ext/rect_inner.png")
        colorpng             = ac.newTexture("apps/python/tyres_app_ext/colors.png")
    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )

    try:
        configdefault = ConfigParser(empty_lines_in_values=False, strict=False, allow_no_value=True, inline_comment_prefixes=(";","#","/","_",","), comment_prefixes=(";","#","/","_",","))
        configdefault.optionxform = str
        configdefault.read(settingsDefFilePath)

        config = ConfigParser(empty_lines_in_values=False, strict=False, allow_no_value=True, inline_comment_prefixes=(";","#","/","_",","), comment_prefixes=(";","#","/","_",","))
        config.optionxform = str
        if os.path.isfile(settingsFilePath):
            with open(settingsFilePath, "r", encoding="utf-8", errors="ignore") as F:
                config.read_string("[ACHEADER]\n" + F.read().encode('ascii', 'ignore').decode('ascii'))
                config.remove_section("ACHEADER")

        ##config.read(settingsFilePath)

        carname = ac.getCarName(0)
        theemulti = float( getSetting(configdefault, config, 'GENERAL'  , 'THEEMULTI', str( theemulti )) )
        theemulti = float( getSetting(None         , config, 'COLORMULT', carname    , str( theemulti )) )

        gAppSizeW               = float(           getSetting(configdefault, config, 'GENERAL', 'APPSIZE'        , gAppSizeW                ) )
        gAppSizeH               = float(           getSetting(configdefault, config, 'GENERAL', 'APPSIZEHeight'  , gAppSizeH                ) )
        fontSizeMult            = float(           getSetting(configdefault, config, 'GENERAL', 'fontSizeMult'    , fontSizeMult            ) )
        gUnits["temp"]          = str(             getSetting(configdefault, config, 'GENERAL', 'TEMPID'          , gUnits['temp']          ) ).upper()
        gUnits["pressure"]      = str(             getSetting(configdefault, config, 'GENERAL', 'PRESSID'         , gUnits['pressure']      ) ).upper()
        tyregraphwidth          = float(           getSetting(configdefault, config, 'GENERAL', 'WIDTH', str( tyregraphwidth )) )
        gOpacity                = int( 100 * float(getSetting(configdefault, config, 'GENERAL', 'OPACITYBG', str( gOpacity  ) ) ) )
        #ac.log("gOpacityFG a " + str(gOpacityFG))
        gOpacityFG              = int( 100 * float(getSetting(configdefault, config, 'GENERAL', 'OPACITYFG', str( gOpacityFG) ) ) )
        #ac.log("gOpacityFG b " + str(gOpacityFG))
        #                                                                     config['GENERAL']['OPACITYBG'] = str(round(gOpacity  /100.0,1))
        #                                                                     config['GENERAL']['OPACITYFG'] = str(round(gOpacityFG/100.0,1))
        gColor                  = int(             getSetting(configdefault, config, 'GENERAL', 'COLOR', str(gColor)) )
        gGAPSIZE                = int(             getSetting(configdefault, config, 'GENERAL', 'GAPSIZE', str( gGAPSIZE )) )
        TravelOffsetX           = int(             getSetting(configdefault, config, 'GENERAL', 'MOREOFFSETX', str( TravelOffsetX ) ) )
        TravelOffsetY           = int(             getSetting(configdefault, config, 'GENERAL', 'MOREOFFSETY', str( TravelOffsetY ) ) )
        fontOffsetY             = int(             getSetting(configdefault, config, 'GENERAL', 'fontOffsetY', str(fontOffsetY) ) )
        bShowTyreload           = str2bool (       getSetting(configdefault, config, 'GENERAL', 'TYRELOAD_ENABLED', str( bShowTyreload) ))
        bShowCamber             = str2bool (       getSetting(configdefault, config, 'GENERAL', 'CAMBER_ENABLED', str( bShowCamber) ))
        bShowDirections         = str2bool (       getSetting(configdefault, config, 'GENERAL', 'DIRECTIONS_ENABLED', str( bShowDirections) ))
        bShowSlipRect           = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SLIP_RECT_ENABLED', str( bShowSlipRect) ))
        bShowSlipText           = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SLIP_RECT_TEXT_ENABLED', str( bShowSlipText) ))
        bShowLocked             = str2bool (       getSetting(configdefault, config, 'GENERAL', 'LOCK_ENABLED', str( bShowLocked) ))
        bShowTravel             = str2bool (       getSetting(configdefault, config, 'GENERAL', 'TRAVEL_ENABLED', str( bShowTravel) ))
        bShowAero               = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWAEROENABLED', str( bShowAero) ))
        bShowMore               = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWMORE', str( bShowMore) ))
        bShowVals               = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWVALS', str( bShowVals) ))
        bShowNM                 = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWNM_TORQE', str( bShowNM) ))
        bShowNM_brake           = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWNM_BRAKE', str( bShowNM_brake) ))
        bShowCircles            = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWCIRCLES', str( bShowCircles) ))
        bShowLess               = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWLESS', str( bShowLess) ))
        bShowWearGraph          = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWWEARGRAPH', str( bShowWearGraph) ))
        bShowWearText           = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWWEARTEXT', str( bShowWearText) ))
        bShowAeroText           = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWAEROTEXT', str( bShowAeroText) ))
        bShowBGText             = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWBGTEXT', str( bShowBGText) ))

        bCPhysBrakesEnabled     = str2bool (       getSetting(configdefault, config, 'GENERAL', 'BRAKES_ENABLED', str( bCPhysBrakesEnabled ) ) )
        bCPhysBrakesText        = str2bool (       getSetting(configdefault, config, 'GENERAL', 'BRAKESTEXT', str( bCPhysBrakesText ) ) )

        bCPhysCarcassEnabled    = str2bool (       getSetting(configdefault, config, 'GENERAL', 'CARCASSTEMP_ENABLED', str( bCPhysCarcassEnabled ) ) )
        bCPhysCarcassText       = str2bool (       getSetting(configdefault, config, 'GENERAL', 'CARCASSTEXT', str( bCPhysCarcassText ) ) )
        bShowABS                = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWABS', str( bShowABS ) ) )
        bShowRadiuses           = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWRADIUSES', str( bShowRadiuses ) ) )
        bShowPressure           = str2bool (       getSetting(configdefault, config, 'GENERAL', 'PRESSURE', str( bShowPressure ) ) )
        bShowPressureDiff       = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWPRESSUREDIFF', str( bShowPressureDiff ) ) )
        bShowPressureText       = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWPRESSURETEXT', str( bShowPressureText ) ) )
        bShowGrip               = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWGRIP', str( bShowGrip ) ) )
        bShowGripText           = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWTEXTGRIP', str( bShowGripText ) ) )
        bWheelSpeedVSSlip       = str2bool (       getSetting(configdefault, config, 'GENERAL', 'WheelSpeedVSSlip', str( bWheelSpeedVSSlip ) ) )
        bDRAG                   = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWDRAG', str( bDRAG ) ) )
        bDOWNFORCE              = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWDOWNFORCE', str( bDOWNFORCE ) ) )
        bMz                     = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWMZ', str( bMz ) ) )
        bSHOWIMO                = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOW_IMO', str( bSHOWIMO ) ) )
        bSHOWIMOTEXT            = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOW_TEMPS_IMO', str( bSHOWIMOTEXT ) ) )
        bFlatBlistGrain         = str2bool (       getSetting(configdefault, config, 'GENERAL', 'FLATSPOTSGRAINBLISTER', str(bFlatBlistGrain) ) )
        bSHOWTYREINFO           = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWTYREINFO', str( bSHOWTYREINFO ) ) )
        bTextWhiteOnBlack       = str2bool (       getSetting(configdefault, config, 'GENERAL', 'TEXTCOLOR'       , str(bTextWhiteOnBlack) ) )
        bSHOWHOTG               = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWHOTGRAPHIC', str( bSHOWHOTG) ) )
        bSHOWHOTT               = str2bool (       getSetting(configdefault, config, 'GENERAL', 'SHOWHOTTEXT', str(bSHOWHOTT) ) )
        bImgSet                 = str2bool (       getSetting(configdefault, config, 'GENERAL', 'IMGSET', str(bImgSet) ) )

        bPressureGraph          = str2bool (       getSetting(configdefault, config, 'GENERAL', 'PRESSUREGRAPHIC', str( bPressureGraph ) ) )
        if bCSPactive:
            bFancyMode          = str2bool (       getSetting(configdefault, config, 'GENERAL', 'FANCYMODE'       , str(bFancyMode) ) )
        else:
            bFancyMode          = False

        sCustomFontName         = getSetting(configdefault, config, "GENERAL", "fontName", "Segoe UI")
        if not sCustomFontName in customFonts:
            sCustomFontName = "Segoe UI"

        if bCSPactive:
            f1 = FontMeasures(sCustomFontName, 0, 0, 1.25, 0.69, 0.629, 0.616, 0.066)
            f1.f = ac.ext_glFontCreate(f1.n, f1.s, f1.i, f1.b)
            f2 = FontMeasures(sCustomFontName2, 0, 1, 1.25, 0.69, 0.75, 0.5, 0.5)
            f2.f = ac.ext_glFontCreate(f2.n, f2.s, f2.i, f2.b)

        # ac.log("fnt: " + sCustomFontName)
        # ac.log("f1: " + str(f1))
        # ac.log("f2: " + str(f2))
        appGap = False
        appGap                  = str2bool(        getSetting(configdefault, config, 'GENERAL', 'APPGAP', appGap) )
        #if appGap:
        #    offsetOMI  = 0.02

        TOAppSize = float ( getSetting(configdefault, config, 'GENERAL', 'MORESIZE', str(float(TOAppSize))) )
        TOoffsetx = float ( getSetting(configdefault, config, 'GENERAL', 'MOREWIDTH', str(float(TOoffsetx))) )
        TOoffsety = float ( getSetting(configdefault, config, 'GENERAL', 'MOREHEIGHT', str(float(TOoffsety))) )

        currPal = globals()['colorPal'+str(gColor+1)]
    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )

    try:
        bCPhysicsActive = False
        bCPhysicsActive = ac.ext_isExtendedPhysics()
        if bCPhysicsActive:
            bNewTyreParams = True

        cspCodeNo = int(ac.ext_patchVersionCode())
        if cspCodeNo < 1386:
            bCPhysCarcassEnabled = False
        if cspCodeNo < 1430:
            bShowTravel = False
        if cspCodeNo < 1553:
            bShowNM=False
            bShowNM_brake=False
        if cspCodeNo <= 1958 or not 'ext_getDamperTravel' in dir(ac): # turn dampers off for old version with all values = FL
            bDAMPERsON = False
        else:
            bDAMPERsON = True
    except:
        # bCPhysBrakesEnabled = False
        ac.log('tyre_app_ext: ExtendedPhysics not available for this car, carcass temp not available')
        # ac.log('tyre_app_ext: ' + traceback.format_exc() )

    if not "ext_getBrakeCoreTemp" in dir(ac):
        bCoreTempsEnabled=False

    try:
        t1 = time.time()
        appWindow   = ac.newApp("tyres_app_ext")
        appInfo     = ac.newApp("tyres_app_ext data")
        appSettingstyapp = ac.newApp("tyres_app_ext settings")
        ac.drawBorder(appSettingstyapp, 1)
        ac.setBackgroundOpacity(appSettingstyapp, 50)
        ac.setSize(appSettingstyapp, 710, 490)

        appCreate()
        appHideButtons()
        appResize()
        appResetGo()
        if bSHOWTYREINFO:
            ac.setVisible(appInfo,1)
        ac.log('---tyres_app_ext app loaded---')
        ac.log('tyres_app_loading: ' + str(round(time.time()-t1,3))+'sec')
    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )

    #hideTimer    = 0.25
    #bActiveTimer = True
    return "tyres_app_ext"

def appResize():
    global appWindow, gAppSizeW, gAppSizeH, lbCenter, lbCenter2, lbInfo, lbInfo2, bCPhysicsActive, bCPhysCarcassEnabled, hw, hh, compNameShort, hideTimer, gUnits, settingsFilePath, gOpacity, gColor
    global fntSize, offsetPercent, tyregraphwidth, offsetOMI
    global colorPal1, colorPal2, colorPal3, colorPal4, colorPal5, colorPal6, currPal, bShowTyreload, minwidth, minheight, offset, sDesc
    global sCustomFontName, bHideTimerOn, bCPhysBrakesEnabled, gGAPSIZE, tirenameLong, lbAero, lbAero2
    global TravelOffsetX, TravelOffsetY, gOpacityFG, bShowLess, bShowWearText, bShowWearGraph
    global WHEELS, wheels, appInfo, bShowPressureDiff, bShowPressure, bShowVals, bShowPressureText
    global TOoffset, TOAppSize, TOoffsetx, TOoffsety, TOfntSize, TOhw, TOhh, TOminwidth, TOminheight, TOGAPSIZE
    global bFancyMode, bCSPactive, fontSizeMult, fontOffsetYRear, rtIndex1, marginX, marginY, bPressureGraph, bTextWhiteOnBlack
    global Berror
    global tSurfRL, tSurfFL, tSurfRM, tSurfFM, tSurfRR, tSurfFR, tCarcassR, tCarcassF, tCoreCarcassR, tCoreCarcassF, tCoreF, tCoreR
    try:
        cbFancy
        w           = 240 * gAppSizeW
        h           = 240 * gAppSizeH
        fontOffsetYRear=0
        #if not bShowPressure:
            #fontOffsetYRear += 240 * gAppSizeH/7
            #h -= 240 * gAppSizeH/7
        if not bShowVals:
            fontOffsetYRear += 240 * gAppSizeH/7
            h -= 240 * gAppSizeH/7
        if bSHOWIMOTEXT and bSHOWIMO and bFancyMode:
            fontOffsetYRear += 240 * gAppSizeH/7
            h -= 240 * gAppSizeH/7

        if (bShowMore or bShowTravel) and ((TravelOffsetX>=0 or TravelOffsetY>=0) and gOpacity>0):
            if TravelOffsetY>=0:
                ac.setSize(appWindow, w + TravelOffsetX, h + TravelOffsetY)
            else:
                ac.setSize(appWindow, w + TravelOffsetX, h)
        else:
            ac.setSize(    appWindow, w,                 h)

        if bCSPactive and bFancyMode:
            marginX = 400*gAppSizeW
            marginY = 400*gAppSizeH
        else:
            marginX = 0
            marginY = 0

        if bCSPactive and bFancyMode:
            try:
                if rtIndex1 > -1:
                    ac.ext_disposeRenderTarget(rtIndex1)
                #ac.log('came here ' + str(w) + '   ' + str(h) )
                # create memory image
                rtIndex1 = ac.ext_createRenderTarget(int(w+marginX*2), int(h+marginY*2), False)
            except:
                Berror = True


        if bFancyMode and bCSPactive:
            offgap      = hw*offsetOMI
            fntSize     = 12 * fontSizeMult
            hw          = w/2 # half width
            hh          = h/2 # half height
            minwidth    = hw*0.75 # *graphwidth # -offset
            minwidthOIM = minwidth/3
            offset      = hw*offsetPercent*0.75 # graphwidth
            minheight   = hw/3.25
        else:
            offgap      = hw*offsetOMI
            fntSize     = 12 * fontSizeMult
            hw          = w/2 # half width
            hh          = h/2 # half height
            minwidth    = hw*tyregraphwidth # -offset
            minwidthOIM = minwidth/3
            offset      = hw*offsetPercent*tyregraphwidth + gGAPSIZE
            minheight   = hw/3.25

        # TOAppSize=gAppSizeW
        TOw           = 240 * gAppSizeW
        TOh           = 240 * gAppSizeH

        TOfntSize      = 12*TOAppSize - (TOAppSize*2)
        TOhw           = TOw/2
        TOhh           = TOh/2
        TOminwidth     = TOhw*tyregraphwidth
        TOminheight    = TOhw/3.25
        TOoffset       = TOhw*offsetPercent*tyregraphwidth # + TOoffsetx/4
        # TOoffsetx      = TOhw*offsetPercent*TOgraphwidth  + TOGAPSIZE
        # TOoffsety      = TOhh*offsetPercent*TOgraphwidth  + TOGAPSIZE

        bold=1
        #bold=0
        fontmulti=1.8
        if bCPhysicsActive and bCPhysCarcassEnabled:
            fontmulti=1.75 # for temp
            if sCustomFontName!="Arial" and sCustomFontName!="Strait":
            #if sCustomFontName=="Digital-7" or sCustomFontName=="Ticking Timebomb BB":
                fontmulti=2
                bold=0



        if gOpacity <= 10:
            ac.setBackgroundOpacity(appWindow, 0 )
            ac.drawBorder(appWindow, 0)

        # if bFancyMode and bCSPactive:
        #     ac.setPosition(lbCenter,-1,hh*2)
        # else:
        #     ac.setPosition(lbCenter,1,-1)
        ac.setPosition(lbCenter ,-fntSize*5  ,hh*2+fntSize*1.2  )
        ac.setPosition(lbCenter2,-fntSize*5+1,hh*2+fntSize*1.2+1)
        ac.setSize(lbCenter ,w+fntSize*10,fntSize*4)
        ac.setSize(lbCenter2,w+fntSize*10,fntSize*4)
        ac.setFontSize(lbCenter,fntSize*1.5)
        ac.setFontSize(lbCenter2,fntSize*1.5)

        ac.setFontAlignment(lbCenter,"center")
        ac.setFontAlignment(lbCenter2,"center")
        if not bTextWhiteOnBlack:
            ac.setFontColor(lbCenter2, 1,1,1, gOpacityFG/100)
            ac.setFontColor(lbCenter , 0,0,0, gOpacityFG/100)
            ac.setFontColor(lbInfo   , 0,0,0, gOpacityFG/100)
            ac.setFontColor(lbInfo2  , 0,0,0, gOpacityFG/100)
            ac.setFontColor(lbAero   , 0,0,0, gOpacityFG/100)
            ac.setFontColor(lbAero2  , 1,1,1, gOpacityFG/100)
        else:
            ac.setFontColor(lbCenter2, 0,0,0, gOpacityFG/100)
            ac.setFontColor(lbCenter , 1,1,1, gOpacityFG/100)
            ac.setFontColor(lbInfo   , 1,1,1, gOpacityFG/100)
            ac.setFontColor(lbInfo2  , 1,1,1, gOpacityFG/100)
            ac.setFontColor(lbAero   , 1,1,1, gOpacityFG/100)
            ac.setFontColor(lbAero2  , 0,0,0, gOpacityFG/100)



        ###### second text window
        # ac.setSize(appInfo, w*1.35*fntSize/10, fntSize*27)
        if not bCSPactive:
            localfact=22
        else:
            localfact=28
        if bCPhysCarcassEnabled:
            localfact+=2
        if bDAMPERsON:
            localfact+=2
        if SuspensionForceEnabled:
            localfact+=2

        ac.setSize(appInfo, (w*1.35*fntSize/10)*1.9, fntSize*(localfact+3))
        ac.setPosition(         lbInfo,10,30)
        ac.setSize(             lbInfo,w,h+fntSize*2)
        ac.setFontSize(         lbInfo,fntSize*1.35)
        ac.setFontAlignment(    lbInfo,"left")
        ac.setFontColor(        lbInfo, 1, 1, 1, 1)
        ac.setBackgroundOpacity(lbInfo, 0) # max(0, gOpacity/100-0.1))

        ac.setPosition(         lbInfo2,(w*1.35*fntSize/10)-50,30)
        ac.setSize(             lbInfo2,w,h+fntSize*2)
        ac.setFontSize(         lbInfo2,fntSize*1.35)
        ac.setFontAlignment(    lbInfo2,"left")
        ac.setFontColor(        lbInfo2, 1, 1, 1, 1)

        ac.setSize(         lbTimer, w*0.05, fntSize)
        # ac.setPosition(     lbTimer, w*1.15, fntSize*4.5)
        ac.setPosition(     lbTimer, w*1.15, fntSize*2.5)
        ac.setFontSize(     lbTimer, fntSize*1.5)
        ac.setFontColor(    lbTimer, 1, 1, 1, 1)
        ac.setFontAlignment(lbTimer,"right")
        ######

        if bShowAeroText:
            ac.setPosition(lbAero ,1  ,-fntSize*7.9  )
            ac.setPosition(lbAero2,1+1,-fntSize*7.9+1)
            ac.setSize(lbAero     ,w  , fntSize*8  )
            ac.setSize(lbAero2    ,w  , fntSize*8  )

            ac.setFontSize(lbAero,fntSize*0.9)
            ac.setFontAlignment(lbAero,"center")
            ac.setBackgroundOpacity(lbAero, 0) # max(0, gOpacity/100-0.1))
            ac.setVisible(lbAero, 1)

            if not bTextWhiteOnBlack:
                ac.setFontColor(lbAero2, 1,1,1, gOpacityFG/100)
                ac.setFontColor(lbAero , 0,0,0, gOpacityFG/100)
            else:
                ac.setFontColor(lbAero , 1,1,1, gOpacityFG/100)
                ac.setFontColor(lbAero2, 0,0,0, gOpacityFG/100)

            ac.setFontSize(lbAero2,fntSize*0.9)
            ac.setFontAlignment(lbAero2,"center")
            ac.setBackgroundOpacity(lbAero2, 0) # max(0, gOpacity/100-0.1))
            ac.setVisible(lbAero2, 1)
        else:
            ac.setVisible(lbAero, 0)
            ac.setVisible(lbAero2, 0)

        spaces1=''
        spaces2=''
        spaces3=''
        if tyregraphwidth>0.75:
            for i in range(int(tyregraphwidth/0.75), int(tyregraphwidth/0.75*5)): # starting from 0.75 as 100%
                spaces1=spaces1+" " # O
            for i in range(int(tyregraphwidth/0.75), int(tyregraphwidth/0.75*5)): # starting from 0.75 as 100%
                spaces2=spaces2+" " # M
            for i in range(int(tyregraphwidth/0.75), int(tyregraphwidth/0.75*8)): # starting from 0.75 as 100%
                spaces3=spaces3+" " # I
        else:
            spaces1+=" " # O
            spaces2+=" " # M
            spaces3+=" " # I
            # for i in range(int(graphwidth/0.75), int(graphwidth/0.75*5-1)): # starting from 0.75 as 100%
            #     spaces1+=" " # O
            # for i in range(int(graphwidth/0.75), int(graphwidth/0.75*5-1)): # starting from 0.75 as 100%
            #     spaces2+=" " # M
            # for i in range(int(graphwidth/0.75), int(graphwidth/0.75*8-1)): # starting from 0.75 as 100%
            #     spaces3+=" " # I

        if bCPhysicsActive and bCPhysCarcassEnabled:
            if gUnits["temp"] == "C":
                sDesc = "O"+spaces1+"M"+spaces2+"I"+spaces3+"^"+spaces3+"I"+spaces2+"M"+spaces1+"O\nfront\nCarcass\n°C\nCORE\nTyres: " + tirenameLong + "\nCORE\n°C\nCarcass\nrear\nO"+spaces1+"M"+spaces2+"I"+spaces3+"⌄"+spaces3+"I"+spaces2+"M"+spaces1+"O"
            else:
                sDesc = "O"+spaces1+"M"+spaces2+"I"+spaces3+"^"+spaces3+"I"+spaces2+"M"+spaces1+"O\nfront\nCarcass\n°F\nCORE\nTyres: " + tirenameLong + "\nCORE\n°F\nCarcass\nrear\nO"+spaces1+"M"+spaces2+"I"+spaces3+"⌄"+spaces3+"I"+spaces2+"M"+spaces1+"O"
        else:
            if gUnits["temp"] == "C":
                sDesc = "O"+spaces1+"M"+spaces2+"I"+spaces3+"^"+spaces3+"I"+spaces2+"M"+spaces1+"O\nfront\n°C\nCORE\n\nTyres: "        + tirenameLong + "\n\nCORE\n°C\nrear\nO"+spaces1+"M"+spaces2+"I"+spaces3+"⌄"+spaces3+"I"+spaces2+"M"+spaces1+"O"
            else:
                sDesc = "O"+spaces1+"M"+spaces2+"I"+spaces3+"^"+spaces3+"I"+spaces2+"M"+spaces1+"O\nfront\n°F\nCORE\n\nTyres: "        + tirenameLong + "\n\nCORE\n°F\nrear\nO"+spaces1+"M"+spaces2+"I"+spaces3+"⌄"+spaces3+"I"+spaces2+"M"+spaces1+"O"
        ac.setText(lbCenter, sDesc)
        ac.setText(lbCenter2, sDesc)
        # ac.setTitle(appInfo, sDesc)

        ac.setText(WHEELS["FL"]["brake"]["value"], "")
        ac.setText(WHEELS["FR"]["brake"]["value"], "")
        ac.setText(WHEELS["RL"]["brake"]["value"], "")
        ac.setText(WHEELS["RR"]["brake"]["value"], "")

        #############################################
        for wheel in wheels:
            if bFancyMode and bCSPactive:
                ac.setVisible(WHEELS[wheel]["temp"]["value"]  , 0) # hide "tyre core temps colors"
                ac.setVisible(WHEELS[wheel]["tempc"]["value"] , 0) # hide "tyre core temps colors"
                ac.setVisible(WHEELS[wheel]["ctemp"]["value"] , 0) # hide "tyre carcass temps values"
                ac.setVisible(WHEELS[wheel]["ctmpc"]["value"] , 0) # hide "tyre carcass temps color color"
                ac.setVisible(WHEELS[wheel]["tempO"]["value"] , 0) # hide "tyre core temps colors"
                ac.setVisible(WHEELS[wheel]["tempM"]["value"] , 0) # hide "tyre carcass temps values"
                ac.setVisible(WHEELS[wheel]["tempI"]["value"] , 0) # hide "tyre carcass temps color color"
            else:
                ac.setVisible(WHEELS[wheel]["temp"]["value"]  , 1) # hide "tyre core temps colors"
                ac.setVisible(WHEELS[wheel]["tempc"]["value"] , 1) # hide "tyre core temps colors"
                ac.setVisible(WHEELS[wheel]["ctemp"]["value"] , 1) # hide "tyre carcass temps values"
                ac.setVisible(WHEELS[wheel]["ctmpc"]["value"] , 1) # hide "tyre carcass temps color color"
                ac.setVisible(WHEELS[wheel]["tempO"]["value"] , 1) # hide "tyre core temps colors"
                ac.setVisible(WHEELS[wheel]["tempM"]["value"] , 1) # hide "tyre carcass temps values"
                ac.setVisible(WHEELS[wheel]["tempI"]["value"] , 1) # hide "tyre carcass temps color color"

        if bCPhysBrakesEnabled and brakestempsConfigured:
            add = 0
            if bSHOWIMOTEXT:
                add = fntSize*1.2
            if bFancyMode and bCSPactive:
                ac.setPosition(WHEELS["FL"]["brake"]["value"]   , hw - offset                ,                                 hh*0.2  )
                ac.setPosition(WHEELS["FR"]["brake"]["value"]   , hw + offset - hw*0.1-offgap,                                 hh*0.2  )
                ac.setPosition(WHEELS["RL"]["brake"]["value"]   , hw - offset                ,  hh+hh*0.25+fntSize*2-fontOffsetYRear/2 +add/2)
                ac.setPosition(WHEELS["RR"]["brake"]["value"]   , hw + offset - hw*0.1-offgap,  hh+hh*0.25+fntSize*2-fontOffsetYRear/2 +add/2)

                ac.setPosition(WHEELS["FL"]["brakeD"]["value"]  , hw - offset                ,  0                             )
                ac.setPosition(WHEELS["FR"]["brakeD"]["value"]  , hw + offset - hw*0.1-offgap,  0                             )
                ac.setPosition(WHEELS["RL"]["brakeD"]["value"]  , hw - offset                ,  hh+fntSize*2-fontOffsetYRear/2 +add)
                ac.setPosition(WHEELS["RR"]["brakeD"]["value"]  , hw + offset - hw*0.1-offgap,  hh+fntSize*2-fontOffsetYRear/2 +add)

                ac.setPosition(WHEELS["FL"]["brakeL"]["value"]  , hw - offset                ,     0                   )
                ac.setPosition(WHEELS["FR"]["brakeL"]["value"]  , hw + offset - hw*0.1-offgap,     0                   )
                ac.setPosition(WHEELS["RL"]["brakeL"]["value"]  , hw - offset                ,  hh+fntSize*2-fontOffsetYRear/2)
                ac.setPosition(WHEELS["RR"]["brakeL"]["value"]  , hw + offset - hw*0.1-offgap,  hh+fntSize*2-fontOffsetYRear/2)
            else:
                ac.setPosition(WHEELS["FL"]["brake"]["value"]   , hw - offset                ,     minheight/2)
                ac.setPosition(WHEELS["FR"]["brake"]["value"]   , hw + offset - hw*0.1-offgap,     minheight/2)
                ac.setPosition(WHEELS["RL"]["brake"]["value"]   , hw - offset                ,  hh+fntSize*2-fontOffsetYRear/2 +add)
                ac.setPosition(WHEELS["RR"]["brake"]["value"]   , hw + offset - hw*0.1-offgap,  hh+fntSize*2-fontOffsetYRear/2 +add)
                ac.setPosition(WHEELS["FL"]["brakeD"]["value"]  , hw - offset                ,     minheight  )
                ac.setPosition(WHEELS["FR"]["brakeD"]["value"]  , hw + offset - hw*0.1-offgap,     minheight  )
                ac.setPosition(WHEELS["RL"]["brakeD"]["value"]  , hw - offset                ,  hh+fntSize*2-fontOffsetYRear/2 +add)
                ac.setPosition(WHEELS["RR"]["brakeD"]["value"]  , hw + offset - hw*0.1-offgap,  hh+fntSize*2-fontOffsetYRear/2 +add)
                ac.setPosition(WHEELS["FL"]["brakeL"]["value"]  , hw - offset                ,     minheight/2)
                ac.setPosition(WHEELS["FR"]["brakeL"]["value"]  , hw + offset - hw*0.1-offgap,     minheight/2)
                ac.setPosition(WHEELS["RL"]["brakeL"]["value"]  , hw - offset                ,  hh+fntSize*2-fontOffsetYRear/2)
                ac.setPosition(WHEELS["RR"]["brakeL"]["value"]  , hw + offset - hw*0.1-offgap,  hh+fntSize*2-fontOffsetYRear/2)
        else:
            ac.setPosition(WHEELS["FL"]["brake"]["value"]  , -20000, -20000)
            ac.setPosition(WHEELS["FR"]["brake"]["value"]  , -20000, -20000)
            ac.setPosition(WHEELS["RL"]["brake"]["value"]  , -20000, -20000)
            ac.setPosition(WHEELS["RR"]["brake"]["value"]  , -20000, -20000)
            ac.setPosition(WHEELS["FL"]["brakeD"]["value"] , -20000, -20000)
            ac.setPosition(WHEELS["FR"]["brakeD"]["value"] , -20000, -20000)
            ac.setPosition(WHEELS["RL"]["brakeD"]["value"] , -20000, -20000)
            ac.setPosition(WHEELS["RR"]["brakeD"]["value"] , -20000, -20000)
            ac.setPosition(WHEELS["FL"]["brakeL"]["value"] , -20000, -20000)
            ac.setPosition(WHEELS["FR"]["brakeL"]["value"] , -20000, -20000)
            ac.setPosition(WHEELS["RL"]["brakeL"]["value"] , -20000, -20000)
            ac.setPosition(WHEELS["RR"]["brakeL"]["value"] , -20000, -20000)


        if bSHOWIMO:
            # minheight = minheight
            # o/m/i tyre values
            ac.setPosition(WHEELS["FL"]["tempO"]["value"] , hw - minwidth - offset                 , 0)
            ac.setPosition(WHEELS["FR"]["tempO"]["value"] , hw + offset + minwidthOIM*2            , 0)
            ac.setPosition(WHEELS["RL"]["tempO"]["value"] , hw - minwidth - offset                 , h-minheight-offgap-1)
            ac.setPosition(WHEELS["RR"]["tempO"]["value"] , hw + offset + minwidthOIM*2            , h-minheight-offgap-1)
            # m
            ac.setPosition(WHEELS["FL"]["tempM"]["value"] , hw - minwidth + minwidthOIM  - offset  , 0)
            ac.setPosition(WHEELS["FR"]["tempM"]["value"] , hw + offset + minwidthOIM              , 0)
            ac.setPosition(WHEELS["RL"]["tempM"]["value"] , hw - minwidth + minwidthOIM  - offset  , h-minheight-offgap-1)
            ac.setPosition(WHEELS["RR"]["tempM"]["value"] , hw + offset + minwidthOIM              , h-minheight-offgap-1)
            # i
            ac.setPosition(WHEELS["FL"]["tempI"]["value"] , hw - minwidth + minwidthOIM*2 - offset , 0)
            ac.setPosition(WHEELS["FR"]["tempI"]["value"] , hw + offset                            , 0)
            ac.setPosition(WHEELS["RL"]["tempI"]["value"] , hw - minwidth + minwidthOIM*2 - offset , h-minheight-offgap-1)
            ac.setPosition(WHEELS["RR"]["tempI"]["value"] , hw + offset                            , h-minheight-offgap-1)

            ac.setSize(    WHEELS["FL"]["tempO"]["value"]   , minwidthOIM-offgap              , minheight-offgap    )        # size
            ac.setSize(    WHEELS["FR"]["tempO"]["value"]   , minwidthOIM-offgap +offsetOMI*30, minheight-offgap    )
            ac.setSize(    WHEELS["RL"]["tempO"]["value"]   , minwidthOIM-offgap              , minheight-offgap    )
            ac.setSize(    WHEELS["RR"]["tempO"]["value"]   , minwidthOIM-offgap +offsetOMI*30, minheight-offgap    )
            ac.setSize(    WHEELS["FL"]["tempM"]["value"]   , minwidthOIM-offgap              , minheight-offgap    )
            ac.setSize(    WHEELS["FR"]["tempM"]["value"]   , minwidthOIM-offgap              , minheight-offgap    )
            ac.setSize(    WHEELS["RL"]["tempM"]["value"]   , minwidthOIM-offgap              , minheight-offgap    )
            ac.setSize(    WHEELS["RR"]["tempM"]["value"]   , minwidthOIM-offgap              , minheight-offgap    )
            ac.setSize(    WHEELS["FL"]["tempI"]["value"]   , minwidthOIM-offgap +offsetOMI*30, minheight-offgap    )
            ac.setSize(    WHEELS["FR"]["tempI"]["value"]   , minwidthOIM-offgap              , minheight-offgap    )
            ac.setSize(    WHEELS["RL"]["tempI"]["value"]   , minwidthOIM-offgap +offsetOMI*30, minheight-offgap    )
            ac.setSize(    WHEELS["RR"]["tempI"]["value"]   , minwidthOIM-offgap              , minheight-offgap    )


            # "tempc"  # core temps colored rectangle
            # "ctmpc"  # carcass temps colored rectangle
            # "temp"   # core temps text value
            # "ctemp"  # carcass temps text value
            if bCPhysicsActive and bCPhysCarcassEnabled:
                # carcass enabled
                # core temps values
                ac.setPosition(WHEELS["FL"]["temp"]["value"] , hw - minwidth - offset-fntSize/2 , minheight*1.25-fontOffsetYRear/4)
                ac.setPosition(WHEELS["FR"]["temp"]["value"] , hw + offset           +fntSize/2 , minheight*1.25-fontOffsetYRear/4)
                ac.setPosition(WHEELS["RL"]["temp"]["value"] , hw - minwidth - offset-fntSize/2 , h-hh*0.8      -fontOffsetYRear/3)
                ac.setPosition(WHEELS["RR"]["temp"]["value"] , hw + offset           +fntSize/2 , h-hh*0.8      -fontOffsetYRear/3)
                # carcass temps values
                ac.setPosition(WHEELS["FL"]["ctemp"]["value"], hw - minwidth - offset-offgap  ,   minheight*0.8)
                ac.setPosition(WHEELS["FR"]["ctemp"]["value"], hw + offset           +offgap  ,   minheight*0.8)
                ac.setPosition(WHEELS["RL"]["ctemp"]["value"], hw - minwidth - offset-offgap  ,   hh+offgap+minheight*1.2)
                ac.setPosition(WHEELS["RR"]["ctemp"]["value"], hw + offset           +offgap  ,   hh+offgap+minheight*1.2)

                # carcass colors
                if bShowPressure:
                    ac.setPosition(WHEELS["FL"]["tempc"]["value"], hw - minwidth - offset ,      minheight      )
                    ac.setPosition(WHEELS["FR"]["tempc"]["value"], hw + offset            ,      minheight      )
                    ac.setPosition(WHEELS["RL"]["tempc"]["value"], hw - minwidth - offset ,   hh+fntSize*1.9-offgap )
                    ac.setPosition(WHEELS["RR"]["tempc"]["value"], hw + offset            ,   hh+fntSize*1.9-offgap )
                else:
                    ac.setPosition(WHEELS["FL"]["tempc"]["value"], hw - minwidth - offset ,      minheight      )
                    ac.setPosition(WHEELS["FR"]["tempc"]["value"], hw + offset            ,      minheight      )
                    ac.setPosition(WHEELS["RL"]["tempc"]["value"], hw - minwidth - offset ,   hh+offgap )
                    ac.setPosition(WHEELS["RR"]["tempc"]["value"], hw + offset            ,   hh+offgap )

                # core temps colors
                ac.setPosition(WHEELS["FL"]["ctmpc"]["value"], hw - minwidth-offset+minwidthOIM*0.5, hh-minheight/2-fntSize*2.7)
                ac.setPosition(WHEELS["FR"]["ctmpc"]["value"], hw + offset         +minwidthOIM*0.5, hh-minheight/2-fntSize*2.7)
                ac.setPosition(WHEELS["RL"]["ctmpc"]["value"], hw - minwidth-offset+minwidthOIM*0.5, hh+fntSize*2.25)
                ac.setPosition(WHEELS["RR"]["ctmpc"]["value"], hw + offset         +minwidthOIM*0.5, hh+fntSize*2.25)

                ac.setSize(    WHEELS["FL"]["temp"]["value"]  , minwidth              ,   minheight*2-fntSize*1)
                ac.setSize(    WHEELS["FR"]["temp"]["value"]  , minwidth              ,   minheight*2-fntSize*1)
                ac.setSize(    WHEELS["RL"]["temp"]["value"]  , minwidth              ,   minheight*2-fntSize*1)
                ac.setSize(    WHEELS["RR"]["temp"]["value"]  , minwidth              ,   minheight*2-fntSize*1)
                if offsetOMI>0:
                    if bShowPressure:
                        ac.setSize(    WHEELS["FL"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-minheight-offgap-fntSize)
                        ac.setSize(    WHEELS["FR"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-minheight-offgap-fntSize)
                        ac.setSize(    WHEELS["RL"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-minheight-offgap-fntSize)
                        ac.setSize(    WHEELS["RR"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-minheight-offgap-fntSize)
                    else:
                        ac.setSize(    WHEELS["FL"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-minheight-offgap-fntSize)
                        ac.setSize(    WHEELS["FR"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-minheight-offgap-fntSize)
                        ac.setSize(    WHEELS["RL"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-minheight-offgap-fntSize)
                        ac.setSize(    WHEELS["RR"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-minheight-offgap-fntSize)
                else:
                    if bShowPressure:
                        ac.setSize(    WHEELS["FL"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI,   hh-minheight-offgap-fntSize*2)
                        ac.setSize(    WHEELS["FR"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI,   hh-minheight-offgap-fntSize*2)
                        ac.setSize(    WHEELS["RL"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI,   hh-minheight-offgap-fntSize*2)
                        ac.setSize(    WHEELS["RR"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI,   hh-minheight-offgap-fntSize*2)
                    else:
                        ac.setSize(    WHEELS["FL"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI,   hh-minheight-offgap-1)
                        ac.setSize(    WHEELS["FR"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI,   hh-minheight-offgap-1)
                        ac.setSize(    WHEELS["RL"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI,   hh-minheight-offgap-1)
                        ac.setSize(    WHEELS["RR"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI,   hh-minheight-offgap-1)
                ac.setSize(    WHEELS["FL"]["ctemp"]["value"], minwidth-offgap                ,   minheight-offgap-3    )
                ac.setSize(    WHEELS["FR"]["ctemp"]["value"], minwidth-offgap                ,   minheight-offgap-3    )
                ac.setSize(    WHEELS["RL"]["ctemp"]["value"], minwidth-offgap                ,   minheight-offgap-3    )
                ac.setSize(    WHEELS["RR"]["ctemp"]["value"], minwidth-offgap                ,   minheight-offgap-3    )
                ac.setSize(    WHEELS["FL"]["ctmpc"]["value"], minwidthOIM*2,   minheight/2)
                ac.setSize(    WHEELS["FR"]["ctmpc"]["value"], minwidthOIM*2,   minheight/2)
                ac.setSize(    WHEELS["RL"]["ctmpc"]["value"], minwidthOIM*2,   minheight/2)
                ac.setSize(    WHEELS["RR"]["ctmpc"]["value"], minwidthOIM*2,   minheight/2)
            else:
                # carcass disabled/CPhys disabled
                # core temps rear more up
                ac.setPosition(WHEELS["FL"]["temp"]["value"]  , hw - minwidth - offset,    minheight)
                ac.setPosition(WHEELS["FR"]["temp"]["value"]  , hw + offset           ,    minheight)
                ac.setPosition(WHEELS["RL"]["temp"]["value"]  , hw - minwidth - offset, hh+fntSize*2)
                ac.setPosition(WHEELS["RR"]["temp"]["value"]  , hw + offset           , hh+fntSize*2)
                # core temps size double height
                ac.setSize(    WHEELS["FL"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-minheight-fntSize*2)
                ac.setSize(    WHEELS["FR"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-minheight-fntSize*2)
                ac.setSize(    WHEELS["RL"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-minheight-fntSize*2)
                ac.setSize(    WHEELS["RR"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-minheight-fntSize*2)

        else:
            ### no IMO vals
            minheight = minheight / 3
            ac.setPosition(WHEELS["FL"]["tempO"]["value"] , hw - minwidth - offset                 , 0)
            ac.setPosition(WHEELS["FR"]["tempO"]["value"] , hw + offset + minwidthOIM*2            , 0)
            ac.setPosition(WHEELS["RL"]["tempO"]["value"] , hw - minwidth - offset                 , h-minheight+offgap)
            ac.setPosition(WHEELS["RR"]["tempO"]["value"] , hw + offset + minwidthOIM*2            , h-minheight+offgap)
            # m
            ac.setPosition(WHEELS["FL"]["tempM"]["value"] , hw - minwidth + minwidthOIM  - offset  , 0)
            ac.setPosition(WHEELS["FR"]["tempM"]["value"] , hw + offset + minwidthOIM              , 0)
            ac.setPosition(WHEELS["RL"]["tempM"]["value"] , hw - minwidth + minwidthOIM  - offset  , h-minheight+offgap)
            ac.setPosition(WHEELS["RR"]["tempM"]["value"] , hw + offset + minwidthOIM              , h-minheight+offgap)
            # i
            ac.setPosition(WHEELS["FL"]["tempI"]["value"] , hw - minwidth + minwidthOIM*2 - offset , 0)
            ac.setPosition(WHEELS["FR"]["tempI"]["value"] , hw + offset                            , 0)
            ac.setPosition(WHEELS["RL"]["tempI"]["value"] , hw - minwidth + minwidthOIM*2 - offset , h-minheight+offgap)
            ac.setPosition(WHEELS["RR"]["tempI"]["value"] , hw + offset                            , h-minheight+offgap)

            ac.setSize(    WHEELS["FL"]["tempO"]["value"]   , minwidthOIM-offgap              , minheight-offgap*1.0    )        # size
            ac.setSize(    WHEELS["FR"]["tempO"]["value"]   , minwidthOIM-offgap +offsetOMI*30, minheight-offgap*1.0    )
            ac.setSize(    WHEELS["RL"]["tempO"]["value"]   , minwidthOIM-offgap              , minheight-offgap*1.0    )
            ac.setSize(    WHEELS["RR"]["tempO"]["value"]   , minwidthOIM-offgap +offsetOMI*30, minheight-offgap*1.0    )
            ac.setSize(    WHEELS["FL"]["tempM"]["value"]   , minwidthOIM-offgap              , minheight-offgap*1.0    )
            ac.setSize(    WHEELS["FR"]["tempM"]["value"]   , minwidthOIM-offgap              , minheight-offgap*1.0    )
            ac.setSize(    WHEELS["RL"]["tempM"]["value"]   , minwidthOIM-offgap              , minheight-offgap*1.0    )
            ac.setSize(    WHEELS["RR"]["tempM"]["value"]   , minwidthOIM-offgap              , minheight-offgap*1.0    )
            ac.setSize(    WHEELS["FL"]["tempI"]["value"]   , minwidthOIM-offgap +offsetOMI*30, minheight-offgap*1.0    )
            ac.setSize(    WHEELS["FR"]["tempI"]["value"]   , minwidthOIM-offgap              , minheight-offgap*1.0    )
            ac.setSize(    WHEELS["RL"]["tempI"]["value"]   , minwidthOIM-offgap +offsetOMI*30, minheight-offgap*1.0    )
            ac.setSize(    WHEELS["RR"]["tempI"]["value"]   , minwidthOIM-offgap              , minheight-offgap*1.0    )

            # "tempc"  # core temps colored rectangle
            # "ctmpc"  # carcass temps colored rectangle
            # "temp"   # core temps text value
            # "ctemp"  # carcass temps text value
            if bCPhysicsActive and bCPhysCarcassEnabled:
                ### carcass enabled

                # core temps text
                ac.setPosition(WHEELS["FL"]["temp"]["value"] , hw - minwidth - offset-fntSize/2 , minheight*4-fntSize*1.5)
                ac.setPosition(WHEELS["FR"]["temp"]["value"] , hw + offset           +fntSize/2 , minheight*4-fntSize*1.5)
                ac.setPosition(WHEELS["RL"]["temp"]["value"] , hw - minwidth - offset-fntSize/2 , h-hh*0.8-fontOffsetYRear/3)
                ac.setPosition(WHEELS["RR"]["temp"]["value"] , hw + offset           +fntSize/2 , h-hh*0.8-fontOffsetYRear/3)
                ac.setSize(    WHEELS["FL"]["temp"]["value"]  , minwidth              ,   minheight*3)
                ac.setSize(    WHEELS["FR"]["temp"]["value"]  , minwidth              ,   minheight*3)
                ac.setSize(    WHEELS["RL"]["temp"]["value"]  , minwidth              ,   minheight*3)
                ac.setSize(    WHEELS["RR"]["temp"]["value"]  , minwidth              ,   minheight*3)

                # core temp colors
                ac.setPosition(WHEELS["FL"]["ctmpc"]["value"], hw - minwidth-offset+minwidthOIM*0.5, minheight*2.5+fntSize*0.175)
                ac.setPosition(WHEELS["FR"]["ctmpc"]["value"], hw + offset         +minwidthOIM*0.5, minheight*2.5+fntSize*0.175)
                ac.setPosition(WHEELS["RL"]["ctmpc"]["value"], hw - minwidth-offset+minwidthOIM*0.5, hh+offgap    +fntSize*2.0)
                ac.setPosition(WHEELS["RR"]["ctmpc"]["value"], hw + offset         +minwidthOIM*0.5, hh+offgap    +fntSize*2.0)
                ac.setSize(    WHEELS["FL"]["ctmpc"]["value"], minwidthOIM*2,   minheight*3)
                ac.setSize(    WHEELS["FR"]["ctmpc"]["value"], minwidthOIM*2,   minheight*3)
                ac.setSize(    WHEELS["RL"]["ctmpc"]["value"], minwidthOIM*2,   minheight*3)
                ac.setSize(    WHEELS["RR"]["ctmpc"]["value"], minwidthOIM*2,   minheight*3)

                # carcass temps text
                if bCPhysCarcassText:
                    ac.setVisible(WHEELS["FL"]["ctemp"]["value"], 1)
                    ac.setVisible(WHEELS["FR"]["ctemp"]["value"], 1)
                    ac.setVisible(WHEELS["RL"]["ctemp"]["value"], 1)
                    ac.setVisible(WHEELS["RR"]["ctemp"]["value"], 1)
                    ac.setPosition(WHEELS["FL"]["ctemp"]["value"], hw - minwidth - offset-4  ,   minheight)
                    ac.setPosition(WHEELS["FR"]["ctemp"]["value"], hw + offset           +4  ,   minheight)
                    ac.setPosition(WHEELS["RL"]["ctemp"]["value"], hw - minwidth - offset-4  ,   hh*2-minheight-fntSize*2.5)
                    ac.setPosition(WHEELS["RR"]["ctemp"]["value"], hw + offset           +4  ,   hh*2-minheight-fntSize*2.5)
                    ac.setSize(    WHEELS["FL"]["ctemp"]["value"], minwidth-offgap           ,   minheight-offgap-3    -minwidth*0.2)
                    ac.setSize(    WHEELS["FR"]["ctemp"]["value"], minwidth-offgap           ,   minheight-offgap-3    -minwidth*0.2)
                    ac.setSize(    WHEELS["RL"]["ctemp"]["value"], minwidth-offgap           ,   minheight-offgap-3    -minwidth*0.2)
                    ac.setSize(    WHEELS["RR"]["ctemp"]["value"], minwidth-offgap           ,   minheight-offgap-3    -minwidth*0.2)
                else:
                    ac.setVisible(WHEELS["FL"]["ctemp"]["value"], 0)
                    ac.setVisible(WHEELS["FR"]["ctemp"]["value"], 0)
                    ac.setVisible(WHEELS["RL"]["ctemp"]["value"], 0)
                    ac.setVisible(WHEELS["RR"]["ctemp"]["value"], 0)
                # ac.setVisible(WHEELS["FL"]["ctemp"]["value"], 0)
                # ac.setVisible(WHEELS["FR"]["ctemp"]["value"], 0)
                # ac.setVisible(WHEELS["RL"]["ctemp"]["value"], 0)
                # ac.setVisible(WHEELS["RR"]["ctemp"]["value"], 0)

                # carcass temps colors
                ac.setPosition(WHEELS["FL"]["tempc"]["value"], hw - minwidth - offset ,      offsetOMI+fntSize)
                ac.setPosition(WHEELS["FR"]["tempc"]["value"], hw + offset            ,      offsetOMI+fntSize)
                if bShowPressure:
                    ac.setPosition(WHEELS["RL"]["tempc"]["value"], hw - minwidth - offset ,   hh+offsetOMI+fntSize*2)
                    ac.setPosition(WHEELS["RR"]["tempc"]["value"], hw + offset            ,   hh+offsetOMI+fntSize*2)
                else:
                    ac.setPosition(WHEELS["RL"]["tempc"]["value"], hw - minwidth - offset ,   hh+offsetOMI+1)
                    ac.setPosition(WHEELS["RR"]["tempc"]["value"], hw + offset            ,   hh+offsetOMI+1)
                if offsetOMI>0:
                    ac.setSize(    WHEELS["FL"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-fntSize*2)
                    ac.setSize(    WHEELS["FR"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-fntSize*2)
                    ac.setSize(    WHEELS["RL"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-fntSize*2)
                    ac.setSize(    WHEELS["RR"]["tempc"]["value"], minwidth-offgap+minwidth*offsetOMI/2,   hh-fntSize*2)
                else:
                    if bShowPressure:
                        ac.setSize(    WHEELS["FL"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI  ,   hh-fntSize*3.05)
                        ac.setSize(    WHEELS["FR"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI  ,   hh-fntSize*3.05)
                        ac.setSize(    WHEELS["RL"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI  ,   hh-fntSize*3.05)
                        ac.setSize(    WHEELS["RR"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI  ,   hh-fntSize*3.05)
                    else:
                        ac.setSize(    WHEELS["FL"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI  ,   hh-fntSize*1.1)
                        ac.setSize(    WHEELS["FR"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI  ,   hh-fntSize*1.1)
                        ac.setSize(    WHEELS["RL"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI  ,   hh-fntSize*1.1)
                        ac.setSize(    WHEELS["RR"]["tempc"]["value"], minwidth-offgap-minwidth*offsetOMI  ,   hh-fntSize*1.1)

            else:
                ### carcass disabled
                minheight = minheight * 3

                # core temps rear more up
                # core temps size double height
                if bSHOWIMO:
                    ac.setPosition(WHEELS["FL"]["temp"]["value"]  , hw - minwidth - offset,   minheight/3.15)
                    ac.setPosition(WHEELS["FR"]["temp"]["value"]  , hw + offset           ,   minheight/3.15)
                    ac.setPosition(WHEELS["RL"]["temp"]["value"]  , hw - minwidth - offset, hh + fntSize*1.9)
                    ac.setPosition(WHEELS["RR"]["temp"]["value"]  , hw + offset           , hh + fntSize*1.9)
                    ac.setSize(    WHEELS["FL"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-fntSize*1.9-minheight/3.15)
                    ac.setSize(    WHEELS["FR"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-fntSize*1.9-minheight/3.15)
                    ac.setSize(    WHEELS["RL"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-fntSize*1.9-minheight/3.15)
                    ac.setSize(    WHEELS["RR"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-fntSize*1.9-minheight/3.15)
                else:
                    ac.setPosition(WHEELS["FL"]["temp"]["value"]  , hw - minwidth - offset,   minheight/3.15)
                    ac.setPosition(WHEELS["FR"]["temp"]["value"]  , hw + offset           ,   minheight/3.15)
                    ac.setPosition(WHEELS["RL"]["temp"]["value"]  , hw - minwidth - offset, hh + fntSize*1.9)
                    ac.setPosition(WHEELS["RR"]["temp"]["value"]  , hw + offset           , hh + fntSize*1.9)
                    ac.setSize(    WHEELS["FL"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-fntSize*1.9-minheight/3.15)
                    ac.setSize(    WHEELS["FR"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-fntSize*1.9-minheight/3.15)
                    ac.setSize(    WHEELS["RL"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-fntSize*1.9-minheight/3.15)
                    ac.setSize(    WHEELS["RR"]["temp"]["value"]  , minwidth-minwidth*offsetOMI      ,   hh-fntSize*1.9-minheight/3.15)

                ac.setPosition(WHEELS["FL"]["ctemp"]["value"], -20000, -20000)
                ac.setPosition(WHEELS["FR"]["ctemp"]["value"], -20000, -20000)
                ac.setPosition(WHEELS["RL"]["ctemp"]["value"], -20000, -20000)
                ac.setPosition(WHEELS["RR"]["ctemp"]["value"], -20000, -20000)
                ac.setPosition(WHEELS["FL"]["tempc"]["value"], -20000, -20000)
                ac.setPosition(WHEELS["FR"]["tempc"]["value"], -20000, -20000)
                ac.setPosition(WHEELS["RL"]["tempc"]["value"], -20000, -20000)
                ac.setPosition(WHEELS["RR"]["tempc"]["value"], -20000, -20000)
                ac.setPosition(WHEELS["FL"]["ctmpc"]["value"], -20000, -20000)
                ac.setPosition(WHEELS["FR"]["ctmpc"]["value"], -20000, -20000)
                ac.setPosition(WHEELS["RL"]["ctmpc"]["value"], -20000, -20000)
                ac.setPosition(WHEELS["RR"]["ctmpc"]["value"], -20000, -20000)


        ac.setPosition(WHEELS["FL"]["slip"]             , hw-minwidth/3*2-offset ,    0-fntSize*2)
        ac.setPosition(WHEELS["FR"]["slip"]             , hw+minwidth/3  +offset ,    0-fntSize*2)
        ac.setPosition(WHEELS["RL"]["slip"]             , hw-minwidth/3*2-offset , hh*2+fntSize*1.1)
        ac.setPosition(WHEELS["RR"]["slip"]             , hw+minwidth/3  +offset , hh*2+fntSize*1.1)

        ac.setPosition(WHEELS["FL"]["dirt"]             , hw-minwidth-offset , -fntSize*1.5)
        ac.setPosition(WHEELS["FR"]["dirt"]             , hw+offset          , -fntSize*1.5)
        ac.setPosition(WHEELS["RL"]["dirt"]             , hw-minwidth-offset , h+2)
        ac.setPosition(WHEELS["RR"]["dirt"]             , hw+offset          , h+2)

        if bSHOWIMO:
            ac.setPosition(WHEELS["FL"]["details"]["value"] , hw - hh - minwidth   - offset+offgap+1     , minheight+offgap)
            ac.setPosition(WHEELS["FR"]["details"]["value"] , hw + hh + offset                    -1     , minheight+offgap)
            ac.setPosition(WHEELS["RL"]["details"]["value"] , hw - hh - minwidth   - offset+offgap+1     , hh+offgap+fntSize*2.5      )
            ac.setPosition(WHEELS["RR"]["details"]["value"] , hw + hh + offset                    -1     , hh+offgap+fntSize*2.5      )
        else:
            ac.setPosition(WHEELS["FL"]["details"]["value"] , hw - hh - minwidth   - offset+offgap+1     , minheight/3)
            ac.setPosition(WHEELS["FR"]["details"]["value"] , hw + hh + offset                    -1     , minheight/3)
            ac.setPosition(WHEELS["RL"]["details"]["value"] , hw - hh - minwidth   - offset+offgap+1     , hh+offgap+fntSize*2.5      )
            ac.setPosition(WHEELS["RR"]["details"]["value"] , hw + hh + offset                    -1     , hh+offgap+fntSize*2.5      )

        ac.setPosition(WHEELS["FL"]["load"   ]["value"] , hw - offset + minwidthOIM - minwidth+offgap, hh-fntSize*3.5)
        ac.setPosition(WHEELS["FR"]["load"   ]["value"] , hw + offset + minwidthOIM +offgap          , hh-fntSize*3.5)
        ac.setPosition(WHEELS["RL"]["load"   ]["value"] , hw - offset + minwidthOIM - minwidth+offgap, hh+fntSize*2.5)
        ac.setPosition(WHEELS["RR"]["load"   ]["value"] , hw + offset + minwidthOIM +offgap          , hh+fntSize*2.5)

        ac.setFontAlignment(WHEELS["FL"]["temp"]["value"]    , "right")
        ac.setFontAlignment(WHEELS["FR"]["temp"]["value"]    , "left")
        ac.setFontAlignment(WHEELS["RL"]["temp"]["value"]    , "right")
        ac.setFontAlignment(WHEELS["RR"]["temp"]["value"]    , "left")
        ac.setFontAlignment(WHEELS["FL"]["ctemp"]["value"]    , "right")
        ac.setFontAlignment(WHEELS["FR"]["ctemp"]["value"]    , "left")
        ac.setFontAlignment(WHEELS["RL"]["ctemp"]["value"]    , "right")
        ac.setFontAlignment(WHEELS["RR"]["ctemp"]["value"]    , "left")

        # "tempc"  # core temps colored rectangle
        # "ctmpc"  # carcass temps colored rectangle
        # "temp"   # core temps text value
        # "ctemp"  # carcass temps text value
        ac.setPosition(WHEELS["FL"]["wear"]["value"] , hw   - offset-minwidth-minwidth*0.25 -1,            0 + fontOffsetYRear/4 )
        ac.setPosition(WHEELS["FR"]["wear"]["value"] , hw   + offset+minwidth+minwidth*0.15 -1,            0 + fontOffsetYRear/4 )
        ac.setPosition(WHEELS["RL"]["wear"]["value"] , hw   - offset-minwidth-minwidth*0.25 -1, hh+fntSize*3 - fontOffsetYRear/4 )
        ac.setPosition(WHEELS["RR"]["wear"]["value"] , hw   + offset+minwidth+minwidth*0.15 -1, hh+fntSize*3 - fontOffsetYRear/4 )

        ac.setPosition(WHEELS["FL"]["wearInner"]     , hw   - offset-minwidth-minwidth*0.25+1,            0 + fontOffsetYRear/4 )
        ac.setPosition(WHEELS["FR"]["wearInner"]     , hw   + offset+minwidth+minwidth*0.15+1,            0 + fontOffsetYRear/4 )
        ac.setPosition(WHEELS["RL"]["wearInner"]     , hw   - offset-minwidth-minwidth*0.25+1, hh+fntSize*4 - fontOffsetYRear/4 )
        ac.setPosition(WHEELS["RR"]["wearInner"]     , hw   + offset+minwidth+minwidth*0.15+1, hh+fntSize*4 - fontOffsetYRear/4 )

        if bFancyMode and bShowPressureText:
            ac.setPosition(WHEELS["FL"]["wearLabel"]     , hw   - offset-minwidth- minwidth*0.75, hh-fntSize*4.5 + fontOffsetYRear/4 )
            ac.setPosition(WHEELS["FR"]["wearLabel"]     , hw   + offset+minwidth+ minwidth*0.20, hh-fntSize*4.5 + fontOffsetYRear/4 )
            ac.setPosition(WHEELS["RL"]["wearLabel"]     , hw   - offset-minwidth- minwidth*0.75, hh+fntSize*3 - fontOffsetYRear/4 )
            ac.setPosition(WHEELS["RR"]["wearLabel"]     , hw   + offset+minwidth+ minwidth*0.20, hh+fntSize*3 - fontOffsetYRear/4 )
        else:
            ac.setPosition(WHEELS["FL"]["wearLabel"]     , hw   - offset-minwidth- minwidth*0.75, hh-fntSize*2.325 + fontOffsetYRear/4 )
            ac.setPosition(WHEELS["FR"]["wearLabel"]     , hw   + offset+minwidth+ minwidth*0.20, hh-fntSize*2.325 + fontOffsetYRear/4 )
            ac.setPosition(WHEELS["RL"]["wearLabel"]     , hw   - offset-minwidth- minwidth*0.75, hh+fntSize*2.050 - fontOffsetYRear/4 )
            ac.setPosition(WHEELS["RR"]["wearLabel"]     , hw   + offset+minwidth+ minwidth*0.20, hh+fntSize*2.050 - fontOffsetYRear/4 )

        ### pres under the wheels, wear on the side
        if bShowPressure:
            ac.setVisible(WHEELS["FL"]["pres"]["value"],1)
            ac.setVisible(WHEELS["FR"]["pres"]["value"],1)
            ac.setVisible(WHEELS["RL"]["pres"]["value"],1)
            ac.setVisible(WHEELS["RR"]["pres"]["value"],1)
            if bShowPressureDiff:
                ac.setPosition(WHEELS["FL"]["pres"]["value"] , hw-minwidth*1.5-offset, hh-fntSize*1.9)
                ac.setPosition(WHEELS["FR"]["pres"]["value"] , hw             +offset, hh-fntSize*1.9)
                ac.setPosition(WHEELS["RL"]["pres"]["value"] , hw-minwidth*1.5-offset, hh )
                ac.setPosition(WHEELS["RR"]["pres"]["value"] , hw+            +offset, hh )
            else:
                ac.setPosition(WHEELS["FL"]["pres"]["value"] , hw-minwidth-offset  , hh-fntSize*1.9)
                ac.setPosition(WHEELS["FR"]["pres"]["value"] , hw         +offset  , hh-fntSize*1.9)
                ac.setPosition(WHEELS["RL"]["pres"]["value"] , hw-minwidth-offset  , hh )
                ac.setPosition(WHEELS["RR"]["pres"]["value"] , hw+        +offset  , hh )
        else:
            ac.setVisible(WHEELS["FL"]["pres"]["value"],0)
            ac.setVisible(WHEELS["FR"]["pres"]["value"],0)
            ac.setVisible(WHEELS["RL"]["pres"]["value"],0)
            ac.setVisible(WHEELS["RR"]["pres"]["value"],0)

        #############################################
        for wheel in wheels:
            ### forces update after changed ui params
            WHEELS[wheel]["wear"]["last"] = WHEELS[wheel]["wear"]["last"] + 0.01
            if bShowPressureDiff:
                ac.setSize(WHEELS[wheel]["pres"]["value"]   , minwidth*1.5, fntSize*1.8)
            else:
                ac.setSize(WHEELS[wheel]["pres"]["value"]   , minwidth    , fntSize*1.8)

            ac.setBackgroundOpacity(WHEELS[wheel]["pres"]["value"], gOpacity/100.0)

            ###ac.setSize(    WHEELS[wheel]["wear"]["value"]  , max(4,minwidth*0.1-2), hh-fntSize*2)
            ### v4.1
            ac.setSize(    WHEELS[wheel]["wear"]["value"]  , max(4,minwidth*0.1)  , hh-fntSize*3)
            ac.setSize(    WHEELS[wheel]["wearInner"]      , max(2,minwidth*0.1-4), hh-fntSize*3)
            ac.setSize(    WHEELS[wheel]["wearLabel"]      ,       minwidth*0.5   , fntSize*1.3)

            ac.drawBorder( WHEELS[wheel]["wear"]["value"], 1)
            ac.drawBorder( WHEELS[wheel]["wearInner"], 0)

            if bFancyMode and bCSPactive:
                ac.setVisible( WHEELS[wheel]["brakeD"]["value"]  , 1)
                ac.setSize(    WHEELS[wheel]["brake"]["value"]   , hw*0.1           ,   hh*0.33+fontOffsetYRear/4)
                ac.setSize(    WHEELS[wheel]["brakeD"]["value"]  , hw*0.1           ,   hh-fntSize*1.75)
                ac.setSize(    WHEELS[wheel]["brakeL"]["value"]  , hw*0.1           ,   hh*0.5+fontOffsetYRear)
            else:
                ac.setVisible( WHEELS[wheel]["brakeD"]["value"]  , 0)
                ac.setSize(    WHEELS[wheel]["brake"]["value"]   , hw*0.1           ,   hh*0.5+fontOffsetYRear/4)
                ac.setSize(    WHEELS[wheel]["brakeD"]["value"]  , hw*0.1           ,   minwidth/3.5)
                ac.setSize(    WHEELS[wheel]["brakeL"]["value"]  , hw*0.1           ,   hh*0.5+fontOffsetYRear)

            ac.setSize(    WHEELS[wheel]["details"]["value"] , minwidth-offgap   ,   fntSize)
            ac.setSize(    WHEELS[wheel]["slip"]             , minwidthOIM+offgap,   fntSize)
            ac.setSize(    WHEELS[wheel]["dirt"]             , minwidth-offgap   ,   fntSize*1.5)
            ac.setSize(    WHEELS[wheel]["load"]["value"]    , minwidthOIM*0.666 ,   fntSize)

            if bPressureGraph:
                ac.setVisible(WHEELS["FL"]["pres"]["value"],0)
                ac.setVisible(WHEELS["FR"]["pres"]["value"],0)
                ac.setVisible(WHEELS["RL"]["pres"]["value"],0)
                ac.setVisible(WHEELS["RR"]["pres"]["value"],0)

            if bCPhysicsActive and bCPhysCarcassEnabled:
                if bCPhysCarcassText and not bFancyMode:
                    ac.setVisible(          WHEELS[wheel]["ctemp"]["value"] , 1) # show "tyre carcass temps"
                else:
                    ac.setVisible(          WHEELS[wheel]["ctemp"]["value"] , 0) # show "tyre carcass temps"
                if not bFancyMode and not bCPhysCarcassText:
                    ac.setVisible(          WHEELS[wheel]["tempc"]["value"] , 1) # show "tyre carcass temps values"
                    ac.setVisible(          WHEELS[wheel]["ctmpc"]["value"] , 1) # show "tyre carcass temps"
                ac.setBackgroundOpacity(WHEELS[wheel]["temp"]["value"]  , 0)
                ac.setBackgroundOpacity(WHEELS[wheel]["ctemp"]["value"] , 0)
            else:
                ac.setVisible(WHEELS[wheel]["tempc"]["value"] , 0) # hide "tyre core temps colors"
                ac.setVisible(WHEELS[wheel]["ctemp"]["value"] , 0) # hide "tyre carcass temps values"
                ac.setVisible(WHEELS[wheel]["ctmpc"]["value"] , 0) # hide "tyre carcass temps color color"
                ac.setBackgroundOpacity(WHEELS[wheel]["temp"]["value"] , 0) # show "tyre carcass temps"


            ac.setBackgroundOpacity(WHEELS[wheel]["tempO"]["value"]    , gOpacityFG/100.0)
            ac.setBackgroundOpacity(WHEELS[wheel]["tempM"]["value"]    , gOpacityFG/100.0)
            ac.setBackgroundOpacity(WHEELS[wheel]["tempI"]["value"]    , gOpacityFG/100.0)
            ac.setBackgroundOpacity(WHEELS[wheel]["tempc"]["value"]    , 1)
            ac.setBackgroundOpacity(WHEELS[wheel]["ctmpc"]["value"]    , 1)
            ac.setBackgroundOpacity(WHEELS[wheel]["slip"]              , 0)
            ac.setBackgroundOpacity(WHEELS[wheel]["dirt"]              , gOpacityFG/100.0)
            ac.setBackgroundOpacity(WHEELS[wheel]["pres"]["value"]     , gOpacityFG/100.0)
            ac.setBackgroundOpacity(WHEELS[wheel]["load"]["value"]     , gOpacityFG/100.0)
            ac.setBackgroundOpacity(WHEELS[wheel]["wear"]["value"]     , gOpacityFG/100.0)
            ac.setBackgroundOpacity(WHEELS[wheel]["wearInner"]         , gOpacityFG/100.0)
            ac.setBackgroundOpacity(WHEELS[wheel]["wearLabel"]         , gOpacityFG/100.0)
            ac.setBackgroundOpacity(WHEELS[wheel]["brake"]["value"]    , gOpacityFG/100.0)
            ac.setBackgroundOpacity(WHEELS[wheel]["brakeD"]["value"]   , gOpacityFG/100.0)
            ac.setBackgroundOpacity(WHEELS[wheel]["brakeL"]["value"]   , 0)
            ac.setBackgroundOpacity(lbCenter, float(gOpacity/100.0))
            ac.setBackgroundOpacity(lbCenter2, float(gOpacity/100.0))
            if bShowBGText:
                ac.setVisible(lbCenter,1)
                ac.setVisible(lbCenter2,1)
            else:
                ac.setVisible(lbCenter,0)
                ac.setVisible(lbCenter2,0)

            # ac.setFontSize(    WHEELS[wheel]["brake"]["value"]   , fntSize*0.666)
            # ac.setFontSize(    WHEELS[wheel]["brakeD"]["value"]  , fntSize*0.666)
            # ac.setFontSize(    WHEELS[wheel]["brakeL"]["value"]  , fntSize*0.666)

            ac.setFontColor(WHEELS[wheel]["ctemp"]["value"]   , 0.0, 0.0, 0.0, gOpacityFG/100.0)
            ac.setFontColor(WHEELS[wheel]["temp"]["value"]    , 0.0, 0.0, 0.0, gOpacityFG/100.0)
            ac.setFontColor(WHEELS[wheel]["slip"]             , 0.0, 0.0, 0.0, gOpacityFG/100.0)
            if bTextWhiteOnBlack:
                ac.setFontColor(WHEELS[wheel]["details"]["value"] , 1.0, 1.0, 1.0, gOpacityFG/100.0)
            else:
                ac.setFontColor(WHEELS[wheel]["details"]["value"] , 0.0, 0.0, 0.0, gOpacityFG/100.0)

            ac.setFontAlignment(WHEELS[wheel]["pres"]["value"]    , "center")
            ac.setFontAlignment(WHEELS[wheel]["wear"]["value"]    , "center")
            ac.setFontAlignment(WHEELS[wheel]["brakeL"]["value"]   , "center")

            ac.setFontSize(         WHEELS[wheel]["slip"] , fntSize*0.9)
            ac.setFontSize(         WHEELS[wheel]["dirt"] , fntSize*1.1)
            ac.drawBorder(WHEELS[wheel]["tempc"]["value"], 0)
            ac.setVisible(WHEELS[wheel]["details"]["value"],0)

            if (not bCPhysBrakesEnabled) and (not brakestempsConfigured): # or not bCSPactive:
                ac.setVisible(WHEELS[wheel]["brake" ]["value"],0)
                ac.setVisible(WHEELS[wheel]["brakeL"]["value"],0)
                ac.setVisible(WHEELS[wheel]["brakeD"]["value"],0)
            else:
                ac.setVisible(WHEELS[wheel]["brake" ]["value"],1)
                if bCoreTempsEnabled and bCSPactive:
                    ac.setVisible(WHEELS[wheel]["brakeD"]["value"],1)
                else:
                    ac.setVisible(WHEELS[wheel]["brakeD"]["value"],0)
                ac.setVisible(WHEELS[wheel]["brakeL"]["value"],1)
            ac.setVisible(WHEELS[wheel]["load" ]["value"],0)
            ac.setVisible(WHEELS[wheel]["slip"],1)

            if bShowWearGraph:
                ac.setVisible(WHEELS[wheel]["wear"]["value"],1)
                ac.setVisible(WHEELS[wheel]["wearInner"],1)
                ac.setBackgroundOpacity(WHEELS[wheel]["wearInner"],gOpacityFG/100)
            else:
                ac.setVisible(WHEELS[wheel]["wear"]["value"], 0)
                ac.setVisible(WHEELS[wheel]["wearInner"]    , 0)

            if bShowWearText:
                ac.setVisible(WHEELS[wheel]["wearLabel"],1)
                ac.setBackgroundOpacity(WHEELS[wheel]["wearLabel"],gOpacityFG/100)
            else:
                ac.setVisible(WHEELS[wheel]["wearLabel"],0)

            ac.setBackgroundOpacity(WHEELS[wheel]["wear"]["value"], gOpacityFG/100)
            ac.setBackgroundOpacity(WHEELS[wheel]["wearInner"],gOpacityFG/100)
            if not bCPhysicsActive and not bCPhysCarcassEnabled:
                # already set above for the other case
                ac.setBackgroundColor  ( WHEELS[wheel]["ctemp"]["value"], 0.1,0.1,0.1)
                ac.setBackgroundColor  ( WHEELS[wheel]["temp"]["value"] , 0.1,0.1,0.1)
                ac.setFontColor        ( WHEELS[wheel]["ctemp"]["value"], 0,0,0,1)
                ac.setFontColor        ( WHEELS[wheel]["temp"]["value"] , 0,0,0,1)

            # tyre core temps
            ac.setFontSize(  WHEELS[wheel]["temp"]["value"], fntSize*fontmulti)
            ac.setFontSize(    WHEELS[wheel]["tempO"]["value"]   , fntSize*1.1)
            ac.setFontSize(    WHEELS[wheel]["tempM"]["value"]   , fntSize*1.1)
            ac.setFontSize(    WHEELS[wheel]["tempI"]["value"]   , fntSize*1.1)
            ac.setFontSize(    WHEELS[wheel]["details"]["value"] , fntSize*0.8)
            ac.setFontSize(    WHEELS[wheel]["brakeL"]["value"]   , fntSize*0.8)
            ac.setFontSize(    WHEELS[wheel]["load"]["value"]    , fntSize*0.7)
            # tyre carcass temps
            ac.setFontSize(  WHEELS[wheel]["ctemp"]["value"]     , fntSize*1.3)
            ac.setFontSize(  WHEELS[wheel]["pres"]["value"]      , fntSize*1.4)
            ac.setFontSize(  WHEELS[wheel]["wear"]["value"]      , fntSize*0.95)
            ac.setFontSize(  WHEELS[wheel]["wearLabel"]          , fntSize*1.1)

            ac.setFontColor( WHEELS[wheel]["pres"]["value"]     , 0,0,0,1)
            ac.setFontColor( WHEELS[wheel]["wearLabel"]         , 1,1,1,1)
            ac.setFontColor( WHEELS[wheel]["temp"]["value"]     , 1,1,1,1)
            ac.setFontColor( WHEELS[wheel]["tempI"]["value"]    , 1,1,1,1)
            ac.setFontColor( WHEELS[wheel]["tempM"]["value"]    , 1,1,1,1)
            ac.setFontColor( WHEELS[wheel]["tempO"]["value"]    , 1,1,1,1)
            ac.setFontColor( WHEELS[wheel]["wear"]["value"]     , 1,1,1,1)

            ac.setBackgroundColor( WHEELS[wheel]["dirt"]                 , 0.8,0.5,0.1)
            ac.setBackgroundColor( WHEELS[wheel]["pres"]["value"]        , 0,0,0) #.2,0.2,0.2)
            ac.setBackgroundColor( WHEELS[wheel]["wearLabel"]            , 0.1,0.1,0.1)
            ac.setBackgroundColor( WHEELS[wheel]["tempI"]["value"]       , 0.1,0.1,0.1)
            ac.setBackgroundColor( WHEELS[wheel]["tempM"]["value"]       , 0.1,0.1,0.1)
            ac.setBackgroundColor( WHEELS[wheel]["tempO"]["value"]       , 0.1,0.1,0.1)
            ac.setBackgroundColor( WHEELS[wheel]["wear"]["value"]        , 0.1,0.1,0.1)

            ac.setCustomFont(WHEELS[wheel]["ctemp"]["value"]   , sCustomFontName, 0, bold)
            ac.setCustomFont(WHEELS[wheel]["temp"]["value"]    , sCustomFontName, 0, bold)
            ac.setCustomFont(WHEELS[wheel]["pres"]["value"]    , sCustomFontName, 0, 1)
            ac.setCustomFont(WHEELS[wheel]["wearLabel"]        , sCustomFontName, 0, 0)
            ac.setCustomFont(WHEELS[wheel]["wear"]["value"]    , sCustomFontName, 0, bold)

            ac.setCustomFont(WHEELS[wheel]["tempI"]["value"]   , sCustomFontName, 0, 0)
            ac.setCustomFont(WHEELS[wheel]["tempM"]["value"]   , sCustomFontName, 0, 0)
            ac.setCustomFont(WHEELS[wheel]["tempO"]["value"]   , sCustomFontName, 0, 0)

            ac.setCustomFont(lbAero   , sCustomFontName, 0, 1)
            ac.setCustomFont(lbAero2   , sCustomFontName, 0, 1)
            ac.setCustomFont(lbCenter   , sCustomFontName, 0, 1)
            ac.setCustomFont(lbCenter2   , sCustomFontName, 0, 1)
            ##ac.setCustomFont(lb   , sCustomFontName, 0, 1)


            ac.setText(WHEELS[wheel]["temp"]["value"] , "")
            ac.setText(WHEELS[wheel]["ctemp"]["value"], "")
            ac.setText(WHEELS[wheel]["tempI"]["value"], "")
            ac.setText(WHEELS[wheel]["tempM"]["value"], "")
            ac.setText(WHEELS[wheel]["tempO"]["value"], "")
            ac.setText(WHEELS[wheel]["pres"]["value"] , "")
            ac.setText(WHEELS[wheel]["wear"]["value"] , "")
            ac.setText(WHEELS[wheel]["brake"]["value"], "")
            ac.setText(WHEELS[wheel]["brakeD"]["value"], "")
            ac.setText(WHEELS[wheel]["brakeL"]["value"], "")
            ac.setText(WHEELS[wheel]["dirt"], "")
            ac.setVisible(WHEELS[wheel]["dirt"], 0)
            WHEELS[wheel]["dvis"]=False
    except:
        Berror = True
        ac.log('tyre_app_ext: ' + traceback.format_exc() )


    try:
        if bImgSet:
            tSurfRL              = ac.newTexture("apps/python/tyres_app_ext/img2/tSurfRL.png")
            tSurfFL              = ac.newTexture("apps/python/tyres_app_ext/img2/tSurfFL.png")
            tSurfRM              = ac.newTexture("apps/python/tyres_app_ext/img2/tSurfRM.png")
            tSurfFM              = ac.newTexture("apps/python/tyres_app_ext/img2/tSurfFM.png")
            tSurfRR              = ac.newTexture("apps/python/tyres_app_ext/img2/tSurfRR.png")
            tSurfFR              = ac.newTexture("apps/python/tyres_app_ext/img2/tSurfFR.png")
            tCarcassR            = ac.newTexture("apps/python/tyres_app_ext/img2/tCarcassR.png")
            tCarcassF            = ac.newTexture("apps/python/tyres_app_ext/img2/tCarcassF.png")
            tCoreCarcassR        = ac.newTexture("apps/python/tyres_app_ext/img2/tCoreCarcassR.png")
            tCoreCarcassF        = ac.newTexture("apps/python/tyres_app_ext/img2/tCoreCarcassF.png")
            tCoreF               = ac.newTexture("apps/python/tyres_app_ext/img2/tCoreF.png")
            tCoreR               = ac.newTexture("apps/python/tyres_app_ext/img2/tCoreR.png")
        else:
            tSurfRL              = ac.newTexture("apps/python/tyres_app_ext/tSurfRL.png")
            tSurfFL              = ac.newTexture("apps/python/tyres_app_ext/tSurfFL.png")
            tSurfRM              = ac.newTexture("apps/python/tyres_app_ext/tSurfRM.png")
            tSurfFM              = ac.newTexture("apps/python/tyres_app_ext/tSurfFM.png")
            tSurfRR              = ac.newTexture("apps/python/tyres_app_ext/tSurfRR.png")
            tSurfFR              = ac.newTexture("apps/python/tyres_app_ext/tSurfFR.png")
            tCarcassR            = ac.newTexture("apps/python/tyres_app_ext/tCarcassR.png")
            tCarcassF            = ac.newTexture("apps/python/tyres_app_ext/tCarcassF.png")
            tCoreCarcassR        = ac.newTexture("apps/python/tyres_app_ext/tCoreCarcassR.png")
            tCoreCarcassF        = ac.newTexture("apps/python/tyres_app_ext/tCoreCarcassF.png")
            tCoreF               = ac.newTexture("apps/python/tyres_app_ext/tCoreF.png")
            tCoreR               = ac.newTexture("apps/python/tyres_app_ext/tCoreR.png")
    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )


    appUpdateValues()
    ##################### end appResize()



def appResetGo(*args):
    global bCPhysicsActive, WHEELS, ac_radius, ac_temp, tyreTempI, tyreTempM, tyreTempO, ac_pres, appInfo
    global ac_bradius, ac_presOpt, baseAEROdens, basecgHeight
    global carname, currcar, compNameShort, tirenameLong, dataDict
    global frict_limit_angF, frict_limit_angR
    global maxTF, maxTR, minTF, minTR
    global temp_curveF, temp_curveR, wear_curveF, wear_curveR, hideTimer, bCPhysBrakesEnabled
    global tempFtemp, tempRtemp, tempFgrip, tempRgrip, sIdealTemps, sIdealPress, sIdealGrip, extraHeight
    global wearFkm, wearRkm, wearFperc, wearRperc
    global maxDownForce, maxDrag, maxBT, minBT, maxBrakeTorque, maxTorque, maxDampTravFRONT, minDampTravFRONT, maxDampTravREAR, minDampTravREAR
    global maxSuspTravFRONT, minSuspTravFRONT, maxSuspTravREAR, minSuspTravREAR, maxSuspForceFRONT, minSuspForceFRONT, maxSuspForceREAR, minSuspForceREAR, brakeDetection
    global rh, rhMax, rhMin, PRACTICAL_TEMP_RATIO, tyresVersion, btnTyrePrev
    global fMaxs, fMins, fMaxsTimer, fMinsTimer, brakestempsConfigured

    if compNameShort=="":
        return
    try:
        fMaxs = [0.0]*(30)
        fMins  = [999999.0]*(30)
        fMaxsTimer = [-1.0]*(30)
        fMinsTimer = [-1.0]*(30)
        maxDownForce     = 150 # thats around a quarter of gt3 level, will be adjusted dynamically
        maxDrag          = 500 # adjusted dynamically
        maxBT            = 300   # max brake temp
        minBT            = 20    # min brake temp
        maxBrakeTorque   = 0.0
        maxTorque        = 0.0
        maxDampTravFRONT =-100000.0
        minDampTravFRONT = 100000.0
        maxDampTravREAR  =-100000.0
        minDampTravREAR  = 100000.0
        maxSuspTravFRONT =-100000.0
        minSuspTravFRONT = 100000.0
        maxSuspTravREAR  =-100000.0
        minSuspTravREAR  = 100000.0
        maxSuspForceFRONT=-1000000.0
        minSuspForceFRONT= 1000000.0
        maxSuspForceREAR =-1000000.0
        minSuspForceREAR = 1000000.0
        wearFkm=[]
        wearRkm=[]
        wearFperc=[]
        wearRperc=[]
        tempFtemp=[]
        tempFgrip=[]
        tempRtemp=[]
        tempRgrip=[]

        rh    = [0.0,0.0]
        rhMax = [-10000.0,-10000.0]
        rhMin = [ 10000.0, 10000.0]

        extraHeight = 0
        ac.setTitle(appWindow,"reading data")  # "Tyres app Ext"

        ac_temp["FL"]  , ac_temp["FR"]  , ac_temp["RL"]  , ac_temp["RR"]       = ac.getCarState(currcar, acsys.CS.CurrentTyresCoreTemp)
        ac_pres["FL"]  , ac_pres["FR"]  , ac_pres["RL"]  , ac_pres["RR"]       = ac.getCarState(currcar, acsys.CS.DynamicPressure)
        ac_bradius["FL"], ac_bradius["FR"], ac_bradius["RL"], ac_bradius["RR"] = ac.getCarState(currcar, acsys.CS.TyreRadius)
        ac_radius["FL"], ac_radius["FR"], ac_radius["RL"], ac_radius["RR"]     = ac.getCarState(currcar, acsys.CS.TyreRadius)
        # ac_bradius["FL"], ac_bradius["FR"], ac_bradius["RL"], ac_bradius["RR"] = tyinfo.static.tyreRadius
        # ac_radius["FL"], ac_radius["FR"], ac_radius["RL"], ac_radius["RR"] = ac.getCarState(currcar, acsys.CS.TyreLoadedRadius)

        # load "data.acd" or "data\" files into ACD_FILE buffer
        # ACD_FILE = ACD("content/cars/{}".format(carname))
        carname = ac.getCarName(currcar)
        if not 'car' + str(currcar) in dataDict:
            ACD_FILE = ACD("content/cars/{}".format(carname))
            dataDict['car' + str(currcar)] = ACD_FILE
        else:
            ACD_FILE = dataDict['car' + str(currcar)]

        # brakes.ini
        config = ConfigParser(empty_lines_in_values=False, inline_comment_prefixes=(";","#","/",), comment_prefixes=(";","#","/",), strict=False, allow_no_value=True)
        config.optionxform = str   # keep Case
        config.read_string("[ACHEADER]\n" + ACD_FILE.get_file("brakes.ini"))

        ### assume encrypted/unreadable data by default
        brakeDetection = True
        brakestempsConfigured = True
        if config.has_option("HEADER", "VERSION"):
            if not config.has_option('TEMPS_FRONT','COOL_TRANSFER'):
                ### assume encrypted/unreadable data by default
                brakeDetection = False
                brakestempsConfigured = False

        # [TEMPS_FRONT]
        # 'COOL_TRANSFER=x'
        # brakestempsConfigured=False
        #if config.has_option('TEMPS_FRONT','COOL_TRANSFER'):
        #    brakestempsConfigured=True
        #if not brakestempsConfigured:
        #    bCPhysBrakesEnabled=False

        # tyres.ini
        config = ConfigParser(empty_lines_in_values=False, inline_comment_prefixes=(";","#","/",), comment_prefixes=(";","#","/",), strict=False, allow_no_value=True)
        config.optionxform = str   # keep Case
        config.read_string("[ACHEADER]\n" + ACD_FILE.get_file("tyres.ini"))

        global tyreID, tyreIDMAX, tyreIDcurr
        localCompNameShort = compNameShort
        #if compNameShort
        tyreIDMAX = get_tire_id_max(config)
        if tyreIDcurr==-1:
            # tyreID    = set by current used tyre
            tyreID = get_tire_id(localCompNameShort,config)
        else:
            # tyreID    = set by two buttons
            # ac.console(str(tyreID))
            localCompNameShort = get_tire_name_by_id(tyreID, config)
            tyreID = get_tire_id(localCompNameShort,config)
            tyreIDcurr = -1

        if compNameShort == localCompNameShort:
            ac.setText(btnTyrePrev, "   -    " + str(tyreID+1) + '   (' + str(tyreIDMAX) + ')  +      current')
        else:
            ac.setText(btnTyrePrev, "   -    " + str(tyreID+1) + '   (' + str(tyreIDMAX) + ')  +')
        # ac.setText(btnTyrePrev, "-" + str(tyreID) + ' / ' + str(tyreIDMAX))
        # ac.setText(btnTyrePrev, "-" + str() + ' / ' + str(tyreIDMAX))

        temp_curveF      = ACD_FILE.get_file_section_value_as_curve(config, "THERMAL_FRONT", "PERFORMANCE_CURVE"   , "SHORT_NAME", localCompNameShort)
        temp_curveR      = ACD_FILE.get_file_section_value_as_curve(config, "THERMAL_REAR" , "PERFORMANCE_CURVE"   , "SHORT_NAME", localCompNameShort)
        wear_curveF      = ACD_FILE.get_file_section_value_as_curve(config, "FRONT"        , "WEAR_CURVE"          , "SHORT_NAME", localCompNameShort)
        wear_curveR      = ACD_FILE.get_file_section_value_as_curve(config, "REAR"         , "WEAR_CURVE"          , "SHORT_NAME", localCompNameShort)

        if config.has_section('_EXTENSION') and config.has_option('_EXTENSION', 'PRACTICAL_TEMP_RATIO'):
            s = config['_EXTENSION']['PRACTICAL_TEMP_RATIO']
            ss = s
            if ';' in s:
                ss = float(s.split(';')[0])
            if '#' in s:
                ss = float(s.split('#')[0])
            if ' ' in ss:
                ss = float(s.split(' ')[0])
            if ss.isnumeric():
                PRACTICAL_TEMP_RATIO = float(ss)
            # ac.log(str(PRACTICAL_TEMP_RATIO))

        if len(wear_curveF)>0 and len(wear_curveR)>0:
            for s in wear_curveF.split('\n'):
                t=s.split('|')
                if len(t)>1:
                    wearFkm.append(get_float(t[0]))
                    wearFperc.append(get_float(t[1]))
            for s in wear_curveR.split('\n'):
                t=s.split('|')
                if len(t)>1:
                    wearRkm.append(get_float(t[0]))
                    wearRperc.append(get_float(t[1]))

            minTF100 = max(get_val_from_lut(100.0 , wearFperc, wearFkm      ), 0)   # min tyre temp front
            maxTF100 = min(get_val_from_lut(100.0 , wearFperc, wearFkm, True), 10000)   # max tyre temp front
            minTR100 = max(get_val_from_lut(100.0 , wearRperc, wearRkm      ), 0)   # min tyre temp rear
            maxTR100 = min(get_val_from_lut(100.0 , wearRperc, wearRkm, True), 10000)   # max tyre temp rear

            minTF98  = max(get_val_from_lut( 98.0 , wearFperc, wearFkm      ), 0)   # min tyre temp front
            maxTF98  = min(get_val_from_lut( 98.0 , wearFperc, wearFkm, True), 10000)   # max tyre temp front
            minTR98  = max(get_val_from_lut( 98.0 , wearRperc, wearRkm      ), 0)   # min tyre temp rear
            maxTR98  = min(get_val_from_lut( 98.0 , wearRperc, wearRkm, True), 10000)   # max tyre temp rear

            minTF95  = max(get_val_from_lut( 95.0 , wearFperc, wearFkm      ), 0)   # min tyre temp front
            maxTF95  = min(get_val_from_lut( 95.0 , wearFperc, wearFkm, True), 10000)   # max tyre temp front
            minTR95  = max(get_val_from_lut( 95.0 , wearRperc, wearRkm      ), 0)   # min tyre temp rear
            maxTR95  = min(get_val_from_lut( 95.0 , wearRperc, wearRkm, True), 10000)   # max tyre temp rear

            minTF90  = max(get_val_from_lut( 90.0 , wearFperc, wearFkm      ), 0)   # min tyre temp front
            maxTF90  = min(get_val_from_lut( 90.0 , wearFperc, wearFkm, True), 10000)   # max tyre temp front
            minTR90  = max(get_val_from_lut( 90.0 , wearRperc, wearRkm      ), 0)   # min tyre temp rear
            maxTR90  = min(get_val_from_lut( 90.0 , wearRperc, wearRkm, True), 10000)   # max tyre temp rear

            minTF85  = max(get_val_from_lut( 85.0 , wearFperc, wearFkm      ), 0)   # min tyre temp front
            maxTF85  = min(get_val_from_lut( 85.0 , wearFperc, wearFkm, True), 10000)   # max tyre temp front
            minTR85  = max(get_val_from_lut( 85.0 , wearRperc, wearRkm      ), 0)   # min tyre temp rear
            maxTR85  = min(get_val_from_lut( 85.0 , wearRperc, wearRkm, True), 10000)   # max tyre temp rear

            #if minTF100>0 and maxTF100>0 and minTR100>0 and maxTR100>0 and minTF100<400 and maxTF100<400 and minTR100<400 and maxTR100<400:
            if minTF100 == minTR100 and maxTF100==maxTR100:
                sIdealGrip =  (  "100% grip F+R:  "   + str(round(minTF100,3))  + "-" + str(round(maxTF100,3)) + ' Vkm' +
                              "\n  98% grip F+R:  "   + str(round(minTF98 ,3))  + "-" + str(round(maxTF98 ,3)) + ' Vkm' +
                              "\n  95% grip F+R:  "   + str(round(minTF95 ,3))  + "-" + str(round(maxTF95 ,3)) + ' Vkm'
                              #"\n  90% grip F+R: "   + str(round(minTF90 ,1))  + "-" + str(round(maxTF90 ,1)) + ' Vkm' +
                              #"\n  85% grip F+R: "   + str(round(minTF85 ,1))  + "-" + str(round(maxTF85 ,1)) + ' Vkm'
                              )
            else:
                extraHeight += fntSize*1.25
                sIdealGrip = (  "100% grip Front :  " + str(round(minTF100,3))  + "-" + str(round(maxTF100,3)) + ' Vkm' +
                              "\n100% grip Rear  :  " + str(round(minTR100,3))  + "-" + str(round(maxTR100,3)) + ' Vkm' +
                             "\n  98% grip Front:  " + str(round(minTF98 ,3))  + "-" + str(round(maxTF98 ,3)) + ' Vkm' +
                             "\n  98% grip Rear :  " + str(round(minTR98 ,3))  + "-" + str(round(maxTR98 ,3)) + ' Vkm' +
                             "\n  95% grip Front:  " + str(round(minTF95 ,3))  + "-" + str(round(maxTF95 ,3)) + ' Vkm' +
                             "\n  95% grip Rear :  " + str(round(minTR95 ,3))  + "-" + str(round(maxTR95 ,3)) + ' Vkm'
                             #"\n  90% grip Front: " + str(round(minTF90 ,1))  + "-" + str(round(maxTF90 ,1)) + ' Vkm' +
                             #"\n  90% grip Rear : " + str(round(minTR90 ,1))  + "-" + str(round(maxTR90 ,1)) + ' Vkm' +
                             #"\n  85% grip Front: " + str(round(minTF85 ,1))  + "-" + str(round(maxTF85 ,1)) + ' Vkm' +
                             #"\n  85% grip Rear : " + str(round(minTR85 ,1))  + "-" + str(round(maxTR85 ,1)) + ' Vkm'
                             )
            #else:
            #    sIdealGrip = 'could not load ideal grip from wearcurve'

            extraHeight += fntSize*1.25
        else:
            sIdealGrip = 'could not load ideal grip from wearcurve'

        if len(temp_curveF)>0 and len(temp_curveR)>0:
            for s in temp_curveF.split('\n'):
                t=s.split('|')
                if len(t)>1:
                    tempFtemp.append(get_float(t[0]))
                    tempFgrip.append(get_float(t[1]))
            for s in temp_curveR.split('\n'):
                t=s.split('|')
                if len(t)>1:
                    tempRtemp.append(get_float(t[0]))
                    tempRgrip.append(get_float(t[1]))

            minTF100 = max(get_val_from_lut(1.0 , tempFgrip, tempFtemp      ), minTF)   # min tyre temp front
            minTR100 = max(get_val_from_lut(1.0 , tempRgrip, tempRtemp      ), minTR)   # min tyre temp rear
            maxTF100 = min(get_val_from_lut(1.0 , tempFgrip, tempFtemp, True), maxTF)   # max tyre temp front
            maxTR100 = min(get_val_from_lut(1.0 , tempRgrip, tempRtemp, True), maxTR)   # max tyre temp rear
            if minTF100==maxTF100:
                minTF100 = max(get_val_from_lut(0.9999 , tempFgrip, tempFtemp      ), minTF)   # min tyre temp front
                minTR100 = max(get_val_from_lut(0.9999 , tempRgrip, tempRtemp      ), minTR)   # min tyre temp rear
                maxTF100 = min(get_val_from_lut(0.9999 , tempFgrip, tempFtemp, True), maxTF)   # max tyre temp front
                maxTR100 = min(get_val_from_lut(0.9999 , tempRgrip, tempRtemp, True), maxTR)   # max tyre temp rear
                if minTF100==maxTF100:
                    minTF100 = max(get_val_from_lut(0.999 , tempFgrip, tempFtemp      ), minTF)   # min tyre temp front
                    minTR100 = max(get_val_from_lut(0.999 , tempRgrip, tempRtemp      ), minTR)   # min tyre temp rear
                    maxTF100 = min(get_val_from_lut(0.999 , tempFgrip, tempFtemp, True), maxTF)   # max tyre temp front
                    maxTR100 = min(get_val_from_lut(0.999 , tempRgrip, tempRtemp, True), maxTR)   # max tyre temp rear
                    if minTF100==maxTF100:
                        minTF100 = max(get_val_from_lut(0.99 , tempFgrip, tempFtemp      ), minTF)   # min tyre temp front
                        minTR100 = max(get_val_from_lut(0.99 , tempRgrip, tempRtemp      ), minTR)   # min tyre temp rear
                        maxTF100 = min(get_val_from_lut(0.99 , tempFgrip, tempFtemp, True), maxTF)   # max tyre temp front
                        maxTR100 = min(get_val_from_lut(0.99 , tempRgrip, tempRtemp, True), maxTR)   # max tyre temp rear
                        if minTF100==maxTF100:
                            minTF100 = max(get_val_from_lut(0.9 , tempFgrip, tempFtemp      ), minTF)   # min tyre temp front
                            minTR100 = max(get_val_from_lut(0.9 , tempRgrip, tempRtemp      ), minTR)   # min tyre temp rear
                            maxTF100 = min(get_val_from_lut(0.9 , tempFgrip, tempFtemp, True), maxTF)   # max tyre temp front
                            maxTR100 = min(get_val_from_lut(0.9 , tempRgrip, tempRtemp, True), maxTR)   # max tyre temp rear
                            if minTF100==maxTF100:
                                minTF100 = max(get_val_from_lut(0.9875 , tempFgrip, tempFtemp      ), minTF)   # min tyre temp front
                                minTR100 = max(get_val_from_lut(0.9875 , tempRgrip, tempRtemp      ), minTR)   # min tyre temp rear
                                maxTF100 = min(get_val_from_lut(0.9875 , tempFgrip, tempFtemp, True), maxTF)   # max tyre temp front
                                maxTR100 = min(get_val_from_lut(0.9875 , tempRgrip, tempRtemp, True), maxTR)   # max tyre temp rear
                                if minTF100==maxTF100:
                                    minTF100 = max(get_val_from_lut(0.985 , tempFgrip, tempFtemp      ), minTF)   # min tyre temp front
                                    minTR100 = max(get_val_from_lut(0.985 , tempRgrip, tempRtemp      ), minTR)   # min tyre temp rear
                                    maxTF100 = min(get_val_from_lut(0.985 , tempFgrip, tempFtemp, True), maxTF)   # max tyre temp front
                                    maxTR100 = min(get_val_from_lut(0.985 , tempRgrip, tempRtemp, True), maxTR)   # max tyre temp rear

            ### set min for tyre coloring, get max from lut
            minTFLUT = get_val_from_lut(0.950, tempFgrip, tempFtemp      )
            minTRLUT = get_val_from_lut(0.950, tempRgrip, tempRtemp      )
            ### set max for tyre coloring, get max from reverse lut
            maxTFLUT = get_val_from_lut(0.985, tempFgrip, tempFtemp, True)
            maxTRLUT = get_val_from_lut(0.985, tempRgrip, tempRtemp, True)
            if minTFLUT>0 and maxTFLUT>0 and minTRLUT>0 and maxTRLUT>0 and minTFLUT<400 and maxTFLUT<400 and minTRLUT<400 and maxTRLUT<400:
                # overwrite defaults, set on top of this file
                minTF = minTFLUT  # 55    # min tyre temp front
                maxTF = maxTFLUT  # 125   # max tyre temp front
                minTR = minTRLUT  # 55    # min tyre temp rear
                maxTR = maxTRLUT  # 125   # max tyre temp rear

            if minTF100 == minTR100 and maxTF100==maxTR100:
                sIdealTemps =   "ideal temps F+R:   "   + appGetTempText(minTF100, False, True)  + "-" + appGetTempText(maxTF100, False, True)
                # if gUnits["temp"] == "C":
                #     sIdealTemps =   "ideal temps F+R:   "   + str(int(       minTF100))  + "-" + str(int(maxTF100)) + '°C'
                # else:
                #     sIdealTemps =   "ideal temps F+R:   "   + str(int(C_to_F(minTF100)))  + "-" + str(int(C_to_F(maxTF100))) + 'F'
            else:
                extraHeight += fntSize*1.25
                sIdealTemps = (      "ideal temps Front:   " + appGetTempText(C_to_F(minTF100), False, True)  + "-" + appGetTempText(C_to_F(maxTF100), False, True)+
                              "\n                 Rear   : " + appGetTempText(C_to_F(minTR100), False, True)  + "-" + appGetTempText(C_to_F(maxTR100), False, True) )
                # if gUnits["temp"] == "C":
                #     sIdealTemps = ( "ideal temps Front:   " + str(int(C_to_F(minTF100)))  + "-" + str(int(C_to_F(maxTF100))) + '°C' +
                #                   "\n                 Rear   : " + str(int(C_to_F(minTR100)))  + "-" + str(int(C_to_F(maxTR100))) + '°C'  )
                # else:
                #     sIdealTemps = ( "ideal temps Front:   " + str(int(C_to_F(minTF100)))  + "-" + str(int(C_to_F(maxTF100))) + 'F' +
                #                   "\n                 Rear   : " + str(int(C_to_F(minTR100)))  + "-" + str(int(C_to_F(maxTR100))) + 'F' )
        else:
            sIdealTemps = 'could not load ideal temps fr. th. curve'

        # ac_presOpt["FL"], ac_presOpt["FR"], ac_presOpt["RL"], ac_presOpt["RR"] = ac.getCarState(currcar, acsys.CS.DynamicPressure)
        if carname == 'ier_p13c':
            ac_presOpt["FR"] = 32.0    #28.0
            ac_presOpt["RL"] = 32.0    #28.0
            ac_presOpt["RR"] = 32.0    #28.0
            ac_presOpt["FL"] = 32.0    #28.0
        else:
            ac_presOpt["FL"] = ACD_FILE.get_ideal_pressure(localCompNameShort, 0)
            ac_presOpt["FR"] = ACD_FILE.get_ideal_pressure(localCompNameShort, 1)
            ac_presOpt["RL"] = ACD_FILE.get_ideal_pressure(localCompNameShort, 2)
            ac_presOpt["RR"] = ACD_FILE.get_ideal_pressure(localCompNameShort, 3)

        if ac_presOpt["FL"] == 0 and ac_presOpt["FR"] == 0 and ac_presOpt["RL"] == 0 and ac_presOpt["RR"] == 0:
            sIdealPress = 'failed, current is ideal pressure!'
            ac_presOpt["FL"] = round(ac_pres["FL"],1)
            ac_presOpt["FR"] = round(ac_pres["FR"],1)
            ac_presOpt["RL"] = round(ac_pres["RL"],1)
            ac_presOpt["RR"] = round(ac_pres["RR"],1)

            # if os.path.isfile(userDir+'/Assetto Corsa/cfg/assists.ini'):
            #     configassists = ConfigParser(empty_lines_in_values=False, strict=False, allow_no_value=True, inline_comment_prefixes=(";","#","/","_",","), comment_prefixes=(";","#","/","_",","))
            #     configassists.optionxform = str
            #     # "Assetto Corsa/cfg/assists.ini" -> [ASSISTS] -> TYRE_BLANKETS=1
            #     configassists.read(userDir+'/Assetto Corsa/cfg/assists.ini')
            #     if configassists.has_option('ASSISTS', 'TYRE_BLANKETS'):
            #         if str(configassists.getint('ASSISTS','TYRE_BLANKETS'))=='0':
            #             ac_presOpt["FL"] = ac_presOpt["FL"] + 8
            #             ac_presOpt["FR"] = ac_presOpt["FR"] + 8
            #             ac_presOpt["RL"] = ac_presOpt["RL"] + 8
            #             ac_presOpt["RR"] = ac_presOpt["RR"] + 8

        else:
            if ac_presOpt["FR"] == ac_presOpt["RR"] and ac_presOpt["FL"] == ac_presOpt["RL"]:
                if   gUnits["pressure"] == "BAR": sIdealPress = "ideal pressure F+R: %.2f bar" % (PSI_to(ac_presOpt["FR"]))
                elif gUnits["pressure"] == "KPA": sIdealPress = "ideal pressure F+R: %.1f kpa" % (PSI_to(ac_presOpt["FR"], to = "KPA"))
                else:                             sIdealPress = "ideal pressure F+R: %.1f psi" % (ac_presOpt["FR"])
            else:
                extraHeight += fntSize*1.25
                if   gUnits["pressure"] == "BAR": sIdealPress = "ideal pressure F/R: %.2f bar" % (PSI_to(ac_presOpt["FR"]))             + " / %.2f bar" % (PSI_to(ac_presOpt["RR"]))
                elif gUnits["pressure"] == "KPA": sIdealPress = "ideal pressure F/R: %.1f kpa" % (PSI_to(ac_presOpt["FR"], to = "KPA")) + " / %.2f kpa" % (PSI_to(ac_presOpt["RR"], to = "KPA"))
                else:                             sIdealPress = "ideal pressure F/R: %.1f psi" % (ac_presOpt["FR"])                     + " / %.2f psi" % (ac_presOpt["RR"])

        if carname == 'ier_p13c':
            frict_limit_angF = 8.0
            frict_limit_angR = 8.0
        else:
            frict_limit_angF = ACD_FILE.get_FRICTION_LIMIT_ANGLE(localCompNameShort, 0)
            frict_limit_angR = ACD_FILE.get_FRICTION_LIMIT_ANGLE(localCompNameShort, 2)


        tyresVersion = ""
        if config.has_section('HEADER'):
            if config.has_option('HEADER','VERSION'):
                tyresVersion = str(config['HEADER']['VERSION'])
        tirenameLong  = get_tire_namelong(localCompNameShort, config, 0) + '  (' + localCompNameShort + ')' # \n                                     v' + tyresVersion
        PRESSURE_STATIC_F =  str(ACD_FILE.get_file_section_value(config, "FRONT","PRESSURE_STATIC", "SHORT_NAME", localCompNameShort))
        PRESSURE_STATIC_R =  str(ACD_FILE.get_file_section_value(config, "REAR" ,"PRESSURE_STATIC", "SHORT_NAME", localCompNameShort))
        if PRESSURE_STATIC_F==PRESSURE_STATIC_R:
            sIdealPress += ('\n  static press. F+R  : ' + PRESSURE_STATIC_F )
        else:
            sIdealPress += ('\n  static press. F/R  : ' + PRESSURE_STATIC_F + ' / ' + PRESSURE_STATIC_R)

        baseAEROdens = -1.0
        basecgHeight = -1.0
        WHEELS["coldRead"] = True
        WHEELS["FL"]["temp"]["cold"] = ac_temp["FL"]
        WHEELS["FR"]["temp"]["cold"] = ac_temp["FR"]
        WHEELS["RL"]["temp"]["cold"] = ac_temp["RL"]
        WHEELS["RR"]["temp"]["cold"] = ac_temp["RR"]
        WHEELS["FL"]["tempI"]["cold"] = tyreTempI["FL"]
        WHEELS["FR"]["tempI"]["cold"] = tyreTempI["FR"]
        WHEELS["RL"]["tempI"]["cold"] = tyreTempI["RL"]
        WHEELS["RR"]["tempI"]["cold"] = tyreTempI["RR"]
        WHEELS["FL"]["tempM"]["cold"] = tyreTempM["FL"]
        WHEELS["FR"]["tempM"]["cold"] = tyreTempM["FR"]
        WHEELS["RL"]["tempM"]["cold"] = tyreTempM["RL"]
        WHEELS["RR"]["tempM"]["cold"] = tyreTempM["RR"]
        WHEELS["FL"]["tempO"]["cold"] = tyreTempO["FL"]
        WHEELS["FR"]["tempO"]["cold"] = tyreTempO["FR"]
        WHEELS["RL"]["tempO"]["cold"] = tyreTempO["RL"]
        WHEELS["RR"]["tempO"]["cold"] = tyreTempO["RR"]
        WHEELS["FL"]["ctemp"]["cold"] = ac_temp["FL"]
        WHEELS["FR"]["ctemp"]["cold"] = ac_temp["FR"]
        WHEELS["RL"]["ctemp"]["cold"] = ac_temp["RL"]
        WHEELS["RR"]["ctemp"]["cold"] = ac_temp["RR"]

        appResize()
        ac.setTitle(appWindow,"")  # "Tyres app Ext"
        ac.setTitle(appInfo,"Tyres: " + tirenameLong + '\n                                     v' + tyresVersion)
        hideTimer = 0.02
    except:
        ac.setTitle(appWindow,"")  # "Tyres app Ext"
        ac.log('tyre_app_ext: ' + traceback.format_exc() )



def appReset(*args):
    global thread
    if not thread or not thread.is_alive():
        #thread = threading.Thread(target=runAsThreadLap, args=(sf,))
        thread = threading.Thread(target=appResetGo)
        thread.start()

def onappSettings(*args):
    global b_settings, appSettingstyapp, appWindow
    global hideTimer, bHideTimerOn, fMaxsTimer, fMinsTimer
    try:
        ac.setVisible(appSettingstyapp, 1)
        fMaxsTimer = [-1.0]*(30)
        fMinsTimer = [-1.0]*(30)
        appHideButtons()
    except:
        ac.log('tyre_app_ext: ' + traceback.format_exc() )

def apptoggleIMO(*args):
    global bSHOWIMO
    bSHOWIMO = not bSHOWIMO
    appResize()

def appBraketoggle(*args):
    global brakeDetection, bCPhysBrakesEnabled, brakestempsConfigured
    bCPhysBrakesEnabled = not bCPhysBrakesEnabled
    if bCPhysBrakesEnabled:
        brakeDetection=True
        brakestempsConfigured=True
    appResize()

def appBrakeTextToggle(*args):
    global bCPhysBrakesText
    bCPhysBrakesText = not bCPhysBrakesText
    appResize()

def appCarcassToggle(*args):
    global bCPhysCarcassText
    bCPhysCarcassText = not bCPhysCarcassText
    appResize()

def appclickBars(*args):
    global appInfo, lbTimer
    ac.setVisible(appInfo,1)
    ac.setText(lbTimer,"")

def apptogglePressureDisplay(*args):
    global bShowPressureDiff
    bShowPressureDiff = not bShowPressureDiff
    appResize()


def appTyreNext(*args):
    global tyreID, tyreIDMAX, tyreIDcurr
    global bTimerResetTyreToCurrent, TimerReset, TIME_SwitchBackToDefaultTyre
    if tyreID+1<tyreIDMAX:
        tyreID += 1
        tyreIDcurr = tyreID
        appReset()
        bTimerResetTyreToCurrent = True
        TimerReset = TIME_SwitchBackToDefaultTyre

def appTyrePrev(*args):
    global tyreID, tyreIDMAX, tyreIDcurr
    global bTimerResetTyreToCurrent, TimerReset, TIME_SwitchBackToDefaultTyre
    if tyreID-1>=0:
        tyreID -= 1
        tyreIDcurr = tyreID
        appReset()
        bTimerResetTyreToCurrent = True
        TimerReset = TIME_SwitchBackToDefaultTyre
