#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Module to keep some utility functions.

@author: albertowd
"""

from datetime import datetime
import ac

def log(message, console=True, app_log=True):
    """ Logs a message on the log and console. """
    time_str = datetime.utcnow().strftime("%H:%M:%S.%f")
    formated = "[LT][{}] {}".format(time_str, message)
    if console:
        ac.console(formated)
    if app_log:
        ac.log(formated)
