--

ac.debug("RSS Formula Hybrid 2024","LED")

if car.isAIControlled then
	return nil
end

local SIM = ac.getSim()
local LED = {}
local LEDCollar = {}
local LEDMode = {}
local PitLimiter = false
local AntiStole = false
local Timer = 0
local Green = vec3(0,428,0)
local Red = vec3(428,0,0)
local Blue = vec3(0, 90,900)
local Yellow = vec3(400,200,0)
local OFF = vec3(0,0,0)
local PIT_lut =  ac.DataLUT11.load("assets/PitLimiter.lut")
local StartMode_lut =  ac.DataLUT11.load("assets/StartMode.lut")
local LED_Config = ac.INIConfig.load(ac.getFolder(ac.FolderID.ContentCars).."/"..ac.getCarID(0).."/skins/"..ac.getCarSkinID(0).."/LED_override/".."LED_SETTING.ini")

if LED_Config:get("LED_SETTING","ACTIVE",nil) == nil then
    LED_Config = ac.INIConfig.load("ext_config_mfd.ini")
end
local LED_lut =  LED_Config:tryGetLut("LED_SETTING","RPM_Lut")

local DrsData = ac.INIConfig.trackData("drs_zones.ini")
local ZonesCount = 0
local DETECTION = {}
local END = {}
local index = 0
local CarPos = 0
local DRSD = false

local INITIALIZED = false

local MFDKey = ac.getCarID(car.index) .. "_mfd"
local MFDsharedData = {
	ac.StructItem.key(MFDKey .. "_" .. car.index),
	SpeedUnit = ac.StructItem.int32(),
	MFDPage =  ac.StructItem.int32(),
	MFDBrt =  ac.StructItem.int32(),
	LEDBrt =  ac.StructItem.int32()
}
MFD = ac.connect(MFDsharedData, false, ac.SharedNamespace.Shared)

IGKey = ac.getCarID(car.index) .. "_Ignition"
local IGsharedData = {
	ac.StructItem.key(IGKey .. "_" .. car.index),
	Mode = ac.StructItem.int32()
}
Ignition = ac.connect(IGsharedData, false, ac.SharedNamespace.Shared)

FHSystemKey = "Formula_Hybrid_System"
local FHSystemsharedData = {
	ac.StructItem.key(FHSystemKey .. "_" .. car.index),
	BrakeMigration = ac.StructItem.float(),
	BrakeMigrationRamp = ac.StructItem.float(),
	DiffEntry = ac.StructItem.int32(),
	DiffMid = ac.StructItem.int32(),
	DiffExit = ac.StructItem.int32(),
	DiffExitSpeed = ac.StructItem.int32(),
	FuelTarget = ac.StructItem.float(),
	StartMode = ac.StructItem.boolean(),
	AntiStall = ac.StructItem.boolean()
}
FHSystem = ac.connect(FHSystemsharedData, false, ac.SharedNamespace.Shared)

local function initialize()

    for i = 0,16 do
        if i < 14 then
            LED[i] = ac.findNodes("carRoot:" .. car.index):findMeshes("GSI_LED_"..i):ensureUniqueMaterials()
            if i < 1 then
                LEDCollar[i] = Yellow
            elseif i < 2 then
                LEDCollar[i] = Green
            elseif i < 4 then
                LEDCollar[i] = Red
            elseif i < 9 then
                LEDCollar[i] = Red
            else
                LEDCollar[i] = Blue
            end
            LEDMode[i] = LED_Config:get("LED_SETTING","LED_"..i,-1)
        else
            LED[14] = ac.findNodes("carRoot:" .. car.index):findMeshes("LED_R"):ensureUniqueMaterials()
            LEDCollar[14] = Yellow
            LED[15] = ac.findNodes("carRoot:" .. car.index):findMeshes("LED_G"):ensureUniqueMaterials()
            LEDCollar[15] = Red
            LED[16] = ac.findNodes("carRoot:" .. car.index):findMeshes("LED_B"):ensureUniqueMaterials()
            LEDCollar[16] = Blue
            LED[17] = ac.findNodes("carRoot:" .. car.index):findMeshes("GSI_LED_WHITE"):ensureUniqueMaterials()
            LEDCollar[17] = vec3(3,3,3)
        end
        LED[i]:setMaterialProperty("ksDiffuse",0.01)
    end

    repeat
        DETECTION[index] = DrsData:get('ZONE_'..index, 'DETECTION',-1)
        END[index] = DrsData:get('ZONE_'..index, 'END',-1)
        index = index + 1
    until DrsData:get('ZONE_'..index, 'END',nil) == nil
    ZonesCount = index - 1

    Blink_RPM = LED_Config:get("LED_SETTING","Blink_RPM",16000)
    Blink_Hz = LED_Config:get("LED_SETTING","Blink_Hz",0)
    INITIALIZED = true

end

function drs()
    CarPos = car.splinePosition
    DRSD = false
    for i = 0,ZonesCount do
        if CarPos < END[i] and CarPos > DETECTION[i] then
            DRSD = true
        end

        if END[i] < DETECTION[i] then
            if CarPos < END[i] or CarPos > DETECTION[i] then
                DRSD = true
            end
        end
        if car.drsAvailable then
            DRSD = true
        end
    end
end

function ledcontrol()

    for i = 0,17 do
        LED[i]:setMaterialProperty("ksEmissive",OFF)
        if i < 14 then
            if car.rpm > LED_lut:get(i) and car.gear < 8 then
                LED[i]:setMaterialProperty("ksEmissive",LEDCollar[i]*Brightness)
            end

            if 16000 > LED_lut:get(i) and car.rpm > Blink_RPM then
                LED[i]:setMaterialProperty("ksEmissive",OFF)
                if (math.floor((Timer*Blink_Hz*2)%2)) == 0 then
                    LED[i]:setMaterialProperty("ksEmissive",LEDCollar[i]*Brightness)
                end
            end

            if LEDMode[i] == 0 then
                if DRSD then
                    LED[i]:setMaterialProperty("ksEmissive", LEDCollar[i]*Brightness)
                end
            elseif LEDMode[i] == 1 then
                if car.drsAvailable then
                    LED[i]:setMaterialProperty("ksEmissive", LEDCollar[i]*Brightness)
                end
            elseif LEDMode[i] == 2 then
                if car.drsActive then
                    LED[i]:setMaterialProperty("ksEmissive", LEDCollar[i]*Brightness)
                end
            elseif LEDMode[i] == 3 then
                if car.drsAvailable and not car.drsActive then
                    LED[i]:setMaterialProperty("ksEmissive", LEDCollar[i]*Brightness)
                end
            elseif LEDMode[i] == 4 then
                if car.kersButtonPressed then
                    LED[i]:setMaterialProperty("ksEmissive", LEDCollar[i]*Brightness)
                end
            elseif LEDMode[i] == 5 then
                if car.fuel < car.fuelPerLap*1.5 then
                    LED[i]:setMaterialProperty("ksEmissive", LEDCollar[i]*Brightness)
                end
            elseif LEDMode[i] == 6 then
                if car.mgukDelivery == 0 and car.mguhChargingBatteries then
                    LED[i]:setMaterialProperty("ksEmissive", LEDCollar[i]*Brightness)
                end
            end

            if not SIM.isReplayActive then
                if PitLimiter then
                    LED[i]:setMaterialProperty("ksEmissive",OFF)
                    if math.abs(car.speedKmh-PitSpeed) < PIT_lut:get(i) then
                        LED[i]:setMaterialProperty("ksEmissive", LEDCollar[i]*Brightness)
                    end
                end

                if FHSystem.StartMode then
                    LED[i]:setMaterialProperty("ksEmissive", OFF)
                    if car.rpm > StartMode_lut:get(i) and car.rpm < StartMode_lut:get(i+2) then
                        LED[i]:setMaterialProperty("ksEmissive", LEDCollar[i]*Brightness)
                    end
                end

                if AntiStole then
                    LED[i]:setMaterialProperty("ksEmissive",OFF)
                    if (math.floor((Timer*3)%2)) == 0 then
                        if math.fmod(i,2) == 0 then
                            LED[i]:setMaterialProperty("ksEmissive", LEDCollar[i]*Brightness)
                        end
                    else
                        if math.fmod(i,2) == 1 then
                            LED[i]:setMaterialProperty("ksEmissive", LEDCollar[i]*Brightness)
                        end
                    end
                end
            end

        end
    end

    if SIM.raceFlagType == ac.FlagType.Caution and (math.floor((Timer*5)%2)) == 0 then
        LED[14]:setMaterialProperty("ksEmissive",LEDCollar[14]*Brightness)
    end

    if SIM.raceFlagType == ac.FlagType.FasterCar and (math.floor((Timer*5)%2)) == 0 then
        LED[16]:setMaterialProperty("ksEmissive",LEDCollar[16]*Brightness)
    end

    if car.headlightsActive then
        LED[17]:setMaterialProperty("ksEmissive",LEDCollar[17])
    end
end

function update(dt)

    if not INITIALIZED then initialize() end

    Brightness = MFD.LEDBrt/100
    Timer = Timer + dt
    AntiStole = FHSystem.AntiStall
    PitSpeed = car.speedLimiter
    drs()

	if (car.manualPitsSpeedLimiterEnabled == true) or (car.isInPitlane == true) then
		PitLimiter = true
	else
		PitLimiter = false
	end

    if Ignition.Mode > 0 or SIM.isReplayActive then
        ledcontrol()
    else
        for i = 0,17 do
            LED[i]:setMaterialProperty("ksEmissive",OFF)
        end
    end
end