-- This is just an example, how custom sol config could be used
-- This file must have the same name like your PPFilter and the extension lua

-- For your release version, this file should be placed in the folder /system/cfg/ppfilters/sol_custom_configs/
-- For realtime editing, you can place it in /extension/weather/sol as well.

-- a LUT is defined, this will control godrays
n=1
local godrays = {}

godrays[n] = {  -90, 0 } n=n+1
godrays[n] = {  0.5, 0 } n=n+1
godrays[n] = {    2, 1 } n=n+1
godrays[n] = {   90, 1 } n=n+1

local godrays_length = 20


function init_sol_custom_config()

	-- This will be called once at the start of a session, directly after calling Sol's config
	-- Just copy the values from Sol's config you want to change with the use of your PPFilter and put it here - like:
	
	-- night__moonlight_multiplier = 3.0

	--[[ !!!!!!!!!!!!!!!!!!!!!!!!!!
		
		Do not redefine table/arrays, this could cause errors in future releases !!!

		Access the single members:

		nerd__moon_adjust.low_Hue = 40 
		nerd__moon_adjust.low_Saturation = 1.0
		nerd__moon_adjust.high_Hue = 220
		nerd__moon_adjust.high_Saturation = 0.45
	]]

	-- reset customs to default
	ac.resetGodraysCustomColor()
	ac.resetGodraysCustomDirection()
	ac.resetWeatherStaticAmbient()
	ac.resetShadowsResolution()
	ac.resetShadowsSplits()
	ac.resetSpecularColor()
	ac.resetHorizonFogMultiplier()
	ac.resetGlowBrightness()
	ac.resetWeatherLightsMultiplier()
	ac.resetEmissiveMultiplier()

	ac.setCarExposureActive(false)
	ac.setAutoExposureLimits(0.3, 0.55)

	
	ac.setPpColorTemperatureK(6150)
	-- whitebalance is modulated by Sol if "ppfilter__modify_spectrum" is activated
	ac.setPpWhiteBalanceK(6250)

	ac.setPpSepia(0)
	ac.setPpTonemapGamma(1.45)
	ac.setPpTonemapFilmicContrast(0.50)
	--ac.setPpSaturation(0.98)
	ac.setPpContrast(1.00)
	ac.setPpBrightness(1.00)

	ac.setWeatherFakeShadowOpacity(0.85)
	ac.setWeatherFakeShadowConcentrarion(0.65)

	-- read the godrays length from the PPFilter
	godrays_length = weather__get_PPFilter_INI_Settings("GODRAYS", "LENGTH")
end

function update_sol_custom_config(dt)

	-- This will be called every frame
	-- If you want to dynamically change value, do this here.

	-- Please, whatever you do here, do it advisedly. You can mess up everything here. 

	--[[  You can use this weatherFX functions to set PP Filter values:

		ac.setAutoExposureTarget(v)
		ac.setAutoExposureLimits(min, max)
		ac.setGodraysLength(v)
		ac.setGodraysGlareRatio(v)
		ac.setGodraysAngleAttenuation(v)
		ac.setGodraysNoiseFrequency(v)
		ac.setGodraysNoiseMask(v)
		ac.setGodraysDepthMapThreshold(v)
		ac.setGlareThreshold(v)
		ac.setGlareBloomFilterThreshold(v)
		ac.setGlareStarFilterThreshold(v)
		ac.setPpColorTemperatureK(v)
		ac.setPpWhiteBalanceK(v)    
		ac.setPpHue(v)
		ac.setPpSepia(v)
		ac.setPpSaturation(v)
		ac.setPpBrightness(v)
		ac.setPpContrast(v)
		ac.setPpTonemapFunction(int v)
		ac.setPpTonemapExposure(v)
		ac.setPpTonemapGamma(v)
		ac.setPpTonemapMappingFactor(v)
		ac.setPpTonemapFilmicContrast(v)
	]]


	--##############################################################################################
	--[[  This are some functions, to create dependencies to the sunangle
		
		The compensate function returning the given value or 1 (its mainly used as an multiplicator)

		- transition between v and 1 is with sunangles between -6° and -12°
		day_compensate(v)   - returns 1 while day | v while night
		night_compensate(v) - returns 1 while night | v while day

		- transition between v and 1 is with sunangles between +3° and -6°
		from_twilight_compensate(v)  - returns 1 while day | v while night

		- transition between v and 1 is with sunangles between +6° and 0°
		sun_compensate(v)   - returns 1 with sun | v when sun is < 0°

		- transition between v and 1 is with sunangles between +10° and -11°
		duskdawn_compensate(v)  - returns 1 while dusk or dawn
		
		- transition between v and 1 is with sunangles between +30°->+10° and -9°->-20°
		dawn_exclusive(v) 	- returns 1 while not in dawn
		dusk_exclusive(v) 	- returns 1 while not in dusk

		- __IntD(x, y, e) - "Interpolate Day" 
		sin function of the sun angle, to interpolate between:
		x (value when sunangle is 0°) and y (value when sun is 90°)
		e is the exponent of the sin function a = sin(sunangle)^e
		For example __IntD(0, 1, 0.5), will return almost 1 till the sun is realy near the horizon


		E.g.
		"Boost PP Brightness in the night"

		1. Method:
		ac.setPpBrightness( 1.14 * day_compensate(1.1) )

		Brightness will then be 1.14 at day and 1.254 at night


		2. Method (using math.lerp):
		ac.setPpBrightness( math.lerp( 1.254, 1.14, day_compensate(0) ) )
	]]

	--##############################################################################################
	--[[  You can request the main weather modulators / effects
		weather__get_fog_dense()
		weather__get_overcast() 
		weather__get_badness()
		weather__get_hdr_multiplier()
		weather__get_cloud_shadow()
		weather__get_cloud_density()
		weather__get_ambient_brightness()

		E.g.
		"Boost PP Brightness with bad weather"

		1. Method (using math.lerp):
		ac.setPpBrightness( math.lerp( 1.0, 1.2, weather__get_badness() ) )
	]]

	-- You can make different settings for interior and exterior view
	if ac.isInteriorView() == true then 
		--interior
		
		--better brightness adaption for better driving visibility
		--ppfilter__brightness_sun_link = sun_link * 1.25
		SOL__set_config("pp", "brightness_sun_link", 1.25, true)

		--more contrast to prevent an overbright cockpit
		ac.setPpTonemapFilmicContrast(0.00 + 0.45*from_twilight_compensate(0))
		--more gamma for a better driving visibility
		ac.setPpTonemapGamma(1.35)

		--reduce brightness a bit for nighttimes
		--mainly to prevent too bright HUD and instruments, gamma is enough to compensate it.
		ac.setPpBrightness(0.75+0.10*day_compensate(0))

		ac.setPpContrast(1.00)
	else
		--exterior

		--set to normal brightness adaption
		SOL__set_config("pp", "brightness_sun_link", 1.00, true)

		--set a moderate contrast
		ac.setPpTonemapFilmicContrast(0.00 + 0.3*from_twilight_compensate(0))
		--set a moderate gamma, but not for nighttimes
		ac.setPpTonemapGamma(night_compensate(1.30))

		--do more brightness in nighttimes
		ac.setPpBrightness(night_compensate(0.85))

		ac.setPpContrast(1.00 + 0.04 * from_twilight_compensate(0))
	end

	--if AUTOEXPOSURE will be activated, better set a target value:
	--set AE target || 0.25 at night | 0.35 at day
	ac.setAutoExposureTarget(0.25 + 0.10 * from_twilight_compensate(0))

	local exp_at_night = 0.7
	local exp_at_twilight = 0.5
	local exp_at_day = 0.35

	local exp = math.lerp(math.lerp( exp_at_twilight, exp_at_day, sun_compensate(0)), exp_at_night, night_compensate(0))
	
	SOL_filter__set_exposure_base(exp)
	ac.setPpTonemapExposure(exp)

	ac.setPpSaturation(0.99 + 0.06*from_twilight_compensate(0))

	-- if godrays are not controlled by Sol, "remove" godrays from the moon 
	-- The moon can be the light source, if sun is under -7.5°,
	-- But we remove godrays if the sun is under 1°
	if not SOL__config("pp", "modify_godrays") then
		local godrays_result = interpolate__plan(godrays)
		ac.setGodraysLength(godrays_length * godrays_result[1])
	end


	-- If you want to debug your things, please put it in this condition.
	-- The debug text only appears, if it is activated in sol_config.
	if sol__debug__custom_config == true then

		ac.debug("CC", string.format('exposure %.2f', exp) )
	end
end
