
import platform
import os
import sys 


app_name = os.path.basename(__file__).replace(".py", "")

if platform.architecture()[0] == "64bit":
    libdir = "utilities/Lib64"          
else:
    libdir = "utilities/Lib"          
lib_path = os.path.join(os.path.dirname(__file__), libdir)
sys.path.insert(0, lib_path)
os.environ['PATH'] = os.environ['PATH'] + ";."


from wrapper import Wrapper     
wrapper = Wrapper(app_name) 


sys.path.remove(lib_path)


#-------------------------------------------------------------------------------
def acMain(acVersion):
#-------------------------------------------------------------------------------
    global wrapper

    wrapper._ac_main(acVersion)  
		
    return app_name


#-------------------------------------------------------------------------------
def acUpdate(deltaT):
#-------------------------------------------------------------------------------
    global wrapper

    wrapper._ac_update(deltaT)
    
           
#-------------------------------------------------------------------------------
def acShutdown(*args):
#-------------------------------------------------------------------------------
    global wrapper

    wrapper._ac_shutdown()
                              